/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.differ;

import java.io.IOException;
import java.io.Writer;
import oracle.xml.differ.DiffGenerator;
import oracle.xml.differ.DiffTreeNode;
import oracle.xml.differ.InsertedNode;
import oracle.xml.differ.InsertedNodeList;
import oracle.xml.differ.NodeUtility;
import oracle.xml.parser.v2.DTD;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;

class XSLDiffGenerator
implements DiffGenerator {
    InsertedNode m_startnode = null;
    InsertedNodeList m_startnode_list = null;
    short m_pathpos = 0;
    Writer m_writer;
    int m_indentincr = 0;
    String m_indincrstr = null;
    int m_nodeindincr = 0;
    String m_nodeindincrstr = null;
    int m_currlevel;
    XMLDocument m_doc;
    boolean m_delWSdeletes = false;
    static final short STRBUFFER_50 = 50;
    static final short STRBUFFER_150 = 100;
    static final short STRBUFFER_100 = 150;
    static final short STRBUFFER_200 = 200;

    XSLDiffGenerator() {
    }

    XSLDiffGenerator(Writer writer) throws IOException {
        this.m_writer = writer;
    }

    public void setIndentIncr(int n) {
        this.m_indentincr = n;
        this.m_indincrstr = this.getIncrStr(n);
    }

    public void setNewNodeIndentIncr(int n) {
        this.m_nodeindincr = n;
        this.m_nodeindincrstr = this.getIncrStr(n);
    }

    public void setDelWSBeforeDeletes(boolean bl) {
        this.m_delWSdeletes = bl;
    }

    private String getIncrStr(int n) {
        if (n <= 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (n-- > 0) {
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    protected void setDocument(XMLDocument xMLDocument) {
        this.m_doc = xMLDocument;
    }

    public void startDiffGeneration() throws IOException {
        DTD dTD;
        this.lineWrite("<xsl:stylesheet version=\"1.0\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\">");
        this.lineWrite("<xsl:output ");
        if (this.m_doc.getXmlEncoding() == null) {
            this.lineWrite("xmlns:ora=\"http://www.oracle.com/XSL/Transform/java\" ora:omit-xml-encoding=\"yes\" ");
        } else {
            this.lineWrite("encoding =\"" + this.m_doc.getXmlEncoding() + "\" ");
        }
        if (this.m_doc.getStandalone().equals("yes")) {
            this.lineWrite("standalone=\"yes\" ");
        }
        if ((dTD = (DTD)this.m_doc.getDoctype()) != null) {
            this.lineWrite("doctype-public=\"" + dTD.getPublicId() + "\"  doctype-system=\"" + dTD.getSystemId() + "\"");
        }
        this.lineWrite("/>");
        this.writeAll();
        this.m_writer.flush();
        this.m_startnode = new InsertedNode(this);
        this.m_startnode_list = new InsertedNodeList();
    }

    public void endDiffGeneration() throws IOException {
        this.lineWrite("</xsl:stylesheet>");
        this.m_writer.flush();
    }

    String getXPath(DiffTreeNode diffTreeNode, short s) {
        String string = new String();
        NodeUtility nodeUtility = new NodeUtility();
        Node node = diffTreeNode.getNodeObject();
        switch (s) {
            case 2: 
            case 3: 
            case 4: {
                if (node.getNodeType() == 2) {
                    string = nodeUtility.getXPath(diffTreeNode, (short)0);
                } else {
                    this.m_pathpos = 1;
                    string = nodeUtility.getXPath(diffTreeNode, (short)1);
                    if (string == null) {
                        this.m_pathpos = 2;
                        string = nodeUtility.getXPath(diffTreeNode, (short)2);
                        if (string == null) {
                            this.m_pathpos = 3;
                            string = nodeUtility.getXPath(diffTreeNode, (short)3);
                        }
                    }
                }
                if (s != 4 || this.m_pathpos == 3) break;
                this.m_pathpos = 0;
                break;
            }
            case 1: {
                if (this.m_indincrstr != null && node.getNodeType() == 2) {
                    this.m_pathpos = 3;
                    string = nodeUtility.getXPath(diffTreeNode, (short)3);
                    break;
                }
                this.m_pathpos = 0;
                string = nodeUtility.getXPath(diffTreeNode, (short)0);
            }
        }
        if (this.m_pathpos == 1 && this.m_startnode_list.hasElements() && this.m_startnode_list.getLast().getLevel() == diffTreeNode.getLevel()) {
            this.m_startnode = this.m_startnode_list.Pop();
        }
        return string;
    }

    public void insertNode(DiffTreeNode diffTreeNode) throws IOException {
        String string = this.getXPath(diffTreeNode, (short)2);
        Node node = diffTreeNode.getNodeObject();
        String string2 = null;
        InsertedNode insertedNode = null;
        this.m_currlevel = diffTreeNode.getLevel();
        String string3 = null;
        switch (node.getNodeType()) {
            case 2: {
                int n;
                if (this.m_startnode.getAttrCount() > 0) {
                    n = 0;
                } else {
                    n = ((Attr)node).getOwnerElement().getAttributes().getLength();
                    if (n == 1) {
                        n = 0;
                    }
                }
                String string4 = NodeUtility.getAttrNameText((Attr)node);
                string3 = NodeUtility.getAttrValueText((Attr)node);
                if (string4.equals("xmlns")) {
                    string2 = "";
                    break;
                }
                string2 = n > 0 ? this.getInsertAttr(string4, string3, string) : this.getAttrFunc(string4, string3, this.getIndentStr());
                string3 = null;
                break;
            }
            case 8: {
                string2 = this.getCommentFunc(NodeUtility.getCommentText((Comment)node));
                break;
            }
            case 7: {
                string2 = this.getPIFunc(NodeUtility.getPINameText((ProcessingInstruction)node), NodeUtility.getPIValueText((ProcessingInstruction)node));
                break;
            }
            default: {
                String string5;
                string2 = string5 = NodeUtility.getElementText(node, this.getNewNodeIncrStr(), this.m_currlevel, this.m_pathpos);
                break;
            }
        }
        if (this.m_startnode != null && this.m_startnode.getFirstXPath() != null && this.m_startnode.getFirstXPath().compareTo(string) != 0) {
            this.m_startnode.writeBatchInserts();
        }
        if (this.m_startnode_list.hasElements()) {
            if (this.m_startnode_list.getLast().getFirstXPath() != null && this.m_startnode_list.getLast().getFirstXPath().compareTo(string) != 0) {
                if (diffTreeNode.getLevel() <= this.m_startnode_list.getLast().getLevel()) {
                    this.m_startnode_list.Pop().writeBatchInserts();
                }
            } else {
                this.m_startnode = this.m_startnode_list.Pop();
            }
        }
        if (string2 != null) {
            insertedNode = new InsertedNode(node.getNodeType(), 2, this.m_pathpos, string, string2, string3, diffTreeNode.getLevel());
            this.m_startnode.saveNode(insertedNode);
        }
    }

    public void deleteNode(DiffTreeNode diffTreeNode) throws IOException {
        String string = this.getXPath(diffTreeNode, (short)1);
        Node node = diffTreeNode.getNodeObject();
        if (node.getNodeType() == 2) {
            this.writeDeleteAttr(node.getNodeName(), string);
            this.m_writer.flush();
            return;
        }
        InsertedNode insertedNode = new InsertedNode(node.getNodeType(), diffTreeNode.getDiffType(), this.m_pathpos, string, "", null, diffTreeNode.getLevel());
        if (this.m_startnode_list.hasElements() && diffTreeNode.getLevel() <= this.m_startnode_list.getLast().getLevel()) {
            this.m_startnode_list.Pop().writeBatchInserts();
        }
        if (this.m_startnode.getStart() != null) {
            if (this.m_startnode.getRefType() <= 0) {
                if (this.m_startnode.getLast().getPathType() == 1) {
                    this.m_startnode.writeBatchInserts();
                    this.m_startnode.putDeletedNode(insertedNode, this.m_delWSdeletes);
                } else {
                    this.m_startnode.putDeletedNode(insertedNode, this.m_delWSdeletes);
                    this.m_startnode.writeBatchInserts();
                }
            } else {
                this.m_startnode.writeBatchInserts();
                this.m_startnode.putDeletedNode(insertedNode, this.m_delWSdeletes);
            }
        } else {
            this.m_startnode.putDeletedNode(insertedNode, this.m_delWSdeletes);
        }
    }

    public void moveNode(DiffTreeNode diffTreeNode, DiffTreeNode diffTreeNode2) throws IOException {
        String string = this.getXPath(diffTreeNode, (short)1);
        String string2 = this.getXPath(diffTreeNode2, (short)3);
        Node node = diffTreeNode.getNodeObject();
        Node node2 = diffTreeNode2.getNodeObject();
        this.m_currlevel = diffTreeNode2.getLevel();
        String string3 = null;
        InsertedNode insertedNode = null;
        int n = node.getAttributes() == null ? 0 : node.getAttributes().getLength();
        switch (node.getNodeType()) {
            case 1: 
            case 9: {
                if (node.getChildNodes().getLength() == 1) {
                    if (node.getFirstChild().getNodeType() == 3) {
                        string3 = this.getMoveNode(n, string, string2);
                        break;
                    }
                }
                string3 = this.getMoveElement(n, string);
                break;
            }
            case 8: {
                string3 = this.getMoveComment(string);
                break;
            }
            case 7: {
                string3 = this.getMovePI(string);
            }
        }
        if (this.m_startnode != null && this.m_startnode.getFirstXPath() != null && this.m_startnode.getFirstXPath().compareTo(string2) != 0) {
            this.m_startnode.writeBatchInserts();
        }
        if (this.m_startnode_list.hasElements()) {
            if (this.m_startnode_list.getLast().getFirstXPath() != null && this.m_startnode_list.getLast().getFirstXPath().compareTo(string2) != 0) {
                if (diffTreeNode2.getLevel() <= this.m_startnode_list.getLast().getLevel()) {
                    this.m_startnode_list.Pop().writeBatchInserts();
                }
            } else {
                this.m_startnode = this.m_startnode_list.Pop();
            }
        }
        if (string3 != null) {
            insertedNode = new InsertedNode(node2.getNodeType(), 2, this.m_pathpos, string2, string3, null, diffTreeNode2.getLevel());
            this.m_startnode.saveNode(insertedNode);
        }
        this.m_writer.flush();
    }

    public void batchInsert(DiffTreeNode diffTreeNode) throws IOException {
        if (diffTreeNode == null) {
            if (this.m_startnode.getStart() != null) {
                this.m_startnode.writeBatchInserts();
            }
            while (this.m_startnode_list.hasElements()) {
                this.m_startnode = this.m_startnode_list.Pop();
                this.m_startnode.writeBatchInserts();
            }
            return;
        }
        if (this.m_startnode_list.hasElements() && diffTreeNode.getLevel() <= this.m_startnode_list.getLast().getLevel()) {
            this.m_startnode = this.m_startnode_list.Pop();
        } else {
            if (this.m_startnode.getStart() == null) {
                return;
            }
            if (this.m_startnode.getLast().getPathType() == 2 || this.m_startnode.getLast().getNodeType() == 2) {
                this.m_startnode.setRefType((short)0);
                int n = diffTreeNode.getLevel();
                if (this.m_startnode.getLast().getNodeType() == 2) {
                    --n;
                }
                this.m_startnode.setLevel(n);
                this.m_startnode_list.Push(this.m_startnode);
                this.m_startnode = new InsertedNode(this);
                return;
            }
            if (diffTreeNode.getNodeObject().getNodeType() == 1 && !diffTreeNode.getNodeObject().hasChildNodes()) {
                return;
            }
        }
        this.m_startnode.writeBatchInserts();
    }

    public void modifyNode(DiffTreeNode diffTreeNode, DiffTreeNode diffTreeNode2) throws IOException {
        String string = this.getXPath(diffTreeNode, (short)4);
        Node node = diffTreeNode.getNodeObject();
        Node node2 = diffTreeNode2.getNodeObject();
        String string2 = null;
        this.m_currlevel = diffTreeNode2.getLevel();
        switch (node.getNodeType()) {
            case 2: {
                this.writeModifyAttr(NodeUtility.getAttrNameText((Attr)node), NodeUtility.getAttrValueText((Attr)node2), string);
                this.m_writer.flush();
                return;
            }
            case 8: {
                string2 = this.getCommentFunc(NodeUtility.getCommentText((Comment)node2));
                break;
            }
            case 7: {
                string2 = this.getPIFunc(NodeUtility.getPINameText((ProcessingInstruction)node), NodeUtility.getPIValueText((ProcessingInstruction)node2));
                break;
            }
            default: {
                string2 = this.getModifyTextNode(string, NodeUtility.getElementText(node2, this.m_indincrstr, this.m_currlevel, this.m_pathpos));
            }
        }
        if (this.m_startnode != null && this.m_startnode.getFirstXPath() != null && this.m_startnode.getFirstXPath().compareTo(string) != 0) {
            this.m_startnode.writeBatchInserts();
        }
        if (this.m_startnode_list.hasElements()) {
            if (this.m_startnode_list.getLast().getFirstXPath() != null && this.m_startnode_list.getLast().getFirstXPath().compareTo(string) != 0) {
                if (diffTreeNode2.getLevel() <= this.m_startnode_list.getLast().getLevel()) {
                    this.m_startnode_list.Pop().writeBatchInserts();
                }
            } else {
                this.m_startnode = this.m_startnode_list.Pop();
            }
        }
        InsertedNode insertedNode = new InsertedNode(node2.getNodeType(), 4, this.m_pathpos, string, string2, null, diffTreeNode2.getLevel());
        if (this.m_pathpos != 3) {
            this.m_startnode.writeBatchInserts();
            this.m_startnode.saveNode(insertedNode);
        } else {
            this.m_startnode.saveNode(insertedNode);
        }
    }

    void writeAll() throws IOException {
        this.writeComment("Select all nodes");
        if (this.m_indentincr > 0) {
            this.lineWrite("<xsl:param name=\"indent-increment\" select=\"'" + this.m_indincrstr + "'\"/>");
            this.lineWrite("<xsl:template match=\"*\">");
            this.lineWrite("<xsl:param name=\"indent\" select=\"'&#xA;'\"/>");
            if (this.getNewNodeIndentIncr() > 0) {
                this.lineWrite("<xsl:if test=\"name()='" + this.m_doc.getDocumentElement().getNodeName() + "'\">");
                this.lineWrite("<xsl:text>\n</xsl:text>");
                this.lineWrite("</xsl:if>");
            }
            this.lineWrite("<xsl:element name = \"{name()}\">");
            this.lineWrite("<xsl:apply-templates select=\"@*\">");
            this.lineWrite("<xsl:with-param name=\"indent\" select=\"concat($indent, $indent-increment)\"/>");
            this.lineWrite("</xsl:apply-templates>");
            this.lineWrite("<xsl:apply-templates>");
            this.lineWrite("<xsl:with-param name=\"indent\" select=\"concat($indent, $indent-increment)\"/>");
            this.lineWrite("</xsl:apply-templates>");
            this.lineWrite("</xsl:element>");
            this.lineWrite("</xsl:template>");
            this.lineWrite("<xsl:template match=\"@*\">");
            this.lineWrite("<xsl:param name=\"indent\">");
            this.lineWrite("<xsl:value-of select = \"'&#xA;'\"/>");
            this.lineWrite("</xsl:param>");
            this.lineWrite("<xsl:attribute name = \"{$indent}{name()}\">");
            this.lineWrite("<xsl:value-of select=\".\"/>");
            this.lineWrite("</xsl:attribute>");
            this.lineWrite("</xsl:template>");
            this.lineWrite("<xsl:template match=\"comment()|processing-instruction()\">");
            this.lineWrite("<xsl:copy/>");
            this.lineWrite("</xsl:template>");
        } else if (this.getNewNodeIndentIncr() > 0) {
            this.lineWrite("<xsl:template match=\"*\">");
            this.lineWrite("<xsl:if test=\"name()='" + this.m_doc.getDocumentElement().getNodeName() + "'\">");
            this.lineWrite("<xsl:text>\n</xsl:text>");
            this.lineWrite("</xsl:if>");
            this.lineWrite("<xsl:element name = \"{name()}\">");
            this.lineWrite("<xsl:apply-templates/>");
            this.lineWrite("</xsl:element>");
            this.lineWrite("</xsl:template>");
            this.lineWrite("<xsl:template match=\"node()|@*\">");
            this.lineWrite("<xsl:copy><xsl:apply-templates select=\"node()|@*\"/></xsl:copy>");
            this.lineWrite("</xsl:template>");
            this.lineWrite("<xsl:template match=\"comment()|processing-instruction()\">");
            this.lineWrite("<xsl:copy/>");
            this.lineWrite("</xsl:template>");
        } else {
            this.lineWrite("<xsl:template match=\"node()|@*\">");
            this.lineWrite("<xsl:copy><xsl:apply-templates select=\"node()|@*\"/></xsl:copy>");
            this.lineWrite("</xsl:template>");
        }
    }

    void flush() throws IOException {
        this.m_writer.flush();
    }

    String getMoveNode(int n, String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("<xsl:element name=\"{name(" + string + ")}\">");
        if (n > 0) {
            stringBuffer.append(this.getAttrs(string, this.getIndentStr()));
        }
        stringBuffer.append("<xsl:value-of select=\"" + string + "\"/>");
        stringBuffer.append("</xsl:element>");
        return stringBuffer.toString();
    }

    String getMoveElement(int n, String string) {
        StringBuffer stringBuffer = new StringBuffer(100);
        String string2 = null;
        string2 = this.getNewNodeIncrStr();
        if (string2 != null && this.m_pathpos != 2) {
            stringBuffer.append("<xsl:text>\n" + NodeUtility.getIndentStr(string2, this.m_currlevel) + "</xsl:text>");
        }
        stringBuffer.append("<xsl:copy-of select=\"" + string + "\"/>");
        if (string2 != null && this.m_pathpos == 2) {
            stringBuffer.append("<xsl:text>\n" + NodeUtility.getIndentStr(string2, this.m_currlevel) + "</xsl:text>");
        }
        return stringBuffer.toString();
    }

    String getModifyTextNode(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(50);
        stringBuffer.append(string2);
        return stringBuffer.toString();
    }

    String getInsertAttr(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer(150);
        String string4 = this.getIndentStr();
        stringBuffer.append(this.getAttrs(string3, string4));
        stringBuffer.append(this.getAttrFunc(string, string2, string4));
        return stringBuffer.toString();
    }

    String getAttrFunc(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer(50);
        stringBuffer.append("<xsl:attribute name = \"" + string3 + string + "\">" + string2 + "</xsl:attribute>");
        return stringBuffer.toString();
    }

    String getAttrs(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(150);
        stringBuffer.append("<xsl:for-each select=\"" + string + "/@*\">");
        stringBuffer.append(this.getAttrFunc("{name()}", "<xsl:value-of select=\".\"/>", string2));
        stringBuffer.append("</xsl:for-each>");
        return stringBuffer.toString();
    }

    void writeDeleteAttr(String string, String string2) throws IOException {
        this.lineWrite("<xsl:template match=\"" + string2 + "/@" + string + "\"/>");
    }

    void writeModifyAttr(String string, String string2, String string3) throws IOException {
        this.lineWrite("<xsl:template match=\"" + string3 + "/@" + string + "\">");
        this.lineWrite(this.getAttrFunc(string, string2, this.getIndentStr()));
        this.lineWrite("</xsl:template>");
    }

    String getIndentStr() {
        StringBuffer stringBuffer = new StringBuffer("");
        int n = this.m_currlevel;
        if (this.m_indentincr > 0) {
            stringBuffer.append("&#xA;");
            while (--n > 0) {
                stringBuffer.append(this.m_indincrstr);
            }
        }
        return stringBuffer.toString();
    }

    int getIndentIncr() {
        return this.m_indentincr;
    }

    int getNewNodeIndentIncr() {
        return this.m_nodeindincr;
    }

    String getNewNodeIncrStr() {
        return this.m_nodeindincrstr;
    }

    String getMoveComment(String string) {
        return this.getCommentFunc("<xsl:value-of select=\"" + string + "\"/>");
    }

    String getMovePI(String string) {
        return this.getPIFunc("{name(" + string + ")}", "<xsl:value-of select=\"" + string + "\"/>");
    }

    String getApply() {
        return "<xsl:apply-templates/>";
    }

    String getApplyAttr() {
        if (this.m_indentincr > 0) {
            StringBuffer stringBuffer = new StringBuffer(100);
            stringBuffer.append("<xsl:apply-templates select=\"@*\">");
            stringBuffer.append("<xsl:with-param name=\"indent\" select=\"concat($indent, $indent-increment)\"/>");
            stringBuffer.append("</xsl:apply-templates>");
            return stringBuffer.toString();
        }
        return "<xsl:apply-templates select=\"@*\"/>";
    }

    String getCopyNodesAttr() {
        if (this.m_indentincr > 0) {
            StringBuffer stringBuffer = new StringBuffer(100);
            stringBuffer.append("<xsl:copy><xsl:apply-templates select=\"node()|@*\">");
            stringBuffer.append("<xsl:with-param name=\"indent\" select=\"concat($indent, $indent-increment)\"/>");
            stringBuffer.append("</xsl:apply-templates></xsl:copy>");
            return stringBuffer.toString();
        }
        return "<xsl:copy><xsl:apply-templates select=\"node()|@*\"/></xsl:copy>";
    }

    void writeComment(String string) throws IOException {
        this.lineWrite("<!--" + string + "-->");
    }

    String getCommentFunc(String string) {
        return "<xsl:comment>" + string + "</xsl:comment>";
    }

    String getPIFunc(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(150);
        stringBuffer.append("<xsl:processing-instruction name=\"" + string + "\">");
        stringBuffer.append(string2);
        stringBuffer.append("</xsl:processing-instruction>");
        return stringBuffer.toString();
    }

    void lineWrite(String string) throws IOException {
        this.m_writer.write(string);
    }
}

