/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.canvas;

import com.mxgraph.canvas.mxICanvas2D;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.util.mxUtils;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Stack;

public class mxGraphicsCanvas2D
implements mxICanvas2D {
    public static int IMAGE_SCALING = 4;
    protected Graphics2D graphics;
    protected transient CanvasState state = new CanvasState();
    protected transient Stack<CanvasState> stack = new Stack();
    protected transient GeneralPath currentPath;
    protected transient Stroke currentStroke;
    protected transient Font currentFont;
    protected transient String currentShadowValue;
    protected transient Color currentShadowColor;

    public mxGraphicsCanvas2D(Graphics2D graphics2D) {
        this.setGraphics(graphics2D);
        this.state.g = graphics2D;
    }

    public void setGraphics(Graphics2D graphics2D) {
        this.graphics = graphics2D;
    }

    public Graphics2D getGraphics() {
        return this.graphics;
    }

    @Override
    public void save() {
        this.stack.push(this.state);
        this.state = this.cloneState(this.state);
        this.state.g = (Graphics2D)this.state.g.create();
    }

    @Override
    public void restore() {
        this.state = this.stack.pop();
        this.currentStroke = this.state.g.getStroke();
        this.currentFont = this.state.g.getFont();
    }

    protected CanvasState cloneState(CanvasState canvasState) {
        try {
            return (CanvasState)canvasState.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
            return null;
        }
    }

    @Override
    public void scale(double d) {
        this.state.scale *= d;
    }

    @Override
    public void translate(double d, double d2) {
        this.state.dx += d;
        this.state.dy += d2;
    }

    @Override
    public void rotate(double d, boolean bl, boolean bl2, double d2, double d3) {
        d2 += this.state.dx;
        d3 += this.state.dy;
        d2 *= this.state.scale;
        d3 *= this.state.scale;
        if (bl ^ bl2) {
            double d4 = bl ? d2 : 0.0;
            int n = bl ? -1 : 1;
            double d5 = bl2 ? d3 : 0.0;
            int n2 = bl2 ? -1 : 1;
            this.state.g.translate(d4, d5);
            this.state.g.scale(n, n2);
            this.state.g.translate(-d4, -d5);
        }
        this.state.g.rotate(Math.toRadians(d), d2, d3);
    }

    @Override
    public void setStrokeWidth(double d) {
        if (d * this.state.scale != this.state.strokeWidth) {
            this.state.strokeWidth = d * this.state.scale;
            this.currentStroke = null;
        }
    }

    @Override
    public void setStrokeColor(String string) {
        if (!this.state.strokeColorValue.equals(string)) {
            this.state.strokeColorValue = string;
            this.state.strokeColor = null;
        }
    }

    @Override
    public void setDashed(boolean bl) {
        if (bl != this.state.dashed) {
            this.state.dashed = bl;
            this.currentStroke = null;
        }
    }

    @Override
    public void setDashPattern(String string) {
        if (!this.state.dashPattern.equals(string)) {
            float[] fArray = null;
            if (this.state.dashed && this.state.dashPattern != null) {
                String[] stringArray = string.split(" ");
                fArray = new float[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    fArray[i] = (float)((double)Float.parseFloat(stringArray[i]) * this.state.scale);
                }
            }
            this.state.dashPattern = fArray;
            this.currentStroke = null;
        }
    }

    @Override
    public void setLineCap(String string) {
        if (!this.state.lineCap.equals(string)) {
            this.state.lineCap = string;
            this.currentStroke = null;
        }
    }

    @Override
    public void setLineJoin(String string) {
        if (!this.state.lineJoin.equals(string)) {
            this.state.lineJoin = string;
            this.currentStroke = null;
        }
    }

    @Override
    public void setMiterLimit(double d) {
        if (d != this.state.miterLimit) {
            this.state.miterLimit = d;
            this.currentStroke = null;
        }
    }

    @Override
    public void setFontSize(double d) {
        if (d != this.state.fontSize) {
            this.state.fontSize = d * this.state.scale;
            this.currentFont = null;
        }
    }

    @Override
    public void setFontColor(String string) {
        if (!this.state.fontColorValue.equals(string)) {
            this.state.fontColorValue = string;
            this.state.fontColor = null;
        }
    }

    @Override
    public void setFontFamily(String string) {
        if (!this.state.fontFamily.equals(string)) {
            this.state.fontFamily = string;
            this.currentFont = null;
        }
    }

    @Override
    public void setFontStyle(int n) {
        if (n != this.state.fontStyle) {
            this.state.fontStyle = n;
            this.currentFont = null;
        }
    }

    @Override
    public void setAlpha(double d) {
        if (this.state.alpha != d) {
            this.state.g.setComposite(AlphaComposite.getInstance(3, (float)d));
            this.state.alpha = d;
        }
    }

    @Override
    public void setFillColor(String string) {
        if (!this.state.fillColorValue.equals(string)) {
            this.state.fillColorValue = string;
            this.state.fillColor = null;
            this.state.paint = null;
        }
    }

    @Override
    public void setGradient(String string, String string2, double d, double d2, double d3, double d4, String string3) {
        float f = (float)(this.state.dx + d * this.state.scale);
        float f2 = (float)(this.state.dy + d2 * this.state.scale);
        float f3 = f;
        float f4 = f2;
        d4 *= this.state.scale;
        d3 *= this.state.scale;
        if (string3 == null || string3.length() == 0 || string3.equals("south")) {
            f4 = (float)((double)f2 + d4);
        } else if (string3.equals("east")) {
            f3 = (float)((double)f + d3);
        } else if (string3.equals("north")) {
            f2 = (float)((double)f2 + d4);
        } else if (string3.equals("west")) {
            f = (float)((double)f + d3);
        }
        this.state.paint = new GradientPaint(f, f2, this.parseColor(string), f3, f4, this.parseColor(string2), true);
    }

    protected Color parseColor(String string) {
        return mxUtils.parseColor(string);
    }

    @Override
    public void setGlassGradient(double d, double d2, double d3, double d4) {
        double d5 = 0.4;
        d = this.state.dx + d * this.state.scale;
        d2 = this.state.dy + d2 * this.state.scale;
        d3 *= this.state.scale;
        this.state.paint = new GradientPaint((float)d, (float)d2, new Color(1.0f, 1.0f, 1.0f, 0.9f), (float)d, (float)(d2 + (d4 *= this.state.scale) * d5), new Color(1.0f, 1.0f, 1.0f, 0.3f));
    }

    @Override
    public void rect(double d, double d2, double d3, double d4) {
        this.currentPath = new GeneralPath();
        this.currentPath.append(new Rectangle2D.Double(this.state.dx + d * this.state.scale, this.state.dy + d2 * this.state.scale, d3 * this.state.scale, d4 * this.state.scale), false);
    }

    @Override
    public void roundrect(double d, double d2, double d3, double d4, double d5, double d6) {
        this.begin();
        this.moveTo(d + d5, d2);
        this.lineTo(d + d3 - d5, d2);
        this.quadTo(d + d3, d2, d + d3, d2 + d6);
        this.lineTo(d + d3, d2 + d4 - d6);
        this.quadTo(d + d3, d2 + d4, d + d3 - d5, d2 + d4);
        this.lineTo(d + d5, d2 + d4);
        this.quadTo(d, d2 + d4, d, d2 + d4 - d6);
        this.lineTo(d, d2 + d6);
        this.quadTo(d, d2, d + d5, d2);
        this.end();
    }

    @Override
    public void ellipse(double d, double d2, double d3, double d4) {
        this.currentPath = new GeneralPath();
        this.currentPath.append(new Ellipse2D.Double(this.state.dx + d * this.state.scale, this.state.dy + d2 * this.state.scale, d3 * this.state.scale, d4 * this.state.scale), false);
    }

    @Override
    public void image(double d, double d2, double d3, double d4, String string, boolean bl, boolean bl2, boolean bl3) {
        mxRectangle mxRectangle2;
        Image image;
        if (string != null && d3 > 0.0 && d4 > 0.0 && (image = this.loadImage(string)) != null && (image = this.scaleImage(image, (int)(mxRectangle2 = this.getImageBounds(image, d, d2, d3, d4, bl)).getWidth(), (int)mxRectangle2.getHeight())) != null) {
            this.createImageGraphics(mxRectangle2.getX(), mxRectangle2.getY(), mxRectangle2.getWidth(), mxRectangle2.getHeight(), bl2, bl3).drawImage(image, (int)mxRectangle2.getX(), (int)mxRectangle2.getY(), null);
        }
    }

    protected Image loadImage(String string) {
        return mxUtils.loadImage(string);
    }

    protected final mxRectangle getImageBounds(Image image, double d, double d2, double d3, double d4, boolean bl) {
        d = this.state.dx + d * this.state.scale;
        d2 = this.state.dy + d2 * this.state.scale;
        d3 *= this.state.scale;
        d4 *= this.state.scale;
        if (bl) {
            double d5 = image.getWidth(null);
            double d6 = image.getHeight(null);
            double d7 = Math.min(d3 / d5, d4 / d6);
            int n = (int)Math.round(d5 * d7);
            int n2 = (int)Math.round(d6 * d7);
            d += (d3 - (double)n) / 2.0;
            d2 += (d4 - (double)n2) / 2.0;
            d3 = n;
            d4 = n2;
        } else {
            d3 = Math.round(d3);
            d4 = Math.round(d4);
        }
        return new mxRectangle(d, d2, d3, d4);
    }

    protected Image scaleImage(Image image, int n, int n2) {
        return image.getScaledInstance(n, n2, IMAGE_SCALING);
    }

    protected final Graphics2D createImageGraphics(double d, double d2, double d3, double d4, boolean bl, boolean bl2) {
        Graphics2D graphics2D = this.state.g;
        if (bl || bl2) {
            graphics2D = (Graphics2D)graphics2D.create();
            int n = 1;
            int n2 = 1;
            int n3 = 0;
            int n4 = 0;
            if (bl) {
                n = -1;
                n3 = (int)(-d3 - 2.0 * d);
            }
            if (bl2) {
                n2 = -1;
                n4 = (int)(-d4 - 2.0 * d2);
            }
            graphics2D.scale(n, n2);
            graphics2D.translate(n3, n4);
        }
        return graphics2D;
    }

    @Override
    public void text(double d, double d2, double d3, double d4, String string, String string2, String string3, boolean bl) {
        if (!this.state.fontColorValue.equals(mxConstants.NONE)) {
            d = this.state.dx + d * this.state.scale;
            d2 = this.state.dy + d2 * this.state.scale;
            Graphics2D graphics2D = this.createTextGraphics(d, d2, d3 *= this.state.scale, d4 *= this.state.scale, bl);
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            String[] stringArray = string.split("\n");
            d2 = this.getVerticalTextPosition(d, d2, d3, d4, string2, string3, bl, fontMetrics, stringArray);
            d = this.getHorizontalTextPosition(d, d2, d3, d4, string2, string3, bl, fontMetrics, stringArray);
            for (int i = 0; i < stringArray.length; ++i) {
                int n;
                double d5 = 0.0;
                if (string2.equals("center")) {
                    n = fontMetrics.stringWidth(stringArray[i]);
                    d5 = (d3 - (double)n) / 2.0;
                } else if (string2.equals("right")) {
                    n = fontMetrics.stringWidth(stringArray[i]);
                    d5 = d3 - (double)n;
                }
                graphics2D.drawString(stringArray[i], (int)Math.round(d + d5), (int)Math.round(d2));
                d2 += (double)(fontMetrics.getHeight() + mxConstants.LINESPACING);
            }
        }
    }

    protected final Graphics2D createTextGraphics(double d, double d2, double d3, double d4, boolean bl) {
        Graphics2D graphics2D = this.state.g;
        this.updateFont();
        if (bl) {
            graphics2D = (Graphics2D)this.state.g.create();
            graphics2D.rotate(-1.5707963267948966, d + d3 / 2.0, d2 + d4 / 2.0);
        }
        if (this.state.fontColor == null) {
            this.state.fontColor = this.parseColor(this.state.fontColorValue);
        }
        graphics2D.setColor(this.state.fontColor);
        return graphics2D;
    }

    protected double getVerticalTextPosition(double d, double d2, double d3, double d4, String string, String string2, boolean bl, FontMetrics fontMetrics, String[] stringArray) {
        double d5 = fontMetrics.getHeight() + mxConstants.LINESPACING;
        double d6 = (double)stringArray.length * d5;
        double d7 = d4 - d6;
        if (string2 == null || string2.equals("middle")) {
            d2 += d7 / 2.0;
        } else if (string2.equals("top")) {
            d2 = Math.max(d2, d2 + d7 / 2.0);
        } else if (string2.equals("bottom")) {
            d2 = Math.min(d2, d2 + d7);
        }
        return d2 + (double)fontMetrics.getHeight() * 0.75;
    }

    protected double getHorizontalTextPosition(double d, double d2, double d3, double d4, String string, String string2, boolean bl, FontMetrics fontMetrics, String[] stringArray) {
        if (string != null) {
            if (string.equals("left")) {
                d += (double)mxConstants.LABEL_INSET * this.state.scale;
            } else if (string.equals("right")) {
                d -= (double)mxConstants.LABEL_INSET * this.state.scale;
            }
        }
        return d;
    }

    @Override
    public void begin() {
        this.currentPath = new GeneralPath();
    }

    @Override
    public void moveTo(double d, double d2) {
        if (this.currentPath != null) {
            this.currentPath.moveTo((float)(this.state.dx + d * this.state.scale), (float)(this.state.dy + d2 * this.state.scale));
        }
    }

    @Override
    public void lineTo(double d, double d2) {
        if (this.currentPath != null) {
            this.currentPath.lineTo((float)(this.state.dx + d * this.state.scale), (float)(this.state.dy + d2 * this.state.scale));
        }
    }

    @Override
    public void quadTo(double d, double d2, double d3, double d4) {
        if (this.currentPath != null) {
            this.currentPath.quadTo((float)(this.state.dx + d * this.state.scale), (float)(this.state.dy + d2 * this.state.scale), (float)(this.state.dx + d3 * this.state.scale), (float)(this.state.dy + d4 * this.state.scale));
        }
    }

    @Override
    public void curveTo(double d, double d2, double d3, double d4, double d5, double d6) {
        if (this.currentPath != null) {
            this.currentPath.curveTo((float)(this.state.dx + d * this.state.scale), (float)(this.state.dy + d2 * this.state.scale), (float)(this.state.dx + d3 * this.state.scale), (float)(this.state.dy + d4 * this.state.scale), (float)(this.state.dx + d5 * this.state.scale), (float)(this.state.dy + d6 * this.state.scale));
        }
    }

    @Override
    public void arcTo(double d, double d2, double d3, boolean bl, boolean bl2, double d4, double d5) {
        if (this.currentPath != null) {
            double d6;
            double d7;
            d *= this.state.scale;
            d2 *= this.state.scale;
            d4 = d4 * this.state.scale + this.state.dx;
            d5 = d5 * this.state.scale + this.state.dy;
            Point2D point2D = this.currentPath.getCurrentPoint();
            double d8 = point2D.getX();
            double d9 = point2D.getY();
            double d10 = (d8 - d4) / 2.0;
            double d11 = (d9 - d5) / 2.0;
            d3 = Math.toRadians(d3 % 360.0);
            double d12 = Math.cos(d3);
            double d13 = Math.sin(d3);
            double d14 = d12 * d10 + d13 * d11;
            double d15 = -d13 * d10 + d12 * d11;
            double d16 = d14 * d14;
            double d17 = (d = Math.abs(d)) * d;
            double d18 = d16 / d17 + (d7 = d15 * d15) / (d6 = (d2 = Math.abs(d2)) * d2);
            if (d18 > 1.0) {
                d = Math.sqrt(d18) * d;
                d2 = Math.sqrt(d18) * d2;
                d17 = d * d;
                d6 = d2 * d2;
            }
            double d19 = bl == bl2 ? -1.0 : 1.0;
            double d20 = (d17 * d6 - d17 * d7 - d6 * d16) / (d17 * d7 + d6 * d16);
            d20 = d20 < 0.0 ? 0.0 : d20;
            double d21 = d19 * Math.sqrt(d20);
            double d22 = d21 * (d * d15 / d2);
            double d23 = d21 * -(d2 * d14 / d);
            double d24 = (d8 + d4) / 2.0;
            double d25 = (d9 + d5) / 2.0;
            double d26 = d24 + (d12 * d22 - d13 * d23);
            double d27 = d25 + (d13 * d22 + d12 * d23);
            double d28 = (d14 - d22) / d;
            double d29 = (d15 - d23) / d2;
            double d30 = (-d14 - d22) / d;
            double d31 = (-d15 - d23) / d2;
            double d32 = Math.sqrt(d28 * d28 + d29 * d29);
            double d33 = d28;
            d19 = d29 < 0.0 ? -1.0 : 1.0;
            double d34 = Math.toDegrees(d19 * Math.acos(d33 / d32));
            d32 = Math.sqrt((d28 * d28 + d29 * d29) * (d30 * d30 + d31 * d31));
            d33 = d28 * d30 + d29 * d31;
            d19 = d28 * d31 - d29 * d30 < 0.0 ? -1.0 : 1.0;
            double d35 = Math.toDegrees(d19 * Math.acos(d33 / d32));
            if (!bl2 && d35 > 0.0) {
                d35 -= 360.0;
            } else if (bl2 && d35 < 0.0) {
                d35 += 360.0;
            }
            d35 %= 360.0;
            d34 %= 360.0;
            Arc2D.Double double_ = new Arc2D.Double();
            double_.x = d26 - d;
            double_.y = d27 - d2;
            double_.width = d * 2.0;
            double_.height = d2 * 2.0;
            double_.start = -d34;
            double_.extent = -d35;
            this.currentPath.append(double_, true);
        }
    }

    @Override
    public void end() {
    }

    @Override
    public void close() {
        if (this.currentPath != null) {
            this.currentPath.closePath();
        }
    }

    @Override
    public void stroke() {
        if (this.currentPath != null && !this.state.strokeColorValue.equals(mxConstants.NONE)) {
            if (this.state.strokeColor == null) {
                this.state.strokeColor = this.parseColor(this.state.strokeColorValue);
            }
            this.updateStroke();
            this.state.g.setColor(this.state.strokeColor);
            this.state.g.draw(this.currentPath);
        }
    }

    @Override
    public void fill() {
        if (!(this.currentPath == null || this.state.fillColorValue.equals(mxConstants.NONE) && this.state.paint == null)) {
            if (this.state.paint != null) {
                this.state.g.setPaint(this.state.paint);
                this.state.paint = null;
            } else {
                if (this.state.fillColor == null) {
                    this.state.fillColor = this.parseColor(this.state.fillColorValue);
                }
                this.state.g.setColor(this.state.fillColor);
                this.state.g.setPaint(null);
            }
            this.state.g.fill(this.currentPath);
        }
    }

    @Override
    public void fillAndStroke() {
        this.fill();
        this.stroke();
    }

    @Override
    public void shadow(String string) {
        if (string != null && this.currentPath != null) {
            if (this.currentShadowColor == null || this.currentShadowValue == null || !this.currentShadowValue.equals(string)) {
                this.currentShadowColor = this.parseColor(string);
                this.currentShadowValue = string;
            }
            this.updateStroke();
            this.state.g.setColor(this.currentShadowColor);
            this.state.g.fill(this.currentPath);
            this.state.g.draw(this.currentPath);
        }
    }

    @Override
    public void clip() {
        if (this.currentPath != null) {
            this.state.g.clip(this.currentPath);
        }
    }

    protected void updateFont() {
        if (this.currentFont == null) {
            int n = (int)Math.round(this.state.fontSize);
            int n2 = (this.state.fontStyle & 1) == 1 ? 1 : 0;
            this.currentFont = this.createFont(this.state.fontFamily, n2 += (this.state.fontStyle & 2) == 2 ? 2 : 0, n);
            this.state.g.setFont(this.currentFont);
        }
    }

    protected Font createFont(String string, int n, int n2) {
        return new Font(string, n, n2);
    }

    protected void updateStroke() {
        if (this.currentStroke == null) {
            int n = 0;
            if (this.state.lineCap.equals("round")) {
                n = 1;
            } else if (this.state.lineCap.equals("square")) {
                n = 2;
            }
            int n2 = 0;
            if (this.state.lineJoin.equals("round")) {
                n2 = 1;
            } else if (this.state.lineJoin.equals("bevel")) {
                n2 = 2;
            }
            float f = (float)this.state.miterLimit;
            this.currentStroke = new BasicStroke((float)this.state.strokeWidth, n, n2, f, this.state.dashed ? this.state.dashPattern : null, 0.0f);
            this.state.g.setStroke(this.currentStroke);
        }
    }

    protected class CanvasState
    implements Cloneable {
        protected double alpha = 1.0;
        protected double scale = 1.0;
        protected double dx = 0.0;
        protected double dy = 0.0;
        protected double miterLimit = 10.0;
        protected int fontStyle = 0;
        protected double fontSize = mxConstants.DEFAULT_FONTSIZE;
        protected String fontFamily = mxConstants.DEFAULT_FONTFAMILY;
        protected String fontColorValue = "#000000";
        protected Color fontColor;
        protected String lineCap = "flat";
        protected String lineJoin = "miter";
        protected double strokeWidth = 1.0;
        protected String strokeColorValue = mxConstants.NONE;
        protected Color strokeColor;
        protected String fillColorValue = mxConstants.NONE;
        protected Color fillColor;
        protected Paint paint;
        protected boolean dashed = false;
        protected float[] dashPattern = new float[]{3.0f, 3.0f};
        protected transient Graphics2D g;

        protected CanvasState() {
        }

        public Object clone() throws CloneNotSupportedException {
            return super.clone();
        }
    }
}

