/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.thirdparty.db2;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Properties;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.dbtools.raptor.connections.CDComponentView;
import oracle.dbtools.raptor.explorer.dt.dialog.ConnectionDialogArb;
import oracle.dbtools.thirdparty.db2.DB2ConnectionPanel;
import oracle.dbtools.thirdparty.db2.Messages;
import oracle.ide.util.ResourceUtils;

public class DB2BasicPanel
extends JPanel
implements CDComponentView {
    public static final String DRIVER_CLASSNAME = "COM.ibm.db2os390.sqlj.jdbc.DB2SQLJDriver";
    private static final long serialVersionUID = -8190519193576488547L;
    private JLabel m_chooseDataSource = new JLabel();
    protected JTextField m_db2DataSource = new JTextField();
    private JLabel m_hostLbl = new JLabel();
    protected JTextField m_tfdHost = new JTextField(15);
    private JLabel m_portLbl = new JLabel();
    protected JTextField m_tfdPort = new JTextField(15);

    public DB2BasicPanel(DB2ConnectionPanel dB2ConnectionPanel) {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() {
        this.setLayout(new GridBagLayout());
        this.m_tfdHost.setText("localhost");
        this.m_tfdPort.setText("50000");
        ResourceUtils.resLabel((JLabel)this.m_hostLbl, (Component)this.m_tfdHost, (String)ConnectionDialogArb.getString((String)"CONNECTION_DIALOG_DETAILS_HOST"));
        ResourceUtils.resLabel((JLabel)this.m_portLbl, (Component)this.m_tfdPort, (String)ConnectionDialogArb.getString((String)"CONNECTION_DIALOG_DETAILS_PORT"));
        this.add((Component)this.m_hostLbl, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 5, 0, 0), 0, 0));
        this.add((Component)this.m_tfdHost, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(10, 5, 0, 0), 0, 0));
        this.add((Component)this.m_portLbl, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 5, 0, 0), 0, 0));
        this.add((Component)this.m_tfdPort, new GridBagConstraints(2, 2, 1, 1, 1.0, 0.0, 18, 2, new Insets(10, 5, 0, 0), 0, 0));
        ResourceUtils.resLabel((JLabel)this.m_chooseDataSource, (Component)this.m_db2DataSource, (String)Messages.getString("LABEL_CHOOSEDATABASE"));
        this.add((Component)this.m_chooseDataSource, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 5, 0, 0), 0, 0));
        this.add((Component)this.m_db2DataSource, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 18, 2, new Insets(10, 5, 0, 0), 0, 0));
    }

    public void clear() {
        this.m_tfdHost.setText("");
        this.m_tfdPort.setText("");
        this.m_db2DataSource.setText("");
    }

    public void populateComponent(Properties properties) {
        String string = this.m_db2DataSource.getText();
        properties.setProperty("hostname", this.m_tfdHost.getText().trim());
        properties.put("port", this.m_tfdPort.getText().trim());
        String string2 = "jdbc:db2://" + this.m_tfdHost.getText().trim() + ":" + this.m_tfdPort.getText().trim() + "/" + string;
        properties.setProperty("customUrl", string2);
        properties.setProperty("driver", this.getDriver());
    }

    public void setDefaultPrompts() {
        this.m_tfdHost.setText("localhost");
        this.m_tfdPort.setText("50000");
        this.m_db2DataSource.setText("");
    }

    public String getDriver() {
        return DRIVER_CLASSNAME;
    }
}

