/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util.string;

public class StringUtilities {
    public static final String EMPTY_STRING = "";
    public static final String NEWLINE = System.getProperty("line.separator");

    private StringUtilities() {
    }

    public static String replace(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        StringUtilities.replace(string, string2, string3, stringBuffer);
        return stringBuffer.toString();
    }

    public static void replace(String string, String string2, String string3, StringBuffer stringBuffer) {
        int n = 0;
        int n2 = 0;
        while (n >= 0) {
            n = string.indexOf(string2, n2);
            if (n == -1) {
                stringBuffer.append(string.substring(n2));
                continue;
            }
            stringBuffer.append(string.substring(n2, n));
            stringBuffer.append(string3);
            n2 = n + string2.length();
        }
    }

    public static String labeledComment(String string, String string2) {
        return new StringBuffer().append(StringUtilities.labeledStart(string)).append(string2).append(StringUtilities.labeledEnd()).toString();
    }

    public static String labeledStart(String string) {
        return new StringBuffer().append('[').append(string).append(": ").toString();
    }

    public static String labeledEnd() {
        return "]";
    }

    public static String removeAllBetween(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = string3.length();
        do {
            n = string.indexOf(string2, n2);
            n2 = string.indexOf(string3, n);
            if (n >= 0 && n < n2) {
                stringBuffer.append(string.substring(n3, n));
                n3 = n2 + n4;
                continue;
            }
            stringBuffer.append(string.substring(n3, string.length()));
        } while (n >= 0);
        return stringBuffer.toString();
    }

    public static boolean isEmpty(String string) {
        return string == null || string.trim().equals(EMPTY_STRING);
    }

    public static boolean isNotEmpty(String string) {
        return !StringUtilities.isEmpty(string);
    }

    public static String decodeAttributeValue(String string) {
        if (string == null || EMPTY_STRING.equalsIgnoreCase(string)) {
            return string;
        }
        String string2 = string;
        if (string2.indexOf(38) >= 0) {
            string2 = StringUtilities.replace(string2, "&apos;", "'");
            string2 = StringUtilities.replace(string2, "&quot;", "\"");
            string2 = StringUtilities.replace(string2, "&lt;", "<");
            string2 = StringUtilities.replace(string2, "&gt;", ">");
            string2 = StringUtilities.replace(string2, "&amp;", "&");
        }
        if (string2.indexOf("<br>") >= 0) {
            string2 = StringUtilities.replace(string2, "<br>", "\r\n");
        }
        if (string2.indexOf("<br/>") >= 0) {
            string2 = StringUtilities.replace(string2, "<br/>", "\n");
        }
        if (string2.indexOf("</br>") >= 0) {
            string2 = StringUtilities.replace(string2, "</br>", "\r");
        }
        return string2;
    }

    public static String encodeAttributeValue(String string) {
        if (string == null || EMPTY_STRING.equalsIgnoreCase(string)) {
            return string;
        }
        String string2 = StringUtilities.clearInvalidXMLCharacters(string);
        if (string2.indexOf("&quot;") >= 0) {
            string2 = StringUtilities.replace(string2, "&quot;", "&amp;quot;");
        }
        if (string2.indexOf("&lt;") >= 0) {
            string2 = StringUtilities.replace(string2, "&lt;", "&amp;lt;");
        }
        if (string2.indexOf("&gt;") >= 0) {
            string2 = StringUtilities.replace(string2, "&gt;", "&amp;gt;");
        }
        if (string2.indexOf(38) >= 0) {
            string2 = StringUtilities.replace(string2, "&", "&amp;");
        }
        if (string2.indexOf(34) >= 0) {
            string2 = StringUtilities.replace(string2, "\"", "&quot;");
        }
        if (string2.indexOf(39) >= 0) {
            string2 = StringUtilities.replace(string2, "'", "&apos;");
        }
        if (string2.indexOf(60) >= 0) {
            string2 = StringUtilities.replace(string2, "<", "&lt;");
        }
        if (string2.indexOf(62) >= 0) {
            string2 = StringUtilities.replace(string2, ">", "&gt;");
        }
        if (string2.indexOf("\r\n") >= 0) {
            string2 = StringUtilities.replace(string2, "\r\n", "&lt;br&gt;");
        }
        if (string2.indexOf(10) >= 0) {
            string2 = StringUtilities.replace(string2, "\n", "&lt;br/&gt;");
        }
        if (string2.indexOf("\r") >= 0) {
            string2 = StringUtilities.replace(string2, "\r", "&lt;/br&gt;");
        }
        return string2;
    }

    public static String clearInvalidXMLCharacters(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string == null || EMPTY_STRING.equals(string)) {
            return EMPTY_STRING;
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!(c == '\t' || c == '\n' || c == '\r' || c >= ' ' && c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd') && (c < '\u10000' || c > '\u10ffff')) continue;
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }
}

