/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util.propertymap;

import java.awt.Color;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectPropertyTranslator;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.propertymap.PropertyMap;
import oracle.dbtools.crest.util.propertymap.PropertyMapComparer;
import oracle.dbtools.crest.util.propertymap.PropertyTranslator;

public class PropertyMapWrapper
implements PropertyMap,
Cloneable {
    public static final String KEY_PREFIX = "object.property.auto.";
    private static final PropertyTranslator[] EMPTY_TRANSLATORS = new PropertyTranslator[0];
    private boolean printErrors = false;
    private static final Logger LOGGER = new Logger(PropertyMapWrapper.class);
    private static PropertyTranslator[] sharedTranslators = new PropertyTranslator[]{new StringPropertyTranslator(), new ShortPropertyTranslator(), new IntegerPropertyTranslator(), new LongPropertyTranslator(), new FloatPropertyTranslator(), new DoublePropertyTranslator(), new BooleanPropertyTranslator()};
    private PropertyTranslator[] translators = EMPTY_TRANSLATORS;
    private Object wrappee = null;
    private Class wrappeeClass = Object.class;
    private PropertyMap delegatePropertyMap = PropertyMap.NULL_INSTANCE;
    private Class baseClass = Object.class;
    private Map accessorMap;

    protected Map getAccessorMap() {
        return this.accessorMap;
    }

    public void setWrappeeClass(Class clazz) {
        if (!this.getBaseClass().isAssignableFrom(clazz)) {
            throw new IllegalStateException("baseClass is not a super class of wrappee class.");
        }
        this.wrappeeClass = clazz == null ? Object.class : clazz;
        this.discoverMethods();
    }

    public Class getWrappeeClass() {
        return this.wrappeeClass;
    }

    public void setBaseClass(Class clazz) {
        this.baseClass = clazz == null ? Object.class : clazz;
    }

    public Class getBaseClass() {
        return this.baseClass;
    }

    public void setWrappee(Object object) {
        if (object != null && this.getWrappeeClass().isAssignableFrom(object.getClass())) {
            this.wrappee = object;
            this.delegatePropertyMap = this.wrappee instanceof PropertyMap ? (PropertyMap)this.wrappee : PropertyMap.NULL_INSTANCE;
        } else if (object == null) {
            this.wrappee = null;
            this.delegatePropertyMap = PropertyMap.NULL_INSTANCE;
        }
    }

    public Object getWrappee() {
        return this.wrappee;
    }

    private void discoverMethods() {
        try {
            Method[] methodArray = this.wrappeeClass.getMethods();
            HashMap hashMap = new HashMap();
            HashMap hashMap2 = new HashMap();
            HashMap hashMap3 = new HashMap();
            for (int i = 0; i < methodArray.length; ++i) {
                if (!this.isAccepted(methodArray[i])) continue;
                if (methodArray[i].getName().startsWith("set")) {
                    this.addToMap(methodArray[i], hashMap, 3);
                    continue;
                }
                if (methodArray[i].getName().startsWith("get")) {
                    this.addToMap(methodArray[i], hashMap2, 3);
                    continue;
                }
                if (!methodArray[i].getName().startsWith("is")) continue;
                this.addToMap(methodArray[i], hashMap3, 2);
            }
            this.accessorMap = new TreeMap();
            this.constructMapping(hashMap2, hashMap3, hashMap);
        }
        catch (SecurityException securityException) {
            LOGGER.error("Can not discover methods: ", securityException);
        }
    }

    private void addToMap(Method method, Map map, int n) {
        String string = method.getName().substring(n);
        map.put(string, method);
    }

    private void constructMapping(Map map, Map map2, Map map3) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = map3.keySet().iterator();
        while (iterator.hasNext()) {
            stringBuffer.setLength(0);
            String string = (String)iterator.next();
            Method method = (Method)map3.get(string);
            Method method2 = null;
            if (map.containsKey(string)) {
                method2 = (Method)map.get(string);
            } else if (map2.containsKey(string)) {
                method2 = (Method)map2.get(string);
            }
            if (method2 == null || method == null) continue;
            Class<?> clazz = method2.getReturnType();
            Class<?> clazz2 = method.getParameterTypes()[0];
            PropertyTranslator propertyTranslator = this.getPropertyTranslatorFor(clazz2);
            if (propertyTranslator == null) continue;
            if (propertyTranslator.isStatefull()) {
                int n = this.getPosition(propertyTranslator);
                if (n != -1) {
                    propertyTranslator = new ArrayPositionWrapper(n);
                } else if (this.getPrintErrors()) {
                    LOGGER.error("A statefull PropertyTranslator is not in array: " + propertyTranslator.getClass());
                }
            }
            if (!clazz.equals(clazz2)) continue;
            AccessorPair accessorPair = new AccessorPair();
            accessorPair.setSetter(method);
            accessorPair.setGetter(method2);
            accessorPair.setPropertyTranslator(propertyTranslator);
            stringBuffer.append(KEY_PREFIX);
            stringBuffer.append(string);
            string = stringBuffer.toString();
            this.accessorMap.put(string, accessorPair);
        }
    }

    public void setPrintErrors(boolean bl) {
        this.printErrors = bl;
    }

    public boolean getPrintErrors() {
        return this.printErrors;
    }

    protected boolean isAccepted(Method method) {
        boolean bl = this.isPublicNonStaticMethod(method) && this.isBelowBaseClass(method) && (this.hasSingleArgument(method) || this.hasNoArgument(method) && !this.hasVoidReturn(method));
        return bl;
    }

    protected boolean hasSingleArgument(Method method) {
        return method.getParameterTypes().length == 1;
    }

    protected boolean hasNoArgument(Method method) {
        return method.getParameterTypes().length == 0;
    }

    protected boolean hasVoidReturn(Method method) {
        return Void.TYPE.equals(method.getReturnType());
    }

    protected boolean isBelowBaseClass(Method method) {
        return this.getBaseClass().isAssignableFrom(method.getDeclaringClass());
    }

    protected boolean isPublicNonStaticMethod(Method method) {
        int n = method.getModifiers();
        return Modifier.isPublic(n) && !Modifier.isStatic(n);
    }

    public boolean hasAccessorPair(String string) {
        return this.accessorMap.containsKey(string);
    }

    protected AccessorPair getAccessorPair(String string) {
        return (AccessorPair)this.accessorMap.get(string);
    }

    @Override
    public void setProperty(String string, String string2) {
        if (this.wrappee != null) {
            if (this.hasAccessorPair(string)) {
                AccessorPair accessorPair = this.getAccessorPair(string);
                PropertyTranslator propertyTranslator = accessorPair.getPropertyTranslator();
                if (propertyTranslator instanceof StorageObjectPropertyTranslator && this.wrappee instanceof StorageObject) {
                    ((StorageObjectPropertyTranslator)propertyTranslator).setStorageDesign(((StorageObject)this.wrappee).getStorageDesign());
                }
                Method method = accessorPair.getSetter();
                try {
                    method.invoke(this.wrappee, propertyTranslator.translateFromString(string2));
                }
                catch (IllegalAccessException illegalAccessException) {
                    LOGGER.error("No access rights for setter method", illegalAccessException);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    LOGGER.error("Illegal argument for setter", illegalArgumentException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    LOGGER.error("Invocation error for setter: ", invocationTargetException);
                }
            } else {
                this.delegatePropertyMap.setProperty(string, string2);
            }
        }
    }

    @Override
    public String getProperty(String string) {
        if (this.wrappee != null) {
            if (this.hasAccessorPair(string)) {
                AccessorPair accessorPair = this.getAccessorPair(string);
                Method method = accessorPair.getGetter();
                try {
                    Object object = method.invoke(this.wrappee, new Object[0]);
                    return accessorPair.getPropertyTranslator().translateToString(object);
                }
                catch (IllegalAccessException illegalAccessException) {
                    LOGGER.error("No access rights for getter method", illegalAccessException);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    LOGGER.error("Illegal argument for getter", illegalArgumentException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    LOGGER.error("Invocation error for getter", invocationTargetException);
                }
            } else {
                return this.delegatePropertyMap.getProperty(string);
            }
        }
        return null;
    }

    @Override
    public boolean hasProperty(String string) {
        return this.hasAccessorPair(string) || this.delegatePropertyMap.hasProperty(string);
    }

    @Override
    public boolean hasProperty(String string, String string2) {
        return this.getProperty(string) != null;
    }

    @Override
    public void removeProperty(String string) {
        this.delegatePropertyMap.removeProperty(string);
    }

    @Override
    public void clearProperties() {
        this.delegatePropertyMap.clearProperties();
    }

    @Override
    public Iterator getPropertyNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        PropertyNameIterator propertyNameIterator = new PropertyNameIterator();
        while (propertyNameIterator.hasNext()) {
            String string = (String)propertyNameIterator.next();
            if (arrayList.contains(string)) continue;
            arrayList.add(string);
        }
        return arrayList.iterator();
    }

    public void setTranslators(PropertyTranslator[] propertyTranslatorArray) {
        int n = this.translators.length;
        this.translators = propertyTranslatorArray != null ? propertyTranslatorArray : EMPTY_TRANSLATORS;
        int n2 = this.translators.length;
        if (n2 != n) {
            this.discoverMethods();
        }
    }

    public PropertyTranslator[] getTranslators() {
        return this.translators;
    }

    protected PropertyTranslator getTranslator(int n) {
        if (n < this.getTranslators().length && n >= 0) {
            return this.getTranslators()[n];
        }
        throw new IllegalStateException("Trying to find a PropertyTranslator that is no longer available (position)");
    }

    public int getPosition(PropertyTranslator propertyTranslator) {
        for (int i = 0; i < sharedTranslators.length; ++i) {
            if (sharedTranslators[i] != propertyTranslator) continue;
            return i;
        }
        return -1;
    }

    private PropertyTranslator getPropertyTranslatorFor(Class clazz) {
        int n;
        for (n = 0; n < sharedTranslators.length; ++n) {
            if (!sharedTranslators[n].canHandleClass(clazz)) continue;
            return sharedTranslators[n];
        }
        for (n = 0; n < this.translators.length; ++n) {
            if (!this.translators[n].canHandleClass(clazz)) continue;
            return this.translators[n];
        }
        return null;
    }

    public PropertyMapWrapper makeClone() {
        try {
            return (PropertyMapWrapper)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            LOGGER.error("PropertyMapWrapper should implement Cloneable", cloneNotSupportedException);
            return null;
        }
    }

    protected Object clone() throws CloneNotSupportedException {
        TreeMap treeMap;
        PropertyMapWrapper propertyMapWrapper = (PropertyMapWrapper)super.clone();
        propertyMapWrapper.accessorMap = treeMap = new TreeMap(this.accessorMap);
        return propertyMapWrapper;
    }

    public String toString() {
        return PropertyMapComparer.toString(this);
    }

    class PropertyNameIterator
    implements Iterator {
        private boolean propertyAccessors = true;
        private Iterator delegate = null;

        PropertyNameIterator() {
        }

        private Iterator getDelegate() {
            if (this.propertyAccessors && this.delegate == null) {
                this.delegate = PropertyMapWrapper.this.accessorMap.keySet().iterator();
            }
            return this.delegate;
        }

        @Override
        public boolean hasNext() {
            if (this.getDelegate().hasNext()) {
                return true;
            }
            if (this.propertyAccessors) {
                this.delegate = PropertyMapWrapper.this.delegatePropertyMap.getPropertyNames();
                this.propertyAccessors = false;
                return this.delegate.hasNext();
            }
            return false;
        }

        public Object next() {
            return this.delegate.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("only allowed to read target reference");
        }
    }

    public static class BooleanPropertyTranslator
    extends StringPropertyTranslator {
        @Override
        public Object translateFromString(String string) {
            return string.equalsIgnoreCase(Boolean.TRUE.toString()) ? Boolean.TRUE : Boolean.FALSE;
        }

        @Override
        public boolean canHandleClass(Class clazz) {
            return Boolean.TYPE.equals(clazz) || Boolean.class.equals((Object)clazz);
        }
    }

    public static class DoublePropertyTranslator
    extends StringPropertyTranslator {
        @Override
        public Object translateFromString(String string) {
            try {
                return Double.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                return new Double(0.0);
            }
        }

        @Override
        public boolean canHandleClass(Class clazz) {
            return Double.TYPE.equals(clazz) || Double.class.equals((Object)clazz);
        }
    }

    public static class FloatPropertyTranslator
    extends StringPropertyTranslator {
        @Override
        public Object translateFromString(String string) {
            try {
                return Float.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                return new Float(0.0);
            }
        }

        @Override
        public boolean canHandleClass(Class clazz) {
            return Float.TYPE.equals(clazz) || Float.class.equals((Object)clazz);
        }
    }

    public static class ColorPropertyTranslator
    extends StringPropertyTranslator {
        @Override
        public Object translateFromString(String string) {
            try {
                int n = Integer.parseInt(string);
                return new Color(n);
            }
            catch (NumberFormatException numberFormatException) {
                return new Color(0);
            }
        }

        @Override
        public boolean canHandleClass(Class clazz) {
            return Color.class.equals((Object)clazz);
        }

        @Override
        public String translateToString(Object object) {
            if (object != null) {
                return String.valueOf(((Color)object).getRGB());
            }
            return null;
        }
    }

    public static class ShortPropertyTranslator
    extends StringPropertyTranslator {
        @Override
        public Object translateFromString(String string) {
            try {
                return Short.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                return new Short(0);
            }
        }

        @Override
        public boolean canHandleClass(Class clazz) {
            return Short.TYPE.equals(clazz) || Short.class.equals((Object)clazz);
        }
    }

    public static class LongPropertyTranslator
    extends StringPropertyTranslator {
        @Override
        public Object translateFromString(String string) {
            try {
                return Long.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                return 0L;
            }
        }

        @Override
        public boolean canHandleClass(Class clazz) {
            return Long.TYPE.equals(clazz) || Long.class.equals((Object)clazz);
        }
    }

    public static class IntegerPropertyTranslator
    extends StringPropertyTranslator {
        @Override
        public Object translateFromString(String string) {
            try {
                return Integer.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                return new Integer(0);
            }
        }

        @Override
        public boolean canHandleClass(Class clazz) {
            return Integer.TYPE.equals(clazz) || Integer.class.equals((Object)clazz);
        }
    }

    public static class StringPropertyTranslator
    implements PropertyTranslator {
        @Override
        public Object translateFromString(String string) {
            return string;
        }

        @Override
        public String translateToString(Object object) {
            if (object != null) {
                return object.toString();
            }
            return null;
        }

        @Override
        public boolean canHandleClass(Class clazz) {
            return String.class.equals((Object)clazz);
        }

        @Override
        public boolean isStatefull() {
            return false;
        }
    }

    class ArrayPositionWrapper
    implements PropertyTranslator {
        private int position;

        public ArrayPositionWrapper(int n) {
            this.position = n;
        }

        @Override
        public Object translateFromString(String string) {
            return PropertyMapWrapper.this.getTranslator(this.position).translateFromString(string);
        }

        @Override
        public String translateToString(Object object) {
            return PropertyMapWrapper.this.getTranslator(this.position).translateToString(object);
        }

        @Override
        public boolean canHandleClass(Class clazz) {
            return PropertyMapWrapper.this.getTranslator(this.position).canHandleClass(clazz);
        }

        @Override
        public boolean isStatefull() {
            return true;
        }
    }

    static class AccessorPair {
        private Method getter;
        private Method setter;
        private String name;
        private PropertyTranslator translator;

        AccessorPair() {
        }

        public void setSetter(Method method) {
            this.setter = method;
        }

        public Method getSetter() {
            return this.setter;
        }

        public void setGetter(Method method) {
            this.getter = method;
        }

        public Method getGetter() {
            return this.getter;
        }

        public void setName(String string) {
            this.name = string;
        }

        public String getName() {
            return this.name;
        }

        public void setPropertyTranslator(PropertyTranslator propertyTranslator) {
            this.translator = propertyTranslator;
        }

        public PropertyTranslator getPropertyTranslator() {
            return this.translator;
        }
    }
}

