/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util.options;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.AbstractListModel;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import oracle.dbtools.crest.model.persistence.db.AbstractRepositoryManager;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.AbstractEditorConstants;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.JDBCUtils;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.logging.Logger;

public class RepositoryUsersDialog
extends CustomDialog
implements AbstractEditorConstants {
    private final String[] ACCESS_LEVELS = new String[]{"FULL ACCESS", "LOGICAL ONLY", "VIEWER"};
    private JPanel buttonPanel;
    private JDialog dialog;
    private AbstractRepositoryManager dbman;
    private JList allUsersList;
    private SortedListModel allUsersModel;
    private JTable tbUsers;
    private JButton btnAdd;
    private JButton btnRemove;
    private List lsUsers;
    private List repUsers = new ArrayList();
    private static final Logger LOGGER = new Logger(RepositoryUsersDialog.class);
    List list = null;

    public RepositoryUsersDialog(ApplicationView applicationView, AbstractRepositoryManager abstractRepositoryManager) {
        super(applicationView);
        this.dbman = abstractRepositoryManager;
        JScrollPane jScrollPane = new JScrollPane(this.initUsersPanel());
        this.add((Component)jScrollPane, "Center");
        this.add((Component)this.getButtonPanel(), "South");
        this.initUsers();
    }

    private void initUsers() {
        try {
            Object object;
            String string;
            this.repUsers.clear();
            Connection connection = this.dbman.getConnection();
            Statement statement = null;
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            ResultSet resultSet = null;
            String string2 = "select name, viewer_mode, logical_only, deleted from DMR_Users";
            try {
                statement = connection.createStatement();
            }
            catch (SQLException sQLException) {
                LOGGER.error("RepositoryUsersDialog.initUsers: ", sQLException);
            }
            try {
                resultSet = statement.executeQuery(string2);
            }
            catch (SQLException sQLException) {
                System.out.println(sQLException.getMessage());
                LOGGER.error("RepositoryUsersDialog.initUsers: ", sQLException);
            }
            if (resultSet != null) {
                try {
                    while (resultSet.next()) {
                        string = resultSet.getString(1);
                        object = resultSet.getString(2);
                        String string3 = resultSet.getString(3);
                        String string4 = resultSet.getString(4);
                        if (this.dbman.getUser().trim().equalsIgnoreCase(string.trim())) continue;
                        int n = 0;
                        if ("Y".equalsIgnoreCase((String)object)) {
                            n = 2;
                        } else if ("Y".equalsIgnoreCase(string3)) {
                            n = 1;
                        }
                        UserObj userObj = new UserObj(string, n);
                        if ("Y".equalsIgnoreCase(string4)) {
                            userObj.isDeleted = true;
                        } else {
                            this.lsUsers.add(userObj);
                        }
                        this.repUsers.add(userObj.clone(userObj));
                    }
                }
                catch (SQLException sQLException) {
                    System.out.println(sQLException.getMessage());
                    LOGGER.error("RepositoryUsersDialog.initUsers: ", sQLException);
                }
                resultSet.close();
                if (statement != null) {
                    statement.close();
                }
            }
            resultSet = databaseMetaData.getSchemas();
            while (resultSet.next()) {
                string = resultSet.getString(1);
                if (this.dbman.getUser().trim().equalsIgnoreCase(string.trim()) || this.exists(string)) continue;
                object = new UserObj(string.trim(), 0);
                this.allUsersModel.add(object);
            }
            if (resultSet != null) {
                resultSet.close();
            }
            if (statement != null) {
                statement.close();
            }
        }
        catch (Exception exception) {
            MessageDialogs.showErrorMessage(exception.getMessage());
            LOGGER.error("RepositoryUsersDialog.initUsers: ", exception);
        }
    }

    private boolean exists(String string) {
        for (UserObj userObj : this.lsUsers) {
            if (!userObj.name.equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    protected JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            JButton jButton;
            this.buttonPanel = new JPanel();
            if (this.isEditable()) {
                jButton = new JButton(Messages.getString("RepositoryUsersDialog.OK"));
                jButton.setCursor(Cursor.getPredefinedCursor(12));
                jButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        RepositoryUsersDialog.this.setUsers();
                        RepositoryUsersDialog.this.close();
                    }
                });
                jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
                this.buttonPanel.add(jButton);
            }
            jButton = new JButton(this.isEditable() ? Messages.getString("RepositoryUsersDialog.Cancel") : Messages.getString("RepositoryUsersDialog.Close"));
            jButton.setCursor(Cursor.getPredefinedCursor(12));
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    RepositoryUsersDialog.this.close();
                }
            });
            jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            this.buttonPanel.add(jButton);
            JButton jButton2 = new JButton(this.getHelpAction());
            jButton2.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            this.buttonPanel.add(jButton2);
        }
        return this.buttonPanel;
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), Messages.getString("RepositoryUsersDialog.ManageUsers"));
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.getContentPane().add(this);
            this.setDefaultActions(this.dialog, true);
            this.dialog.pack();
            this.dialog.setResizable(false);
            this.dialog.setModal(true);
        }
        return this.dialog;
    }

    public void showDialog() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().setVisible(true);
    }

    @Override
    protected String getHelpIndex() {
        return "REPOSITORY_USERS_DIALOG";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setUsers() {
        block14: {
            PreparedStatement preparedStatement = null;
            PreparedStatement preparedStatement2 = null;
            PreparedStatement preparedStatement3 = null;
            try {
                Object object;
                Connection connection = this.dbman.getConnection();
                Iterator iterator = this.lsUsers.iterator();
                String string = "update DMR_Users set viewer_mode = ?, logical_only = ?, deleted = 'N' where name = ?";
                String string2 = "insert into DMR_Users (name, Viewer_Mode, Logical_Only) values (?, ?, ?)";
                preparedStatement = connection.prepareStatement(string);
                preparedStatement2 = connection.prepareStatement(string2);
                while (iterator.hasNext()) {
                    object = (UserObj)iterator.next();
                    UserObj userObj = this.getUser(this.repUsers, ((UserObj)object).name);
                    if (userObj != null) {
                        if (!userObj.isDeleted && userObj.access == ((UserObj)object).access) continue;
                        try {
                            preparedStatement.setString(1, ((UserObj)object).access == 2 ? "Y" : "N");
                            preparedStatement.setString(2, ((UserObj)object).access == 1 ? "Y" : "N");
                            preparedStatement.setString(3, ((UserObj)object).name);
                            preparedStatement.executeUpdate();
                            if (!userObj.isDeleted) continue;
                            this.createSynonyms(((UserObj)object).name, this.dbman.getUser());
                            this.grantPrivileges(this.dbman.getUser(), ((UserObj)object).name);
                        }
                        catch (SQLException sQLException) {
                            System.out.println(sQLException.getMessage());
                            LOGGER.error("RepositoryUsersDialog.setUsers: ", sQLException);
                        }
                        continue;
                    }
                    try {
                        preparedStatement2.setString(1, ((UserObj)object).name);
                        preparedStatement2.setString(2, ((UserObj)object).access == 2 ? "Y" : "N");
                        preparedStatement2.setString(3, ((UserObj)object).access == 1 ? "Y" : "N");
                        preparedStatement2.executeUpdate();
                        this.createSynonyms(((UserObj)object).name, this.dbman.getUser());
                        this.grantPrivileges(this.dbman.getUser(), ((UserObj)object).name);
                    }
                    catch (SQLException sQLException) {
                        System.out.println(sQLException.getMessage());
                        LOGGER.error("RepositoryUsersDialog.setUsers: ", sQLException);
                    }
                }
                object = "update DMR_Users set deleted = 'Y' where name = ?";
                preparedStatement3 = connection.prepareStatement((String)object);
                for (UserObj userObj : this.repUsers) {
                    UserObj userObj2 = this.getUser(this.lsUsers, userObj.name);
                    if (userObj2 != null) continue;
                    try {
                        preparedStatement3.setString(1, userObj.name);
                        preparedStatement3.executeUpdate();
                        this.dbman.getRepositoryFactory().dropSynonymsFor(userObj.name, connection);
                        this.dbman.getRepositoryFactory().revokePrivilegesFrom(userObj.name, connection);
                    }
                    catch (SQLException sQLException) {
                        System.out.println(sQLException.getMessage());
                        LOGGER.error("RepositoryUsersDialog.setUsers: ", sQLException);
                    }
                }
                JDBCUtils.close(preparedStatement);
            }
            catch (SQLException sQLException) {
                LOGGER.error("RepositoryUsersDialog.setUsers: ", sQLException);
                break block14;
            }
            finally {
                JDBCUtils.close(preparedStatement);
                JDBCUtils.close(preparedStatement2);
                JDBCUtils.close(preparedStatement3);
            }
            JDBCUtils.close(preparedStatement2);
            JDBCUtils.close(preparedStatement3);
        }
    }

    private void createSynonyms(String string, String string2) {
        try {
            Connection connection = this.dbman.getConnection();
            for (String string3 : this.dbman.getRepositoryFactory().getTableNames()) {
                try {
                    String string4 = "create or replace synonym " + string + "." + string3 + " for " + string2 + "." + string3;
                    PreparedStatement preparedStatement = connection.prepareStatement(string4);
                    preparedStatement.execute();
                    preparedStatement.close();
                }
                catch (SQLException sQLException) {
                    System.out.println(string3 + " - " + sQLException.getMessage());
                    LOGGER.error("RepositoryUsersDialog.createSynonyms: ", sQLException);
                }
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            LOGGER.error("RepositoryUsersDialog.createSynonyms: ", exception);
        }
    }

    private void grantPrivileges(String string, String string2) {
        try {
            Connection connection = this.dbman.getConnection();
            for (String string3 : this.dbman.getRepositoryFactory().getTableNames()) {
                try {
                    String string4 = "grant select, insert, delete, update on " + string + "." + string3 + " to " + string2;
                    String string5 = "grant select on " + string + "." + string3 + " to " + string2;
                    PreparedStatement preparedStatement = string3.equalsIgnoreCase("Repository") || string3.equalsIgnoreCase("DMR_Users") ? connection.prepareStatement(string5) : connection.prepareStatement(string4);
                    preparedStatement.execute();
                    preparedStatement.close();
                }
                catch (SQLException sQLException) {
                    System.out.println(string3 + " - " + sQLException.getMessage());
                    LOGGER.error("RepositoryUsersDialog.grantPrivileges: ", sQLException);
                }
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            LOGGER.error("RepositoryUsersDialog.grantPrivileges: ", exception);
        }
    }

    private UserObj getUser(List list, String string) {
        for (UserObj userObj : list) {
            if (!userObj.name.equalsIgnoreCase(string)) continue;
            return userObj;
        }
        return null;
    }

    protected JPanel initUsersPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.allUsersModel = new SortedListModel();
        this.allUsersList = new JList(this.allUsersModel);
        ListSelectionModel listSelectionModel = this.allUsersList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllUsersListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.allUsersList);
        jScrollPane.setPreferredSize(new Dimension(200, 300));
        jPanel.add((Component)jScrollPane, "West");
        this.lsUsers = new ArrayList();
        this.tbUsers = new JTable(new UserModel());
        TableColumn tableColumn = this.tbUsers.getColumnModel().getColumn(1);
        JComboBox<String> jComboBox = new JComboBox<String>(this.ACCESS_LEVELS);
        tableColumn.setCellEditor(new DefaultCellEditor(jComboBox));
        this.tbUsers.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (RepositoryUsersDialog.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                    if (RepositoryUsersDialog.this.tbUsers.getSelectedRow() == -1) {
                        RepositoryUsersDialog.this.btnRemove.setEnabled(false);
                    } else {
                        RepositoryUsersDialog.this.btnRemove.setEnabled(true);
                    }
                }
            }
        });
        JScrollPane jScrollPane2 = new JScrollPane(this.tbUsers);
        jScrollPane2.setPreferredSize(new Dimension(300, 300));
        jPanel.add((Component)jScrollPane2, "East");
        JPanel jPanel2 = new JPanel();
        jPanel2.setPreferredSize(new Dimension(36, 300));
        JToolBar jToolBar = new JToolBar(1);
        jToolBar.setFloatable(false);
        GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
        this.btnAdd = new JButton(gUIConfiguration.getIcon("MOVE_RIGHT_ICON", 16));
        this.btnAdd.addActionListener(new AddUsersActionListener());
        this.btnAdd.setEnabled(false);
        this.btnAdd.setToolTipText(Messages.getString("RepositoryUsersDialog.AddUser"));
        this.btnRemove = new JButton(gUIConfiguration.getIcon("MOVE_LEFT_ICON", 16));
        this.btnRemove.setEnabled(false);
        this.btnRemove.addActionListener(new RemoveUsersActionListener());
        this.btnRemove.setToolTipText(Messages.getString("RepositoryUsersDialog.RemoveUser"));
        JLabel jLabel = new JLabel();
        jLabel.setPreferredSize(new Dimension(16, 110));
        jPanel2.add(jLabel);
        jToolBar.add(this.btnAdd);
        jToolBar.add(this.btnRemove);
        jPanel2.add(jToolBar);
        jPanel.add(jPanel2);
        return jPanel;
    }

    private int getAccessLevel(String string) {
        int n;
        if (this.list == null) {
            this.list = new ArrayList<String>(Arrays.asList(this.ACCESS_LEVELS));
        }
        if ((n = this.list.indexOf(string)) == -1) {
            n = 0;
        }
        return n;
    }

    public class SortedListModel
    extends AbstractListModel {
        private Comparator COMPARATOR = new Comparator(){

            public int compare(Object object, Object object2) {
                String string = object.toString();
                String string2 = object2.toString();
                Collator collator = Collator.getInstance();
                int n = collator.compare(string, string2);
                return n;
            }
        };
        SortedSet model = new TreeSet(this.COMPARATOR);

        @Override
        public int getSize() {
            return this.model.size();
        }

        @Override
        public Object getElementAt(int n) {
            return this.model.toArray()[n];
        }

        public void add(Object object) {
            if (this.model.add(object)) {
                this.fireContentsChanged(this, 0, this.getSize());
            }
        }

        public void addAll(Object[] objectArray) {
            List<Object> list = Arrays.asList(objectArray);
            this.model.addAll(list);
            this.fireContentsChanged(this, 0, this.getSize());
        }

        public void clear() {
            this.model.clear();
            this.fireContentsChanged(this, 0, this.getSize());
        }

        public boolean contains(Object object) {
            return this.model.contains(object);
        }

        public Object firstElement() {
            return this.model.first();
        }

        public Iterator iterator() {
            return this.model.iterator();
        }

        public Object lastElement() {
            return this.model.last();
        }

        public boolean removeElement(Object object) {
            boolean bl = this.model.remove(object);
            if (bl) {
                this.fireContentsChanged(this, 0, this.getSize());
            }
            return bl;
        }
    }

    private class UserObj {
        public static final int ALL_ACCESS = 0;
        public static final int LOGICAL_ONLY_ACCESS = 1;
        public static final int VIEWER_ONLY_ACCESS = 2;
        String name = "";
        int access = 0;
        boolean isDeleted = false;

        public UserObj(String string, int n) {
            this.name = string;
            this.access = n;
        }

        public UserObj(String string, int n, boolean bl) {
            this.name = string;
            this.access = n;
            this.isDeleted = bl;
        }

        public String toString() {
            return this.name;
        }

        public UserObj clone(UserObj userObj) {
            return new UserObj(new String(userObj.name), userObj.access, userObj.isDeleted);
        }
    }

    public class UserModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return RepositoryUsersDialog.this.lsUsers.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("RepositoryUsersDialog.UserName");
            }
            if (n == 1) {
                return Messages.getString("RepositoryUsersDialog.AccessLevel");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 1;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            UserObj userObj = (UserObj)RepositoryUsersDialog.this.lsUsers.get(n);
            if (n2 == 0) {
                return userObj.name;
            }
            if (n2 == 1) {
                return RepositoryUsersDialog.this.ACCESS_LEVELS[userObj.access];
            }
            return new Integer(n * n2);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            UserObj userObj = (UserObj)RepositoryUsersDialog.this.lsUsers.get(n);
            if (n2 == 1) {
                String string = (String)object;
                userObj.access = RepositoryUsersDialog.this.getAccessLevel(string);
            }
        }
    }

    private class AllUsersListSelectionHandler
    implements ListSelectionListener {
        private AllUsersListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (RepositoryUsersDialog.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (RepositoryUsersDialog.this.allUsersList.getSelectedIndex() == -1) {
                    RepositoryUsersDialog.this.btnAdd.setEnabled(false);
                } else {
                    RepositoryUsersDialog.this.btnAdd.setEnabled(true);
                }
            }
        }
    }

    private class RemoveUsersActionListener
    implements ActionListener {
        private RemoveUsersActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!RepositoryUsersDialog.this.lsUsers.isEmpty()) {
                int[] nArray = RepositoryUsersDialog.this.tbUsers.getSelectedRows();
                for (int i = nArray.length - 1; i >= 0; --i) {
                    Object e = RepositoryUsersDialog.this.lsUsers.get(nArray[i]);
                    if (RepositoryUsersDialog.this.allUsersModel.contains(e)) continue;
                    RepositoryUsersDialog.this.allUsersModel.add(e);
                    RepositoryUsersDialog.this.lsUsers.remove(e);
                }
                RepositoryUsersDialog.this.allUsersList.updateUI();
                RepositoryUsersDialog.this.tbUsers.updateUI();
                RepositoryUsersDialog.this.btnRemove.setEnabled(false);
            }
        }
    }

    private class AddUsersActionListener
    implements ActionListener {
        private AddUsersActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (RepositoryUsersDialog.this.allUsersModel.getSize() > 0) {
                Object[] objectArray = RepositoryUsersDialog.this.allUsersList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (RepositoryUsersDialog.this.lsUsers.contains(object)) continue;
                    RepositoryUsersDialog.this.lsUsers.add(object);
                    RepositoryUsersDialog.this.allUsersModel.removeElement(object);
                }
                RepositoryUsersDialog.this.allUsersList.updateUI();
                RepositoryUsersDialog.this.tbUsers.updateUI();
            }
        }
    }
}

