/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util.logging;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.URL;
import java.util.MissingResourceException;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.Extension;
import oracle.dbtools.crest.util.Loader;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.config.EnvironOptions;
import oracle.ide.config.IdeSettings;
import org.apache.log4j.Category;
import org.apache.log4j.xml.DOMConfigurator;

public class Logger {
    private static boolean initialized = false;
    private static boolean firstLog = true;
    private static String configurationFile = "log4j.xml";
    private static String LOG_FILE_NAME = "log.file.name";
    private static Long watchDelay = null;
    private Category category = null;

    public Logger(Class clazz) {
        if (!initialized) {
            Logger.init();
        }
        this.category = Category.getInstance((Class)clazz);
        if (firstLog) {
            try {
                this.info(Extension.getExtensionVersion());
            }
            catch (Exception exception) {
                this.info("3.0");
            }
            firstLog = false;
        }
    }

    private static String getExtensionDir() {
        try {
            ExtensionRegistry extensionRegistry;
            javax.ide.extension.Extension extension;
            if (!Extension.isDataModeler() && (extension = (extensionRegistry = ExtensionRegistry.getExtensionRegistry()).findExtension(Extension.getExtensionID())) != null) {
                String string = extensionRegistry.getInstallDirectory(extension).getAbsolutePath();
                File file = new File(string, "log");
                if (!file.exists()) {
                    file.mkdirs();
                }
                return string;
            }
            return ApplicationView.basePath;
        }
        catch (Exception exception) {
            return "../";
        }
    }

    private static synchronized void init() {
        if (!initialized) {
            Serializable serializable;
            URL uRL = Logger.getCustomLogDir();
            if (uRL != null) {
                if (!uRL.getPath().equals("")) {
                    serializable = new File(uRL.getPath());
                    if (((File)serializable).isDirectory() && Logger.hasPermissions(uRL.getPath())) {
                        System.setProperty(LOG_FILE_NAME, new File(uRL.getPath(), "/datamodeler.log").getAbsolutePath());
                    } else if (Logger.hasPermissions(Logger.getExtensionDir() + "/log/")) {
                        System.setProperty(LOG_FILE_NAME, new File(Logger.getExtensionDir(), "/log/datamodeler.log").getAbsolutePath());
                    } else {
                        System.setProperty(LOG_FILE_NAME, new File(System.getProperty("user.home"), "/datamodeler.log").getAbsolutePath());
                    }
                } else if (Logger.hasPermissions(Logger.getExtensionDir() + "/log/")) {
                    System.setProperty(LOG_FILE_NAME, new File(Logger.getExtensionDir(), "/log/datamodeler.log").getAbsolutePath());
                } else {
                    System.setProperty(LOG_FILE_NAME, new File(System.getProperty("user.home"), "/datamodeler.log").getAbsolutePath());
                }
            } else if (Logger.hasPermissions(Logger.getExtensionDir() + "/log/")) {
                System.setProperty(LOG_FILE_NAME, new File(Logger.getExtensionDir(), "/log/datamodeler.log").getAbsolutePath());
            } else {
                System.setProperty(LOG_FILE_NAME, new File(System.getProperty("user.home"), "/datamodeler.log").getAbsolutePath());
            }
            try {
                serializable = Loader.getResource(configurationFile, Logger.class);
                if (watchDelay != null) {
                    DOMConfigurator.configureAndWatch((String)((URL)serializable).getFile(), (long)watchDelay);
                } else {
                    DOMConfigurator.configure((URL)serializable);
                }
            }
            catch (MissingResourceException missingResourceException) {
                System.out.println(missingResourceException.getMessage());
            }
            initialized = true;
        }
    }

    public static void configure(String string, Long l) {
        if (configurationFile != null) {
            configurationFile = string;
        }
        if (watchDelay != null) {
            watchDelay = l;
        }
        initialized = false;
        Logger.init();
    }

    public void debug(Object object) {
        this.category.debug(object);
    }

    public void debug(Object object, Throwable throwable) {
        this.category.debug(object, throwable);
    }

    public void error(Object object) {
        this.category.error(object);
    }

    public void error(Object object, Throwable throwable) {
        this.category.error(object, throwable);
    }

    public void info(Object object) {
        this.category.info(object);
    }

    public void info(Object object, Throwable throwable) {
        this.category.info(object, throwable);
    }

    public void warn(Object object) {
        this.category.warn(object);
    }

    public void warn(Object object, Throwable throwable) {
        this.category.warn(object, throwable);
    }

    public boolean isDebugEnabled() {
        return this.category.isDebugEnabled();
    }

    public boolean isInfoEnabled() {
        return this.category.isInfoEnabled();
    }

    private static URL getCustomLogDir() {
        try {
            IdeSettings ideSettings = Ide.getSettings();
            EnvironOptions environOptions = (EnvironOptions)ideSettings.getData("environment-options");
            return environOptions.getLogFilePrefix();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void update() {
        Serializable serializable;
        URL uRL = Logger.getCustomLogDir();
        if (uRL != null) {
            if (!uRL.getPath().equals("")) {
                serializable = new File(uRL.getPath());
                if (((File)serializable).isDirectory() && Logger.hasPermissions(uRL.getPath())) {
                    System.setProperty(LOG_FILE_NAME, new File(uRL.getPath(), "/datamodeler.log").getAbsolutePath());
                } else if (Logger.hasPermissions(Logger.getExtensionDir() + "/log/")) {
                    System.setProperty(LOG_FILE_NAME, new File(Logger.getExtensionDir(), "/log/datamodeler.log").getAbsolutePath());
                } else {
                    System.setProperty(LOG_FILE_NAME, new File(System.getProperty("user.home"), "/datamodeler.log").getAbsolutePath());
                }
            } else if (Logger.hasPermissions(Logger.getExtensionDir() + "/log/")) {
                System.setProperty(LOG_FILE_NAME, new File(Logger.getExtensionDir(), "/log/datamodeler.log").getAbsolutePath());
            } else {
                System.setProperty(LOG_FILE_NAME, new File(System.getProperty("user.home"), "/datamodeler.log").getAbsolutePath());
            }
        } else if (Logger.hasPermissions(Logger.getExtensionDir() + "/log/")) {
            System.setProperty(LOG_FILE_NAME, new File(Logger.getExtensionDir(), "/log/datamodeler.log").getAbsolutePath());
        } else {
            System.setProperty(LOG_FILE_NAME, new File(System.getProperty("user.home"), "/datamodeler.log").getAbsolutePath());
        }
        try {
            serializable = Loader.getResource(configurationFile, Logger.class);
            if (watchDelay != null) {
                DOMConfigurator.configureAndWatch((String)((URL)serializable).getFile(), (long)watchDelay);
            } else {
                DOMConfigurator.configure((URL)serializable);
            }
        }
        catch (MissingResourceException missingResourceException) {
            System.out.println(missingResourceException.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean hasPermissions(String string) {
        PrintWriter printWriter = null;
        File file = new File(string + "test.log");
        try {
            FileWriter fileWriter = new FileWriter(file);
            printWriter = new PrintWriter(fileWriter);
            printWriter.write("test");
            printWriter.flush();
            printWriter.close();
            file.delete();
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (printWriter != null) {
                printWriter.flush();
                printWriter.close();
            }
        }
    }
}

