/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util.logging;

import java.util.ArrayList;
import oracle.dbtools.crest.model.MDConfiguration;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.Extension;
import oracle.dbtools.crest.util.Messages;

public class ExportLogger {
    private ArrayList warnings = new ArrayList();
    private ArrayList errors = new ArrayList();
    private ArrayList notRecognized = new ArrayList();
    private int exportedStatemnets;
    private ArrayList failed = new ArrayList();
    private String modelName;
    private static final String NEWLINE = System.getProperty("line.separator");

    public ExportLogger() {
    }

    public ExportLogger(String string) {
        this.modelName = string;
    }

    public ArrayList getErrors() {
        return this.errors;
    }

    public void addFailedStatement(String string) {
        if (!"".equalsIgnoreCase(string)) {
            this.failed.add(string.trim());
        }
    }

    public void addError(String string) {
        if (!"".equalsIgnoreCase(string)) {
            this.errors.add(string.trim());
        }
    }

    public void addWarning(String string) {
        this.addWarning(string, false);
    }

    public void addWarning(String string, boolean bl) {
        if (!"".equalsIgnoreCase(string)) {
            if (bl) {
                if (!this.warningExists(string.trim())) {
                    this.warnings.add(string.trim());
                }
            } else {
                this.warnings.add(string);
            }
        }
    }

    public boolean warningExists(String string) {
        for (String string2 : this.warnings) {
            if (!string.equals(string2)) continue;
            return true;
        }
        return false;
    }

    public void setErrors(ArrayList arrayList) {
        this.errors = arrayList;
    }

    public int getFailedStatements() {
        return this.failed.size();
    }

    public ArrayList getNotRecognized() {
        return this.notRecognized;
    }

    public void addNotRecognized(String string) {
        this.notRecognized.add(string);
    }

    public void setNotRecognized(ArrayList arrayList) {
        this.notRecognized = arrayList;
    }

    public int getExportedStatemnets() {
        return this.exportedStatemnets;
    }

    public void setExportedStatemnets(int n) {
        this.exportedStatemnets = n;
    }

    public void incrementExportedStatemnets() {
        ++this.exportedStatemnets;
    }

    public ArrayList getWarnings() {
        return this.warnings;
    }

    public void setWarnings(ArrayList arrayList) {
        this.warnings = arrayList;
    }

    public String generateReport(ApplicationView applicationView) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Extension.getExtensionVersion()).append(NEWLINE);
        stringBuffer.append(MDConfiguration.getDefaultInstance().get("appName")).append(Messages.getString("ExportLogger.ExportLog")).append(NEWLINE);
        stringBuffer.append(Messages.getString("ExportLogger.DateAndTime")).append(MDConfiguration.timeToString(System.currentTimeMillis())).append(NEWLINE);
        stringBuffer.append(Messages.getString("ExportLogger.DesignName")).append(applicationView.getDesignName()).append(NEWLINE);
        stringBuffer.append(Messages.getString("ExportLogger.ModelName")).append(this.modelName).append(NEWLINE);
        stringBuffer.append(NEWLINE).append(Messages.getString("ExportLogger.ExportFinished")).append(NEWLINE).append(NEWLINE);
        stringBuffer.append(Messages.getString("ExportLogger.Errors")).append(this.getErrors().size()).append(NEWLINE);
        stringBuffer.append(Messages.getString("ExportLogger.Warnings")).append(this.getWarnings().size()).append(NEWLINE);
        if (this.getErrors().size() > 0) {
            stringBuffer.append(NEWLINE);
            stringBuffer.append("<<<<< ERRORS >>>>>").append(NEWLINE);
            for (String string : this.getErrors()) {
                stringBuffer.append(string).append(NEWLINE);
            }
        }
        if (this.getWarnings().size() > 0) {
            stringBuffer.append(NEWLINE);
            stringBuffer.append("<<<<< WARNINGS >>>>>").append(NEWLINE);
            for (String string : this.getWarnings()) {
                stringBuffer.append(string).append(NEWLINE);
            }
        }
        return stringBuffer.toString();
    }

    public String getModelName() {
        return this.modelName;
    }

    public void setModelName(String string) {
        this.modelName = string;
    }
}

