/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util.gui.swing;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class SortedJListModel
extends DefaultListModel {
    private List<SortedListEntry> sortedModel;
    private ListModel unsortedModel;
    private Comparator comparator;
    private SortOrder sortOrder;

    private SortedJListModel() {
    }

    public SortedJListModel(ListModel listModel) {
        this(listModel, SortOrder.ASCENDING, null);
    }

    public SortedJListModel(ListModel listModel, SortOrder sortOrder) {
        this(listModel, sortOrder, null);
    }

    public SortedJListModel(ListModel listModel, SortOrder sortOrder, Comparator comparator) {
        this.unsortedModel = listModel;
        this.unsortedModel.addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent listDataEvent) {
                SortedJListModel.this.unsortedIntervalAdded(listDataEvent);
            }

            @Override
            public void intervalRemoved(ListDataEvent listDataEvent) {
                SortedJListModel.this.unsortedIntervalRemoved(listDataEvent);
            }

            @Override
            public void contentsChanged(ListDataEvent listDataEvent) {
                SortedJListModel.this.unsortedContentsChanged(listDataEvent);
            }
        });
        this.sortOrder = sortOrder;
        this.comparator = comparator != null ? comparator : Collator.getInstance();
        int n = listModel.getSize();
        this.sortedModel = new ArrayList<SortedListEntry>(n);
        for (int i = 0; i < n; ++i) {
            SortedListEntry sortedListEntry = new SortedListEntry(i);
            int n2 = this.findInsertionPoint(sortedListEntry);
            this.sortedModel.add(n2, sortedListEntry);
        }
    }

    @Override
    public Object getElementAt(int n) throws IndexOutOfBoundsException {
        if (this.sortedModel.size() == 0) {
            return null;
        }
        int n2 = this.toUnsortedModelIndex(n);
        Object e = this.unsortedModel.getElementAt(n2);
        return e;
    }

    @Override
    public int getSize() {
        int n = this.sortedModel.size();
        return n;
    }

    public int toUnsortedModelIndex(int n) throws IndexOutOfBoundsException {
        int n2 = -1;
        SortedListEntry sortedListEntry = this.sortedModel.get(n);
        n2 = sortedListEntry.getIndex();
        return n2;
    }

    public int[] toUnsortedModelIndices(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        int n = 0;
        for (int n2 : nArray) {
            nArray2[n++] = this.toUnsortedModelIndex(n2);
        }
        Arrays.sort(nArray2);
        return nArray2;
    }

    public int toSortedModelIndex(int n) {
        int n2 = -1;
        int n3 = -1;
        for (SortedListEntry sortedListEntry : this.sortedModel) {
            ++n3;
            if (sortedListEntry.getIndex() != n) continue;
            n2 = n3;
            break;
        }
        return n2;
    }

    public int[] toSortedModelIndices(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        int n = 0;
        for (int n2 : nArray) {
            nArray2[n++] = this.toSortedModelIndex(n2);
        }
        Arrays.sort(nArray2);
        return nArray2;
    }

    private void resetModelData() {
        int n = 0;
        for (SortedListEntry sortedListEntry : this.sortedModel) {
            sortedListEntry.setIndex(n++);
        }
    }

    public void setComparator(Comparator comparator) {
        if (comparator == null) {
            this.sortOrder = SortOrder.UNORDERED;
            this.comparator = Collator.getInstance();
            this.resetModelData();
        } else {
            this.comparator = comparator;
            Collections.sort(this.sortedModel);
        }
        this.fireContentsChanged(0, 0, this.sortedModel.size() - 1);
    }

    public void setSortOrder(SortOrder sortOrder) {
        if (this.sortOrder != sortOrder) {
            this.sortOrder = sortOrder;
            if (sortOrder == SortOrder.UNORDERED) {
                this.resetModelData();
            } else {
                Collections.sort(this.sortedModel);
            }
            this.fireContentsChanged(0, 0, this.sortedModel.size() - 1);
        }
    }

    private void unsortedIntervalAdded(ListDataEvent listDataEvent) {
        int n;
        int n2 = listDataEvent.getIndex0();
        int n3 = listDataEvent.getIndex1();
        int n4 = n3 - n2 + 1;
        for (SortedListEntry sortedListEntry : this.sortedModel) {
            n = sortedListEntry.getIndex();
            if (n < n2) continue;
            sortedListEntry.setIndex(n + n4);
        }
        for (int i = n2; i <= n3; ++i) {
            SortedListEntry sortedListEntry;
            sortedListEntry = new SortedListEntry(i);
            n = this.findInsertionPoint(sortedListEntry);
            this.sortedModel.add(n, sortedListEntry);
            this.fireIntervalAdded(1, n, n);
        }
    }

    private void unsortedIntervalRemoved(ListDataEvent listDataEvent) {
        int n;
        int n2 = listDataEvent.getIndex0();
        int n3 = listDataEvent.getIndex1();
        int n4 = n3 - n2 + 1;
        int n5 = this.sortedModel.size();
        boolean[] blArray = new boolean[n5];
        for (n = n5 - 1; n >= 0; --n) {
            SortedListEntry sortedListEntry = this.sortedModel.get(n);
            int n6 = sortedListEntry.getIndex();
            if (n6 > n3) {
                sortedListEntry.setIndex(n6 - n4);
                continue;
            }
            if (n6 < n2) continue;
            this.sortedModel.remove(n);
            blArray[n] = true;
        }
        for (n = blArray.length - 1; n >= 0; --n) {
            if (!blArray[n]) continue;
            this.fireIntervalRemoved(2, n, n);
        }
    }

    private void unsortedContentsChanged(ListDataEvent listDataEvent) {
        Collections.sort(this.sortedModel);
        this.fireContentsChanged(0, 0, this.sortedModel.size() - 1);
    }

    private int findInsertionPoint(SortedListEntry sortedListEntry) {
        int n = this.sortedModel.size();
        if (this.sortOrder != SortOrder.UNORDERED && (n = Collections.binarySearch(this.sortedModel, sortedListEntry)) < 0) {
            n = -(n + 1);
        }
        return n;
    }

    class SortedListEntry
    implements Comparable {
        private int index;

        private SortedListEntry() {
        }

        public SortedListEntry(int n) {
            this.index = n;
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int n) {
            this.index = n;
        }

        public int compareTo(Object object) {
            Object object2 = SortedJListModel.this.unsortedModel.getElementAt(this.index);
            SortedListEntry sortedListEntry = (SortedListEntry)object;
            Object object3 = SortedJListModel.this.unsortedModel.getElementAt(sortedListEntry.getIndex());
            if (SortedJListModel.this.comparator instanceof Collator) {
                object2 = object2.toString();
                object3 = object3.toString();
            }
            int n = SortedJListModel.this.comparator.compare(object2, object3);
            if (SortedJListModel.this.sortOrder == SortOrder.DESCENDING) {
                n = -n;
            }
            return n;
        }
    }

    public static enum SortOrder {
        UNORDERED,
        ASCENDING,
        DESCENDING;

    }
}

