/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util.gui.swing;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import javax.swing.text.View;

public class SelectedTabbedPaneUI
extends BasicTabbedPaneUI {
    private static final Color whiteColor = Color.white;
    private static final Color lightBlue = new Color(61, 149, 255, 50);
    private static final Color lightWhite = new Color(200, 200, 200, 50);
    private static final Color selectedColor = new Color(0, 84, 227);

    @Override
    protected void paintTabBackground(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        if (bl) {
            GradientPaint gradientPaint = this.tabPane.isEnabledAt(n2) ? new GradientPaint(n3, n4, selectedColor, n3 + n5 - 2, n4, lightBlue) : new GradientPaint(n3, n4, this.shadow, n3 + n5 / 2, n4, lightWhite);
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setPaint(gradientPaint);
            if (n == 1) {
                graphics2D.fillRect(n3 + 2, n4 + 2, n5 - 2, n6 - 2);
            } else {
                graphics2D.fillRect(n3 + 2, n4, n5 - 2, n6 - 1);
            }
        }
    }

    @Override
    protected void paintFocusIndicator(Graphics graphics, int n, Rectangle[] rectangleArray, int n2, Rectangle rectangle, Rectangle rectangle2, boolean bl) {
    }

    @Override
    protected void paintTabBorder(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        if (n == 1) {
            graphics.setColor(this.shadow);
            graphics.drawLine(n3, n4 + 2, n3, n4 + n6 - 2);
            graphics.drawLine(n3 + 1, n4 + 1, n3 + 1, n4 + 1);
            graphics.drawLine(n3 + 2, n4, n3 + n5 - 2, n4);
            graphics.drawLine(n3 + n5, n4 + 2, n3 + n5, n4 + n6 - 2);
            graphics.drawLine(n3 + n5 - 1, n4 + 1, n3 + n5 - 1, n4 + 1);
            if (bl) {
                graphics.setColor(this.lightHighlight);
                graphics.drawLine(n3 + 1, n4 + 2, n3 + 1, n4 + n6 - 1);
                graphics.drawLine(n3 + 3, n4 + 1, n3 + n5 - 2, n4 + 1);
                graphics.drawLine(n3 + n5 - 1, n4 + 2, n3 + n5 - 1, n4 + n6 - 1);
            }
        } else if (n == 3) {
            graphics.setColor(this.shadow);
            graphics.drawLine(n3, n4 + 1, n3, n4 + n6 - 2);
            graphics.drawLine(n3 + 2, n4 + n6, n3 + 1, n4 - 1 + n6);
            graphics.drawLine(n3 + 2, n4 + n6, n3 + n5 - 3, n4 + n6);
            graphics.drawLine(n3 + n5, n4 + n6 - 2, n3 + n5, n4 + 1);
            graphics.drawLine(n3 + n5 - 2, n4 + n6, n3 + n5 - 1, n4 - 1 + n6);
            if (bl) {
                graphics.setColor(this.lightHighlight);
                graphics.drawLine(n3 + 1, n4, n3 + 1, n4 + n6 - 2);
                graphics.drawLine(n3 + 2, n4 - 1 + n6, n3 + n5 - 2, n4 - 1 + n6);
                graphics.drawLine(n3 + n5 - 1, n4 - 2 + n6, n3 + n5 - 1, n4);
            }
        } else {
            super.paintTabBorder(graphics, n, n2, n3, n4, n5, n6, bl);
        }
    }

    @Override
    protected void paintText(Graphics graphics, int n, Font font, FontMetrics fontMetrics, int n2, String string, Rectangle rectangle, boolean bl) {
        graphics.setFont(font);
        View view = this.getTextViewForTab(n2);
        if (view != null) {
            view.paint(graphics, rectangle);
        } else {
            int n3 = this.tabPane.getDisplayedMnemonicIndexAt(n2);
            if (this.tabPane.isEnabled() && this.tabPane.isEnabledAt(n2)) {
                int n4 = 0;
                if (bl) {
                    graphics.setColor(whiteColor);
                    if (n == 3) {
                        n4 = 2;
                    } else if (n == 1) {
                        n4 = -2;
                    }
                } else {
                    graphics.setColor(this.tabPane.getForegroundAt(n2));
                }
                BasicGraphicsUtils.drawStringUnderlineCharAt(graphics, string, n3, rectangle.x, rectangle.y + fontMetrics.getAscent() - n4);
            } else {
                graphics.setColor(this.tabPane.getBackgroundAt(n2).brighter());
                BasicGraphicsUtils.drawStringUnderlineCharAt(graphics, string, n3, rectangle.x, rectangle.y + fontMetrics.getAscent());
                graphics.setColor(this.tabPane.getBackgroundAt(n2).darker());
                BasicGraphicsUtils.drawStringUnderlineCharAt(graphics, string, n3, rectangle.x - 1, rectangle.y + fontMetrics.getAscent() - 1);
            }
        }
    }
}

