/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util.gui.swing;

import java.awt.Toolkit;
import java.util.regex.Pattern;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class JNumericField
extends JTextField {
    private Pattern wholeNumberPattern;

    public JNumericField() {
        this.setDocument(new NumericDocument());
    }

    public JNumericField(int n, int n2) {
        this();
        this.wholeNumberPattern = Pattern.compile("^?[0-9]{0," + n + "}");
        this.setColumns(n2);
    }

    class NumericDocument
    extends PlainDocument {
        NumericDocument() {
        }

        @Override
        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (string != null) {
                String string2;
                int n2 = this.getLength();
                if (n2 == 0) {
                    string2 = string;
                } else {
                    String string3 = this.getText(0, n2);
                    StringBuffer stringBuffer = new StringBuffer(string3);
                    stringBuffer.insert(n, string);
                    string2 = stringBuffer.toString();
                }
                if (n2 == 0 && ("-".equals(string) || "+".equals(string))) {
                    super.insertString(n, string, attributeSet);
                } else {
                    try {
                        if (this.validateValue(string2)) {
                            super.insertString(n, string, attributeSet);
                        } else {
                            Toolkit.getDefaultToolkit().beep();
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        Toolkit.getDefaultToolkit().beep();
                    }
                }
            }
        }

        public boolean validateValue(String string) throws NumberFormatException {
            return JNumericField.this.wholeNumberPattern != null && JNumericField.this.wholeNumberPattern.matcher(string).matches();
        }
    }
}

