/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util.gui.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class JListDialog
extends JDialog {
    private static final String KEY_ESCAPE = "ESCAPE";
    private JList list;
    private Object result = null;
    private JButton bnOK;
    private Action escapeAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JListDialog.this.result = null;
            JListDialog.this.dispose();
        }
    };

    public JListDialog(Frame frame, String string, String string2, Object[] objectArray, Object object, int n) {
        super(frame, string, true);
        this.getContentPane().add((Component)this.init(string2, objectArray, object), "Center");
        this.getContentPane().add((Component)this.getBottomPanel(), "South");
        int n2 = 1;
        JComponent jComponent = (JComponent)this.getContentPane();
        jComponent.getInputMap(n2).put(KeyStroke.getKeyStroke(KEY_ESCAPE), KEY_ESCAPE);
        jComponent.getActionMap().put(KEY_ESCAPE, this.escapeAction);
        this.pack();
        this.setSize(new Dimension(n, 280));
        this.setResizable(false);
        CommonUtil.centerOnScreen(this);
    }

    private JPanel init(String string, Object[] objectArray, Object object) {
        JPanel jPanel = new JPanel(new BorderLayout());
        JLabel jLabel = new JLabel(string);
        jPanel.add((Component)jLabel, "North");
        this.list = new JList<Object>(objectArray);
        this.list.setSelectionMode(0);
        if (object != null) {
            this.list.setSelectedValue(object, true);
        }
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                JListDialog.this.result = JListDialog.this.list.getSelectedValue();
                if (mouseEvent.getClickCount() == 2) {
                    JListDialog.this.dispose();
                }
                JListDialog.this.bnOK.setEnabled(JListDialog.this.result != null);
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.list);
        jPanel.add(jScrollPane);
        return jPanel;
    }

    public JPanel getBottomPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(1));
        this.bnOK = new JButton(Messages.getString("JListDialog.OK"));
        this.bnOK.setMnemonic(79);
        this.bnOK.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.bnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JListDialog.this.result = JListDialog.this.list.getSelectedValue();
                JListDialog.this.dispose();
            }
        });
        this.bnOK.setEnabled(this.list.getSelectedValue() != null);
        this.getRootPane().setDefaultButton(this.bnOK);
        jPanel.add(this.bnOK);
        JButton jButton = new JButton(Messages.getString("JListDialog.Cancel"));
        jButton.setMnemonic(67);
        jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JListDialog.this.result = null;
                JListDialog.this.dispose();
            }
        });
        jPanel.add(jButton);
        return jPanel;
    }

    public Object getResult() {
        return this.result;
    }

    public static Object showDialog(Frame frame, String string, String string2, Object[] objectArray, Object object, int n) {
        JListDialog jListDialog = new JListDialog(frame, string2, string, objectArray, object, n);
        jListDialog.setVisible(true);
        return jListDialog.getResult();
    }

    public static Object showDialog(Frame frame, String string, String string2, Object[] objectArray, Object object) {
        JListDialog jListDialog = new JListDialog(frame, string2, string, objectArray, object, 300);
        jListDialog.setVisible(true);
        return jListDialog.getResult();
    }

    public static Object showDialog(Frame frame, String string, String string2, Object[] objectArray) {
        return JListDialog.showDialog(frame, string, string2, objectArray, null);
    }
}

