/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util.gui.swing;

import oracle.dbtools.crest.util.gui.swing.JNumericField;

public class JIntegerField
extends JNumericField {
    public JIntegerField() {
        this.setDocument(new IntegerDocument());
    }

    public JIntegerField(int n, int n2) {
        this.setDocument(new IntegerDocument());
        this.setColumns(n2);
        this.setValue((long)n);
    }

    public void setLargeIntegerDocument(int n) {
        this.setDocument(new LargeIntegerDocument(n));
    }

    public int getIntValue() {
        try {
            return Integer.parseInt(this.getText());
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public long getLongValue() {
        try {
            return Long.parseLong(this.getText());
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    public void setValue(Integer n) {
        if (n == null) {
            this.setText("");
        } else {
            this.setText(Integer.toString(n));
        }
    }

    public void setValue(long l) {
        this.setText(Long.toString(l));
    }

    class LargeIntegerDocument
    extends JNumericField.NumericDocument {
        int maxDigits;

        public LargeIntegerDocument(int n) {
            super(JIntegerField.this);
            this.maxDigits = 38;
            this.maxDigits = n;
        }

        @Override
        public boolean validateValue(String string) throws NumberFormatException {
            Double.parseDouble(string);
            return string.indexOf(".") == -1 && string.length() <= this.maxDigits;
        }
    }

    class IntegerDocument
    extends JNumericField.NumericDocument {
        IntegerDocument() {
            super(JIntegerField.this);
        }

        @Override
        public boolean validateValue(String string) throws NumberFormatException {
            Integer.parseInt(string);
            return true;
        }
    }
}

