/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util.gui.swing;

import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.EventListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.TabbedPaneUI;
import oracle.dbtools.crest.util.gui.swing.CloseListener;
import oracle.dbtools.crest.util.gui.swing.CloseTabbedPaneEnhancedUI;
import oracle.dbtools.crest.util.gui.swing.CloseTabbedPaneUI;
import oracle.dbtools.crest.util.gui.swing.RightPopupListener;

public class JCloseTabbedPane
extends JTabbedPane {
    private int overTabIndex = -1;
    private CloseTabbedPaneUI paneUI;

    public JCloseTabbedPane() {
        super.setTabLayoutPolicy(1);
        this.paneUI = new CloseTabbedPaneEnhancedUI();
        super.setUI(this.paneUI);
    }

    public int getOverTabIndex() {
        return this.overTabIndex;
    }

    public boolean isCloseEnabled() {
        return this.paneUI.isCloseEnabled();
    }

    @Override
    public void setTabLayoutPolicy(int n) {
    }

    @Override
    public void setTabPlacement(int n) {
    }

    @Override
    public void setUI(TabbedPaneUI tabbedPaneUI) {
    }

    public void setCloseIcon(boolean bl) {
        this.paneUI.setCloseIcon(bl);
    }

    public void detachTab(int n) {
        if (n < 0 || n >= this.getTabCount()) {
            return;
        }
        final JFrame jFrame = new JFrame();
        Window window = SwingUtilities.windowForComponent(this);
        final int n2 = n;
        final JComponent jComponent = (JComponent)this.getComponentAt(n2);
        final Icon icon = this.getIconAt(n2);
        final String string = this.getTitleAt(n2);
        final String string2 = this.getToolTipTextAt(n2);
        final Border border = jComponent.getBorder();
        this.removeTabAt(n);
        jComponent.setPreferredSize(jComponent.getSize());
        jFrame.setTitle(string);
        jFrame.getContentPane().add(jComponent);
        jFrame.setLocation(window.getLocation());
        jFrame.pack();
        jFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                jFrame.dispose();
                JCloseTabbedPane.this.insertTab(string, icon, jComponent, string2, Math.min(n2, JCloseTabbedPane.this.getTabCount()));
                jComponent.setBorder(border);
                JCloseTabbedPane.this.setSelectedComponent(jComponent);
            }
        });
        WindowFocusListener windowFocusListener = new WindowFocusListener(){
            long start;
            long end;

            @Override
            public void windowGainedFocus(WindowEvent windowEvent) {
                this.start = System.currentTimeMillis();
            }

            @Override
            public void windowLostFocus(WindowEvent windowEvent) {
                this.end = System.currentTimeMillis();
                long l = this.end - this.start;
                if (l < 100L) {
                    jFrame.toFront();
                }
                jFrame.removeWindowFocusListener(this);
            }
        };
        jFrame.addWindowFocusListener(windowFocusListener);
        jFrame.show();
        jFrame.toFront();
    }

    public synchronized void addRightPopupListener(RightPopupListener rightPopupListener) {
        this.listenerList.add(RightPopupListener.class, rightPopupListener);
    }

    public synchronized void removeRightPopupListener(RightPopupListener rightPopupListener) {
        this.listenerList.remove(RightPopupListener.class, rightPopupListener);
    }

    public synchronized void addCloseListener(CloseListener closeListener) {
        this.listenerList.add(CloseListener.class, closeListener);
    }

    public synchronized void removeCloseListener(CloseListener closeListener) {
        this.listenerList.remove(CloseListener.class, closeListener);
    }

    public void fireCloseTabEvent(MouseEvent mouseEvent, int n) {
        this.overTabIndex = n;
        EventListener[] eventListenerArray = this.getListeners(CloseListener.class);
        for (int i = 0; i < eventListenerArray.length; ++i) {
            ((CloseListener)eventListenerArray[i]).closeOperation(mouseEvent);
        }
    }

    public void fireRightPopupTabEvent(MouseEvent mouseEvent) {
        this.overTabIndex = -1;
        EventListener[] eventListenerArray = this.getListeners(RightPopupListener.class);
        for (int i = 0; i < eventListenerArray.length; ++i) {
            ((RightPopupListener)eventListenerArray[i]).popupOperation(mouseEvent);
        }
    }
}

