/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util.gui.swing;

import java.util.ArrayList;
import java.util.Collection;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.Messages;

public class ColumnsSortOrderModel
extends AbstractTableModel {
    final String[] COL_NAMES = new String[]{Messages.getString("ColumnsSortOrderModel.ColumnName"), Messages.getString("ColumnsSortOrderModel.SortOrder")};
    private ArrayList columns = new ArrayList();

    public ColumnsSortOrderModel(Index index) {
        Column[] columnArray = (Column[])index.getElements();
        for (int i = 0; i < columnArray.length; ++i) {
            this.columns.add(new ColumnNode(index, columnArray[i]));
        }
    }

    @Override
    public int getColumnCount() {
        return this.COL_NAMES.length;
    }

    @Override
    public int getRowCount() {
        return this.columns.size();
    }

    public void dataChanged() {
        this.fireTableDataChanged();
    }

    @Override
    public String getColumnName(int n) {
        return this.COL_NAMES[n];
    }

    @Override
    public Object getValueAt(int n, int n2) {
        ColumnNode columnNode = (ColumnNode)this.columns.get(n);
        if (n2 == 0) {
            return columnNode;
        }
        return columnNode.sortOrder;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (ApplicationView.IS_VIEWER || ApplicationView.LOGICAL_MODEL_ONLY) {
            return false;
        }
        return n2 != 0;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        ColumnNode columnNode = (ColumnNode)this.columns.get(n);
        if (n2 == 1) {
            columnNode.sortOrder = (String)object;
            this.fireTableCellUpdated(n, n2);
        }
    }

    public void setUpSortOrderColumn(TableColumn tableColumn) {
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.addItem("ASC");
        jComboBox.addItem("DESC");
        tableColumn.setCellEditor(new DefaultCellEditor(jComboBox));
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
        defaultTableCellRenderer.setToolTipText(Messages.getString("ColumnsSortOrderModel.ClickFoComboBox"));
        tableColumn.setCellRenderer(defaultTableCellRenderer);
        TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
        if (tableCellRenderer instanceof DefaultTableCellRenderer) {
            ((DefaultTableCellRenderer)tableCellRenderer).setToolTipText(Messages.getString("ColumnsSortOrderModel.ClickSortOrder"));
        }
    }

    public Collection getColumnsSortOrederColl() {
        return this.columns;
    }

    public class ColumnNode {
        public String name;
        public String objectId;
        public String sortOrder;

        ColumnNode(Index index, Column column) {
            this.name = column.getName();
            this.objectId = column.getObjectID();
            this.sortOrder = index.getColumnSortOrder(column);
        }

        public String toString() {
            return this.name;
        }
    }
}

