/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util.compare;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.dbtools.crest.util.compare.CompareMappingObject;
import oracle.dbtools.crest.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class CompareMapping {
    private static final String COMPARE_MAPPING_FILE_NAME = "comparemapping.xml";
    private static final String COMPARE_MAPPING_ELEMENT = "mapping";
    private static final String COMPARE_MAPPING_SOURCE_PARENT = "sourceparent";
    private static final String COMPARE_MAPPING_TARGET_PARENT = "targetparent";
    private static final String COMPARE_MAPPING_SOURCE_OBJECT = "sourceobject";
    private static final String COMPARE_MAPPING_TARGET_OBJECT = "targetobject";
    private static final String COMPARE_MAPPING_SELECTED = "selected";
    private Map<String, CompareMappingObject> compareMapping = new TreeMap<String, CompareMappingObject>();
    private static final Logger LOGGER = new Logger(CompareMapping.class);

    public Map<String, CompareMappingObject> getCompareMap() {
        return this.compareMapping;
    }

    public void addCompareMappingObject(CompareMappingObject compareMappingObject) {
        this.compareMapping.put(compareMappingObject.toString(), compareMappingObject);
    }

    public void clearCompareMappingsList() {
        this.compareMapping.clear();
    }

    public void init() {
        try {
            File file = new File(COMPARE_MAPPING_FILE_NAME);
            if (file.exists()) {
                FileInputStream fileInputStream = new FileInputStream(file);
                InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, "UTF-8");
                InputSource inputSource = new InputSource(inputStreamReader);
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document document = documentBuilder.parse(inputSource);
                NodeList nodeList = document.getElementsByTagName(COMPARE_MAPPING_ELEMENT);
                int n = nodeList.getLength();
                for (int i = 0; i < n; ++i) {
                    Element element = (Element)nodeList.item(i);
                    String string = element.getAttribute(COMPARE_MAPPING_SOURCE_PARENT);
                    String string2 = element.getAttribute(COMPARE_MAPPING_TARGET_PARENT);
                    String string3 = element.getAttribute(COMPARE_MAPPING_SOURCE_OBJECT);
                    String string4 = element.getAttribute(COMPARE_MAPPING_TARGET_OBJECT);
                    boolean bl = Boolean.valueOf(element.getAttribute(COMPARE_MAPPING_SELECTED));
                    CompareMappingObject compareMappingObject = new CompareMappingObject(string, string3, string2, string4);
                    compareMappingObject.setSelected(bl);
                    this.addCompareMappingObject(compareMappingObject);
                }
            }
        }
        catch (Exception exception) {
            LOGGER.error("Unable to initialize Compare Mapping: ", exception);
        }
    }

    public List<CompareMappingObject> asList() {
        ArrayList<CompareMappingObject> arrayList = new ArrayList<CompareMappingObject>();
        Iterator<String> iterator = this.compareMapping.keySet().iterator();
        while (iterator.hasNext()) {
            arrayList.add(this.compareMapping.get(iterator.next()));
        }
        return arrayList;
    }
}

