/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.MissingResourceException;

public class Loader {
    private Loader() {
    }

    public static URL getResource(String string, Class clazz) throws MissingResourceException {
        URL uRL = null;
        if (string == null) {
            return null;
        }
        for (int i = 0; i < 2; ++i) {
            ClassLoader classLoader;
            if (clazz != null && (classLoader = clazz.getClassLoader()) != null && (uRL = classLoader.getResource(string)) != null) {
                return uRL;
            }
            uRL = ClassLoader.getSystemResource(string);
            if (uRL != null) {
                return uRL;
            }
            if (string.startsWith("/")) {
                if (string.length() <= 1) break;
                string = string.substring(1);
                continue;
            }
            string = "/" + string;
        }
        throw new MissingResourceException("Resource " + string + " not found in the classpath.", string, "");
    }

    public static InputStream getResourceAsStream(String string, Class clazz) throws MissingResourceException, IOException {
        URL uRL = Loader.getResource(string, clazz);
        return uRL.openStream();
    }

    public static String getResourceAsString(String string, Class clazz) throws MissingResourceException, IOException {
        InputStream inputStream = Loader.getResourceAsStream(string, clazz);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        DataInputStream dataInputStream = new DataInputStream(bufferedInputStream);
        int n = dataInputStream.available();
        byte[] byArray = new byte[n];
        dataInputStream.readFully(byArray);
        dataInputStream.close();
        bufferedInputStream.close();
        inputStream.close();
        return new String(byArray);
    }
}

