/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util;

import java.awt.Component;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JOptionPane;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.util.Messages;
import oracle.ide.Ide;

public class BirtReports_JavaMaker {
    RelationalDesign pdes;
    String tab = "  ";
    String tab2 = "    ";
    private List columnNames = new ArrayList();
    private String dirName;
    int cols_in_row = 3;

    public void generate(File file, RelationalDesign relationalDesign) {
        int n;
        this.pdes = relationalDesign;
        if (file.exists() && (n = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("BirtReports_JavaMaker.FileExists"), file.getAbsolutePath()), Messages.getString("BirtReports_JavaMaker.Warning"), 0, 3, this.getConfiguration().getIcon("SAVE_ICON", 32))) == 1) {
            return;
        }
        StringBuffer stringBuffer = this.generateContent();
        file.getParentFile().mkdirs();
        try {
            file.createNewFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new BufferedOutputStream(new FileOutputStream(file)));
        }
        catch (FileNotFoundException fileNotFoundException) {
            printWriter = null;
        }
        if (printWriter != null) {
            printWriter.print(stringBuffer.toString());
            printWriter.flush();
            printWriter.close();
        }
    }

    private StringBuffer generateContent() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("import java.util.ArrayList;");
        stringBuffer.append("\nimport java.util.List;\n");
        stringBuffer.append("\npublic class BirtJavaClasses {");
        Iterator iterator = this.pdes.getTableSet().iterator();
        while (iterator.hasNext()) {
            Table table = (Table)iterator.next();
            stringBuffer.append("\n\n");
            this.processTable(table, stringBuffer);
        }
        stringBuffer.append("\n}");
        return stringBuffer;
    }

    public void setDirName(String string) {
        this.dirName = string;
    }

    private void processTable(Table table, StringBuffer stringBuffer) {
        stringBuffer.append("    public static class ").append(table.getName().trim()).append(" {\n");
        stringBuffer.append(this.tab).append("        private static List columnNames = new ArrayList();\n");
        stringBuffer.append(this.tab).append("        private static List dataTypes = new ArrayList();");
        this.addConstructor(table, stringBuffer);
        stringBuffer.append(this.tab).append("\n        public static List getColumnNames() {");
        stringBuffer.append(this.tab).append("\n            return columnNames;");
        stringBuffer.append(this.tab).append("\n        }");
        stringBuffer.append(this.tab).append("\n        public static List getDataTypes() {");
        stringBuffer.append(this.tab).append("\n            return dataTypes;");
        stringBuffer.append(this.tab).append("\n        }");
        stringBuffer.append("\n    }");
    }

    private void addConstructor(Table table, StringBuffer stringBuffer) {
        stringBuffer.append("\n        public ").append(table.getName().trim()).append("() {");
        for (Column column : table.getElementsCollection()) {
            stringBuffer.append("\n            ").append("columnNames.add(\"").append(column.getName().trim()).append("\");");
            stringBuffer.append("\n            ").append("dataTypes.add(\"").append(this.getDataType(column).trim()).append("\");");
        }
        stringBuffer.append("\n        }");
    }

    private GUIConfiguration getConfiguration() {
        return GUIConfiguration.getInstance();
    }

    public List getColumnNames() {
        return this.columnNames;
    }

    public String getDirName() {
        return this.dirName;
    }

    private String getDataType(Column column) {
        if (column.getDataType() instanceof StructuredType && column.isReference()) {
            return "REF " + column.getDataType().toString();
        }
        if (column.getDataType() instanceof DistinctType) {
            DistinctType distinctType = (DistinctType)column.getDataType();
            return distinctType.getName();
        }
        return column.getDataType().toString();
    }
}

