/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util;

import java.awt.Component;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.Iterator;
import javax.swing.JOptionPane;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.util.Messages;
import oracle.ide.Ide;

public class BirtReports_DDLMaker {
    RelationalDesign pdes;
    String tab = "  ";
    String tab2 = "    ";
    int cols_in_row = 3;

    public void generate(File file, RelationalDesign relationalDesign) {
        int n;
        this.pdes = relationalDesign;
        if (file.exists() && (n = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("BirtReports_DDLMaker.FileExists"), file.getAbsolutePath()), Messages.getString("BirtReports_DDLMaker.Warning"), 0, 3, this.getConfiguration().getIcon("SAVE_ICON", 32))) == 1) {
            return;
        }
        StringBuffer stringBuffer = this.generateContent();
        file.getParentFile().mkdirs();
        try {
            file.createNewFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new BufferedOutputStream(new FileOutputStream(file)));
        }
        catch (FileNotFoundException fileNotFoundException) {
            printWriter = null;
        }
        if (printWriter != null) {
            printWriter.print(stringBuffer.toString());
            printWriter.flush();
            printWriter.close();
        }
    }

    private StringBuffer generateContent() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.pdes.getTableSet().iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            Table table = (Table)iterator.next();
            String string = table.getName().trim();
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append("\n\n");
            }
            stringBuffer.append("-- ").append(string).append("\n");
            stringBuffer.append("\n-- plain select\n");
            this.appendPlainSelect(table, stringBuffer);
            stringBuffer.append("\n\n-- parameter select\n");
            stringBuffer.append("if (params[\"DatabaseType\"].equals(\"CSV\")){");
            stringBuffer.append("\n");
            this.appendQuotedSelect(table, stringBuffer, true);
            stringBuffer.append(";\n}else{\n");
            this.appendQuotedSelect(table, stringBuffer, false);
            stringBuffer.append(";\n}\n");
        }
        return stringBuffer;
    }

    private void appendPlainSelect(Table table, StringBuffer stringBuffer) {
        stringBuffer.append(this.tab).append("select \n").append(this.tab2);
        boolean bl = true;
        int n = 0;
        Iterator iterator = table.getElementsCollection().iterator();
        while (iterator.hasNext()) {
            ++n;
            Column column = (Column)iterator.next();
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(", ");
            }
            if (n > this.cols_in_row) {
                stringBuffer.append("\n").append(this.tab2);
                n = 1;
            }
            stringBuffer.append(column.getName().trim().toUpperCase());
        }
        stringBuffer.append("\n").append(this.tab).append("from ").append(table.getName());
    }

    private void appendQuotedSelect(Table table, StringBuffer stringBuffer, boolean bl) {
        Object object;
        stringBuffer.append(this.tab).append("\"select \" + \n").append(this.tab2);
        boolean bl2 = true;
        int n = 0;
        Iterator iterator = table.getElementsCollection().iterator();
        while (iterator.hasNext()) {
            ++n;
            object = (Column)iterator.next();
            if (bl2) {
                bl2 = false;
                stringBuffer.append("\"");
            } else {
                stringBuffer.append(", ");
            }
            if (n > this.cols_in_row) {
                stringBuffer.append("\" + \n").append(this.tab2).append("\"");
                n = 1;
            }
            stringBuffer.append(((ContainedObject)object).getName().trim().toUpperCase());
        }
        object = table.getName().trim();
        if (bl) {
            object = (String)object + ".csv";
        }
        stringBuffer.append(" \" + \n").append(this.tab).append("\"from ").append((String)object).append("\"");
    }

    private GUIConfiguration getConfiguration() {
        return GUIConfiguration.getInstance();
    }
}

