/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.wizards.reports;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.datatypes.DataTypesDesign;
import oracle.dbtools.crest.model.design.glossary.Glossary;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.RelationalDesignSet;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.swingui.wizards.metadata.DMConnectionModel;
import oracle.dbtools.crest.swingui.wizards.metadata.connection.ConnectionInfo;
import oracle.dbtools.crest.swingui.wizards.metadata.connection.FCPConnectionDialog;
import oracle.dbtools.crest.swingui.wizards.reports.Messages;
import oracle.dbtools.crest.swingui.wizards.reports.RenderPDFReport;
import oracle.dbtools.crest.swingui.wizards.reports.ReportTemplate;
import oracle.dbtools.crest.swingui.wizards.reports.ReportTemplatesDialog;
import oracle.dbtools.crest.swingui.wizards.reports.ReportsGenerator;
import oracle.dbtools.crest.swingui.wizards.reports.ReportsHTMLTOC;
import oracle.dbtools.crest.swingui.wizards.reports.SaxonLoader;
import oracle.dbtools.crest.swingui.wizards.reports.SelectGlossaryDialog;
import oracle.dbtools.crest.swingui.wizards.reports.SelectModelDialog;
import oracle.dbtools.crest.swingui.wizards.reports.SelectReportObjectDialog;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.ide.Ide;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFilter;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdeveloper.db.ConnectionException;
import oracle.jdeveloper.db.DatabaseConnections;
import oracle.sql.BFILE;
import oracle.sql.ORAData;

public class ReportsGenerationDialog
extends CustomDialog {
    private static final long serialVersionUID = 828694421474632391L;
    public static ReportTemplate blankRT = new ReportTemplate(" ", 0, "0");
    private static String defaultVMOptions = "-Xmx768M";
    private boolean result = false;
    private JDialog dialog;
    private JPanel mainPanel;
    private JPanel reportingSchemaPanel;
    public JButton bnClose;
    public JButton bnGenerate;
    public JButton bnSelectModel = new JButton(Messages.getString("ReportsGenerationDialog.SelectModel"));
    public JComboBox cmbReports;
    public JComboBox cmbOutFormat;
    public JTextField txtVMOptions;
    public JComboBox cmbDesigns = new JComboBox();
    public JComboBox cmbModels = new JComboBox();
    private JTextField txtSelectedDesign = new JTextField();
    private JTextField txtSelectedVersionDate = new JTextField();
    private JTextField txtSelectedModel = new JTextField();
    private JTextField txtSelectedSubView = new JTextField();
    private JTextField txtSelectedObject = new JTextField();
    private JTextField txtSelectedDesignObject = new JTextField();
    private JTextField txtReportsDir = new JTextField();
    private JTable tbConnections = new JTable(new DMConnectionModel(DatabaseConnections.getInstance(), true));
    private JButton bnProps;
    private JButton bnRemove;
    private JButton bnTest;
    private JCheckBox cbIncludeAll;
    private JButton bnSelectSubView;
    private JButton bnSelectObject;
    private ReportsGenerationDialog er = this;
    private String selectedObjectOvid = null;
    private Object selectedObject = null;
    private Object selectedSubView = null;
    private JButton btnAdd = new JButton();
    private int reportCode;
    private ApplicationView appView;
    private ArrayList<DesignPart> fullModelsList = new ArrayList();
    private JCheckBox chbCompressReport = new JCheckBox(Messages.getString("ReportsGenerationDialog.CompressReportFile"));
    private JTabbedPane tpane;
    private static File lastFolder = null;
    private ProgressDialog monitor;
    private BFILE bfile;
    private InputStream inputStream;
    private Connection connection = null;
    private JButton bnManage;
    public JComboBox cmbTemplates;
    private ReportsGenerationDialog rgd;
    private File xsltFile = null;
    private String reportType;
    private String saxonPath;
    private String tocTagName = "";
    private String reportFileName = "";
    private File rawXMLFile;
    private File outputFile = null;
    private String reportsPath;
    private static final Logger LOGGER = new Logger(ReportsGenerationDialog.class);

    public ReportsGenerationDialog(ApplicationView applicationView) {
        super(applicationView);
        this.appView = applicationView;
        this.rgd = this;
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanel.setPreferredSize(new Dimension(460, 630));
        this.initNorthPanel();
        this.initCenterPanel();
        this.initButtonsPanel();
        this.saxonPath = applicationView.getSettings().getDefaultSaxonPath();
        this.reportsPath = applicationView.getSettings().getDefaultReportsPath();
    }

    private void initNorthPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setPreferredSize(new Dimension(400, 135));
        JPanel jPanel2 = new JPanel(new SpringLayout());
        jPanel2.setBorder(BorderFactory.createTitledBorder(Messages.getString("ReportsGenerationDialog.Reports")));
        jPanel2.setPreferredSize(new Dimension(400, 80));
        JLabel jLabel = new JLabel(Messages.getString("ReportsGenerationDialog.AvailableReports"));
        jLabel.setPreferredSize(new Dimension(130, 20));
        CommonUtil.setLabelConstraints((SpringLayout)jPanel2.getLayout(), jLabel, 5, 3);
        this.cmbReports = new JComboBox<Object>(this.getReportsList().toArray());
        this.cmbReports.setPreferredSize(new Dimension(120, 20));
        CommonUtil.setObjectConstraints((SpringLayout)jPanel2.getLayout(), this.cmbReports, 140, 3);
        this.cmbReports.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (!ReportsGenerationDialog.this.cbIncludeAll.isSelected()) {
                    if (((String)ReportsGenerationDialog.this.cmbReports.getSelectedItem()).equalsIgnoreCase("Tables") || ((String)ReportsGenerationDialog.this.cmbReports.getSelectedItem()).equalsIgnoreCase("Entities")) {
                        ReportsGenerationDialog.this.bnSelectSubView.setEnabled(true);
                    }
                    ReportsGenerationDialog.this.bnSelectObject.setEnabled(true);
                }
                if (itemEvent.getStateChange() == 1) {
                    ReportsGenerationDialog.this.selectedObject = null;
                    ReportsGenerationDialog.this.setSelectedObjectOvid(null);
                    ReportsGenerationDialog.this.txtSelectedSubView.setText("");
                    ReportsGenerationDialog.this.txtSelectedObject.setText("");
                    ReportsGenerationDialog.this.txtSelectedDesign.setText("");
                    ReportsGenerationDialog.this.txtSelectedDesignObject.setText("");
                    ReportsGenerationDialog.this.txtSelectedModel.setText("");
                    ReportsGenerationDialog.this.txtSelectedVersionDate.setText("");
                    ReportsGenerationDialog.this.setCodesAndUI();
                }
            }
        });
        jPanel2.add(jLabel);
        jPanel2.add(this.cmbReports);
        this.cbIncludeAll = new JCheckBox(Messages.getString("ReportsGenerationDialog.IncludeAll"));
        jPanel2.add(this.cbIncludeAll);
        this.cbIncludeAll.setToolTipText(Messages.getString("ReportsGenerationDialog.IncludeAllTooltip"));
        this.cbIncludeAll.setSelected(true);
        CommonUtil.setObjectConstraints((SpringLayout)jPanel2.getLayout(), this.cbIncludeAll, 280, 3);
        this.cbIncludeAll.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 2) {
                    if (((String)ReportsGenerationDialog.this.cmbReports.getSelectedItem()).equalsIgnoreCase("Tables") || ((String)ReportsGenerationDialog.this.cmbReports.getSelectedItem()).equalsIgnoreCase("Entities")) {
                        ReportsGenerationDialog.this.bnSelectSubView.setEnabled(true);
                        ReportsGenerationDialog.this.bnSelectObject.setEnabled(true);
                    } else if (((String)ReportsGenerationDialog.this.cmbReports.getSelectedItem()).equalsIgnoreCase("Structured Types") || ((String)ReportsGenerationDialog.this.cmbReports.getSelectedItem()).equalsIgnoreCase("Distinct Types") || ((String)ReportsGenerationDialog.this.cmbReports.getSelectedItem()).equalsIgnoreCase("Collection Types")) {
                        ReportsGenerationDialog.this.bnSelectObject.setEnabled(true);
                    }
                } else if (itemEvent.getStateChange() == 1) {
                    ReportsGenerationDialog.this.bnSelectSubView.setEnabled(false);
                    ReportsGenerationDialog.this.bnSelectObject.setEnabled(false);
                }
                ReportsGenerationDialog.this.setSelectedObject(null);
                ReportsGenerationDialog.this.setSelectedObjectOvid(null);
                ReportsGenerationDialog.this.txtSelectedSubView.setText("");
                ReportsGenerationDialog.this.txtSelectedObject.setText("");
                ReportsGenerationDialog.this.txtSelectedDesignObject.setText("");
                ReportsGenerationDialog.this.setCodesAndUI();
            }
        });
        JLabel jLabel2 = new JLabel(Messages.getString("ReportsGenerationDialog.ReportsOutFormat"));
        jLabel2.setPreferredSize(new Dimension(120, 20));
        CommonUtil.setLabelConstraints((SpringLayout)jPanel2.getLayout(), jLabel2, 5, 27);
        this.cmbOutFormat = new JComboBox<Object>(this.getOutTypesList().toArray());
        this.cmbOutFormat.setPreferredSize(new Dimension(46, 20));
        CommonUtil.setObjectConstraints((SpringLayout)jPanel2.getLayout(), this.cmbOutFormat, 140, 27);
        this.cmbOutFormat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ReportsGenerationDialog.this.cmbOutFormat.getSelectedItem().equals("PDF")) {
                    ReportsGenerationDialog.this.txtVMOptions.setEnabled(true);
                    if (ReportsGenerationDialog.this.txtVMOptions.getText().equals("")) {
                        ReportsGenerationDialog.this.txtVMOptions.setText(defaultVMOptions);
                    }
                } else {
                    ReportsGenerationDialog.this.txtVMOptions.setEnabled(false);
                    ReportsGenerationDialog.this.txtVMOptions.setText("");
                }
            }
        });
        jPanel2.add(jLabel2);
        jPanel2.add(this.cmbOutFormat);
        JLabel jLabel3 = new JLabel(Messages.getString("ReportsGenerationDialog.VMOptions"));
        jLabel3.setPreferredSize(new Dimension(150, 20));
        CommonUtil.setLabelConstraints((SpringLayout)jPanel2.getLayout(), jLabel3, 200, 27);
        this.txtVMOptions = new JTextField();
        this.txtVMOptions.setPreferredSize(new Dimension(100, 20));
        this.txtVMOptions.setToolTipText(Messages.getString("ReportsGenerationDialog.VMOptionsToolTip"));
        CommonUtil.setObjectConstraints((SpringLayout)jPanel2.getLayout(), this.txtVMOptions, 300, 27);
        this.txtVMOptions.setEnabled(false);
        jPanel2.add(jLabel3);
        jPanel2.add(this.txtVMOptions);
        JPanel jPanel3 = new JPanel(new SpringLayout());
        jPanel3.setBorder(BorderFactory.createTitledBorder(Messages.getString("ReportTemplatesDialog.ReportTemplates")));
        jPanel3.setPreferredSize(new Dimension(400, 30));
        this.cmbTemplates = new JComboBox();
        this.cmbTemplates.setPreferredSize(new Dimension(320, 20));
        this.cmbTemplates.setRenderer(new ComboBoxRenderer());
        CommonUtil.setObjectConstraints((SpringLayout)jPanel3.getLayout(), this.cmbTemplates, 5, 3);
        this.bnManage = new JButton(Messages.getString("ReportTemplatesDialog.Manage"));
        this.bnManage.setMnemonic(77);
        this.bnManage.setPreferredSize(new Dimension(105, 20));
        CommonUtil.setObjectConstraints((SpringLayout)jPanel3.getLayout(), this.bnManage, 330, 3);
        this.bnManage.addActionListener(new ManageTemplatesAction());
        jPanel3.add(this.cmbTemplates);
        jPanel3.add(this.bnManage);
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)jPanel3, "Center");
        this.mainPanel.add((Component)jPanel, "North");
        this.add((Component)this.mainPanel, "Center");
    }

    private void initCenterPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("ReportsGenerationDialog.Designs")));
        this.tpane = new JTabbedPane();
        this.initDesignsPanel();
        this.initReportingSchemaPanel();
        jPanel.add(this.tpane);
        this.mainPanel.add((Component)jPanel, "Center");
    }

    private void initDesignsPanel() {
        JPanel jPanel = new JPanel(new SpringLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("ReportsGenerationDialog.Designs")));
        JLabel jLabel = new JLabel(Messages.getString("ReportsGenerationDialog.AvailableDesigns"));
        jLabel.setPreferredSize(new Dimension(140, 20));
        CommonUtil.setLabelConstraints((SpringLayout)jPanel.getLayout(), jLabel, 5, 25);
        jPanel.add(jLabel);
        Object[] objectArray = this.appView.getDesigns().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            this.cmbDesigns.addItem(objectArray[i]);
        }
        this.cmbDesigns.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DesignPart designPart;
                Design design = (Design)ReportsGenerationDialog.this.cmbDesigns.getSelectedItem();
                RelationalDesignSet relationalDesignSet = design.getRelationalDesigns();
                ReportsGenerationDialog.this.fullModelsList.clear();
                Iterator iterator = relationalDesignSet.iterator();
                while (iterator.hasNext()) {
                    designPart = (RelationalDesign)iterator.next();
                    ReportsGenerationDialog.this.fullModelsList.add(designPart);
                }
                designPart = design.getLogicalDesign();
                ReportsGenerationDialog.this.fullModelsList.add(designPart);
                DataTypesDesign dataTypesDesign = design.getDataTypesDesign();
                ReportsGenerationDialog.this.fullModelsList.add(dataTypesDesign);
                if (((String)ReportsGenerationDialog.this.cmbReports.getSelectedItem()).equalsIgnoreCase("Entities")) {
                    ReportsGenerationDialog.this.reloadModels(4);
                    ReportsGenerationDialog.this.txtSelectedSubView.setText("");
                    ReportsGenerationDialog.this.txtSelectedObject.setText("");
                } else if (((String)ReportsGenerationDialog.this.cmbReports.getSelectedItem()).equalsIgnoreCase("Tables")) {
                    ReportsGenerationDialog.this.reloadModels(2);
                    ReportsGenerationDialog.this.txtSelectedSubView.setText("");
                    ReportsGenerationDialog.this.txtSelectedObject.setText("");
                } else if (((String)ReportsGenerationDialog.this.cmbReports.getSelectedItem()).equalsIgnoreCase("Structured Types")) {
                    ReportsGenerationDialog.this.reloadModels(8);
                    ReportsGenerationDialog.this.txtSelectedSubView.setText("");
                    ReportsGenerationDialog.this.txtSelectedObject.setText("");
                } else if (((String)ReportsGenerationDialog.this.cmbReports.getSelectedItem()).equalsIgnoreCase("Distinct Types")) {
                    ReportsGenerationDialog.this.reloadModels(12);
                    ReportsGenerationDialog.this.txtSelectedSubView.setText("");
                    ReportsGenerationDialog.this.txtSelectedObject.setText("");
                } else if (((String)ReportsGenerationDialog.this.cmbReports.getSelectedItem()).equalsIgnoreCase("Collection Types")) {
                    ReportsGenerationDialog.this.reloadModels(10);
                    ReportsGenerationDialog.this.txtSelectedSubView.setText("");
                    ReportsGenerationDialog.this.txtSelectedObject.setText("");
                }
            }
        });
        this.cmbDesigns.setPreferredSize(new Dimension(265, 20));
        CommonUtil.setObjectConstraints((SpringLayout)jPanel.getLayout(), this.cmbDesigns, 160, 25);
        jPanel.add(this.cmbDesigns);
        JLabel jLabel2 = new JLabel(Messages.getString("ReportsGenerationDialog.AvailableModels"));
        jLabel2.setPreferredSize(new Dimension(140, 20));
        CommonUtil.setLabelConstraints((SpringLayout)jPanel.getLayout(), jLabel2, 5, 50);
        jPanel.add(jLabel2);
        this.cmbModels.setPreferredSize(new Dimension(265, 20));
        CommonUtil.setObjectConstraints((SpringLayout)jPanel.getLayout(), this.cmbModels, 160, 50);
        jPanel.add(this.cmbModels);
        this.cmbModels.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
            }
        });
        this.cmbDesigns.setSelectedIndex(0);
        this.cmbReports.setSelectedIndex(1);
        this.cmbReports.setSelectedIndex(0);
        JLabel jLabel3 = new JLabel(Messages.getString("ReportsGenerationDialog.SelectedSubView"));
        jLabel3.setPreferredSize(new Dimension(140, 20));
        CommonUtil.setLabelConstraints((SpringLayout)jPanel.getLayout(), jLabel3, 5, 75);
        jPanel.add(jLabel3);
        this.txtSelectedSubView.setEnabled(false);
        this.txtSelectedSubView.setDisabledTextColor(Color.black);
        this.txtSelectedSubView.setPreferredSize(new Dimension(155, 20));
        CommonUtil.setObjectConstraints((SpringLayout)jPanel.getLayout(), this.txtSelectedSubView, 160, 75);
        jPanel.add(this.txtSelectedSubView);
        this.bnSelectSubView = new JButton(Messages.getString("ReportsGenerationDialog.Select"));
        this.bnSelectSubView.setToolTipText(Messages.getString("ReportsGenerationDialog.SelectSubView"));
        this.bnSelectSubView.setEnabled(false);
        this.bnSelectSubView.setPreferredSize(new Dimension(105, 20));
        this.bnSelectSubView.setMnemonic(86);
        CommonUtil.setObjectConstraints((SpringLayout)jPanel.getLayout(), this.bnSelectSubView, 320, 75);
        this.bnSelectSubView.addActionListener(new SelectSubViewAction());
        jPanel.add(this.bnSelectSubView);
        JLabel jLabel4 = new JLabel(Messages.getString("ReportsGenerationDialog.SelectedObject"));
        jLabel4.setPreferredSize(new Dimension(140, 20));
        CommonUtil.setLabelConstraints((SpringLayout)jPanel.getLayout(), jLabel4, 5, 100);
        jPanel.add(jLabel4);
        this.txtSelectedObject.setEnabled(false);
        this.txtSelectedObject.setDisabledTextColor(Color.black);
        this.txtSelectedObject.setPreferredSize(new Dimension(155, 20));
        CommonUtil.setObjectConstraints((SpringLayout)jPanel.getLayout(), this.txtSelectedObject, 160, 100);
        jPanel.add(this.txtSelectedObject);
        this.bnSelectObject = new JButton(Messages.getString("ReportsGenerationDialog.Select"));
        this.bnSelectObject.setToolTipText(Messages.getString("ReportsGenerationDialog.SelectObject"));
        this.bnSelectObject.setEnabled(false);
        this.bnSelectObject.setPreferredSize(new Dimension(105, 20));
        this.bnSelectObject.setMnemonic(83);
        CommonUtil.setObjectConstraints((SpringLayout)jPanel.getLayout(), this.bnSelectObject, 320, 100);
        this.bnSelectObject.addActionListener(new SelectObjectAction());
        jPanel.add(this.bnSelectObject);
        this.tpane.addTab(Messages.getString("ReportsGenerationDialog.LoadedDesigns"), jPanel);
    }

    private void reloadModels(int n) {
        block4: {
            Iterator iterator;
            block5: {
                block3: {
                    ArrayList arrayList = this.getFullModelsList();
                    this.cmbModels.removeAllItems();
                    iterator = arrayList.iterator();
                    if (n != 2) break block3;
                    while (iterator.hasNext()) {
                        Object e = iterator.next();
                        if (!(e instanceof RelationalDesign)) continue;
                        this.cmbModels.addItem(e);
                    }
                    break block4;
                }
                if (n != 4) break block5;
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    if (!(e instanceof LogicalDesign)) continue;
                    this.cmbModels.addItem(e);
                }
                break block4;
            }
            if (n != 10 && n != 12 && n != 8) break block4;
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof DataTypesDesign)) continue;
                this.cmbModels.addItem(e);
            }
        }
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    private void initReportingSchemaPanel() {
        JPanel jPanel = new JPanel(new SpringLayout());
        jPanel.setPreferredSize(new Dimension(400, 50));
        jPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("ReportsGenerationDialog.ServerDir")));
        JLabel jLabel = new JLabel(Messages.getString("ReportsGenerationDialog.DirPath"));
        jLabel.setPreferredSize(new Dimension(130, 20));
        CommonUtil.setLabelConstraints((SpringLayout)jPanel.getLayout(), jLabel, 5, 3);
        jPanel.add(jLabel);
        this.txtReportsDir = new JTextField();
        this.txtReportsDir.setToolTipText(Messages.getString("ReportsGenerationDialog.ReportsDirTooltip"));
        this.txtReportsDir.setPreferredSize(new Dimension(280, 20));
        CommonUtil.setObjectConstraints((SpringLayout)jPanel.getLayout(), this.txtReportsDir, 150, 3);
        jPanel.add(this.txtReportsDir);
        this.tbConnections.setSelectionMode(0);
        this.tbConnections.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    ReportsGenerationDialog.this.showConnectionProperties();
                } else {
                    boolean bl = ReportsGenerationDialog.this.tbConnections.getSelectedRow() > -1;
                    ReportsGenerationDialog.this.bnTest.setEnabled(bl);
                    ReportsGenerationDialog.this.bnProps.setEnabled(bl);
                    ReportsGenerationDialog.this.bnRemove.setEnabled(bl);
                    ReportsGenerationDialog.this.bnSelectModel.setEnabled(bl);
                }
            }
        });
        this.tbConnections.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n = ReportsGenerationDialog.this.tbConnections.getSelectedRow();
                if (n == -1) {
                    ReportsGenerationDialog.this.bnSelectModel.setEnabled(false);
                } else {
                    ReportsGenerationDialog.this.bnSelectModel.setEnabled(true);
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.tbConnections);
        jScrollPane.setPreferredSize(new Dimension(100, 100));
        GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)new JLabel(Messages.getString("ReportsGenerationDialog.Connections")), "North");
        JPanel jPanel3 = new JPanel(new GridLayout(1, 2));
        jPanel3.setPreferredSize(new Dimension(200, 35));
        this.bnProps = new JButton(gUIConfiguration.getIcon("EDIT_ICON", 16));
        this.bnProps.setToolTipText(Messages.getString("ReportsGenerationDialog.ConnectionProperties"));
        this.bnProps.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReportsGenerationDialog.this.showConnectionProperties();
            }
        });
        this.bnProps.setEnabled(false);
        this.btnAdd.setIcon(gUIConfiguration.getIcon("ADD_ICON", 16));
        this.btnAdd.setToolTipText(Messages.getString("ReportsGenerationDialog.AddConnection"));
        this.btnAdd.addActionListener(new AddAction());
        this.bnRemove = new JButton(gUIConfiguration.getIcon("REMOVE_ICON", 16));
        this.bnRemove.setToolTipText(Messages.getString("ReportsGenerationDialog.RemoveConnection"));
        this.bnRemove.addActionListener(new RemoveAction());
        this.bnRemove.setEnabled(false);
        this.bnTest = new JButton(gUIConfiguration.getIcon("DESIGN_RULES_ICON", 16));
        this.bnTest.setToolTipText(Messages.getString("ReportsGenerationDialog.TestConnection"));
        this.bnTest.addActionListener(new TestAction());
        this.bnTest.setEnabled(false);
        JToolBar jToolBar = new JToolBar(0);
        jToolBar.setFloatable(false);
        jToolBar.add(this.bnProps);
        jToolBar.add(this.btnAdd);
        jToolBar.add(this.bnRemove);
        jToolBar.add(this.bnTest);
        jPanel3.add(jToolBar);
        jPanel2.add((Component)jPanel3, "North");
        jPanel2.add((Component)jScrollPane, "Center");
        jPanel2.setPreferredSize(new Dimension(70, 70));
        this.updateConnections();
        JPanel jPanel4 = new JPanel(new SpringLayout());
        JLabel jLabel2 = new JLabel(Messages.getString("ReportsGenerationDialog.ChosenDesign"));
        jLabel2.setPreferredSize(new Dimension(190, 20));
        CommonUtil.setLabelConstraints((SpringLayout)jPanel4.getLayout(), jLabel2, 10, 20);
        jPanel4.add(jLabel2);
        this.txtSelectedDesign.setEnabled(false);
        this.txtSelectedDesign.setPreferredSize(new Dimension(225, 20));
        this.txtSelectedDesign.setDisabledTextColor(Color.black);
        CommonUtil.setObjectConstraints((SpringLayout)jPanel4.getLayout(), this.txtSelectedDesign, 200, 20);
        jPanel4.add(this.txtSelectedDesign);
        JLabel jLabel3 = new JLabel(Messages.getString("ReportsGenerationDialog.ChosenVersionDate"));
        jLabel3.setPreferredSize(new Dimension(190, 20));
        CommonUtil.setLabelConstraints((SpringLayout)jPanel4.getLayout(), jLabel3, 10, 45);
        jPanel4.add(jLabel3);
        this.txtSelectedVersionDate.setEnabled(false);
        this.txtSelectedVersionDate.setPreferredSize(new Dimension(225, 20));
        this.txtSelectedVersionDate.setDisabledTextColor(Color.black);
        CommonUtil.setObjectConstraints((SpringLayout)jPanel4.getLayout(), this.txtSelectedVersionDate, 200, 45);
        jPanel4.add(this.txtSelectedVersionDate);
        JLabel jLabel4 = new JLabel(Messages.getString("ReportsGenerationDialog.ChosenModel"));
        jLabel4.setPreferredSize(new Dimension(190, 20));
        CommonUtil.setLabelConstraints((SpringLayout)jPanel4.getLayout(), jLabel4, 10, 70);
        jPanel4.add(jLabel4);
        this.txtSelectedModel.setEnabled(false);
        this.txtSelectedModel.setPreferredSize(new Dimension(225, 20));
        this.txtSelectedModel.setDisabledTextColor(Color.black);
        CommonUtil.setObjectConstraints((SpringLayout)jPanel4.getLayout(), this.txtSelectedModel, 200, 70);
        jPanel4.add(this.txtSelectedModel);
        JLabel jLabel5 = new JLabel(Messages.getString("ReportsGenerationDialog.ChosenObject"));
        jLabel5.setPreferredSize(new Dimension(190, 20));
        CommonUtil.setLabelConstraints((SpringLayout)jPanel4.getLayout(), jLabel5, 10, 95);
        jPanel4.add(jLabel5);
        this.txtSelectedDesignObject.setEnabled(false);
        this.txtSelectedDesignObject.setDisabledTextColor(Color.black);
        this.txtSelectedDesignObject.setPreferredSize(new Dimension(225, 20));
        CommonUtil.setObjectConstraints((SpringLayout)jPanel4.getLayout(), this.txtSelectedDesignObject, 200, 95);
        jPanel4.add(this.txtSelectedDesignObject);
        CommonUtil.setObjectConstraints((SpringLayout)jPanel4.getLayout(), this.chbCompressReport, 10, 120);
        jPanel4.add(this.chbCompressReport);
        JPanel jPanel5 = new JPanel(new FlowLayout(1));
        this.bnSelectModel.setPreferredSize(new Dimension(220, 23));
        this.bnSelectModel.addActionListener(new SelectModelAction());
        this.bnSelectModel.setEnabled(false);
        this.bnSelectModel.setMnemonic(77);
        jPanel5.add(this.bnSelectModel);
        JPanel jPanel6 = new JPanel(new BorderLayout());
        jPanel6.setPreferredSize(new Dimension(100, 172));
        jPanel6.add((Component)jPanel4, "Center");
        jPanel6.add((Component)jPanel5, "South");
        this.reportingSchemaPanel = new JPanel(new BorderLayout());
        JPanel jPanel7 = new JPanel(new BorderLayout());
        jPanel7.setBorder(BorderFactory.createTitledBorder(Messages.getString("ReportsGenerationDialog.ReportingSchema")));
        jPanel7.setPreferredSize(new Dimension(400, 360));
        jPanel7.add((Component)jPanel2, "Center");
        jPanel7.add((Component)jPanel6, "South");
        this.reportingSchemaPanel.add((Component)jPanel, "North");
        this.reportingSchemaPanel.add((Component)jPanel7, "South");
        this.tpane.addTab(Messages.getString("ReportsGenerationDialog.UseReportingSchema"), this.reportingSchemaPanel);
    }

    private Properties getSelectedConnectionProperties() {
        Properties properties = null;
        try {
            properties = ((DMConnectionModel)this.tbConnections.getModel()).getRowData(this.tbConnections.getSelectedRow());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return properties;
    }

    private void showConnectionProperties() {
        Properties properties = this.getSelectedConnectionProperties();
        if (properties != null) {
            String string = ConnectionInfo.getConnectionName(properties);
            FCPConnectionDialog.showConnectionDialog(string, true);
            this.updateConnections();
        }
    }

    public void closeConnection() {
        if (this.connection != null) {
            try {
                if (!this.connection.isClosed()) {
                    this.connection.close();
                }
                this.connection = null;
            }
            catch (Exception exception) {
                LOGGER.error("Unable to close the connection", exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initConnection() {
        block5: {
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                this.closeConnection();
                Properties properties = this.getSelectedConnectionProperties();
                if (properties == null) break block5;
                try {
                    this.connection = DatabaseConnections.getInstance().getConnection(properties);
                }
                catch (Exception exception) {
                    MessageDialogs.showErrorMessage(exception.getLocalizedMessage());
                    boolean bl = false;
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    return bl;
                }
            }
            finally {
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
        return this.connection != null;
    }

    private void initButtonsPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(1));
        this.bnGenerate = new JButton(Messages.getString("ReportsGenerationDialog.GenerateReports"));
        this.bnGenerate.setPreferredSize(new Dimension(160, 23));
        this.bnGenerate.addActionListener(new GenerateAction());
        this.bnGenerate.setMnemonic(71);
        jPanel.add(this.bnGenerate);
        this.bnClose = new JButton(Messages.getString("ReportsGenerationDialog.Close"));
        this.bnClose.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.bnClose.addActionListener(new CloseAction());
        this.bnClose.setMnemonic(67);
        jPanel.add(this.bnClose);
        JButton jButton = new JButton(this.getHelpAction());
        jButton.setMnemonic(72);
        jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jPanel.add(jButton);
        this.mainPanel.add((Component)jPanel, "South");
    }

    private ArrayList getReportsList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("Tables");
        arrayList.add("Entities");
        arrayList.add("Domains");
        arrayList.add("Glossaries");
        arrayList.add("Structured Types");
        arrayList.add("Distinct Types");
        arrayList.add("Collection Types");
        arrayList.add("Change Requests");
        arrayList.add("Measurements");
        return arrayList;
    }

    private ArrayList getOutTypesList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("RTF");
        arrayList.add("HTML");
        arrayList.add("PDF");
        return arrayList;
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), Messages.getString("ReportsGenerationDialog.Reports"));
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.getContentPane().add(this);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            this.dialog.setModal(true);
            this.dialog.setResizable(false);
        }
        return this.dialog;
    }

    public boolean showDialog() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().setVisible(true);
        return this.result;
    }

    @Override
    protected String getHelpIndex() {
        return "GENERATE_REPORT_DIALOG";
    }

    private void updateConnections() {
        ((DMConnectionModel)this.tbConnections.getModel()).reReadConnections();
    }

    public void fillTxtSelectedDesign(String string) {
        this.txtSelectedDesign.setText(string);
    }

    public void fillTxtSelectedVersionDate(String string) {
        this.txtSelectedVersionDate.setText(string);
    }

    public Object getSelectedObject() {
        return this.selectedObject;
    }

    public Object getSelectedSubView() {
        return this.selectedSubView;
    }

    public JComboBox getCmbReports() {
        return this.cmbReports;
    }

    public void fillTxtSelectedModel(String string) {
        this.txtSelectedModel.setText(string);
    }

    public void fillTxtSelectedObject(String string) {
        this.txtSelectedObject.setText(string);
    }

    public void fillTtxtSelectedDesignObject(String string) {
        this.txtSelectedDesignObject.setText(string);
    }

    public void fillTxtSelectedSubView(String string) {
        this.txtSelectedSubView.setText(string);
    }

    public void setSelectedObject(Object object) {
        this.selectedObject = object;
    }

    public void setSelectedSubView(Object object) {
        this.selectedSubView = object;
    }

    private void generateReport() {
        Thread thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void run() {
                ReportTemplate reportTemplate = (ReportTemplate)ReportsGenerationDialog.this.cmbTemplates.getSelectedItem();
                ReportsGenerationDialog.this.reportType = (String)ReportsGenerationDialog.this.cmbReports.getSelectedItem();
                boolean bl = true;
                if (ReportsGenerationDialog.this.reportsPath.equals("") || ReportsGenerationDialog.this.reportsPath == null) {
                    ReportsGenerationDialog.this.reportsPath = new File(ApplicationView.basePath, "reports").getAbsolutePath();
                }
                if (!ReportsGenerationDialog.this.hasPermissions(ReportsGenerationDialog.this.reportsPath)) {
                    ReportsGenerationDialog.this.reportsPath = new File(ReportsGenerationDialog.this.getApplicationView().getUserHomeDirectory().getFile()).getAbsolutePath();
                }
                if (ReportsGenerationDialog.this.tpane.getSelectedIndex() == 0) {
                    Glossary glossary = null;
                    if (ReportsGenerationDialog.this.reportType.equalsIgnoreCase("Glossaries")) {
                        glossary = ReportsGenerationDialog.this.getGlossaryFile();
                    }
                    if (!ReportsGenerationDialog.this.cbIncludeAll.isSelected() && ReportsGenerationDialog.this.getSelectedObject() == null && ReportsGenerationDialog.this.getSelectedSubView() == null) {
                        JOptionPane.showMessageDialog(null, MessageFormat.format(Messages.getString("ReportsGenerationDialog.NoSelectedObject"), Messages.getString("ReportsGenerationDialog.IncludeAll")), Messages.getString("ReportsGenerationDialog.Choose"), 0);
                        return;
                    }
                    if (!bl) return;
                    ReportsGenerator reportsGenerator = new ReportsGenerator(ReportsGenerationDialog.this.appView);
                    reportsGenerator.createReport(ReportsGenerationDialog.this.reportType, (String)ReportsGenerationDialog.this.cmbOutFormat.getSelectedItem(), ReportsGenerationDialog.this.txtVMOptions.getText(), reportTemplate, (Design)ReportsGenerationDialog.this.cmbDesigns.getSelectedItem(), (DesignPart)ReportsGenerationDialog.this.cmbModels.getSelectedItem(), ReportsGenerationDialog.this.getSelectedObject(), ReportsGenerationDialog.this.getSelectedSubView(), glossary, ReportsGenerationDialog.this.reportsPath);
                    return;
                }
                if (ReportsGenerationDialog.this.tpane.getSelectedIndex() != 1) return;
                BufferedReader bufferedReader = null;
                BufferedReader bufferedReader2 = null;
                OutputStreamWriter outputStreamWriter = null;
                OutputStream outputStream = null;
                PrintWriter printWriter = null;
                PrintWriter printWriter2 = null;
                if (!ReportsGenerationDialog.this.cbIncludeAll.isSelected() && ReportsGenerationDialog.this.getSelectedObjectOvid() == null) {
                    JOptionPane.showMessageDialog(null, MessageFormat.format(Messages.getString("ReportsGenerationDialog.NoSelectedObject"), Messages.getString("ReportsGenerationDialog.IncludeAll")), Messages.getString("ReportsGenerationDialog.Choose"), 0);
                    return;
                }
                if (!bl) return;
                if (!ReportsGenerationDialog.this.initConnection()) return;
                String string = ReportsGenerationDialog.this.getSelectedObjectOvid();
                if (string != null && !string.equals("")) {
                    Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(3));
                    OracleCallableStatement oracleCallableStatement = null;
                    try {
                        ReportsGenerationDialog.this.monitor = new ProgressDialog(ReportsGenerationDialog.this.appView, "", 0, 100);
                        ReportsGenerationDialog.this.monitor.setNote(Messages.getString("ReportsGenerationDialog.GatherData"));
                        ReportsGenerationDialog.this.monitor.setProgress(1);
                        oracleCallableStatement = (OracleCallableStatement)ReportsGenerationDialog.this.connection.prepareCall("{CALL Pkg_Osdm_Utils.Generate_Report(?,?,?,?,?,?,?,?,?)}");
                        oracleCallableStatement.setInt(1, ReportsGenerationDialog.this.reportCode);
                        oracleCallableStatement.setString(2, ReportsGenerationDialog.this.getSelectedObjectOvid());
                        oracleCallableStatement.setInt(3, 1);
                        oracleCallableStatement.setString(4, ReportsGenerationDialog.this.txtReportsDir.getText().equals("") ? null : ReportsGenerationDialog.this.txtReportsDir.getText().trim());
                        oracleCallableStatement.setInt(5, ReportsGenerationDialog.this.chbCompressReport.isSelected() ? 1 : 0);
                        oracleCallableStatement.setORAData(6, (ORAData)reportTemplate);
                        oracleCallableStatement.registerOutParameter(7, -13);
                        oracleCallableStatement.registerOutParameter(8, 2);
                        oracleCallableStatement.registerOutParameter(9, 12);
                        ReportsGenerationDialog.this.monitor.setProgress(5);
                        oracleCallableStatement.execute();
                        int n = ((BigDecimal)oracleCallableStatement.getObject(8)).intValue();
                        if (n == 0) {
                            ReportsGenerationDialog.this.initReportParams();
                            File file = new File(ReportsGenerationDialog.this.reportsPath);
                            File file2 = new File((String)oracleCallableStatement.getObject(9));
                            if (!file.getAbsolutePath().equals(file2.getAbsolutePath())) {
                                int n2;
                                ReportsGenerationDialog.this.monitor.setNote(Messages.getString("ReportsGenerationDialog.DownloadReport") + ReportsGenerationDialog.this.reportFileName + " ...");
                                ReportsGenerationDialog.this.monitor.setProgress(50);
                                ReportsGenerationDialog.this.bfile = (BFILE)oracleCallableStatement.getObject(7);
                                ReportsGenerationDialog.this.bfile.openFile();
                                ReportsGenerationDialog.this.inputStream = ReportsGenerationDialog.this.bfile.getBinaryStream();
                                ReportsGenerationDialog.this.rawXMLFile = new File(ReportsGenerationDialog.this.reportsPath + "/report_data_rs.xml");
                                outputStream = new FileOutputStream(ReportsGenerationDialog.this.rawXMLFile);
                                byte[] byArray = new byte[1024];
                                while ((n2 = ReportsGenerationDialog.this.inputStream.read(byArray)) > 0) {
                                    ((FileOutputStream)outputStream).write(byArray, 0, n2);
                                }
                                outputStream.flush();
                                ((FileOutputStream)outputStream).close();
                                ReportsGenerationDialog.this.bfile.closeFile();
                                ReportsGenerationDialog.this.inputStream.close();
                                bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(ReportsGenerationDialog.this.rawXMLFile), "UTF-8"));
                                StreamSource streamSource = new StreamSource(bufferedReader);
                                bufferedReader2 = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(ReportsGenerationDialog.this.xsltFile), "UTF-8"));
                                StreamSource streamSource2 = new StreamSource(bufferedReader2);
                                ReportsGenerationDialog.this.outputFile = new File(ReportsGenerationDialog.this.reportsPath, ReportsGenerationDialog.this.reportFileName);
                                if (((String)ReportsGenerationDialog.this.cmbOutFormat.getSelectedItem()).equals("PDF")) {
                                    new Thread(new RenderPDFReport(ReportsGenerationDialog.this.appView, ReportsGenerationDialog.this.txtVMOptions.getText(), "report_data_rs.xml", ReportsGenerationDialog.this.xsltFile.getAbsolutePath(), ReportsGenerationDialog.this.reportFileName, ReportsGenerationDialog.this.appView.getSettings().getDefaultSaxonPath(), ReportsGenerationDialog.this.reportsPath)).start();
                                    ReportsGenerationDialog.this.monitor.setProgress(100);
                                    ReportsGenerationDialog.this.monitor.close();
                                    ApplicationView.log(Messages.getString("ReportsGenerationDialog.RenderingPDFReport"));
                                    JOptionPane.showMessageDialog(null, Messages.getString("ReportsGenerationDialog.PDFRenderingStarted"), Messages.getString("ReportsGenerationDialog.ReportGenerationRes"), 1);
                                } else {
                                    Object object;
                                    Object object2;
                                    if (ReportsGenerationDialog.this.saxonPath != null && !ReportsGenerationDialog.this.saxonPath.equals("")) {
                                        object2 = SaxonLoader.getInstance(ReportsGenerationDialog.this.saxonPath);
                                        object = TransformerFactory.newInstance("net.sf.saxon.TransformerFactoryImpl", (ClassLoader)object2);
                                        Transformer transformer = ((TransformerFactory)object).newTransformer(streamSource2);
                                        transformer.setOutputProperty("encoding", "UTF-8");
                                        transformer.transform(streamSource, new StreamResult(ReportsGenerationDialog.this.outputFile));
                                    } else {
                                        object2 = TransformerFactory.newInstance();
                                        object = ((TransformerFactory)object2).newTransformer(streamSource2);
                                        ((Transformer)object).setOutputProperty("encoding", "UTF-8");
                                        outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(ReportsGenerationDialog.this.outputFile), "UTF-8");
                                        ((Transformer)object).transform(streamSource, new StreamResult(outputStreamWriter));
                                    }
                                    if (((String)ReportsGenerationDialog.this.cmbOutFormat.getSelectedItem()).equals("HTML") && !ReportsGenerationDialog.this.tocTagName.equals("")) {
                                        object2 = ReportsGenerationDialog.this.reportFileName.substring(0, ReportsGenerationDialog.this.reportFileName.indexOf(".")) + "_index" + ReportsGenerationDialog.this.reportFileName.substring(ReportsGenerationDialog.this.reportFileName.indexOf("."), ReportsGenerationDialog.this.reportFileName.length());
                                        object = ReportsGenerationDialog.this.reportFileName.substring(0, ReportsGenerationDialog.this.reportFileName.indexOf(".")) + "_toc" + ReportsGenerationDialog.this.reportFileName.substring(ReportsGenerationDialog.this.reportFileName.indexOf("."), ReportsGenerationDialog.this.reportFileName.length());
                                        printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(ReportsGenerationDialog.this.reportsPath, (String)object2)), "UTF-8"));
                                        printWriter.print(ReportsHTMLTOC.createHTMLIndexPage((String)object, ReportsGenerationDialog.this.reportFileName));
                                        printWriter.flush();
                                        printWriter.close();
                                        printWriter2 = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(ReportsGenerationDialog.this.reportsPath, (String)object)), "UTF-8"));
                                        printWriter2.print(ReportsHTMLTOC.createHTMLTOCPage(ReportsGenerationDialog.this.reportFileName, ReportsGenerationDialog.this.rawXMLFile, ReportsGenerationDialog.this.tocTagName));
                                        printWriter2.flush();
                                        printWriter2.close();
                                        ReportsGenerationDialog.this.reportFileName = (String)object2;
                                    }
                                    ReportsGenerationDialog.this.monitor.setNote(Messages.getString("ReportsGenerationDialog.Finished"));
                                    ReportsGenerationDialog.this.monitor.setProgress(100);
                                    ReportsGenerationDialog.this.monitor.close();
                                    JOptionPane.showMessageDialog(null, MessageFormat.format(Messages.getString("ReportsGenerationDialog.ReportGenerationOKMsg"), ReportsGenerationDialog.this.reportFileName, ReportsGenerationDialog.this.reportsPath), Messages.getString("ReportsGenerationDialog.ReportGenerationRes"), 1);
                                }
                            }
                            oracleCallableStatement.close();
                            return;
                        }
                        if (n == 1) {
                            JOptionPane.showMessageDialog(null, Messages.getString("ReportsGenerationDialog.ReportingDirObjErr"), Messages.getString("ReportsGenerationDialog.ReportGenerationRes"), 0);
                            return;
                        }
                        if (n == 2) {
                            JOptionPane.showMessageDialog(null, Messages.getString("ReportsGenerationDialog.ReportingDirPermissionsErr"), Messages.getString("ReportsGenerationDialog.ReportGenerationRes"), 0);
                            return;
                        }
                        if (n != 3) return;
                        JOptionPane.showMessageDialog(null, Messages.getString("ReportsGenerationDialog.ReportingDirCreateErr"), Messages.getString("ReportsGenerationDialog.ReportGenerationRes"), 0);
                        return;
                    }
                    catch (SQLException sQLException) {
                        LOGGER.error("Generating report from Reporting Schema exception - " + sQLException.getMessage());
                        JOptionPane.showMessageDialog(null, Messages.getString("ReportsGenerationDialog.ReportGenerationErrMsg"), Messages.getString("ReportsGenerationDialog.ReportGenerationRes"), 0);
                        return;
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        if (fileNotFoundException.getMessage().contains("Access is denied")) {
                            JOptionPane.showMessageDialog(null, MessageFormat.format(Messages.getString("ReportsGenerationDialog.ReportGenerationAccessErrMsg"), fileNotFoundException.getMessage()), Messages.getString("ReportsGenerationDialog.ReportGenerationRes"), 0);
                            LOGGER.error("Exception during report generation " + fileNotFoundException);
                            return;
                        }
                        JOptionPane.showMessageDialog(null, Messages.getString("ReportsGenerationDialog.ReportGenerationErrMsg"), Messages.getString("ReportsGenerationDialog.ReportGenerationRes"), 0);
                        LOGGER.error("Exception during report generation " + fileNotFoundException);
                        return;
                    }
                    catch (IOException iOException) {
                        LOGGER.error("Generating report from Reporting Schema exception - " + iOException.getMessage());
                        JOptionPane.showMessageDialog(null, Messages.getString("ReportsGenerationDialog.ReportGenerationErrMsg"), Messages.getString("ReportsGenerationDialog.ReportGenerationRes"), 0);
                        return;
                    }
                    catch (NullPointerException nullPointerException) {
                        LOGGER.error("Generating report from Reporting Schema exception. PLSQL package Pkg_Osdm_Utils did not returned report file. See the PLSQL log file for details. " + nullPointerException.getMessage());
                        JOptionPane.showMessageDialog(null, Messages.getString("ReportsGenerationDialog.ReportGenerationErrMsg"), Messages.getString("ReportsGenerationDialog.ReportGenerationRes"), 0);
                        return;
                    }
                    catch (Exception exception) {
                        LOGGER.error("Generating report from Reporting Schema exception. PLSQL package Pkg_Osdm_Utils did not returned report file. See the PLSQL log file for details. " + exception.getMessage());
                        JOptionPane.showMessageDialog(null, Messages.getString("ReportsGenerationDialog.ReportGenerationErrMsg"), Messages.getString("ReportsGenerationDialog.ReportGenerationRes"), 0);
                        return;
                    }
                    finally {
                        Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(0));
                        if (oracleCallableStatement != null) {
                            try {
                                oracleCallableStatement.close();
                            }
                            catch (SQLException sQLException) {
                                LOGGER.error("SQLException on statement close " + sQLException);
                            }
                        }
                        if (ReportsGenerationDialog.this.bfile != null) {
                            try {
                                ReportsGenerationDialog.this.bfile.closeFile();
                            }
                            catch (SQLException sQLException) {
                                LOGGER.error("Could not close report generation BFile " + sQLException);
                            }
                        }
                        if (ReportsGenerationDialog.this.inputStream != null) {
                            try {
                                ReportsGenerationDialog.this.inputStream.close();
                            }
                            catch (IOException iOException) {
                                LOGGER.error("Could not close report generation BFile input stream " + iOException);
                            }
                        }
                        if (outputStream != null) {
                            try {
                                outputStream.flush();
                                ((FileOutputStream)outputStream).close();
                            }
                            catch (IOException iOException) {
                                LOGGER.error("ReportsGenerator.createReport() Unable to close raw XML file : " + iOException);
                            }
                        }
                        if (outputStreamWriter != null) {
                            try {
                                outputStreamWriter.flush();
                                outputStreamWriter.close();
                            }
                            catch (IOException iOException) {
                                LOGGER.error("ReportsGenerator.createReport() Unable to close XSLT1.0 generated report " + ReportsGenerationDialog.this.reportFileName + ": " + iOException);
                            }
                        }
                        if (printWriter != null) {
                            printWriter.flush();
                            printWriter.close();
                        }
                        if (printWriter2 != null) {
                            printWriter2.flush();
                            printWriter2.close();
                        }
                        if (bufferedReader != null) {
                            try {
                                bufferedReader.close();
                            }
                            catch (IOException iOException) {
                                LOGGER.error("ReportsGenerator.createReport() Unable to close raw XML file : " + iOException);
                            }
                        }
                        if (bufferedReader2 != null) {
                            try {
                                bufferedReader2.close();
                            }
                            catch (IOException iOException) {
                                LOGGER.error("ReportsGenerator.createReport() Unable to close XSLT file : " + iOException);
                            }
                        }
                        ReportsGenerationDialog.this.monitor.close();
                    }
                }
                JOptionPane.showMessageDialog(null, Messages.getString("ReportsGenerationDialog.NoModelSelected"), Messages.getString("ReportsGenerationDialog.SelectModel"), 2);
            }
        };
        thread.start();
    }

    private Glossary getGlossaryFile() {
        Glossary glossary = null;
        File file = null;
        try {
            ApplicationView.waitLoadFilesThreadToComplete();
            URLFilter uRLFilter = new URLFilter(){

                public boolean accept(URL uRL) {
                    File file = new File(uRL.getPath());
                    return file.getName().toLowerCase().endsWith(".glossary") || file.isDirectory();
                }

                public String toString() {
                    return Messages.getString("GlossaryDialog.CWDGlossaryFiles");
                }
            };
            URLChooser uRLChooser = DialogUtil.newURLChooser();
            uRLChooser.clearChooseableURLFilters();
            uRLChooser.setSelectionScope(0);
            uRLChooser.setSelectionMode(0);
            uRLChooser.setShowJarsAsDirs(false);
            uRLChooser.setURLFilter(uRLFilter);
            if (lastFolder != null) {
                uRLChooser.setSelectedURL(URLFactory.newDirURL((File)lastFolder));
            } else {
                String string = this.getApplicationView().getSettings().getDefaultImportPath();
                if (string != null && string.length() > 0) {
                    uRLChooser.setSelectedURL(URLFactory.newDirURL((String)string));
                } else {
                    URL uRL = this.getApplicationView().getUserHomeDirectory();
                    if (uRL != null) {
                        uRLChooser.setSelectedURL(uRL);
                    }
                }
            }
            int n = uRLChooser.showOpenDialog((Component)Ide.getMainWindow(), Messages.getString("ReportsGenerationDialog.OpenGlossary"));
            if (n == 0 && (file = new File(uRLChooser.getSelectedURL().getPath())) != null) {
                lastFolder = file.getParentFile();
                glossary = new Glossary(file);
                if (!glossary.isLoaded()) {
                    LOGGER.error("Reports generation : error during glossary file load " + file.toString());
                    JOptionPane.showMessageDialog(null, Messages.getString("ReportsGenerationDialog.ErrGlossaryOpen"), Messages.getString("ReportsGenerationDialog.OpenGlossary"), 0);
                }
            }
        }
        catch (Exception exception) {
            LOGGER.error("Generating report for glossary file : " + file.toString() + " " + exception.getMessage());
            JOptionPane.showMessageDialog(null, Messages.getString("ReportsGenerationDialog.ErrGlossaryPrint"), Messages.getString("ReportsGenerationDialog.ReportGenerationRes"), 0);
        }
        return glossary;
    }

    public JComboBox getCmbModels() {
        return this.cmbModels;
    }

    public ArrayList getFullModelsList() {
        return this.fullModelsList;
    }

    public JCheckBox getcbIncludeAll() {
        return this.cbIncludeAll;
    }

    public void setSelectedObjectOvid(String string) {
        this.selectedObjectOvid = string;
    }

    public String getSelectedObjectOvid() {
        return this.selectedObjectOvid;
    }

    private void setCodesAndUI() {
        this.cmbTemplates.removeAllItems();
        this.cmbTemplates.addItem(blankRT);
        if (((String)this.cmbReports.getSelectedItem()).equalsIgnoreCase("Tables")) {
            this.reportCode = this.cbIncludeAll.isSelected() ? 2 : 1;
            this.cmbModels.setEnabled(true);
            this.reloadModels(2);
            this.cmbTemplates.setEnabled(true);
            this.bnManage.setEnabled(true);
            this.cbIncludeAll.setEnabled(true);
        } else if (((String)this.cmbReports.getSelectedItem()).equalsIgnoreCase("Entities")) {
            this.reportCode = this.cbIncludeAll.isSelected() ? 4 : 3;
            this.cmbModels.setEnabled(true);
            this.reloadModels(4);
            this.cmbTemplates.setEnabled(true);
            this.bnManage.setEnabled(true);
            this.cbIncludeAll.setEnabled(true);
        } else if (((String)this.cmbReports.getSelectedItem()).equalsIgnoreCase("Domains")) {
            this.reportCode = 5;
            this.bnSelectSubView.setEnabled(false);
            this.bnSelectObject.setEnabled(false);
            this.cmbModels.setEnabled(false);
            this.cmbTemplates.setEnabled(true);
            this.bnManage.setEnabled(true);
            this.cbIncludeAll.setEnabled(true);
        } else if (((String)this.cmbReports.getSelectedItem()).equalsIgnoreCase("Glossaries")) {
            this.reportCode = 6;
            this.bnSelectSubView.setEnabled(false);
            this.bnSelectObject.setEnabled(false);
            this.cmbModels.setEnabled(false);
            this.cmbTemplates.setEnabled(false);
            this.bnManage.setEnabled(false);
            this.cbIncludeAll.setEnabled(false);
        } else if (((String)this.cmbReports.getSelectedItem()).equalsIgnoreCase("Structured Types")) {
            this.reportCode = this.cbIncludeAll.isSelected() ? 8 : 7;
            this.reloadModels(8);
            this.cmbModels.setEnabled(true);
            this.cmbTemplates.setEnabled(true);
            this.bnManage.setEnabled(true);
            this.cbIncludeAll.setEnabled(true);
        } else if (((String)this.cmbReports.getSelectedItem()).equalsIgnoreCase("Distinct Types")) {
            this.reportCode = this.cbIncludeAll.isSelected() ? 12 : 11;
            this.reloadModels(12);
            this.cmbModels.setEnabled(true);
            this.cmbTemplates.setEnabled(true);
            this.bnManage.setEnabled(true);
            this.cbIncludeAll.setEnabled(true);
        } else if (((String)this.cmbReports.getSelectedItem()).equalsIgnoreCase("Collection Types")) {
            this.reportCode = this.cbIncludeAll.isSelected() ? 10 : 9;
            this.reloadModels(10);
            this.cmbModels.setEnabled(true);
            this.cmbTemplates.setEnabled(true);
            this.bnManage.setEnabled(true);
            this.cbIncludeAll.setEnabled(true);
        } else if (((String)this.cmbReports.getSelectedItem()).equalsIgnoreCase("Change Requests")) {
            this.cmbModels.setEnabled(false);
            this.reportCode = 13;
            this.cmbTemplates.setEnabled(true);
            this.bnManage.setEnabled(true);
            this.cbIncludeAll.setSelected(true);
            this.cbIncludeAll.setEnabled(false);
        } else if (((String)this.cmbReports.getSelectedItem()).equalsIgnoreCase("Measurements")) {
            this.cmbModels.setEnabled(false);
            this.reportCode = 14;
            this.cmbTemplates.setEnabled(true);
            this.bnManage.setEnabled(true);
            this.cbIncludeAll.setSelected(true);
            this.cbIncludeAll.setEnabled(false);
        }
        for (ReportTemplate reportTemplate : this.appView.getReportTemplates()) {
            if (reportTemplate.getType() != this.reportCode) continue;
            this.cmbTemplates.addItem(reportTemplate);
        }
        this.cmbTemplates.updateUI();
    }

    private void initReportParams() {
        this.tocTagName = "";
        String string = "";
        string = this.saxonPath != null && !this.saxonPath.equals("") ? "20" : "10";
        String string2 = ((String)this.cmbOutFormat.getSelectedItem()).toLowerCase();
        if (!this.cbIncludeAll.isSelected()) {
            if (this.reportType.equalsIgnoreCase("Tables")) {
                this.xsltFile = new File(ApplicationView.basePath, "reports/xslt/" + string + "/SingleTableDetails_" + string2 + ".xslt");
                this.reportFileName = "SingleTableDetails_" + this.getLastUsedFileIdx("SingleTableDetails") + "_rs." + string2;
            } else if (this.reportType.equalsIgnoreCase("Entities")) {
                this.xsltFile = new File(ApplicationView.basePath, "reports/xslt/" + string + "/SingleEntityDetails_" + string2 + ".xslt");
                this.reportFileName = "SingleEntityDetails_" + this.getLastUsedFileIdx("SingleEntityDetails") + "_rs." + string2;
            } else if (this.reportType.equalsIgnoreCase("Collection Types")) {
                this.xsltFile = new File(ApplicationView.basePath, "reports/xslt/" + string + "/SingleCollectionTypeDetails_" + string2 + ".xslt");
                this.reportFileName = "SingleCollectionTypeDetails_" + this.getLastUsedFileIdx("SingleCollectionTypeDetails") + "_rs." + string2;
            } else if (this.reportType.equalsIgnoreCase("Structured Types")) {
                this.xsltFile = new File(ApplicationView.basePath, "reports/xslt/" + string + "/SingleStructuredTypeDetails_" + string2 + ".xslt");
                this.reportFileName = "SingleStructuredTypeDetails_" + this.getLastUsedFileIdx("SingleStructuredTypeDetails") + "_rs." + string2;
            } else if (this.reportType.equalsIgnoreCase("Distinct Types")) {
                this.xsltFile = new File(ApplicationView.basePath, "reports/xslt/" + string + "/SingleDistinctTypeDetails_" + string2 + ".xslt");
                this.reportFileName = "SingleDistinctTypeDetails_" + this.getLastUsedFileIdx("SingleDistinctTypeDetails") + "_rs." + string2;
            }
        } else if (this.reportType.equalsIgnoreCase("Tables")) {
            this.xsltFile = new File(ApplicationView.basePath, "reports/xslt/" + string + "/AllTablesDetails_" + string2 + ".xslt");
            this.reportFileName = "AllTablesDetails_" + this.getLastUsedFileIdx("AllTablesDetails") + "_rs." + string2;
            this.tocTagName = "TableName";
        } else if (this.reportType.equalsIgnoreCase("Entities")) {
            this.xsltFile = new File(ApplicationView.basePath, "reports/xslt/" + string + "/AllEntitiesDetails_" + string2 + ".xslt");
            this.reportFileName = "AllEntitiesDetails_" + this.getLastUsedFileIdx("AllEntitiesDetails") + "_rs." + string2;
            this.tocTagName = "EntityName";
        } else if (this.reportType.equalsIgnoreCase("Domains")) {
            this.xsltFile = new File(ApplicationView.basePath, "reports/xslt/" + string + "/AllDomainsDetails_" + string2 + ".xslt");
            this.reportFileName = "AllDomainsDetails_" + this.getLastUsedFileIdx("AllDomainsDetails") + "_rs." + string2;
            this.tocTagName = "DomainName";
        } else if (this.reportType.equalsIgnoreCase("Glossaries")) {
            this.xsltFile = new File(ApplicationView.basePath, "reports/xslt/" + string + "/GlossaryDetails_" + string2 + ".xslt");
            this.reportFileName = "GlossaryDetails_" + this.getLastUsedFileIdx("GlossaryDetails") + "_rs." + string2;
        } else if (this.reportType.equalsIgnoreCase("Structured Types")) {
            this.xsltFile = new File(ApplicationView.basePath, "reports/xslt/" + string + "/AllStructuredTypesDetails_" + string2 + ".xslt");
            this.reportFileName = "AllStructuredTypesDetails_" + this.getLastUsedFileIdx("AllStructuredTypesDetails") + "_rs." + string2;
            this.tocTagName = "STName";
        } else if (this.reportType.equalsIgnoreCase("Distinct Types")) {
            this.xsltFile = new File(ApplicationView.basePath, "reports/xslt/" + string + "/AllDistinctTypesDetails_" + string2 + ".xslt");
            this.reportFileName = "AllDistinctTypesDetails_" + this.getLastUsedFileIdx("AllDistinctTypesDetails") + "_rs." + string2;
            this.tocTagName = "DTName";
        } else if (this.reportType.equalsIgnoreCase("Collection Types")) {
            this.xsltFile = new File(ApplicationView.basePath, "reports/xslt/" + string + "/AllCollectionTypesDetails_" + string2 + ".xslt");
            this.reportFileName = "AllCollectionTypesDetails_" + this.getLastUsedFileIdx("AllCollectionTypesDetails") + "_rs." + string2;
            this.tocTagName = "CTName";
        } else if (this.reportType.equalsIgnoreCase("Change Requests")) {
            this.xsltFile = new File(ApplicationView.basePath, "reports/xslt/" + string + "/ChangeRequestsDetails_" + string2 + ".xslt");
            this.reportFileName = "ChangeRequestsDetails_" + this.getLastUsedFileIdx("ChangeRequestsDetails") + "_rs." + string2;
        } else if (this.reportType.equalsIgnoreCase("Measurements")) {
            this.xsltFile = new File(ApplicationView.basePath, "reports/xslt/" + string + "/MeasurementsDetails_" + string2 + ".xslt");
            this.reportFileName = "MeasurementsDetails_" + this.getLastUsedFileIdx("MeasurementsDetails") + "_rs." + string2;
        }
    }

    private long getLastUsedFileIdx(String string) {
        long l = 0L;
        long l2 = 0L;
        try {
            File[] fileArray;
            File file = new File(this.reportsPath);
            if (!file.exists()) {
                file.mkdirs();
            }
            if ((fileArray = file.listFiles()) == null) {
                fileArray = new File(file.getParent()).listFiles();
            }
            for (int i = 0; i < fileArray.length; ++i) {
                File file2 = fileArray[i];
                String string2 = file2.getName();
                if (!file2.isFile() || !string2.startsWith(string) || string2.indexOf("_rs") <= 1) continue;
                String string3 = string2.substring(string2.indexOf("_") + 1, string2.indexOf("_rs"));
                try {
                    l2 = new Long(string3);
                    if (l2 <= l) continue;
                    l = l2;
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        catch (Exception exception) {
            LOGGER.error("ReportsGenerator.getLastUsedFileIdx() Exception : " + exception);
        }
        return l + 1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasPermissions(String string) {
        PrintWriter printWriter = null;
        try {
            File file = new File(string + "/test.log");
            FileWriter fileWriter = new FileWriter(file);
            printWriter = new PrintWriter(fileWriter);
            printWriter.write("test");
            printWriter.flush();
            printWriter.close();
            printWriter = null;
            file.delete();
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
            boolean bl = false;
            return bl;
        }
        catch (Exception exception) {
            LOGGER.error("ReportsGenerator.hasPermissions() " + exception);
            boolean bl = false;
            return bl;
        }
        finally {
            if (printWriter != null) {
                printWriter.flush();
                printWriter.close();
                printWriter = null;
            }
        }
    }

    class ComboBoxRenderer
    extends JLabel
    implements ListCellRenderer {
        ComboBoxRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            String string = " ";
            if (object != null) {
                string = ((ReportTemplate)object).getName();
            }
            this.setText(string);
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            this.setEnabled(jList.isEnabled());
            this.setFont(jList.getFont());
            this.setOpaque(true);
            return this;
        }
    }

    private class SelectModelAction
    implements ActionListener {
        private SelectModelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (ReportsGenerationDialog.this.initConnection()) {
                if (((String)ReportsGenerationDialog.this.cmbReports.getSelectedItem()).equals("Glossaries")) {
                    SelectGlossaryDialog selectGlossaryDialog = new SelectGlossaryDialog(ReportsGenerationDialog.this.appView, ReportsGenerationDialog.this.er, ReportsGenerationDialog.this.connection);
                    selectGlossaryDialog.showDialog();
                } else {
                    SelectModelDialog.showDialog(ReportsGenerationDialog.this.getApplicationView().getFrame(), ReportsGenerationDialog.this.connection, ReportsGenerationDialog.this.er);
                }
            }
        }
    }

    private class TestAction
    implements ActionListener {
        private TestAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FCPConnectionDialog.testConnection(ReportsGenerationDialog.this.getSelectedConnectionProperties());
        }
    }

    private class RemoveAction
    implements ActionListener {
        private RemoveAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Properties properties = ReportsGenerationDialog.this.getSelectedConnectionProperties();
            if (properties != null) {
                try {
                    String string = ConnectionInfo.getConnectionName(properties);
                    int n = JOptionPane.showConfirmDialog(ReportsGenerationDialog.this, MessageFormat.format(Messages.getString("ReportsGenerationDialog.SureToDelete"), string), Messages.getString("ReportsGenerationDialog.SelectOption"), 0);
                    if (n == 0) {
                        DatabaseConnections.getInstance().removeConnection(string);
                        ReportsGenerationDialog.this.updateConnections();
                        ReportsGenerationDialog.this.tbConnections.clearSelection();
                        ReportsGenerationDialog.this.bnTest.setEnabled(false);
                        ReportsGenerationDialog.this.bnProps.setEnabled(false);
                        ReportsGenerationDialog.this.bnRemove.setEnabled(false);
                        ReportsGenerationDialog.this.bnSelectModel.setEnabled(false);
                    }
                }
                catch (ConnectionException connectionException) {
                    LOGGER.error("Unable to delete connection", connectionException);
                    MessageDialogs.showMessage(ApplicationView.frame, "Unable to delete connection");
                }
            }
        }
    }

    private class AddAction
    implements ActionListener {
        private AddAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                FCPConnectionDialog.showConnectionDialog(true);
                ReportsGenerationDialog.this.updateConnections();
            }
            catch (Exception exception) {
                LOGGER.error(exception);
            }
        }
    }

    private class ManageTemplatesAction
    implements ActionListener {
        private ManageTemplatesAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ReportTemplatesDialog reportTemplatesDialog = new ReportTemplatesDialog(ReportsGenerationDialog.this.appView, ReportsGenerationDialog.this.reportCode, ReportsGenerationDialog.this.rgd);
            reportTemplatesDialog.showDialog();
        }
    }

    private class SelectSubViewAction
    implements ActionListener {
        private SelectSubViewAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SelectReportObjectDialog selectReportObjectDialog = new SelectReportObjectDialog(ReportsGenerationDialog.this.appView, ReportsGenerationDialog.this.er, true);
            selectReportObjectDialog.showDialog();
        }
    }

    private class SelectObjectAction
    implements ActionListener {
        private SelectObjectAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SelectReportObjectDialog selectReportObjectDialog = new SelectReportObjectDialog(ReportsGenerationDialog.this.appView, ReportsGenerationDialog.this.er, false);
            selectReportObjectDialog.showDialog();
        }
    }

    private class GenerateAction
    implements ActionListener {
        private GenerateAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ReportsGenerationDialog.this.generateReport();
        }
    }

    private class CloseAction
    implements ActionListener {
        private CloseAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ReportsGenerationDialog.this.close();
        }
    }
}

