/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.wizards.reports;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.dbtools.crest.model.MDConfiguration;
import oracle.dbtools.crest.model.metadata.XMLTransformationManager;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.wizards.reports.ReportTemplate;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.options.Settings;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class ReportTemplatesPersistence {
    public static final String RT_FILE_NAME = "report_templates.xml";
    private ApplicationView appView;
    private static final Logger LOGGER = new Logger(ReportTemplatesPersistence.class);

    public ReportTemplatesPersistence(ApplicationView applicationView) {
        this.appView = applicationView;
    }

    public void saveReportTemplates() {
        StringBuffer stringBuffer = new StringBuffer(MDConfiguration.getDefaultInstance().get("xml.documenttype"));
        stringBuffer.append("\n");
        stringBuffer.append("<").append("report_templates").append(">");
        for (ReportTemplate reportTemplate : this.appView.getReportTemplates()) {
            stringBuffer.append("\n");
            stringBuffer.append("\t").append("<").append("report_template").append(' ');
            stringBuffer.append("id=\"").append(reportTemplate.getReportTemplateId()).append("\"").append(' ');
            stringBuffer.append("name=\"").append(StringUtilities.encodeAttributeValue(reportTemplate.getName())).append("\"").append(' ');
            stringBuffer.append("type=\"").append(reportTemplate.getType()).append("\"").append(' ');
            stringBuffer.append(">");
            stringBuffer.append("\n");
            if (reportTemplate.getType() == 1 || reportTemplate.getType() == 2) {
                stringBuffer.append("\t\t").append("<").append("description_notes").append(">");
                stringBuffer.append(reportTemplate.isUseDescriptionInfo());
                stringBuffer.append("</").append("description_notes").append(">");
                stringBuffer.append("\n");
                stringBuffer.append("\t\t").append("<").append("quantitative_info").append(">");
                stringBuffer.append(reportTemplate.isUseQuantitativeInfo());
                stringBuffer.append("</").append("quantitative_info").append(">");
                stringBuffer.append("\n");
                stringBuffer.append("\t\t").append("<").append("table_columns").append(">");
                stringBuffer.append(reportTemplate.isUseTableColumns());
                stringBuffer.append("</").append("table_columns").append(">");
                stringBuffer.append("\n");
                stringBuffer.append("\t\t").append("<").append("table_columns_comments").append(">");
                stringBuffer.append(reportTemplate.isUseTableColumnsComments());
                stringBuffer.append("</").append("table_columns_comments").append(">");
                stringBuffer.append("\n");
                stringBuffer.append("\t\t").append("<").append("table_constraints").append(">");
                stringBuffer.append(reportTemplate.isUseTableConstraints());
                stringBuffer.append("</").append("table_constraints").append(">");
                stringBuffer.append("\n");
                stringBuffer.append("\t\t").append("<").append("table_fk_rf").append(">");
                stringBuffer.append(reportTemplate.isUseTableFKReferredFrom());
                stringBuffer.append("</").append("table_fk_rf").append(">");
                stringBuffer.append("\n");
                stringBuffer.append("\t\t").append("<").append("table_fk_rt").append(">");
                stringBuffer.append(reportTemplate.isUseTableFKReferringTo());
                stringBuffer.append("</").append("table_fk_rt").append(">");
                stringBuffer.append("\n");
                stringBuffer.append("\t\t").append("<").append("table_indexes").append(">");
                stringBuffer.append(reportTemplate.isUseTableIndexes());
                stringBuffer.append("</").append("table_indexes").append(">");
                stringBuffer.append("\n");
            } else if (reportTemplate.getType() == 3 || reportTemplate.getType() == 4) {
                stringBuffer.append("\t\t").append("<").append("description_notes").append(">");
                stringBuffer.append(reportTemplate.isUseDescriptionInfo());
                stringBuffer.append("</").append("description_notes").append(">");
                stringBuffer.append("\n");
                stringBuffer.append("\t\t").append("<").append("quantitative_info").append(">");
                stringBuffer.append(reportTemplate.isUseQuantitativeInfo());
                stringBuffer.append("</").append("quantitative_info").append(">");
                stringBuffer.append("\n");
                stringBuffer.append("\t\t").append("<").append("entity_attributes").append(">");
                stringBuffer.append(reportTemplate.isUseEntityAttributes());
                stringBuffer.append("</").append("entity_attributes").append(">");
                stringBuffer.append("\n");
                stringBuffer.append("\t\t").append("<").append("entity_attributes_comments").append(">");
                stringBuffer.append(reportTemplate.isUseEntityAttributesComments());
                stringBuffer.append("</").append("entity_attributes_comments").append(">");
                stringBuffer.append("\n");
                stringBuffer.append("\t\t").append("<").append("entity_constraints").append(">");
                stringBuffer.append(reportTemplate.isUseEntityConstraints());
                stringBuffer.append("</").append("entity_constraints").append(">");
                stringBuffer.append("\n");
                stringBuffer.append("\t\t").append("<").append("entity_identifiers").append(">");
                stringBuffer.append(reportTemplate.isUseEntityIdentifiers());
                stringBuffer.append("</").append("entity_identifiers").append(">");
                stringBuffer.append("\n");
                stringBuffer.append("\t\t").append("<").append("entity_relationships").append(">");
                stringBuffer.append(reportTemplate.isUseEntityRelationships());
                stringBuffer.append("</").append("entity_relationships").append(">");
                stringBuffer.append("\n");
                stringBuffer.append("\t\t").append("<").append("entity_inc_processes").append(">");
                stringBuffer.append(reportTemplate.isUseEntityIncomingProcesses());
                stringBuffer.append("</").append("entity_inc_processes").append(">");
                stringBuffer.append("\n");
                stringBuffer.append("\t\t").append("<").append("entity_out_processes").append(">");
                stringBuffer.append(reportTemplate.isUseEntityOutgoingProcesses());
                stringBuffer.append("</").append("entity_out_processes").append(">");
                stringBuffer.append("\n");
            } else if (reportTemplate.getType() == 5) {
                stringBuffer.append("\t\t").append("<").append("domain_constraints").append(">");
                stringBuffer.append(reportTemplate.isUseDomainConstraints());
                stringBuffer.append("</").append("domain_constraints").append(">");
                stringBuffer.append("\n");
                stringBuffer.append("\t\t").append("<").append("domain_used_in_entities").append(">");
                stringBuffer.append(reportTemplate.isUseDomainUsedInEntities());
                stringBuffer.append("</").append("domain_used_in_entities").append(">");
                stringBuffer.append("\n");
                stringBuffer.append("\t\t").append("<").append("domain_used_in_tables").append(">");
                stringBuffer.append(reportTemplate.isUseDomainUsedInTables());
                stringBuffer.append("</").append("domain_used_in_tables").append(">");
                stringBuffer.append("\n");
            } else if (reportTemplate.getType() == 7 || reportTemplate.getType() == 8) {
                stringBuffer.append("\t\t").append("<").append("description_notes").append(">");
                stringBuffer.append(reportTemplate.isUseDescriptionInfo());
                stringBuffer.append("</").append("description_notes").append(">");
                stringBuffer.append("\n");
                stringBuffer.append("\t\t").append("<").append("st_attributes").append(">");
                stringBuffer.append(reportTemplate.isUseSTAttributes());
                stringBuffer.append("</").append("st_attributes").append(">");
                stringBuffer.append("\n");
                stringBuffer.append("\t\t").append("<").append("st_attributes_comments").append(">");
                stringBuffer.append(reportTemplate.isUseSTAttributesComments());
                stringBuffer.append("</").append("st_attributes_comments").append(">");
                stringBuffer.append("\n");
                stringBuffer.append("\t\t").append("<").append("st_methods").append(">");
                stringBuffer.append(reportTemplate.isUseSTMethods());
                stringBuffer.append("</").append("st_methods").append(">");
                stringBuffer.append("\n");
                stringBuffer.append("\t\t").append("<").append("st_used_in_tables").append(">");
                stringBuffer.append(reportTemplate.isUseSTUsedInTables());
                stringBuffer.append("</").append("st_used_in_tables").append(">");
                stringBuffer.append("\n");
                stringBuffer.append("\t\t").append("<").append("st_used_in_entities").append(">");
                stringBuffer.append(reportTemplate.isUseSTUsedInEntities());
                stringBuffer.append("</").append("st_used_in_entities").append(">");
                stringBuffer.append("\n");
            } else if (reportTemplate.getType() == 9 || reportTemplate.getType() == 10) {
                stringBuffer.append("\t\t").append("<").append("description_notes").append(">");
                stringBuffer.append(reportTemplate.isUseDescriptionInfo());
                stringBuffer.append("</").append("description_notes").append(">");
                stringBuffer.append("\n");
                stringBuffer.append("\t\t").append("<").append("ct_used_in_tables").append(">");
                stringBuffer.append(reportTemplate.isUseCTUsedInTables());
                stringBuffer.append("</").append("ct_used_in_tables").append(">");
                stringBuffer.append("\n");
                stringBuffer.append("\t\t").append("<").append("ct_used_in_entities").append(">");
                stringBuffer.append(reportTemplate.isUseCTUsedInEntities());
                stringBuffer.append("</").append("ct_used_in_entities").append(">");
                stringBuffer.append("\n");
            } else if (reportTemplate.getType() == 11 || reportTemplate.getType() == 12) {
                stringBuffer.append("\t\t").append("<").append("description_notes").append(">");
                stringBuffer.append(reportTemplate.isUseDescriptionInfo());
                stringBuffer.append("</").append("description_notes").append(">");
                stringBuffer.append("\n");
                stringBuffer.append("\t\t").append("<").append("dt_used_in_tables").append(">");
                stringBuffer.append(reportTemplate.isUseDTUsedInTables());
                stringBuffer.append("</").append("dt_used_in_tables").append(">");
                stringBuffer.append("\n");
                stringBuffer.append("\t\t").append("<").append("dt_used_in_entities").append(">");
                stringBuffer.append(reportTemplate.isUseDTUsedInEntities());
                stringBuffer.append("</").append("dt_used_in_entities").append(">");
                stringBuffer.append("\n");
            } else if (reportTemplate.getType() == 13) {
                stringBuffer.append("\t\t").append("<").append("ct_impacted_objects").append(">");
                stringBuffer.append(reportTemplate.isUseCRImpactedObjects());
                stringBuffer.append("</").append("ct_impacted_objects").append(">");
                stringBuffer.append("\n");
            } else if (reportTemplate.getType() == 14) {
                stringBuffer.append("\t\t").append("<").append("mt_impacted_objects").append(">");
                stringBuffer.append(reportTemplate.isUseMRImpactedObjects());
                stringBuffer.append("</").append("mt_impacted_objects").append(">");
                stringBuffer.append("\n");
            }
            stringBuffer.append("\t").append("</").append("report_template").append(">");
        }
        stringBuffer.append("\n");
        stringBuffer.append("</").append("report_templates").append(">");
        this.writeToFile(stringBuffer);
    }

    private void writeToFile(StringBuffer stringBuffer) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(new File(XMLTransformationManager.getDefaultSystemTypesPath(), RT_FILE_NAME));
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
            outputStreamWriter.write(stringBuffer.toString());
            outputStreamWriter.close();
        }
        catch (Exception exception) {
            LOGGER.error("Unable to save report templates: ", exception);
        }
    }

    public void loadReportTemplates(Settings settings) {
        try {
            File file = new File(XMLTransformationManager.getDefaultSystemTypesPath(settings), RT_FILE_NAME);
            if (file.exists()) {
                FileInputStream fileInputStream = new FileInputStream(file);
                InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, "UTF-8");
                InputSource inputSource = new InputSource(inputStreamReader);
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document document = documentBuilder.parse(inputSource);
                this.loadData(document);
            }
        }
        catch (Exception exception) {
            LOGGER.error("Unable to load report templates: ", exception);
        }
    }

    private void loadData(Document document) {
        ArrayList<ReportTemplate> arrayList = new ArrayList<ReportTemplate>();
        NodeList nodeList = document.getElementsByTagName("report_template");
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            NodeList nodeList2;
            NodeList nodeList3;
            NodeList nodeList4;
            NodeList nodeList5;
            NodeList nodeList6;
            NodeList nodeList7;
            NodeList nodeList8;
            NodeList nodeList9;
            Element element = (Element)nodeList.item(i);
            int n2 = Integer.valueOf(element.getAttribute("type"));
            ReportTemplate reportTemplate = new ReportTemplate(StringUtilities.decodeAttributeValue(element.getAttribute("name")), n2, element.getAttribute("id"));
            if (n2 == 1 || n2 == 2) {
                nodeList9 = element.getElementsByTagName("description_notes");
                if (nodeList9.item(0) != null) {
                    reportTemplate.setUseDescriptionInfo(Boolean.valueOf(nodeList9.item(0).getTextContent()));
                }
                if ((nodeList8 = element.getElementsByTagName("quantitative_info")).item(0) != null) {
                    reportTemplate.setUseQuantitativeInfo(Boolean.valueOf(nodeList8.item(0).getTextContent()));
                }
                if ((nodeList7 = element.getElementsByTagName("table_columns")).item(0) != null) {
                    reportTemplate.setUseTableColumns(Boolean.valueOf(nodeList7.item(0).getTextContent()));
                }
                if ((nodeList6 = element.getElementsByTagName("table_columns_comments")).item(0) != null) {
                    reportTemplate.setUseTableColumnsComments(Boolean.valueOf(nodeList6.item(0).getTextContent()));
                }
                if ((nodeList5 = element.getElementsByTagName("table_constraints")).item(0) != null) {
                    reportTemplate.setUseTableConstraints(Boolean.valueOf(nodeList5.item(0).getTextContent()));
                }
                if ((nodeList4 = element.getElementsByTagName("table_fk_rf")).item(0) != null) {
                    reportTemplate.setUseTableFKReferredFrom(Boolean.valueOf(nodeList4.item(0).getTextContent()));
                }
                if ((nodeList3 = element.getElementsByTagName("table_fk_rt")).item(0) != null) {
                    reportTemplate.setUseTableFKReferringTo(Boolean.valueOf(nodeList3.item(0).getTextContent()));
                }
                if ((nodeList2 = element.getElementsByTagName("table_indexes")).item(0) != null) {
                    reportTemplate.setUseTableIndexes(Boolean.valueOf(nodeList2.item(0).getTextContent()));
                }
            } else if (n2 == 3 || n2 == 4) {
                NodeList nodeList10;
                nodeList9 = element.getElementsByTagName("description_notes");
                if (nodeList9.item(0) != null) {
                    reportTemplate.setUseDescriptionInfo(Boolean.valueOf(nodeList9.item(0).getTextContent()));
                }
                if ((nodeList8 = element.getElementsByTagName("quantitative_info")).item(0) != null) {
                    reportTemplate.setUseQuantitativeInfo(Boolean.valueOf(nodeList8.item(0).getTextContent()));
                }
                if ((nodeList7 = element.getElementsByTagName("entity_attributes")).item(0) != null) {
                    reportTemplate.setUseEntityAttributes(Boolean.valueOf(nodeList7.item(0).getTextContent()));
                }
                if ((nodeList6 = element.getElementsByTagName("entity_attributes_comments")).item(0) != null) {
                    reportTemplate.setUseEntityAttributesComments(Boolean.valueOf(nodeList6.item(0).getTextContent()));
                }
                if ((nodeList5 = element.getElementsByTagName("entity_constraints")).item(0) != null) {
                    reportTemplate.setUseEntityConstraints(Boolean.valueOf(nodeList5.item(0).getTextContent()));
                }
                if ((nodeList4 = element.getElementsByTagName("entity_identifiers")).item(0) != null) {
                    reportTemplate.setUseEntityIdentifiers(Boolean.valueOf(nodeList4.item(0).getTextContent()));
                }
                if ((nodeList3 = element.getElementsByTagName("entity_relationships")).item(0) != null) {
                    reportTemplate.setUseEntityRelationships(Boolean.valueOf(nodeList3.item(0).getTextContent()));
                }
                if ((nodeList2 = element.getElementsByTagName("entity_inc_processes")).item(0) != null) {
                    reportTemplate.setUseEntityIncomingProcesses(Boolean.valueOf(nodeList2.item(0).getTextContent()));
                }
                if ((nodeList10 = element.getElementsByTagName("entity_out_processes")).item(0) != null) {
                    reportTemplate.setUseEntityOutgoingProcesses(Boolean.valueOf(nodeList10.item(0).getTextContent()));
                }
            } else if (n2 == 5) {
                nodeList9 = element.getElementsByTagName("domain_constraints");
                if (nodeList9.item(0) != null) {
                    reportTemplate.setUseDomainConstraints(Boolean.valueOf(nodeList9.item(0).getTextContent()));
                }
                if ((nodeList8 = element.getElementsByTagName("domain_used_in_tables")).item(0) != null) {
                    reportTemplate.setUseDomainUsedInTables(Boolean.valueOf(nodeList8.item(0).getTextContent()));
                }
                if ((nodeList7 = element.getElementsByTagName("domain_used_in_entities")).item(0) != null) {
                    reportTemplate.setUseDomainUsedInEntities(Boolean.valueOf(nodeList7.item(0).getTextContent()));
                }
            } else if (n2 == 7 || n2 == 8) {
                nodeList9 = element.getElementsByTagName("description_notes");
                if (nodeList9.item(0) != null) {
                    reportTemplate.setUseDescriptionInfo(Boolean.valueOf(nodeList9.item(0).getTextContent()));
                }
                if ((nodeList8 = element.getElementsByTagName("st_attributes")).item(0) != null) {
                    reportTemplate.setUseSTAttributes(Boolean.valueOf(nodeList8.item(0).getTextContent()));
                }
                if ((nodeList7 = element.getElementsByTagName("st_attributes_comments")).item(0) != null) {
                    reportTemplate.setUseSTAttributesComments(Boolean.valueOf(nodeList7.item(0).getTextContent()));
                }
                if ((nodeList6 = element.getElementsByTagName("st_methods")).item(0) != null) {
                    reportTemplate.setUseSTMethods(Boolean.valueOf(nodeList6.item(0).getTextContent()));
                }
                if ((nodeList5 = element.getElementsByTagName("st_used_in_tables")).item(0) != null) {
                    reportTemplate.setUseSTUsedInTables(Boolean.valueOf(nodeList5.item(0).getTextContent()));
                }
                if ((nodeList4 = element.getElementsByTagName("st_used_in_entities")).item(0) != null) {
                    reportTemplate.setUseSTUsedInEntities(Boolean.valueOf(nodeList4.item(0).getTextContent()));
                }
            } else if (n2 == 9 || n2 == 10) {
                nodeList9 = element.getElementsByTagName("description_notes");
                if (nodeList9.item(0) != null) {
                    reportTemplate.setUseDescriptionInfo(Boolean.valueOf(nodeList9.item(0).getTextContent()));
                }
                if ((nodeList8 = element.getElementsByTagName("ct_used_in_tables")).item(0) != null) {
                    reportTemplate.setUseCTUsedInTables(Boolean.valueOf(nodeList8.item(0).getTextContent()));
                }
                if ((nodeList7 = element.getElementsByTagName("ct_used_in_entities")).item(0) != null) {
                    reportTemplate.setUseCTUsedInEntities(Boolean.valueOf(nodeList7.item(0).getTextContent()));
                }
            } else if (n2 == 11 || n2 == 12) {
                nodeList9 = element.getElementsByTagName("description_notes");
                if (nodeList9.item(0) != null) {
                    reportTemplate.setUseDescriptionInfo(Boolean.valueOf(nodeList9.item(0).getTextContent()));
                }
                if ((nodeList8 = element.getElementsByTagName("dt_used_in_tables")).item(0) != null) {
                    reportTemplate.setUseDTUsedInTables(Boolean.valueOf(nodeList8.item(0).getTextContent()));
                }
                if ((nodeList7 = element.getElementsByTagName("dt_used_in_entities")).item(0) != null) {
                    reportTemplate.setUseDTUsedInEntities(Boolean.valueOf(nodeList7.item(0).getTextContent()));
                }
            } else if (n2 == 13) {
                nodeList9 = element.getElementsByTagName("ct_impacted_objects");
                if (nodeList9.item(0) != null) {
                    reportTemplate.setUseCRImpactedObjects(Boolean.valueOf(nodeList9.item(0).getTextContent()));
                }
            } else if (n2 == 14 && (nodeList9 = element.getElementsByTagName("mt_impacted_objects")).item(0) != null) {
                reportTemplate.setUseMRImpactedObjects(Boolean.valueOf(nodeList9.item(0).getTextContent()));
            }
            arrayList.add(reportTemplate);
        }
        this.appView.getReportTemplates().clear();
        this.appView.getReportTemplates().addAll(arrayList);
    }
}

