/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.wizards.reports;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.wizards.reports.Messages;
import oracle.dbtools.crest.swingui.wizards.reports.ReportsGenerator;
import oracle.dbtools.crest.util.logging.Logger;

public class RenderPDFReport
implements Runnable {
    private String vmOptions;
    private String xsltFile;
    private String reportsPath;
    private String reportFileName;
    private String rawXMLFileName;
    private String saxonPath;
    private static final Logger LOGGER = new Logger(ReportsGenerator.class);

    public RenderPDFReport(ApplicationView applicationView, String string, String string2, String string3, String string4, String string5, String string6) {
        this.vmOptions = string;
        this.xsltFile = string3;
        this.reportFileName = string4;
        this.rawXMLFileName = string2;
        this.saxonPath = string5;
        this.reportsPath = string6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int n;
        String string;
        ProcessBuilder processBuilder;
        BufferedReader bufferedReader;
        InputStreamReader inputStreamReader;
        String string2 = new File(System.getProperty("java.home"), "/bin/java").getAbsolutePath();
        Process process = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = false;
        if (this.saxonPath != null && !this.saxonPath.equals("")) {
            LOGGER.info("Using XSLT 2.0");
            inputStreamReader = null;
            bufferedReader = null;
            try {
                boolean bl2 = false;
                arrayList.add(string2);
                arrayList.add("-jar");
                arrayList.add(this.vmOptions.trim());
                arrayList.add(new File(this.saxonPath).getAbsolutePath());
                arrayList.add("-s:" + new File(this.reportsPath, this.rawXMLFileName).getAbsolutePath());
                arrayList.add("-xsl:" + this.xsltFile);
                arrayList.add("-o:" + new File(this.reportsPath, "report_data.fo").getAbsolutePath());
                processBuilder = new ProcessBuilder(arrayList);
                process = processBuilder.start();
                inputStreamReader = new InputStreamReader(process.getErrorStream());
                bufferedReader = new BufferedReader(inputStreamReader);
                while ((string = bufferedReader.readLine()) != null) {
                    LOGGER.error("XSLT-FO file generation message: " + string);
                    bl2 = true;
                }
                inputStreamReader.close();
                bufferedReader.close();
                if (bl2) {
                    LOGGER.error("PDF report generation FOP message: If the above error line is something like 'Unable to access jarfile' that usually means that JVM parameter entered in JVM Options text box is not according to specifications.");
                }
                if ((n = process.waitFor()) == 0) {
                    bl = true;
                } else {
                    ApplicationView.log(Messages.getString("ReportsGenerationDialog.ReportGenerationErrMsg"));
                }
                arrayList.clear();
                arrayList.add(string2);
                arrayList.add("-jar");
                arrayList.add(this.vmOptions.trim());
                arrayList.add(new File(ApplicationView.basePath, "lib/fop.jar").getAbsolutePath());
                arrayList.add("-c");
                arrayList.add(new File(ApplicationView.basePath + "/reports/fop.xconf").getAbsolutePath());
                arrayList.add("-fo");
                arrayList.add(new File(this.reportsPath, "report_data.fo").getAbsolutePath());
                arrayList.add("-pdf");
                arrayList.add(new File(this.reportsPath, this.reportFileName).getAbsolutePath());
            }
            catch (IOException iOException) {
                LOGGER.error("Exception during XSLT-FO file generation " + iOException);
            }
            catch (Exception exception) {
                LOGGER.error("Exception during XSLT-FO file generation " + exception);
            }
            finally {
                try {
                    process.getInputStream().close();
                    process.getOutputStream().close();
                    process.getErrorStream().close();
                    inputStreamReader.close();
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    LOGGER.error("Could not close Input/Output/Error streams of XSLT-FO file generation! " + iOException);
                }
            }
        } else {
            LOGGER.info("Using XSLT 1.0");
            arrayList.clear();
            arrayList.add(string2);
            arrayList.add("-jar");
            arrayList.add(this.vmOptions.trim());
            arrayList.add(new File(ApplicationView.basePath, "lib/fop.jar").getAbsolutePath());
            arrayList.add("-c");
            arrayList.add(new File(ApplicationView.basePath + "/reports/fop.xconf").getAbsolutePath());
            arrayList.add("-xml");
            arrayList.add(new File(this.reportsPath, this.rawXMLFileName).getAbsolutePath());
            arrayList.add("-xsl");
            arrayList.add(this.xsltFile);
            arrayList.add("-pdf");
            arrayList.add(new File(this.reportsPath, this.reportFileName).getAbsolutePath());
            bl = true;
        }
        if (bl) {
            inputStreamReader = null;
            bufferedReader = null;
            try {
                boolean bl3 = false;
                processBuilder = new ProcessBuilder(arrayList);
                process = processBuilder.start();
                inputStreamReader = new InputStreamReader(process.getErrorStream());
                bufferedReader = new BufferedReader(inputStreamReader);
                while ((string = bufferedReader.readLine()) != null) {
                    LOGGER.error("PDF report generation FOP message: " + string);
                    bl3 = true;
                }
                inputStreamReader.close();
                bufferedReader.close();
                if (bl3) {
                    LOGGER.error("PDF report generation FOP message: If the above error line is something like 'Unable to access jarfile' that usually means that JVM parameter entered in JVM Options text box is not according to specifications.");
                }
                if ((n = process.waitFor()) == 0) {
                    ApplicationView.log(MessageFormat.format(Messages.getString("ReportsGenerationDialog.ReportGenerationOKMsg"), this.reportFileName, this.reportsPath));
                } else {
                    ApplicationView.log(Messages.getString("ReportsGenerationDialog.ReportGenerationErrMsg"));
                }
            }
            catch (IOException iOException) {
                LOGGER.error("Exception during PDF report generation " + iOException);
            }
            catch (Exception exception) {
                LOGGER.error("Exception during PDF report generation " + exception);
            }
            finally {
                try {
                    process.getInputStream().close();
                    process.getOutputStream().close();
                    process.getErrorStream().close();
                    inputStreamReader.close();
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    LOGGER.error("Could not close Input/Output/Error streams of PDF report generation! " + iOException);
                }
            }
        }
    }
}

