/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.wizards.oracledesigner;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import javax.swing.border.TitledBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import oracle.dbtools.crest.imports.oracledesigner.ODExtractionController;
import oracle.dbtools.crest.imports.oracledesigner.ODExtractionHandler;
import oracle.dbtools.crest.imports.oracledesigner.ODObject;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.WindowsTableHeader;
import oracle.dbtools.crest.swingui.wizards.CustomWizard;
import oracle.dbtools.crest.swingui.wizards.Messages;
import oracle.dbtools.crest.swingui.wizards.metadata.DMConnectionModel;
import oracle.dbtools.crest.swingui.wizards.metadata.connection.ConnectionInfo;
import oracle.dbtools.crest.swingui.wizards.metadata.connection.FCPConnectionDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.jdeveloper.db.ConnectionException;
import oracle.jdeveloper.db.DatabaseConnections;

public class ODExtractionWizard
extends CustomWizard {
    public static final String DATABASE = "DATABASE";
    public static final String TABLE = "TABLE";
    public static final String VIEW = "VIEW";
    public static final String LOGIN = "LOGIN";
    public static final String USER = "USER";
    public static final String ROLE = "ROLE";
    public static final String RULE = "RULE";
    public static final String DEFAULT = "DEFAULT";
    public static final String PROCEDURE = "PROCEDURE";
    public static final String TRIGGER = "TRIGGER";
    public static final String DATATYPE = "DATATYPE";
    public static final String ALIAS = "ALIAS";
    public static final String BUFFERPOOL = "BUFFERPOOL";
    public static final String NODEGROUP = "NODEGROUP";
    public static final String OWNER = "OWNER";
    public static final String SEQUENCE = "SEQUENCE";
    public static final String USERGROUP = "USERGROUP";
    public static final String TABLESPACE = "TABLESPACE";
    public static final String AUX_TABLE = "AUX TABLE";
    public static final String STORAGE_GROUP = "STORAGE GROUP";
    public static final String VCAT = "VCAT";
    public static final String VOLUME = "VOLUME";
    private static final Font fontGrey = new Font("Dialog", 2, 12);
    private static final Font fontBlue = new Font("Dialog", 1, 12);
    private static final String DESCRIPTION_1 = Messages.getString("ODExtractionWizard.SelectDBConnection");
    private static final String DESCRIPTION_2 = Messages.getString("ODExtractionWizard.SelectWorkArea");
    private static final String DESCRIPTION_3 = Messages.getString("ODExtractionWizard.SelectApplicationSystems");
    private static final String DESCRIPTION_4 = Messages.getString("ODExtractionWizard.SelectObjectsToImport");
    private static final String DESCRIPTION_5 = Messages.getString("ODExtractionWizard.ViewSummaryGenerateDesign");
    private static final String FIRST_PAGE = "FIRST_PAGE";
    private static final String SECOND_PAGE = "SECOND_PAGE";
    private static final String THIRD_PAGE = "THIRD_PAGE";
    private static final String FOURTH_PAGE = "FOURTH_PAGE";
    private static final String FIFTH_PAGE = "FIFTH_PAGE";
    protected JTabbedPane tpane;
    protected JTable tbWorkAreas;
    protected List lsWorkAreas;
    protected JTable tbAppSys;
    protected List<ODObject> lsAppSys;
    protected JTable tbTableSpaces;
    protected JTable tbTempTableSpaces;
    protected JTable tbUndoTableSpaces;
    protected JTable tbUsers;
    protected JTable tbRoles;
    protected JTable tbDirectories;
    protected JTable tbExternalTables;
    protected JTable tbContexts;
    protected JTable tbClusters;
    protected JTable tbSequence;
    protected JTable tbSnapshots;
    protected JTable tbDimensions;
    protected JTable tbCollectionTypes;
    protected JTable tbStructuredTypes;
    protected List lsTableSpaces = new ArrayList();
    protected List lsTempTableSpaces = new ArrayList();
    protected List lsUndoTableSpaces = new ArrayList();
    protected List lsUsers = new ArrayList();
    protected List lsRoles = new ArrayList();
    protected List lsDirectories = new ArrayList();
    protected List lsExternalTables = new ArrayList();
    protected List lsContexts = new ArrayList();
    protected List lsClusters = new ArrayList();
    protected List lsSequence = new ArrayList();
    protected List lsSnapshots = new ArrayList();
    protected List lsDimensions = new ArrayList();
    protected List lsCollectionTypes = new ArrayList();
    protected List lsStructuredTypes = new ArrayList();
    protected JTable tbDomains;
    protected JTable tbEntities;
    protected JTable tbTables;
    protected JTable tbViews;
    protected List lsDomains = new ArrayList();
    protected List lsEntities = new ArrayList();
    protected List lsTables = new ArrayList();
    protected List lsViews = new ArrayList();
    private CardLayout cardLayout = new CardLayout();
    private JPanel pnMain;
    private JTextArea taDescription;
    private JLabel lbTask1;
    private JLabel lbTask2;
    private JLabel lbTask3;
    private JLabel lbTask4;
    private JLabel lbTask5;
    private int taskNbr = 1;
    private JTable tbConnections;
    private ODExtractionController controller;
    private JButton bnRemove;
    private JButton bnProperties;
    private JButton bnTestConnection;
    private JLabel taSummary;
    private JButton bnImport;
    protected JPanel firstPanel;
    protected JPanel secondPanel;
    protected JPanel thirdPanel;
    protected JPanel fourthPanel;
    protected JPanel fifthPanel;
    private Connection connection = null;
    private JPanel pnWarning;
    private boolean inExistingDesign;
    private static final Logger LOGGER = new Logger(ODExtractionWizard.class);

    public ODExtractionWizard(ApplicationView applicationView, boolean bl) {
        super(applicationView);
        ODExtractionHandler.clearInstance();
        this.inExistingDesign = bl;
        this.pnMain.setLayout(this.cardLayout);
        this.firstPanel = this.initFirstTab();
        this.pnMain.add((Component)this.firstPanel, FIRST_PAGE);
        this.secondPanel = this.initSecondTab();
        this.pnMain.add((Component)this.secondPanel, SECOND_PAGE);
        this.thirdPanel = this.initThirdTab();
        this.pnMain.add((Component)this.thirdPanel, THIRD_PAGE);
        this.fourthPanel = this.initFourthTab();
        this.pnMain.add((Component)this.fourthPanel, FOURTH_PAGE);
        this.fifthPanel = this.initFifthTab();
        this.pnMain.add((Component)this.fifthPanel, FIFTH_PAGE);
        this.handleButtons();
    }

    @Override
    protected String getCaption() {
        return Messages.getString("ODExtractionWizard.OracleDesignerImportWizard");
    }

    public ODExtractionController getController() {
        if (this.controller == null) {
            this.controller = new ODExtractionController(this.view);
        }
        return this.controller;
    }

    @Override
    protected JPanel initMainPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBackground(Color.WHITE);
        ImageIcon imageIcon = (ImageIcon)GUIConfiguration.getInstance().getIcon("DBM_WIZARD_BANNER");
        jPanel2.add((Component)new JLabel(imageIcon), "West");
        this.taDescription = new JTextArea();
        this.taDescription.setEditable(false);
        this.taDescription.setFont(fontBlue);
        this.taDescription.setBackground(Color.WHITE);
        JPanel jPanel3 = new JPanel(new FlowLayout(1, 0, 25));
        jPanel3.setBackground(Color.WHITE);
        jPanel3.add(this.taDescription);
        jPanel2.add((Component)jPanel3, "Center");
        jPanel.add((Component)jPanel2, "North");
        JPanel jPanel4 = new JPanel(new GridLayout(0, 1));
        jPanel4.setBackground(Color.WHITE);
        jPanel4.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        this.lbTask1 = new JLabel(Messages.getString("ODExtractionWizard.ConnectDB"));
        this.lbTask2 = new JLabel(Messages.getString("ODExtractionWizard.SelectWorkAreaPar"));
        this.lbTask3 = new JLabel(Messages.getString("ODExtractionWizard.SelectApplicationSystemsPar"));
        this.lbTask4 = new JLabel(Messages.getString("ODExtractionWizard.SelectObjectsToImportPar"));
        this.lbTask5 = new JLabel(Messages.getString("ODExtractionWizard.GenerateDesignPar"));
        jPanel4.add(this.lbTask1);
        jPanel4.add(this.lbTask2);
        jPanel4.add(this.lbTask3);
        jPanel4.add(this.lbTask4);
        jPanel4.add(this.lbTask5);
        jPanel4.add(new JLabel());
        jPanel4.add(new JLabel());
        jPanel4.add(new JLabel());
        jPanel4.add(new JLabel());
        jPanel4.add(new JLabel());
        jPanel4.add(new JLabel());
        jPanel4.setPreferredSize(new Dimension(280, 350));
        jPanel.add((Component)jPanel4, "West");
        this.pnMain = new JPanel();
        this.pnMain.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        this.pnMain.setPreferredSize(new Dimension(680, 450));
        jPanel.add((Component)this.pnMain, "Center");
        return jPanel;
    }

    private void updateConnections() {
        ((DMConnectionModel)this.tbConnections.getModel()).reReadConnections();
    }

    private Properties getSelectedConnectionProperties() {
        Properties properties = null;
        try {
            properties = ((DMConnectionModel)this.tbConnections.getModel()).getRowData(this.tbConnections.getSelectedRow());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return properties;
    }

    private void showConnectionProperties() {
        Properties properties = this.getSelectedConnectionProperties();
        if (properties != null) {
            String string = ConnectionInfo.getConnectionName(properties);
            FCPConnectionDialog.showConnectionDialog(string, true);
            this.updateConnections();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initConnection() {
        block5: {
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                this.closeConnection();
                Properties properties = this.getSelectedConnectionProperties();
                if (properties == null) break block5;
                try {
                    this.connection = DatabaseConnections.getInstance().getConnection(properties);
                }
                catch (Exception exception) {
                    MessageDialogs.showErrorMessage(exception.getLocalizedMessage());
                    boolean bl = false;
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    return bl;
                }
            }
            finally {
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
        return this.connection != null;
    }

    public void closeConnection() {
        if (this.connection != null) {
            try {
                if (!this.connection.isClosed()) {
                    this.connection.close();
                }
                this.connection = null;
            }
            catch (Exception exception) {
                LOGGER.error("Unable to close the connection", exception);
            }
        }
    }

    public int getSelectedConnectionType() {
        return ConnectionInfo.getConnectionType(this.getSelectedConnectionProperties());
    }

    private JPanel initFirstTab() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.tbConnections = new JTable(new DMConnectionModel(DatabaseConnections.getInstance(), true));
        this.tbConnections.setSelectionMode(0);
        this.tbConnections.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    ODExtractionWizard.this.showConnectionProperties();
                } else {
                    boolean bl = ODExtractionWizard.this.tbConnections.getSelectedRow() > -1;
                    ODExtractionWizard.this.bnNext.setEnabled(bl);
                    ODExtractionWizard.this.bnRemove.setEnabled(bl);
                    ODExtractionWizard.this.bnProperties.setEnabled(bl);
                    ODExtractionWizard.this.bnTestConnection.setEnabled(bl);
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.tbConnections);
        jPanel.add((Component)jScrollPane, "Center");
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        JButton jButton = new JButton(Messages.getString("ODExtractionWizard.Add"));
        jButton.setMnemonic(65);
        jButton.addActionListener(new AddAction());
        this.bnRemove = new JButton(Messages.getString("ODExtractionWizard.Remove"));
        this.bnRemove.setMnemonic(82);
        this.bnRemove.addActionListener(new RemoveAction());
        this.bnRemove.setEnabled(false);
        this.bnImport = new JButton(Messages.getString("ODExtractionWizard.Import"));
        this.bnImport.setToolTipText(Messages.getString("ODExtractionWizard.ImportSQLDevDBConnection"));
        this.bnImport.setMnemonic(73);
        this.bnImport.addActionListener(new ImportAction());
        this.bnProperties = new JButton(Messages.getString("ODExtractionWizard.Properties"));
        this.bnProperties.setMnemonic(80);
        this.bnProperties.addActionListener(new PropertiesAction());
        this.bnProperties.setEnabled(false);
        this.bnTestConnection = new JButton(Messages.getString("ODExtractionWizard.TestConnection"));
        this.bnTestConnection.setMnemonic(84);
        this.bnTestConnection.addActionListener(new TestAction());
        this.bnTestConnection.setEnabled(false);
        JPanel jPanel3 = new JPanel();
        jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.bnRemove.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.bnImport.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.bnProperties.setPreferredSize(MessageDialogs.BUTTON_SIZE_EX);
        jPanel3.setPreferredSize(new Dimension(40, 25));
        this.bnTestConnection.setPreferredSize(MessageDialogs.BUTTON_SIZE_EX);
        jPanel2.add(jButton);
        jPanel2.add(this.bnRemove);
        jPanel2.add(this.bnImport);
        jPanel2.add(this.bnProperties);
        jPanel2.add(jPanel3);
        jPanel2.add(this.bnTestConnection);
        jPanel.add((Component)jPanel2, "South");
        this.updateConnections();
        return jPanel;
    }

    public boolean initWorkAreas(boolean bl) {
        return this.getWorkAreas(bl);
    }

    public boolean initAppSys(boolean bl) {
        return this.getAppSys(bl);
    }

    public boolean initDBObjects(boolean bl) {
        return this.getODObjects(bl);
    }

    protected JPanel initFifthTab() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.taSummary = new JLabel();
        this.taSummary.setFont(this.taSummary.getFont().deriveFont(0));
        this.taSummary.setVerticalAlignment(1);
        jPanel.add((Component)this.taSummary, "Center");
        jPanel.add((Component)new JPanel(), "East");
        jPanel.add((Component)new JPanel(), "West");
        jPanel.add((Component)new JPanel(), "North");
        jPanel.add((Component)new JPanel(), "South");
        return jPanel;
    }

    private boolean performTask(boolean bl) {
        switch (this.taskNbr) {
            case 1: {
                this.closeConnection();
            }
            case 2: {
                if (!this.initConnection()) {
                    return false;
                }
                return this.initWorkAreas(bl);
            }
            case 3: {
                int n = this.tbAppSys.getEditingRow();
                int n2 = this.tbAppSys.getEditingColumn();
                if (n > -1 && n2 > -1) {
                    this.tbAppSys.getCellEditor(n, n2).stopCellEditing();
                }
                return this.initAppSys(bl);
            }
            case 4: {
                return this.initDBObjects(bl);
            }
            case 5: {
                return this.getSummary();
            }
        }
        return true;
    }

    private Map getSummaryList() {
        TreeMap<String, Integer> treeMap = new TreeMap<String, Integer>();
        for (ODObject oDObject : this.getSelectedObjects()) {
            if (!oDObject.isSelected()) continue;
            if (treeMap.containsKey(oDObject.getType())) {
                Integer n = (Integer)treeMap.get(oDObject.getType());
                int n2 = n;
                treeMap.put(oDObject.getType(), new Integer(++n2));
                continue;
            }
            treeMap.put(oDObject.getType(), new Integer(1));
        }
        return treeMap;
    }

    @Override
    protected String getHelpIndex() {
        return "IMPORT_ORACLE_DESIGNER_MODELS_WIZARD";
    }

    private String addTableRow(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<tr>");
        stringBuffer.append("<td width=\"150\">");
        stringBuffer.append("<p>");
        stringBuffer.append(string);
        stringBuffer.append("</p>");
        stringBuffer.append("</td>");
        stringBuffer.append("<td width=\"60\" align=\"right\">");
        stringBuffer.append("<p>");
        stringBuffer.append(string2);
        stringBuffer.append("</p>");
        stringBuffer.append("</td>");
        stringBuffer.append("</tr>");
        return stringBuffer.toString();
    }

    private boolean getSummary() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<html>");
        stringBuffer.append("<body>");
        stringBuffer.append("<p>");
        stringBuffer.append("<b>");
        stringBuffer.append(Messages.getString("ODExtractionWizard.DatabaseName"));
        stringBuffer.append("</b>");
        stringBuffer.append(ConnectionInfo.getConnectionName(this.getSelectedConnectionProperties()));
        stringBuffer.append("</p>");
        stringBuffer.append("<p>");
        stringBuffer.append("<b>");
        stringBuffer.append(Messages.getString("ODExtractionWizard.DatabaseVersion"));
        stringBuffer.append("</b>");
        stringBuffer.append(this.getController().getDBProductVersion());
        stringBuffer.append("</p>");
        stringBuffer.append("<p></p>");
        stringBuffer.append("<p>");
        stringBuffer.append("<b>");
        stringBuffer.append(Messages.getString("ODExtractionWizard.DBObjectsImported"));
        stringBuffer.append("</b>");
        stringBuffer.append("</p>");
        stringBuffer.append("<table border=\"0\" width=\"170\">");
        Map map = this.getSummaryList();
        Object[] objectArray = map.keySet().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            String string = (String)objectArray[i];
            Integer n = (Integer)map.get(objectArray[i]);
            stringBuffer.append(this.addTableRow(string, n.toString()));
        }
        stringBuffer.append("</table>");
        stringBuffer.append("</body>");
        stringBuffer.append("</html>");
        this.taSummary.setText(stringBuffer.toString());
        return true;
    }

    @Override
    protected void doBack() {
        --this.taskNbr;
        try {
            if (this.performTask(false)) {
                this.handleButtons();
                switch (this.taskNbr) {
                    case 1: {
                        this.cardLayout.show(this.pnMain, FIRST_PAGE);
                        break;
                    }
                    case 2: {
                        this.cardLayout.show(this.pnMain, SECOND_PAGE);
                        break;
                    }
                    case 3: {
                        this.cardLayout.show(this.pnMain, THIRD_PAGE);
                        break;
                    }
                    case 4: {
                        this.cardLayout.show(this.pnMain, FOURTH_PAGE);
                    }
                }
            } else {
                ++this.taskNbr;
            }
        }
        catch (Throwable throwable) {
            ++this.taskNbr;
            JOptionPane.showMessageDialog(this, throwable.getMessage(), Messages.getString("ODExtractionWizard.Error"), 0);
            LOGGER.error(throwable);
        }
    }

    @Override
    protected void doNext() {
        ++this.taskNbr;
        try {
            if (this.performTask(true)) {
                this.handleButtons();
                switch (this.taskNbr) {
                    case 2: {
                        this.cardLayout.show(this.pnMain, SECOND_PAGE);
                        break;
                    }
                    case 3: {
                        this.cardLayout.show(this.pnMain, THIRD_PAGE);
                        break;
                    }
                    case 4: {
                        this.cardLayout.show(this.pnMain, FOURTH_PAGE);
                        break;
                    }
                    case 5: {
                        this.cardLayout.show(this.pnMain, FIFTH_PAGE);
                    }
                }
            } else {
                --this.taskNbr;
            }
        }
        catch (Throwable throwable) {
            --this.taskNbr;
            JOptionPane.showMessageDialog(this, throwable.getMessage(), Messages.getString("ODExtractionWizard.Error"), 0);
            LOGGER.error(throwable);
        }
    }

    @Override
    protected void doFinish() {
        try {
            this.getController().generateDesign(this.connection, this.getSelectedConnectionProperties(), this.getSelectedObjects(), this.inExistingDesign);
        }
        catch (Throwable throwable) {
            MessageDialogs.showErrorMessage(this, throwable.getMessage());
            LOGGER.error(throwable);
        }
        this.dispose();
    }

    @Override
    protected void doCancel() {
        this.closeConnection();
        this.dispose();
    }

    @Override
    protected void doClosing() {
        this.closeConnection();
    }

    private void handleButtons() {
        this.handleLabels();
        this.handleDescription();
        switch (this.taskNbr) {
            case 1: {
                this.bnBack.setEnabled(false);
                this.bnNext.setEnabled(this.tbConnections.getSelectedRow() > -1);
                this.bnFinish.setEnabled(false);
                this.bnCancel.setEnabled(true);
                break;
            }
            case 2: {
                this.bnBack.setEnabled(true);
                this.bnNext.setEnabled(this.tbWorkAreas.getSelectedRow() > -1);
                this.bnFinish.setEnabled(false);
                this.bnCancel.setEnabled(true);
                break;
            }
            case 3: {
                this.bnBack.setEnabled(true);
                this.bnNext.setEnabled(this.hasAppSystemSelected());
                this.bnFinish.setEnabled(false);
                this.bnCancel.setEnabled(true);
                break;
            }
            case 4: {
                this.bnBack.setEnabled(true);
                this.bnNext.setEnabled(true);
                this.bnFinish.setEnabled(false);
                this.bnCancel.setEnabled(true);
                break;
            }
            case 5: {
                this.bnBack.setEnabled(true);
                this.bnNext.setEnabled(false);
                this.bnFinish.setEnabled(true);
                this.bnCancel.setEnabled(true);
            }
        }
    }

    private void handleLabels() {
        switch (this.taskNbr) {
            case 1: {
                this.setBlueLabel(this.lbTask1);
                this.setGreyLabel(this.lbTask2);
                this.setGreyLabel(this.lbTask3);
                this.setGreyLabel(this.lbTask4);
                this.setGreyLabel(this.lbTask5);
                break;
            }
            case 2: {
                this.setBlackLabel(this.lbTask1);
                this.setBlueLabel(this.lbTask2);
                this.setGreyLabel(this.lbTask3);
                this.setGreyLabel(this.lbTask4);
                this.setGreyLabel(this.lbTask5);
                break;
            }
            case 3: {
                this.setBlackLabel(this.lbTask1);
                this.setBlackLabel(this.lbTask2);
                this.setBlueLabel(this.lbTask3);
                this.setGreyLabel(this.lbTask4);
                this.setGreyLabel(this.lbTask5);
                break;
            }
            case 4: {
                this.setBlackLabel(this.lbTask1);
                this.setBlackLabel(this.lbTask2);
                this.setBlackLabel(this.lbTask3);
                this.setBlueLabel(this.lbTask4);
                this.setGreyLabel(this.lbTask5);
                break;
            }
            case 5: {
                this.setBlackLabel(this.lbTask1);
                this.setBlackLabel(this.lbTask2);
                this.setBlackLabel(this.lbTask3);
                this.setBlackLabel(this.lbTask4);
                this.setBlueLabel(this.lbTask5);
                break;
            }
            default: {
                this.setBlueLabel(this.lbTask1);
                this.setGreyLabel(this.lbTask2);
                this.setGreyLabel(this.lbTask3);
                this.setGreyLabel(this.lbTask4);
                this.setGreyLabel(this.lbTask5);
            }
        }
    }

    private void setGreyLabel(JLabel jLabel) {
        jLabel.setForeground(Color.LIGHT_GRAY);
        jLabel.setFont(fontGrey);
    }

    private void setBlueLabel(JLabel jLabel) {
        jLabel.setForeground(Color.BLUE);
        jLabel.setFont(fontBlue);
    }

    private void setBlackLabel(JLabel jLabel) {
        jLabel.setForeground(Color.BLACK);
        jLabel.setFont(fontBlue);
    }

    private void handleDescription() {
        switch (this.taskNbr) {
            case 1: {
                this.taDescription.setText(DESCRIPTION_1);
                break;
            }
            case 2: {
                this.taDescription.setText(DESCRIPTION_2);
                break;
            }
            case 3: {
                this.taDescription.setText(DESCRIPTION_3);
                break;
            }
            case 4: {
                this.taDescription.setText(DESCRIPTION_4);
                break;
            }
            case 5: {
                this.taDescription.setText(DESCRIPTION_5);
                break;
            }
            default: {
                this.taDescription.setText(DESCRIPTION_1);
            }
        }
    }

    protected JTabbedPane getTabbedPane() {
        if (this.tpane == null) {
            this.tpane = new JTabbedPane(3);
        }
        return this.tpane;
    }

    public JPanel initSecondTab() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.lsWorkAreas = new ArrayList();
        this.tbWorkAreas = new JTable(new WorkAreaModel());
        this.tbWorkAreas.setSelectionMode(0);
        this.tbWorkAreas.setAutoCreateRowSorter(true);
        WindowsTableHeader.setSortedHeader(this.tbWorkAreas);
        TableColumn tableColumn = this.tbWorkAreas.getColumnModel().getColumn(1);
        tableColumn.setPreferredWidth(200);
        JScrollPane jScrollPane = new JScrollPane(this.tbWorkAreas);
        jPanel.add((Component)jScrollPane, "Center");
        this.tbWorkAreas.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                boolean bl = ODExtractionWizard.this.tbWorkAreas.getSelectedRow() > -1;
                ODExtractionWizard.this.bnNext.setEnabled(bl);
            }
        });
        return jPanel;
    }

    public JPanel initThirdTab() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.lsAppSys = new ArrayList<ODObject>();
        this.tbAppSys = new JTable(new AppSysModel());
        this.tbAppSys.setAutoCreateRowSorter(true);
        WindowsTableHeader.setSortedHeader(this.tbAppSys);
        TableColumn tableColumn = this.tbAppSys.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(5);
        tableColumn = this.tbAppSys.getColumnModel().getColumn(1);
        tableColumn.setPreferredWidth(100);
        tableColumn = this.tbAppSys.getColumnModel().getColumn(2);
        tableColumn.setPreferredWidth(100);
        tableColumn = this.tbAppSys.getColumnModel().getColumn(3);
        tableColumn.setPreferredWidth(100);
        tableColumn.setCellEditor(new BranchCB());
        JScrollPane jScrollPane = new JScrollPane(this.tbAppSys);
        jPanel.add((Component)jScrollPane, "Center");
        this.tbAppSys.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                ODExtractionWizard.this.bnNext.setEnabled(ODExtractionWizard.this.hasAppSystemSelected());
            }
        });
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        JButton jButton = this.createSelectAllButton();
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ODExtractionWizard.this.checkAll(ODExtractionWizard.this.tbAppSys, ODExtractionWizard.this.lsAppSys, true);
                ODExtractionWizard.this.bnNext.setEnabled(ODExtractionWizard.this.hasAppSystemSelected());
            }
        });
        JButton jButton2 = this.createDeselectAllButton();
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ODExtractionWizard.this.checkAll(ODExtractionWizard.this.tbAppSys, ODExtractionWizard.this.lsAppSys, false);
                ODExtractionWizard.this.bnNext.setEnabled(false);
            }
        });
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        jPanel.add((Component)jPanel2, "South");
        return jPanel;
    }

    private void checkAll(JTable jTable, List<ODObject> list, boolean bl) {
        ListSelectionModel listSelectionModel = jTable.getSelectionModel();
        if (listSelectionModel.isSelectionEmpty()) {
            for (ODObject oDObject : list) {
                oDObject.setSelected(bl);
            }
        } else {
            for (int i = 0; i < list.size(); ++i) {
                if (!listSelectionModel.isSelectedIndex(i)) continue;
                list.get(i).setSelected(bl);
            }
        }
        jTable.updateUI();
    }

    public JPanel initFourthTab() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.getTabbedPane(), "Center");
        this.addTabs();
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        JButton jButton = this.createSelectAllButton();
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ODExtractionWizard.this.checkAll(ODExtractionWizard.this.getCurrentTable(), ODExtractionWizard.this.getCurrentList(), true);
            }
        });
        JButton jButton2 = this.createDeselectAllButton();
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ODExtractionWizard.this.checkAll(ODExtractionWizard.this.getCurrentTable(), ODExtractionWizard.this.getCurrentList(), false);
            }
        });
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        jPanel.add((Component)jPanel2, "South");
        return jPanel;
    }

    protected JTable createTabContents(List list) {
        JTable jTable = new JTable(new ObjectModel(list));
        jTable.setAutoCreateRowSorter(true);
        WindowsTableHeader.setSortedHeader(jTable);
        TableColumn tableColumn = jTable.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(5);
        tableColumn = jTable.getColumnModel().getColumn(1);
        tableColumn.setPreferredWidth(150);
        tableColumn = jTable.getColumnModel().getColumn(2);
        tableColumn.setPreferredWidth(150);
        return jTable;
    }

    protected JTable addTab(List list, String string) {
        JTable jTable = this.createTabContents(list);
        this.getTabbedPane().addTab(string, new JScrollPane(jTable));
        return jTable;
    }

    /*
     * Exception decompiling
     */
    protected boolean getWorkAreas(boolean var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean getAppSys(boolean bl) {
        if (bl) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                this.resetWorkAreas();
                this.lsAppSys.clear();
                try {
                    List list = this.getController().getApplicationSystems(this.connection, this.lsWorkAreas);
                    if (list.size() > 0) {
                        this.lsAppSys.addAll(list);
                        this.createPrefixes();
                    }
                    this.tbAppSys.updateUI();
                    boolean bl2 = true;
                    return bl2;
                }
                catch (Exception exception) {
                    MessageDialogs.showErrorMessage(this, exception.getMessage());
                    LOGGER.error(exception);
                    this.tbAppSys.updateUI();
                    boolean bl3 = false;
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    return bl3;
                }
            }
            finally {
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
        return true;
    }

    private void resetWorkAreas() {
        if (this.tbWorkAreas.getSelectedRow() > -1) {
            ODObject oDObject = (ODObject)this.lsWorkAreas.get(this.tbWorkAreas.convertRowIndexToModel(this.tbWorkAreas.getSelectedRow()));
            for (ODObject oDObject2 : this.lsWorkAreas) {
                if (oDObject2 != oDObject) {
                    oDObject2.setSelected(false);
                    continue;
                }
                oDObject2.setSelected(true);
            }
        }
    }

    private void createPrefixes() {
        for (ODObject oDObject : this.lsAppSys) {
            if (oDObject.parentAPP != null) continue;
            this.createPrefixes(oDObject, 1);
        }
    }

    private void createPrefixes(ODObject oDObject, int n) {
        for (ODObject oDObject2 : this.lsAppSys) {
            if (oDObject2.parentAPP == null || !oDObject2.parentAPP.equals(oDObject.getIrid())) continue;
            oDObject2.prefix = this.makePrefix(n);
            this.createPrefixes(oDObject2, n + 1);
        }
    }

    private String makePrefix(int n) {
        String string = "";
        for (int i = 0; i < n; ++i) {
            string = string + "  ";
        }
        return string;
    }

    private boolean hasAppSystemSelected() {
        for (ODObject oDObject : this.lsAppSys) {
            if (!oDObject.isSelected()) continue;
            return true;
        }
        return false;
    }

    protected List getCurrentList() {
        int n = this.getTabbedPane().getSelectedIndex();
        switch (n) {
            case 0: {
                return this.lsEntities;
            }
            case 1: {
                return this.lsTables;
            }
            case 2: {
                return this.lsViews;
            }
            case 3: {
                return this.lsClusters;
            }
            case 4: {
                return this.lsSequence;
            }
            case 5: {
                return this.lsSnapshots;
            }
            case 6: {
                return this.lsCollectionTypes;
            }
            case 7: {
                return this.lsStructuredTypes;
            }
            case 8: {
                return this.lsDomains;
            }
        }
        return this.lsEntities;
    }

    protected JTable getCurrentTable() {
        int n = this.getTabbedPane().getSelectedIndex();
        switch (n) {
            case 0: {
                return this.tbEntities;
            }
            case 1: {
                return this.tbTables;
            }
            case 2: {
                return this.tbViews;
            }
            case 3: {
                return this.tbClusters;
            }
            case 4: {
                return this.tbSequence;
            }
            case 5: {
                return this.tbSnapshots;
            }
            case 6: {
                return this.tbCollectionTypes;
            }
            case 7: {
                return this.tbStructuredTypes;
            }
            case 8: {
                return this.tbDomains;
            }
        }
        return this.tbEntities;
    }

    protected void addTabs() {
        if (this.tbEntities == null) {
            this.tbEntities = this.addTab(this.lsEntities, Messages.getString("ODExtractionWizard.Entities"));
            this.tbTables = this.addTab(this.lsTables, Messages.getString("ODExtractionWizard.Tables"));
            this.tbViews = this.addTab(this.lsViews, Messages.getString("ODExtractionWizard.Views"));
            this.tbClusters = this.addTab(this.lsClusters, Messages.getString("ODExtractionWizard.Clusters"));
            this.tbSequence = this.addTab(this.lsSequence, Messages.getString("ODExtractionWizard.Sequences"));
            this.tbSnapshots = this.addTab(this.lsSnapshots, Messages.getString("ODExtractionWizard.Snapshots"));
            this.tbCollectionTypes = this.addTab(this.lsCollectionTypes, Messages.getString("ODExtractionWizard.CollectionTypes"));
            this.tbStructuredTypes = this.addTab(this.lsStructuredTypes, Messages.getString("ODExtractionWizard.StructuredTypes"));
            this.tbDomains = this.addDomainsTab();
        }
    }

    private JTable addDomainsTab() {
        this.tbDomains = this.createTabContents(this.lsDomains);
        this.tbDomains.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                if ("Name exist".equals(((ODObject)ODExtractionWizard.this.lsDomains.get(n)).getStatus())) {
                    component.setForeground(Color.RED);
                } else {
                    component.setForeground(Color.BLACK);
                }
                return component;
            }
        });
        this.pnWarning = new JPanel(new BorderLayout());
        TitledBorder titledBorder = BorderFactory.createTitledBorder("");
        this.pnWarning.setBorder(BorderFactory.createTitledBorder(titledBorder, Messages.getString("ODExtractionWizard.Warning"), 1, 2, null, Color.RED));
        JLabel jLabel = new JLabel();
        jLabel.setText(Messages.getString("ODExtractionWizard.ExistingTypeOverridden"));
        jLabel.setForeground(Color.RED);
        this.pnWarning.add((Component)jLabel, "North");
        this.pnWarning.setVisible(false);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new JScrollPane(this.tbDomains), "Center");
        jPanel.add((Component)this.pnWarning, "South");
        this.getTabbedPane().addTab(Messages.getString("ODExtractionWizard.Domains"), jPanel);
        return this.tbDomains;
    }

    protected JTable addSimpleTab(JTable jTable, List list, String string) {
        jTable = new JTable(new SimpleModel(list));
        jTable.setSelectionMode(0);
        TableColumn tableColumn = jTable.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(50);
        tableColumn = jTable.getColumnModel().getColumn(1);
        tableColumn.setPreferredWidth(300);
        JScrollPane jScrollPane = new JScrollPane(jTable);
        this.getTabbedPane().addTab(string, jScrollPane);
        return jTable;
    }

    protected void updateTables() {
        this.tbEntities.updateUI();
        this.tbTables.updateUI();
        this.tbViews.updateUI();
        this.tbClusters.updateUI();
        this.tbSequence.updateUI();
        this.tbSnapshots.updateUI();
        this.tbCollectionTypes.updateUI();
        this.tbStructuredTypes.updateUI();
        this.tbDomains.updateUI();
    }

    protected void clearAll() {
        this.lsDomains.clear();
        this.lsEntities.clear();
        this.lsTables.clear();
        this.lsViews.clear();
        this.lsTableSpaces.clear();
        this.lsTempTableSpaces.clear();
        this.lsUndoTableSpaces.clear();
        this.lsUsers.clear();
        this.lsRoles.clear();
        this.lsDirectories.clear();
        this.lsExternalTables.clear();
        this.lsContexts.clear();
        this.lsClusters.clear();
        this.lsSequence.clear();
        this.lsSnapshots.clear();
        this.lsDimensions.clear();
        this.lsCollectionTypes.clear();
        this.lsStructuredTypes.clear();
    }

    private void addAditionalTabs() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean getODObjects(boolean bl) {
        if (bl) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                this.clearAll();
                this.addAditionalTabs();
                try {
                    List list = this.getController().getODObjects(this.connection, this.lsAppSys);
                    if (list.size() > 0) {
                        this.initSpecificObjects(list);
                    }
                    this.updateTables();
                    boolean bl2 = true;
                    return bl2;
                }
                catch (Exception exception) {
                    MessageDialogs.showErrorMessage(this, exception.getMessage());
                    LOGGER.error(exception);
                    this.updateTables();
                    boolean bl3 = false;
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    return bl3;
                }
            }
            finally {
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
        return true;
    }

    protected void initSpecificObjects(List list) {
        this.clearAll();
        for (ODObject oDObject : list) {
            String string = oDObject.getType();
            if (string.equalsIgnoreCase("DOMAIN")) {
                this.lsDomains.add(oDObject);
                continue;
            }
            if (string.equalsIgnoreCase("ENTITY")) {
                this.lsEntities.add(oDObject);
                continue;
            }
            if (string.equalsIgnoreCase(TABLE)) {
                this.lsTables.add(oDObject);
                continue;
            }
            if (string.equalsIgnoreCase(VIEW)) {
                this.lsViews.add(oDObject);
                continue;
            }
            if (string.equalsIgnoreCase("CLUSTER")) {
                this.lsClusters.add(oDObject);
                continue;
            }
            if (string.equalsIgnoreCase(SEQUENCE)) {
                this.lsSequence.add(oDObject);
                continue;
            }
            if (string.equalsIgnoreCase("SNAPSHOT")) {
                this.lsSnapshots.add(oDObject);
                continue;
            }
            if (string.equalsIgnoreCase("COLLECTION TYPE")) {
                this.lsCollectionTypes.add(oDObject);
                continue;
            }
            if (!string.equalsIgnoreCase("STRUCTURED TYPE")) continue;
            this.lsStructuredTypes.add(oDObject);
        }
        this.pnWarning.setVisible(!this.lsDomains.isEmpty() && "Name exist".equals(((ODObject)this.lsDomains.get(0)).getStatus()));
    }

    public List getSelectedObjects() {
        ArrayList<ODObject> arrayList = new ArrayList<ODObject>();
        for (ODObject oDObject : this.lsDomains) {
            if (!oDObject.isSelected()) continue;
            arrayList.add(oDObject);
        }
        for (ODObject oDObject : this.lsEntities) {
            if (!oDObject.isSelected()) continue;
            arrayList.add(oDObject);
        }
        for (ODObject oDObject : this.lsTables) {
            if (!oDObject.isSelected()) continue;
            arrayList.add(oDObject);
        }
        for (ODObject oDObject : this.lsViews) {
            if (!oDObject.isSelected()) continue;
            arrayList.add(oDObject);
        }
        for (ODObject oDObject : this.lsTableSpaces) {
            if (!oDObject.isSelected()) continue;
            arrayList.add(oDObject);
        }
        for (ODObject oDObject : this.lsTempTableSpaces) {
            if (!oDObject.isSelected()) continue;
            arrayList.add(oDObject);
        }
        if (this.tbUndoTableSpaces != null) {
            for (ODObject oDObject : this.lsUndoTableSpaces) {
                if (!oDObject.isSelected()) continue;
                arrayList.add(oDObject);
            }
        }
        for (ODObject oDObject : this.lsUsers) {
            if (!oDObject.isSelected()) continue;
            arrayList.add(oDObject);
        }
        for (ODObject oDObject : this.lsRoles) {
            if (!oDObject.isSelected()) continue;
            arrayList.add(oDObject);
        }
        for (ODObject oDObject : this.lsDirectories) {
            if (!oDObject.isSelected()) continue;
            arrayList.add(oDObject);
        }
        for (ODObject oDObject : this.lsExternalTables) {
            if (!oDObject.isSelected()) continue;
            arrayList.add(oDObject);
        }
        for (ODObject oDObject : this.lsContexts) {
            if (!oDObject.isSelected()) continue;
            arrayList.add(oDObject);
        }
        for (ODObject oDObject : this.lsClusters) {
            if (!oDObject.isSelected()) continue;
            arrayList.add(oDObject);
        }
        for (ODObject oDObject : this.lsSequence) {
            if (!oDObject.isSelected()) continue;
            arrayList.add(oDObject);
        }
        for (ODObject oDObject : this.lsSnapshots) {
            if (!oDObject.isSelected()) continue;
            arrayList.add(oDObject);
        }
        for (ODObject oDObject : this.lsDimensions) {
            if (!oDObject.isSelected()) continue;
            arrayList.add(oDObject);
        }
        for (ODObject oDObject : this.lsCollectionTypes) {
            if (!oDObject.isSelected()) continue;
            arrayList.add(oDObject);
        }
        for (ODObject oDObject : this.lsStructuredTypes) {
            if (!oDObject.isSelected()) continue;
            arrayList.add(oDObject);
        }
        return arrayList;
    }

    private JButton createSelectAllButton() {
        JButton jButton = new JButton(GUIConfiguration.getInstance().getIcon("SELECT_ALL"));
        jButton.setMnemonic(83);
        jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE_SMALL);
        jButton.setToolTipText(Messages.getString("ODExtractionWizard.SelectAll"));
        return jButton;
    }

    private JButton createDeselectAllButton() {
        JButton jButton = new JButton(GUIConfiguration.getInstance().getIcon("DESELECT_ALL"));
        jButton.setMnemonic(68);
        jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE_SMALL);
        jButton.setToolTipText(Messages.getString("ODExtractionWizard.DeselectAll"));
        return jButton;
    }

    class BranchCB
    extends DefaultCellEditor {
        JComboBox cbox;

        BranchCB() {
            super(new JComboBox());
            this.cbox = (JComboBox)this.getComponent();
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            ODObject oDObject = ODExtractionWizard.this.lsAppSys.get(n);
            this.cbox.setModel(new DefaultComboBoxModel<Object>(oDObject.branches.toArray()));
            this.cbox.setSelectedItem(oDObject.branch);
            return this.cbox;
        }
    }

    class SimpleModel
    extends AbstractTableModel {
        List list;

        public SimpleModel(List list) {
            this.list = list;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return this.list.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("ODExtractionWizard.Selected");
            }
            if (n == 1) {
                return Messages.getString("ODExtractionWizard.Name");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            ODObject oDObject = (ODObject)this.list.get(n);
            switch (n2) {
                case 0: {
                    return oDObject.isSelected();
                }
                case 1: {
                    return oDObject.getName();
                }
            }
            return new Integer(n * n2);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 0) {
                ODObject oDObject = (ODObject)this.list.get(n);
                oDObject.setSelected((Boolean)object);
            }
        }
    }

    class ObjectModel
    extends AbstractTableModel {
        List list;

        public ObjectModel(List list) {
            this.list = list;
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return this.list.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("ODExtractionWizard.Selected");
            }
            if (n == 1) {
                return Messages.getString("ODExtractionWizard.ApplicationSystem");
            }
            if (n == 2) {
                return Messages.getString("ODExtractionWizard.ObjectName");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            ODObject oDObject = (ODObject)this.list.get(n);
            switch (n2) {
                case 0: {
                    return oDObject.isSelected();
                }
                case 1: {
                    return oDObject.getParentName();
                }
                case 2: {
                    return oDObject.getName();
                }
            }
            return new Integer(n * n2);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 0) {
                ODObject oDObject = (ODObject)this.list.get(n);
                oDObject.setSelected((Boolean)object);
            }
        }
    }

    class AppSysModel
    extends AbstractTableModel {
        AppSysModel() {
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public int getRowCount() {
            return ODExtractionWizard.this.lsAppSys.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("ODExtractionWizard.Selected");
            }
            if (n == 1) {
                return Messages.getString("ODExtractionWizard.WorkArea");
            }
            if (n == 2) {
                return Messages.getString("ODExtractionWizard.ApplicationSystem");
            }
            if (n == 3) {
                return Messages.getString("ODExtractionWizard.Branch");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            if (n2 == 3) {
                ODObject oDObject = ODExtractionWizard.this.lsAppSys.get(n);
                return oDObject.branches.size() > 1;
            }
            return n2 == 0;
        }

        public Class getColumnClass(int n) {
            if (n == 3) {
                return ODExtractionHandler.Branch.class;
            }
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            ODObject oDObject = ODExtractionWizard.this.lsAppSys.get(n);
            switch (n2) {
                case 0: {
                    return oDObject.isSelected();
                }
                case 1: {
                    return oDObject.getParentName();
                }
                case 2: {
                    if (oDObject.sourceBranch != null && !"MAIN".equalsIgnoreCase(oDObject.sourceBranch.getName())) {
                        return oDObject.prefix + oDObject.getName() + " (" + oDObject.sourceBranch.getName() + ")";
                    }
                    return oDObject.prefix + oDObject.getName();
                }
                case 3: {
                    return oDObject.branch;
                }
            }
            return new Integer(n * n2);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 0) {
                ODObject oDObject = ODExtractionWizard.this.lsAppSys.get(n);
                oDObject.setSelected((Boolean)object);
                this.setChildren(oDObject, (Boolean)object);
                this.fireTableDataChanged();
            } else if (n2 == 3) {
                ODObject oDObject = ODExtractionWizard.this.lsAppSys.get(n);
                oDObject.branch = (ODExtractionHandler.Branch)object;
            }
        }

        private void setChildren(ODObject oDObject, boolean bl) {
            for (ODObject oDObject2 : ODExtractionWizard.this.lsAppSys) {
                if (oDObject2.parentAPP == null || !oDObject2.parentAPP.equals(oDObject.getIrid())) continue;
                oDObject2.setSelected(bl);
                this.setChildren(oDObject2, bl);
            }
        }
    }

    class WorkAreaModel
    extends AbstractTableModel {
        WorkAreaModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return ODExtractionWizard.this.lsWorkAreas.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("ODExtractionWizard.WorkArea");
            }
            if (n == 1) {
                return Messages.getString("ODExtractionWizard.Description");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            if (this.getValueAt(0, n) != null) {
                return this.getValueAt(0, n).getClass();
            }
            return String.class;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            ODObject oDObject = (ODObject)ODExtractionWizard.this.lsWorkAreas.get(n);
            switch (n2) {
                case 0: {
                    return oDObject.getName();
                }
                case 1: {
                    return oDObject.getDescription();
                }
            }
            return new Integer(n * n2);
        }
    }

    private class TestAction
    implements ActionListener {
        private TestAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FCPConnectionDialog.testConnection(ODExtractionWizard.this.getSelectedConnectionProperties());
        }
    }

    private class PropertiesAction
    implements ActionListener {
        private PropertiesAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ODExtractionWizard.this.showConnectionProperties();
        }
    }

    private class ImportAction
    implements ActionListener {
        private ImportAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FCPConnectionDialog.importConnections();
            ODExtractionWizard.this.updateConnections();
        }
    }

    private class RemoveAction
    implements ActionListener {
        private RemoveAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Properties properties = ODExtractionWizard.this.getSelectedConnectionProperties();
            if (properties != null) {
                try {
                    String string = ConnectionInfo.getConnectionName(properties);
                    int n = JOptionPane.showConfirmDialog(ODExtractionWizard.this, MessageFormat.format(Messages.getString("ODExtractionWizard.AreYouSure"), string), Messages.getString("ODExtractionWizard.SelectOption"), 0);
                    if (n == 0) {
                        DatabaseConnections.getInstance().removeConnection(string);
                        ODExtractionWizard.this.updateConnections();
                        ODExtractionWizard.this.tbConnections.clearSelection();
                        ODExtractionWizard.this.bnNext.setEnabled(false);
                        ODExtractionWizard.this.bnRemove.setEnabled(false);
                        ODExtractionWizard.this.bnProperties.setEnabled(false);
                        ODExtractionWizard.this.bnTestConnection.setEnabled(false);
                    }
                }
                catch (ConnectionException connectionException) {
                    LOGGER.error("Unable to delete connection", connectionException);
                    MessageDialogs.showMessage(ApplicationView.frame, "Unable to delete connection");
                }
            }
        }
    }

    private class AddAction
    implements ActionListener {
        private AddAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                FCPConnectionDialog.showConnectionDialog(true);
                ODExtractionWizard.this.updateConnections();
            }
            catch (Exception exception) {
                LOGGER.error(exception);
            }
        }
    }
}

