/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.wizards.metadata.oracle;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxySetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableViewProxySetOracle;
import oracle.dbtools.crest.swingui.WindowsTableHeader;
import oracle.dbtools.crest.swingui.wizards.Messages;
import oracle.dbtools.crest.swingui.wizards.metadata.AbstractDBMExtractionWizardImpl;
import oracle.dbtools.crest.swingui.wizards.metadata.DBMExtractionWizard;

public class DBMExtractionWizardOracle
extends AbstractDBMExtractionWizardImpl {
    private static DBMExtractionWizardOracle impl;
    protected JTable tbTableSpaces;
    protected JTable tbTempTableSpaces;
    protected JTable tbUndoTableSpaces;
    protected JTable tbUsers;
    protected JTable tbRoles;
    protected JTable tbDirectories;
    protected JTable tbExternalTables;
    protected JTable tbContexts;
    protected JTable tbClusters;
    protected JTable tbSequence;
    protected JTable tbSynonyms;
    protected JTable tbDimensions;
    protected JTable tbTypes;
    protected JTable tbPackages;
    protected JTable tbProcedures;
    protected JTable tbFunctions;
    protected List lsTableSpaces = new ArrayList();
    protected List lsTempTableSpaces = new ArrayList();
    protected List lsUndoTableSpaces = new ArrayList();
    protected List lsUsers = new ArrayList();
    protected List lsRoles = new ArrayList();
    protected List lsDirectories = new ArrayList();
    protected List lsExternalTables = new ArrayList();
    protected List lsContexts = new ArrayList();
    protected List lsClusters = new ArrayList();
    protected List lsSequence = new ArrayList();
    protected List lsSynonyms = new ArrayList();
    protected List lsDimensions = new ArrayList();
    protected List lsTypes = new ArrayList();
    protected List lsPackages = new ArrayList();
    protected List lsProcedures = new ArrayList();
    protected List lsFunctions = new ArrayList();
    private JPanel warning;

    public DBMExtractionWizardOracle(DBMExtractionWizard dBMExtractionWizard) {
        super(dBMExtractionWizard);
    }

    public static AbstractDBMExtractionWizardImpl getInstance(DBMExtractionWizard dBMExtractionWizard) {
        if (impl == null) {
            impl = new DBMExtractionWizardOracle(dBMExtractionWizard);
        }
        return impl;
    }

    public static void clearInstance() {
        impl = null;
    }

    @Override
    protected List getCurrentList() {
        int n = this.getTabbedPane().getSelectedIndex();
        switch (n) {
            case 0: {
                return this.lsTables;
            }
            case 1: {
                return this.lsViews;
            }
            case 2: {
                return this.lsUsers;
            }
            case 3: {
                return this.lsRoles;
            }
            case 4: {
                return this.lsDirectories;
            }
            case 5: {
                return this.lsExternalTables;
            }
            case 6: {
                return this.lsContexts;
            }
            case 7: {
                return this.lsClusters;
            }
            case 8: {
                return this.lsSequence;
            }
            case 9: {
                return this.lsSynonyms;
            }
            case 10: {
                return this.lsTableSpaces;
            }
            case 11: {
                return this.lsTempTableSpaces;
            }
            case 12: {
                return this.lsDimensions;
            }
            case 13: {
                return this.lsTypes;
            }
            case 14: {
                return this.lsPackages;
            }
            case 15: {
                return this.lsProcedures;
            }
            case 16: {
                return this.lsFunctions;
            }
            case 17: {
                return this.lsUndoTableSpaces;
            }
        }
        return this.lsTables;
    }

    @Override
    protected void addTabs() {
        if (this.tbTables == null) {
            this.tbTables = this.addTab(this.tbTables, this.lsTables, Messages.getString("DBMExtractionWizardOracle.Tables"));
            this.tbViews = this.addTab(this.tbViews, this.lsViews, Messages.getString("DBMExtractionWizardOracle.Views"));
            this.tbUsers = this.addSimpleTab(this.tbUsers, this.lsUsers, Messages.getString("DBMExtractionWizardOracle.Users"));
            this.tbRoles = this.addSimpleTab(this.tbRoles, this.lsRoles, Messages.getString("DBMExtractionWizardOracle.Roles"));
            this.tbDirectories = this.addSimpleTab(this.tbDirectories, this.lsDirectories, Messages.getString("DBMExtractionWizardOracle.Directories"));
            this.tbExternalTables = this.addSimpleTab(this.tbExternalTables, this.lsExternalTables, Messages.getString("DBMExtractionWizardOracle.ExternalTables"));
            this.tbContexts = this.addSimpleTab(this.tbContexts, this.lsContexts, Messages.getString("DBMExtractionWizardOracle.Contexts"));
            this.tbClusters = this.addTab(this.tbClusters, this.lsClusters, Messages.getString("DBMExtractionWizardOracle.Clusters"));
            this.tbSequence = this.addTab(this.tbSequence, this.lsSequence, Messages.getString("DBMExtractionWizardOracle.Sequences"));
            this.tbSynonyms = this.addTab(this.tbSynonyms, this.lsSynonyms, Messages.getString("DBMExtractionWizardOracle.Synonyms"));
            this.tbTableSpaces = this.addSimpleTab(this.tbTableSpaces, this.lsTableSpaces, Messages.getString("DBMExtractionWizardOracle.TableSpaces"));
            this.tbTempTableSpaces = this.addSimpleTab(this.tbTempTableSpaces, this.lsTempTableSpaces, Messages.getString("DBMExtractionWizardOracle.TempTableSpaces"));
            this.tbDimensions = this.addTab(this.tbDimensions, this.lsDimensions, Messages.getString("DBMExtractionWizardOracle.Dimensions"));
            this.tbTypes = this.addTypesTab(this.tbTypes, Messages.getString("DBMExtractionWizardOracle.Types"), new TypeModel(this.lsTypes));
            this.tbTypes.setDefaultRenderer(Object.class, new TypeCellRender());
            this.tbPackages = this.addTab(this.tbPackages, this.lsPackages, Messages.getString("DBMExtractionWizardOracle.Packages"));
            this.tbProcedures = this.addTab(this.tbProcedures, this.lsProcedures, Messages.getString("DBMExtractionWizardOracle.StoredProcedures"));
            this.tbFunctions = this.addTab(this.tbFunctions, this.lsFunctions, Messages.getString("DBMExtractionWizardOracle.Functions"));
        }
    }

    protected JTable addTypesTab(JTable jTable, String string, AbstractTableModel abstractTableModel) {
        jTable = new JTable(abstractTableModel);
        jTable.setAutoCreateRowSorter(true);
        WindowsTableHeader.setSortedHeader(jTable);
        TableColumn tableColumn = jTable.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(50);
        tableColumn = jTable.getColumnModel().getColumn(1);
        tableColumn.setPreferredWidth(60);
        tableColumn = jTable.getColumnModel().getColumn(2);
        tableColumn.setPreferredWidth(60);
        JPanel jPanel = new JPanel(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(jTable);
        jPanel.add((Component)jScrollPane, "Center");
        this.warning = new JPanel(new BorderLayout());
        TitledBorder titledBorder = BorderFactory.createTitledBorder("");
        this.warning.setBorder(BorderFactory.createTitledBorder(titledBorder, Messages.getString("DBMExtractionWizardOracle.Warning"), 1, 2, null, Color.RED));
        JLabel jLabel = new JLabel();
        jLabel.setText(Messages.getString("DBMExtractionWizardOracle.ExistingTypeOverridden"));
        jLabel.setForeground(Color.RED);
        this.warning.add((Component)jLabel, "North");
        this.warning.setVisible(false);
        jPanel.add((Component)this.warning, "South");
        this.getTabbedPane().addTab(string, jPanel);
        return jTable;
    }

    protected JTable addSimpleTab(JTable jTable, List list, String string) {
        jTable = new JTable(new SimpleModel(list));
        jTable.setAutoCreateRowSorter(true);
        WindowsTableHeader.setSortedHeader(jTable);
        TableColumn tableColumn = jTable.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(50);
        tableColumn = jTable.getColumnModel().getColumn(1);
        tableColumn.setPreferredWidth(300);
        JScrollPane jScrollPane = new JScrollPane(jTable);
        this.getTabbedPane().addTab(string, jScrollPane);
        return jTable;
    }

    @Override
    protected void updateTables() {
        this.tbTables.updateUI();
        this.tbViews.updateUI();
        this.tbTableSpaces.updateUI();
        this.tbUsers.updateUI();
        this.tbRoles.updateUI();
        this.tbDirectories.updateUI();
        this.tbExternalTables.updateUI();
        this.tbContexts.updateUI();
        this.tbTempTableSpaces.updateUI();
        this.tbContexts.updateUI();
        this.tbClusters.updateUI();
        this.tbSequence.updateUI();
        this.tbSynonyms.updateUI();
        this.tbDimensions.updateUI();
        this.tbTypes.updateUI();
        this.tbPackages.updateUI();
        this.tbProcedures.updateUI();
        this.tbFunctions.updateUI();
        if (this.tbUndoTableSpaces != null) {
            this.tbUndoTableSpaces.updateUI();
        }
    }

    @Override
    protected void clearAll() {
        this.lsTables.clear();
        this.lsViews.clear();
        this.lsTableSpaces.clear();
        this.lsTempTableSpaces.clear();
        this.lsUndoTableSpaces.clear();
        this.lsUsers.clear();
        this.lsRoles.clear();
        this.lsDirectories.clear();
        this.lsExternalTables.clear();
        this.lsContexts.clear();
        this.lsClusters.clear();
        this.lsSequence.clear();
        this.lsSynonyms.clear();
        this.lsDimensions.clear();
        this.lsTypes.clear();
        this.lsPackages.clear();
        this.lsProcedures.clear();
        this.lsFunctions.clear();
    }

    @Override
    protected JTabbedPane getTabbedPane() {
        if (this.tpane == null) {
            this.tpane = new JTabbedPane(3);
        }
        return this.tpane;
    }

    private void addAditionalTabs() {
        String string = Messages.getString("DBMExtractionWizardOracle.UndoTableSpaces");
        if (this.wizard.getController().getDBMExtractionHandler(this.wizard.getSelectedConnectionType()).getDBMajorVersion() > 8) {
            if (this.tbUndoTableSpaces == null) {
                this.tbUndoTableSpaces = this.addSimpleTab(this.tbUndoTableSpaces, this.lsUndoTableSpaces, string);
            }
        } else {
            if (this.tbUndoTableSpaces != null) {
                this.getTabbedPane().remove(this.getTabbedPane().indexOfTab(string));
            }
            this.tbUndoTableSpaces = null;
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    protected boolean getDBObjects(boolean var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    protected void initSpecificObjects(List list) {
        this.clearAll();
        for (DBObject dBObject : list) {
            String string = dBObject.getType();
            if (string.equalsIgnoreCase("TABLE")) {
                this.lsTables.add(dBObject);
                continue;
            }
            if (string.equalsIgnoreCase("VIEW")) {
                this.lsViews.add(dBObject);
                continue;
            }
            if (string.equalsIgnoreCase("TABLESPACE")) {
                this.lsTableSpaces.add(dBObject);
                continue;
            }
            if (string.equalsIgnoreCase("TEMP TABLESPACE")) {
                this.lsTempTableSpaces.add(dBObject);
                continue;
            }
            if (string.equalsIgnoreCase("UNDO TABLESPACE")) {
                this.lsUndoTableSpaces.add(dBObject);
                continue;
            }
            if (string.equalsIgnoreCase("USER")) {
                this.lsUsers.add(dBObject);
                continue;
            }
            if (string.equalsIgnoreCase("ROLE")) {
                this.lsRoles.add(dBObject);
                continue;
            }
            if (string.equalsIgnoreCase("CONTEXT")) {
                this.lsContexts.add(dBObject);
                continue;
            }
            if (string.equalsIgnoreCase("DIRECTORY")) {
                this.lsDirectories.add(dBObject);
                continue;
            }
            if (string.equalsIgnoreCase("EXTERNAL TABLE")) {
                this.lsExternalTables.add(dBObject);
                continue;
            }
            if (string.equalsIgnoreCase("CLUSTER")) {
                this.lsClusters.add(dBObject);
                continue;
            }
            if (string.equalsIgnoreCase("SEQUENCE")) {
                this.lsSequence.add(dBObject);
                continue;
            }
            if (string.equalsIgnoreCase("SYNONYM")) {
                this.lsSynonyms.add(dBObject);
                continue;
            }
            if (string.equalsIgnoreCase("DIMENSION")) {
                this.lsDimensions.add(dBObject);
                continue;
            }
            if (string.equalsIgnoreCase("PACKAGE")) {
                this.lsPackages.add(dBObject);
                continue;
            }
            if (string.equalsIgnoreCase("PROCEDURE")) {
                this.lsProcedures.add(dBObject);
                continue;
            }
            if (string.equalsIgnoreCase("FUNCTION")) {
                this.lsFunctions.add(dBObject);
                continue;
            }
            if (!string.equalsIgnoreCase("OBJECT") && !string.equalsIgnoreCase("COLLECTION")) continue;
            this.lsTypes.add(dBObject);
        }
        Collections.sort(this.lsTypes, new TypeComparator());
        this.setTypeWarning();
    }

    @Override
    public List getSelectedObjects() {
        ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
        for (DBObject dBObject : this.lsTables) {
            if (!dBObject.isSelected()) continue;
            arrayList.add(dBObject);
        }
        for (DBObject dBObject : this.lsViews) {
            if (!dBObject.isSelected()) continue;
            arrayList.add(dBObject);
        }
        for (DBObject dBObject : this.lsTableSpaces) {
            if (!dBObject.isSelected()) continue;
            arrayList.add(dBObject);
        }
        for (DBObject dBObject : this.lsTempTableSpaces) {
            if (!dBObject.isSelected()) continue;
            arrayList.add(dBObject);
        }
        if (this.tbUndoTableSpaces != null) {
            for (DBObject dBObject : this.lsUndoTableSpaces) {
                if (!dBObject.isSelected()) continue;
                arrayList.add(dBObject);
            }
        }
        for (DBObject dBObject : this.lsRoles) {
            if (!dBObject.isSelected()) continue;
            arrayList.add(dBObject);
        }
        for (DBObject dBObject : this.lsUsers) {
            if (!dBObject.isSelected()) continue;
            arrayList.add(dBObject);
        }
        for (DBObject dBObject : this.lsDirectories) {
            if (!dBObject.isSelected()) continue;
            arrayList.add(dBObject);
        }
        for (DBObject dBObject : this.lsExternalTables) {
            if (!dBObject.isSelected()) continue;
            arrayList.add(dBObject);
        }
        for (DBObject dBObject : this.lsContexts) {
            if (!dBObject.isSelected()) continue;
            arrayList.add(dBObject);
        }
        for (DBObject dBObject : this.lsClusters) {
            if (!dBObject.isSelected()) continue;
            arrayList.add(dBObject);
        }
        for (DBObject dBObject : this.lsSequence) {
            if (!dBObject.isSelected()) continue;
            arrayList.add(dBObject);
        }
        for (DBObject dBObject : this.lsSynonyms) {
            if (!dBObject.isSelected()) continue;
            arrayList.add(dBObject);
        }
        for (DBObject dBObject : this.lsDimensions) {
            if (!dBObject.isSelected()) continue;
            arrayList.add(dBObject);
        }
        for (DBObject dBObject : this.lsPackages) {
            if (!dBObject.isSelected()) continue;
            arrayList.add(dBObject);
        }
        for (DBObject dBObject : this.lsProcedures) {
            if (!dBObject.isSelected()) continue;
            arrayList.add(dBObject);
        }
        for (DBObject dBObject : this.lsFunctions) {
            if (!dBObject.isSelected()) continue;
            arrayList.add(dBObject);
        }
        for (DBObject dBObject : this.lsTypes) {
            if (!dBObject.isSelected()) continue;
            arrayList.add(dBObject);
        }
        return arrayList;
    }

    @Override
    public void setSelected(DBObject dBObject, boolean bl) {
        if (dBObject != null) {
            dBObject.setSelected(bl);
            if (!dBObject.isRequiredSet()) {
                // empty if block
            }
        }
    }

    @Override
    protected int getFilterColumn(JTable jTable) {
        int n = super.getFilterColumn(jTable);
        if (n < 0) {
            TableModel tableModel = jTable.getModel();
            if (tableModel instanceof SimpleModel) {
                return ((SimpleModel)tableModel).getFilterColumn();
            }
            if (tableModel instanceof TypeModel) {
                return ((TypeModel)tableModel).getFilterColumn();
            }
        }
        return n;
    }

    private void setTypeWarning() {
        if (!this.lsTypes.isEmpty()) {
            DBObject dBObject = (DBObject)this.lsTypes.get(0);
            if (dBObject.getStatus().equals("Type name exist")) {
                this.warning.setVisible(true);
            } else {
                this.warning.setVisible(false);
            }
        }
    }

    @Override
    public void applySelectionForExisting(StorageDesign storageDesign, List list) {
        if (!(storageDesign instanceof StorageDesignOracle)) {
            return;
        }
        StorageDesignOracle storageDesignOracle = (StorageDesignOracle)storageDesign;
        for (DBObject dBObject : list) {
            boolean bl;
            String string = dBObject.getType();
            RelationalObjectProxy relationalObjectProxy = null;
            String string2 = dBObject.getSchema();
            String string3 = dBObject.getName();
            boolean bl2 = bl = string2 != null && !"".equals(string2);
            if (bl) {
                if (string.equalsIgnoreCase("TABLE")) {
                    relationalObjectProxy = storageDesignOracle.getTableProxySet().getByUserSchemaAndName(string2, string3);
                } else if (string.equalsIgnoreCase("VIEW")) {
                    relationalObjectProxy = storageDesignOracle.getTableViewProxySet().getBySchemaAndName(string2, string3);
                } else if (string.equalsIgnoreCase("OBJECT")) {
                    relationalObjectProxy = storageDesignOracle.getStructuredTypeProxySet().getBySchemaAndName(string2, string3);
                } else if (string.equalsIgnoreCase("COLLECTION")) {
                    relationalObjectProxy = storageDesignOracle.getCollectionTypeProxySet().getByOwnerAndName(string2, string3);
                }
            } else if (string.equalsIgnoreCase("TABLE")) {
                relationalObjectProxy = ((TableProxySetOracle)storageDesignOracle.getTableProxySet()).getByName(string3);
            } else if (string.equalsIgnoreCase("VIEW")) {
                relationalObjectProxy = ((TableViewProxySetOracle)storageDesignOracle.getTableViewProxySet()).getByName(string3);
            } else if (string.equalsIgnoreCase("OBJECT")) {
                relationalObjectProxy = storageDesignOracle.getStructuredTypeProxySet().getByName(string3);
            } else if (string.equalsIgnoreCase("COLLECTION")) {
                relationalObjectProxy = storageDesignOracle.getCollectionTypeProxySet().getByName(string3);
            }
            if (relationalObjectProxy == null) continue;
            dBObject.setSelected(true);
        }
    }

    class TypeCellRender
    extends DefaultTableCellRenderer {
        TypeCellRender() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            DBObject dBObject = (DBObject)DBMExtractionWizardOracle.this.lsTypes.get(n);
            if (dBObject.getStatus().equals("Type name exist")) {
                component.setForeground(Color.RED);
            } else {
                component.setForeground(Color.BLACK);
            }
            return component;
        }
    }

    class TypeComparator
    implements Comparator {
        TypeComparator() {
        }

        public int compare(Object object, Object object2) {
            if (object instanceof DBObject && object2 instanceof DBObject) {
                DBObject dBObject = (DBObject)object;
                DBObject dBObject2 = (DBObject)object2;
                if (dBObject.getStatus().equals("Type name exist")) {
                    return -1;
                }
                if (dBObject2.getStatus().equals("Type name exist")) {
                    return 1;
                }
                return 0;
            }
            return object.toString().compareTo(object2.toString());
        }
    }

    class TypeModel
    extends AbstractTableModel {
        List list;

        public TypeModel(List list) {
            this.list = list;
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public int getRowCount() {
            return this.list.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("DBMExtractionWizardOracle.Selected");
            }
            if (n == 1) {
                return Messages.getString("DBMExtractionWizardOracle.Schema");
            }
            if (n == 2) {
                return Messages.getString("DBMExtractionWizardOracle.ObjectName");
            }
            if (n == 3) {
                return Messages.getString("DBMExtractionWizardOracle.Status");
            }
            return "";
        }

        public int getFilterColumn() {
            return 2;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        public Class getColumnClass(int n) {
            if (n == 0) {
                return Boolean.class;
            }
            return String.class;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            DBObject dBObject = (DBObject)this.list.get(n);
            switch (n2) {
                case 0: {
                    return dBObject.isSelected();
                }
                case 1: {
                    return dBObject.getSchema();
                }
                case 2: {
                    return dBObject.getName();
                }
                case 3: {
                    return dBObject.getStatus();
                }
            }
            return new Integer(n * n2);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 0) {
                DBObject dBObject = (DBObject)this.list.get(n);
                DBMExtractionWizardOracle.this.setSelected(dBObject, (Boolean)object);
            }
        }
    }

    class SimpleModel
    extends AbstractTableModel {
        List list;

        public SimpleModel(List list) {
            this.list = list;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return this.list.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("DBMExtractionWizardOracle.Selected");
            }
            if (n == 1) {
                return Messages.getString("DBMExtractionWizardOracle.Name");
            }
            return "";
        }

        public int getFilterColumn() {
            return 1;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        public Class getColumnClass(int n) {
            if (n == 0) {
                return Boolean.class;
            }
            return String.class;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n < this.list.size()) {
                DBObject dBObject = (DBObject)this.list.get(n);
                switch (n2) {
                    case 0: {
                        return dBObject.isSelected();
                    }
                    case 1: {
                        return dBObject.getName();
                    }
                }
                return null;
            }
            return null;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 0) {
                DBObject dBObject = (DBObject)this.list.get(n);
                DBMExtractionWizardOracle.this.setSelected(dBObject, (Boolean)object);
            }
        }
    }
}

