/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.wizards.metadata.odbc;

import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.swingui.wizards.Messages;
import oracle.dbtools.crest.swingui.wizards.metadata.AbstractDBMExtractionWizardImpl;
import oracle.dbtools.crest.swingui.wizards.metadata.DBMExtractionWizard;

public class DBMExtractionWizardODBC
extends AbstractDBMExtractionWizardImpl {
    private static DBMExtractionWizardODBC impl;

    public DBMExtractionWizardODBC(DBMExtractionWizard dBMExtractionWizard) {
        super(dBMExtractionWizard);
    }

    public static AbstractDBMExtractionWizardImpl getInstance(DBMExtractionWizard dBMExtractionWizard) {
        if (impl == null) {
            impl = new DBMExtractionWizardODBC(dBMExtractionWizard);
        }
        return impl;
    }

    public static void clearInstance() {
        impl = null;
    }

    @Override
    protected List getCurrentList() {
        int n = this.getTabbedPane().getSelectedIndex();
        switch (n) {
            case 0: {
                return this.lsTables;
            }
            case 1: {
                return this.lsViews;
            }
        }
        return this.lsTables;
    }

    @Override
    protected void addTabs() {
        if (this.tbTables == null) {
            this.tbTables = this.addTab(this.tbTables, this.lsTables, Messages.getString("DBMExtractionWizardODBC.Tables"));
            this.tbViews = this.addTab(this.tbViews, this.lsViews, Messages.getString("DBMExtractionWizardODBC.Views"));
        }
    }

    @Override
    protected void updateTables() {
        this.tbTables.updateUI();
        this.tbViews.updateUI();
    }

    @Override
    public List getSelectedObjects() {
        ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
        for (DBObject dBObject : this.lsTables) {
            if (!dBObject.isSelected()) continue;
            arrayList.add(dBObject);
        }
        for (DBObject dBObject : this.lsViews) {
            if (!dBObject.isSelected()) continue;
            arrayList.add(dBObject);
        }
        return arrayList;
    }

    @Override
    protected void clearAll() {
        this.lsTables.clear();
        this.lsViews.clear();
    }

    @Override
    protected void initSpecificObjects(List list) {
        this.clearAll();
        for (DBObject dBObject : list) {
            String string = dBObject.getType();
            if (string.equalsIgnoreCase("TABLE")) {
                this.lsTables.add(dBObject);
                continue;
            }
            if (!string.equalsIgnoreCase("VIEW")) continue;
            this.lsViews.add(dBObject);
        }
    }
}

