/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.wizards.metadata.connection;

import java.awt.Component;
import java.awt.Window;
import java.beans.VetoableChangeListener;
import java.net.URL;
import java.sql.Connection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.swing.JOptionPane;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.wizards.Messages;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.raptor.ConnectionArb;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.connections.ConnectionDialog;
import oracle.dbtools.raptor.connections.ImportExportPanel;
import oracle.ide.Ide;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.ide.net.URLPath;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.db.ConnectionInfo;
import oracle.jdeveloper.db.DatabaseConnectionStores;
import oracle.jdeveloper.db.DatabaseConnections;
import oracle.jdeveloper.db.adapter.DatabaseProvider;
import oracle.jdeveloper.db.migration.CMConnectionsReader;
import oracle.jdevimpl.db.adapter.CMHelper;

public class FCPConnectionDialog {
    private static final Logger LOGGER = new Logger(FCPConnectionDialog.class);

    public static ConnectionInfo showConnectionDialog() {
        return FCPConnectionDialog.showConnectionDialog(null, false);
    }

    public static ConnectionInfo showConnectionDialog(boolean bl) {
        return FCPConnectionDialog.showConnectionDialog(null, bl);
    }

    public static ConnectionInfo showConnectionDialog(String string, boolean bl) {
        if (bl) {
            DBConfig.getInstance().setThirdPartyPath(new URLPath());
        } else {
            DBConfig.getInstance().setThirdPartyPath(ApplicationView.getInstance().getSettings().getJDBCDriversPath());
        }
        ConnectionInfo connectionInfo = ConnectionDialog.launch((DatabaseConnections)DatabaseConnections.getInstance(), (String)string);
        if (connectionInfo != null) {
            try {
                Connection connection = connectionInfo.getConnection();
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {
                LOGGER.error("FCPConnectionDialog.showConnectionDialog()", exception);
            }
        }
        return connectionInfo;
    }

    public static void testConnection(final Properties properties) {
        try {
            if (properties != null) {
                ConnectRunnable connectRunnable = new ConnectRunnable(){

                    protected Object doWork() throws Exception {
                        DatabaseConnections.getInstance().testConnection(properties);
                        return null;
                    }
                };
                connectRunnable.setTitle(Messages.getString("FCPConnectionDialog.TestingConnection"));
                connectRunnable.start(true);
                if (!connectRunnable.isCanceled()) {
                    MessageDialogs.showMessage(ApplicationView.frame, Messages.getString("FCPConnectionDialog.ConnectionSuccessfull"));
                }
            }
        }
        catch (Exception exception) {
            MessageDialogs.showErrorMessage(ApplicationView.frame, exception.getMessage());
        }
    }

    public static boolean importConnections() {
        String string = ConnectionArb.getString((String)"IMPORT_TITLE");
        ImportExportPanel importExportPanel = new ImportExportPanel("IdeConnections");
        importExportPanel.setMode("IMPORT");
        Component component = importExportPanel.getDefaultFocus();
        VetoableChangeListener vetoableChangeListener = null;
        boolean bl = OnePageWizardDialogFactory.runDialog((Component)importExportPanel, (Component)component, (String)string, (int)7, vetoableChangeListener);
        if (bl) {
            Object[] objectArray = importExportPanel.getSelectedValues();
            HashSet<String> hashSet = new HashSet<String>();
            for (Object object : objectArray) {
                hashSet.add((String)object);
            }
            FCPConnectionDialog.doImport(importExportPanel.getSelectedURL(), hashSet, importExportPanel.oldCM);
        }
        return true;
    }

    private static boolean doImport(URL uRL, Set<String> set, boolean bl) {
        DatabaseConnections databaseConnections = DatabaseConnectionStores.getInstance().getStore("IdeConnections");
        if (set.size() > 0) {
            String[] stringArray = null;
            stringArray = databaseConnections == null || databaseConnections.listConnections() == null ? new String[]{} : databaseConnections.listConnections().toArray(new String[databaseConnections.listConnections().size()]);
            try {
                Object object2;
                HashMap<Object, Properties> hashMap = new HashMap<Object, Properties>();
                if (bl) {
                    object2 = new CMConnectionsReader(uRL.getFile(), true);
                    List object3 = object2.read();
                    for (Properties properties : object3) {
                        String string = properties.getProperty("ConnectionName");
                        if (!set.contains(string)) continue;
                        hashMap.put(string, FCPConnectionDialog.convertProps(properties));
                    }
                } else {
                    object2 = DatabaseConnections.getPrivateInstance((URL)uRL);
                    for (Object object : object2.listConnections()) {
                        if (!set.contains(object)) continue;
                        hashMap.put(object, object2.getProperties((String)object));
                    }
                }
                for (String string : set) {
                    Object object;
                    object = (Properties)hashMap.get(string);
                    if (object == null) continue;
                    boolean bl2 = true;
                    boolean bl3 = FCPConnectionDialog._isStringInArray(string, stringArray);
                    if (bl3) {
                        int n = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), ConnectionArb.format((String)"CONFIRM_REPLACE_CTN", (Object[])new Object[]{string}), ConnectionArb.getString((String)"IMPEXP_IMPORT_WARNING_TITLE"), 0);
                        boolean bl4 = bl2 = n != 1;
                    }
                    if (!bl2) continue;
                    if (bl3) {
                        databaseConnections.updateConnection(string, string, (Properties)object);
                        continue;
                    }
                    databaseConnections.addConnection(string, (Properties)object);
                }
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Window)null, (Exception)exception, (String)ConnectionArb.getString((String)"IMPEXP_EXPORT_FAILURE"));
            }
        }
        return true;
    }

    private static Properties convertProps(Properties properties) {
        Properties properties2 = ((DatabaseProvider)CMHelper.createReferenceFromDescriptor((Properties)properties)).getProperties();
        if ("oraJDBC".equals(properties2.getProperty("subtype"))) {
            String string = properties2.getProperty("password");
            String string2 = properties2.getProperty("SavePassword");
            if (!ModelUtil.hasLength((String)string) && string2 == null) {
                properties2.setProperty("SavePassword", Boolean.FALSE.toString());
            }
        }
        return properties2;
    }

    private static boolean _isStringInArray(String string, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    public static abstract class ConnectRunnable
    extends ProgressRunnable {
        boolean m_canceled;

        protected void doCancel() {
            super.doCancel();
            this.m_canceled = true;
        }

        public boolean isCanceled() {
            return this.m_canceled;
        }
    }
}

