/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.wizards.metadata.connection;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.thirdparty.db2.DB2ConnectionPanel;
import oracle.dbtools.thirdparty.jdbc.DMJDBCBasicPanel;
import oracle.dbtools.thirdparty.udb.UDBConnectionPanel;
import oracle.jdeveloper.db.DatabaseConnections;

public abstract class ConnectionInfo {
    public static final String ORACLE_TYPE = "Oracle";
    public static final int TYPE_JDBC = 0;
    public static final int TYPE_ORACLE = 1;
    public static final int TYPE_SQL_SERVER = 2;
    public static final int TYPE_DB2 = 3;
    public static final int TYPE_UDB = 4;
    private static final Logger LOGGER = new Logger(ConnectionInfo.class);

    public static String getConnectionName(Properties properties) {
        return properties.getProperty("ConnName");
    }

    public static String getConnectionUserName(Properties properties) {
        return properties.getProperty("user");
    }

    public static void listConnectionProperties(Properties properties) {
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            Object object = enumeration.nextElement();
            System.out.println(object + " - " + properties.getProperty((String)object));
        }
    }

    public static int getConnectionType(Properties properties) {
        int n = ConnectionInfo.getConnectionTypeImpl(properties);
        if (n == 0) {
            String string = properties.getProperty("DB_TYPE");
            if (string != null) {
                for (int i = 0; i < DMJDBCBasicPanel.DB_TYPES.length; ++i) {
                    String string2 = DMJDBCBasicPanel.DB_TYPES[i];
                    if (!string.equalsIgnoreCase(string2)) continue;
                    return i;
                }
            }
            return n;
        }
        return n;
    }

    private static int getConnectionTypeImpl(Properties properties) {
        String string = properties.getProperty("RaptorConnectionType");
        if (string != null) {
            if (ORACLE_TYPE.equalsIgnoreCase(string)) {
                return 1;
            }
            if ("Microsoft SQL Server".equalsIgnoreCase(string)) {
                return 2;
            }
            if (DB2ConnectionPanel.CONNECTION_TYPE.equalsIgnoreCase(string)) {
                return 3;
            }
            if (UDBConnectionPanel.CONNECTION_TYPE.equalsIgnoreCase(string)) {
                return 4;
            }
        }
        return 0;
    }

    public static int getDBMajorVersion(Connection connection) {
        if (connection != null) {
            try {
                DatabaseMetaData databaseMetaData = connection.getMetaData();
                return databaseMetaData.getDatabaseMajorVersion();
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
            }
        }
        return -1;
    }

    public static List<Properties> getAllConnections(DatabaseConnections databaseConnections, boolean bl) {
        ArrayList<Properties> arrayList = new ArrayList<Properties>();
        try {
            Collection collection = bl ? databaseConnections.listConnections(true) : databaseConnections.listConnections();
            String[] stringArray = collection.toArray(new String[0]);
            Arrays.sort(stringArray, String.CASE_INSENSITIVE_ORDER);
            for (String string : stringArray) {
                Properties properties = databaseConnections.getProperties(string);
                properties.setProperty("ConnName", string);
                arrayList.add(properties);
            }
        }
        catch (Exception exception) {
            LOGGER.error("FCPConnectionDialog.showConnectionDialog(store)", exception);
        }
        return arrayList;
    }
}

