/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.wizards.metadata;

import java.text.MessageFormat;
import java.util.List;
import java.util.Properties;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.crest.swingui.wizards.metadata.connection.ConnectionInfo;
import oracle.dbtools.raptor.explorer.dt.dialog.ConnectionDialogArb;
import oracle.jdeveloper.db.DatabaseConnections;

public class DMConnectionModel
extends AbstractTableModel {
    List<Properties> data = null;
    DatabaseConnections m_store;
    boolean oracleOnly;

    public DMConnectionModel(DatabaseConnections databaseConnections, boolean bl) {
        this.m_store = databaseConnections;
        this.oracleOnly = bl;
        this.data = ConnectionInfo.getAllConnections(this.m_store, bl);
    }

    public void reReadConnections() {
        this.data = ConnectionInfo.getAllConnections(this.m_store, this.oracleOnly);
        this.fireTableStructureChanged();
        this.fireTableDataChanged();
    }

    @Override
    public String getColumnName(int n) {
        String string = null;
        switch (n) {
            case 0: {
                string = ConnectionDialogArb.getString((String)"CONNECTION_DIALOG_LIST_HEADER_NAME");
                break;
            }
            case 1: {
                string = ConnectionDialogArb.getString((String)"CONNECTION_DIALOG_LIST_HEADER_DETAIL");
            }
        }
        return string;
    }

    @Override
    public int getRowCount() {
        return this.data != null ? this.data.size() : 0;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        Properties properties = this.getRowData(n);
        String string = null;
        switch (n2) {
            case 0: {
                string = properties.getProperty("ConnName");
                break;
            }
            case 1: {
                String string2;
                String string3 = properties.getProperty("hostname");
                if (string3 != null) {
                    string2 = properties.getProperty("port");
                    String string4 = properties.getProperty("sid");
                    String string5 = properties.getProperty("serviceName");
                    string4 = string4 != null ? string4 : string5;
                    string4 = string4 != null && string4.length() > 0 ? "/" + string4 : "";
                    string = MessageFormat.format("//{0}:{1}{2}", string3, string2 != null ? string2 : "1521", string4);
                } else {
                    string2 = properties.getProperty("customUrl");
                    if (string2 != null) {
                        string = string2.substring(string2.lastIndexOf(64) + 1);
                    }
                }
                string2 = properties.getProperty("user");
                if (string2 == null) {
                    string2 = "";
                }
                string = string2 + "@" + string;
            }
        }
        return string;
    }

    public Properties getRowData(int n) {
        return this.data.get(n);
    }
}

