/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.wizards.metadata;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.Connection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import oracle.dbtools.crest.imports.metadata.DBMExtractionController;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.wizards.CustomWizard;
import oracle.dbtools.crest.swingui.wizards.Messages;
import oracle.dbtools.crest.swingui.wizards.metadata.AbstractDBMExtractionWizardImpl;
import oracle.dbtools.crest.swingui.wizards.metadata.DMConnectionModel;
import oracle.dbtools.crest.swingui.wizards.metadata.DefaultDBMExtractionWizard;
import oracle.dbtools.crest.swingui.wizards.metadata.connection.ConnectionInfo;
import oracle.dbtools.crest.swingui.wizards.metadata.connection.FCPConnectionDialog;
import oracle.dbtools.crest.swingui.wizards.metadata.db2.DBMExtractionWizardDB2;
import oracle.dbtools.crest.swingui.wizards.metadata.db2.v80.DBMExtractionWizardDB2v80;
import oracle.dbtools.crest.swingui.wizards.metadata.odbc.DBMExtractionWizardODBC;
import oracle.dbtools.crest.swingui.wizards.metadata.oracle.DBMExtractionWizardOracle;
import oracle.dbtools.crest.swingui.wizards.metadata.sqlserver.DBMExtractionWizardSqlServer;
import oracle.dbtools.crest.swingui.wizards.metadata.udb.DBMExtractionWizardUDB;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.compare.CompareMappingDialog;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.jdeveloper.db.ConnectionException;
import oracle.jdeveloper.db.DatabaseConnections;

public class DBMExtractionWizard
extends CustomWizard {
    private static final Font fontGrey = new Font("Dialog", 2, 12);
    private static final Font fontBlue = new Font("Dialog", 1, 12);
    private static final String DESCRIPTION_1 = Messages.getString("DBMExtractionWizard.SelectDatabaseConnection");
    private static final String DESCRIPTION_2 = Messages.getString("DBMExtractionWizard.SelectSchema");
    private static final String DESCRIPTION_3 = Messages.getString("DBMExtractionWizard.SelectObjects");
    private static final String DESCRIPTION_4 = Messages.getString("DBMExtractionWizard.ViewSummaryGenerateDesign");
    private static final String FIRST_PAGE = "FIRST_PAGE";
    private static final String SECOND_PAGE = "SECOND_PAGE";
    private static final String THIRD_PAGE = "THIRD_PAGE";
    private static final String FOURTH_PAGE = "FOURTH_PAGE";
    private CardLayout cardLayout = new CardLayout();
    private JPanel pnMain;
    private JTextArea taDescription;
    private JLabel lbTask1;
    private JLabel lbTask2;
    private JLabel lbTask3;
    private JLabel lbTask4;
    private int taskNbr = 1;
    private JTable tbConnections;
    private DBMExtractionController controller;
    private JButton bnRemove;
    private JButton bnProperties;
    private JButton bnTestConnection;
    private JButton bnImport;
    private JLabel taSummary;
    protected JPanel firstPanel;
    protected JPanel secondPanel;
    protected JPanel thirdPanel;
    protected JPanel forthPanel;
    private JComboBox cbImportTo;
    private JComboBox cbSite;
    private JCheckBox chbReverseTarget;
    private Connection connection = null;
    private static final Logger LOGGER = new Logger(DBMExtractionWizard.class);

    public DBMExtractionWizard(ApplicationView applicationView) {
        super(applicationView);
        this.clearInstances();
        this.pnMain.setLayout(this.cardLayout);
        this.handleButtons();
        this.refreshMainPanel();
    }

    @Override
    protected String getCaption() {
        return Messages.getString("DBMExtractionWizard.DataDictionaryImportWizard");
    }

    private void clearInstances() {
        DefaultDBMExtractionWizard.clearInstance();
        DBMExtractionWizardDB2.clearInstance();
        DBMExtractionWizardDB2v80.clearInstance();
        DBMExtractionWizardODBC.clearInstance();
        DBMExtractionWizardOracle.clearInstance();
        DBMExtractionWizardSqlServer.clearInstance();
        DBMExtractionWizardUDB.clearInstance();
    }

    public DBMExtractionController getController() {
        if (this.controller == null) {
            this.controller = new DBMExtractionController(this.view);
        }
        return this.controller;
    }

    @Override
    protected JPanel initMainPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBackground(Color.WHITE);
        ImageIcon imageIcon = (ImageIcon)GUIConfiguration.getInstance().getIcon("DBM_WIZARD_BANNER");
        jPanel2.add((Component)new JLabel(imageIcon), "West");
        this.taDescription = new JTextArea();
        this.taDescription.setEditable(false);
        this.taDescription.setFont(fontBlue);
        this.taDescription.setBackground(Color.WHITE);
        JPanel jPanel3 = new JPanel(new FlowLayout(1, 0, 25));
        jPanel3.setBackground(Color.WHITE);
        jPanel3.add(this.taDescription);
        jPanel2.add((Component)jPanel3, "Center");
        jPanel.add((Component)jPanel2, "North");
        JPanel jPanel4 = new JPanel(new GridLayout(0, 1));
        jPanel4.setBackground(Color.WHITE);
        jPanel4.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        this.lbTask1 = new JLabel(Messages.getString("DBMExtractionWizard.SectionConnectDatabase"));
        this.lbTask2 = new JLabel(Messages.getString("DBMExtractionWizard.SectionSelectSchemaDatabase"));
        this.lbTask3 = new JLabel(Messages.getString("DBMExtractionWizard.SectionSelectObjectsToImport"));
        this.lbTask4 = new JLabel(Messages.getString("DBMExtractionWizard.SectionGenerateDesign"));
        jPanel4.add(this.lbTask1);
        jPanel4.add(this.lbTask2);
        jPanel4.add(this.lbTask3);
        jPanel4.add(this.lbTask4);
        jPanel4.add(new JLabel());
        jPanel4.add(new JLabel());
        jPanel4.add(new JLabel());
        jPanel4.add(new JLabel());
        jPanel4.add(new JLabel());
        jPanel4.add(new JLabel());
        jPanel4.add(new JLabel());
        jPanel4.setPreferredSize(new Dimension(280, 350));
        jPanel.add((Component)jPanel4, "West");
        this.pnMain = new JPanel();
        this.pnMain.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        this.pnMain.setPreferredSize(new Dimension(860, 550));
        this.firstPanel = this.initFirstTab();
        this.pnMain.add((Component)this.firstPanel, FIRST_PAGE);
        this.forthPanel = this.initFourthTab();
        this.pnMain.add((Component)this.forthPanel, FOURTH_PAGE);
        jPanel.add((Component)this.pnMain, "Center");
        return jPanel;
    }

    private void updateConnections() {
        ((DMConnectionModel)this.tbConnections.getModel()).reReadConnections();
    }

    private Properties getSelectedConnectionProperties() {
        Properties properties = null;
        try {
            properties = ((DMConnectionModel)this.tbConnections.getModel()).getRowData(this.tbConnections.getSelectedRow());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return properties;
    }

    public Connection getSelectedConnection() {
        return this.connection;
    }

    public int getSelectedConnectionType() {
        return ConnectionInfo.getConnectionType(this.getSelectedConnectionProperties());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initConnection() {
        block5: {
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                this.closeConnection();
                Properties properties = this.getSelectedConnectionProperties();
                if (properties == null) break block5;
                try {
                    this.connection = DatabaseConnections.getInstance().getConnection(properties);
                }
                catch (Exception exception) {
                    MessageDialogs.showErrorMessage(exception.getLocalizedMessage());
                    boolean bl = false;
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    return bl;
                }
            }
            finally {
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
        return this.connection != null;
    }

    private JPanel initFirstTab() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.tbConnections = new JTable(new DMConnectionModel(DatabaseConnections.getInstance(), false));
        this.tbConnections.setSelectionMode(0);
        this.tbConnections.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    DBMExtractionWizard.this.showConnectionProperties();
                } else {
                    boolean bl = DBMExtractionWizard.this.tbConnections.getSelectedRow() > -1;
                    DBMExtractionWizard.this.bnNext.setEnabled(bl);
                    DBMExtractionWizard.this.bnRemove.setEnabled(bl);
                    DBMExtractionWizard.this.bnProperties.setEnabled(bl);
                    DBMExtractionWizard.this.bnTestConnection.setEnabled(bl);
                }
            }
        });
        this.tbConnections.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                if (keyEvent.getKeyChar() == '\n') {
                    DBMExtractionWizard.this.showConnectionProperties();
                }
                boolean bl = DBMExtractionWizard.this.tbConnections.getSelectedRow() > -1;
                DBMExtractionWizard.this.bnNext.setEnabled(bl);
                DBMExtractionWizard.this.bnRemove.setEnabled(bl);
                DBMExtractionWizard.this.bnProperties.setEnabled(bl);
                DBMExtractionWizard.this.bnTestConnection.setEnabled(bl);
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.tbConnections);
        jPanel.add((Component)jScrollPane, "Center");
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        JButton jButton = new JButton(Messages.getString("DBMExtractionWizard.Add"));
        jButton.setMnemonic(65);
        jButton.addActionListener(new AddAction());
        this.bnRemove = new JButton(Messages.getString("DBMExtractionWizard.Remove"));
        this.bnRemove.setMnemonic(82);
        this.bnRemove.addActionListener(new RemoveAction());
        this.bnRemove.setEnabled(false);
        this.bnImport = new JButton(Messages.getString("DBMExtractionWizard.Import"));
        this.bnImport.setToolTipText(Messages.getString("DBMExtractionWizard.ImportSQLDeveloperDatabaseConnections"));
        this.bnImport.setMnemonic(73);
        this.bnImport.addActionListener(new ImportAction());
        this.bnProperties = new JButton(Messages.getString("DBMExtractionWizard.Properties"));
        this.bnProperties.setMnemonic(80);
        this.bnProperties.addActionListener(new PropertiesAction());
        this.bnProperties.setEnabled(false);
        this.bnTestConnection = new JButton(Messages.getString("DBMExtractionWizard.TestConnection"));
        this.bnTestConnection.setMnemonic(84);
        this.bnTestConnection.addActionListener(new TestAction());
        this.bnTestConnection.setEnabled(false);
        JPanel jPanel3 = new JPanel();
        jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.bnRemove.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.bnImport.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.bnProperties.setPreferredSize(MessageDialogs.BUTTON_SIZE_EX);
        jPanel3.setPreferredSize(new Dimension(40, 25));
        this.bnTestConnection.setPreferredSize(MessageDialogs.BUTTON_SIZE_EX);
        jPanel2.add(jButton);
        jPanel2.add(this.bnRemove);
        jPanel2.add(this.bnImport);
        jPanel2.add(this.bnProperties);
        jPanel2.add(jPanel3);
        jPanel2.add(this.bnTestConnection);
        jPanel.add((Component)jPanel2, "South");
        this.updateConnections();
        return jPanel;
    }

    private void showConnectionProperties() {
        Properties properties = this.getSelectedConnectionProperties();
        if (properties != null) {
            String string = ConnectionInfo.getConnectionName(properties);
            FCPConnectionDialog.showConnectionDialog(string, false);
            this.updateConnections();
        }
    }

    @Override
    protected String getHelpIndex() {
        return "IMPORT_METADATA_WIZARD";
    }

    private AbstractDBMExtractionWizardImpl getImpl() {
        if (this.connection == null) {
            return DefaultDBMExtractionWizard.getInstance(this);
        }
        switch (this.getSelectedConnectionType()) {
            case 3: {
                if (ConnectionInfo.getDBMajorVersion(this.connection) == 7) {
                    return DBMExtractionWizardDB2.getInstance(this);
                }
                return DBMExtractionWizardDB2v80.getInstance(this);
            }
            case 4: {
                return DBMExtractionWizardUDB.getInstance(this);
            }
            case 1: {
                return DBMExtractionWizardOracle.getInstance(this);
            }
            case 2: {
                return DBMExtractionWizardSqlServer.getInstance(this);
            }
            case 0: {
                return DBMExtractionWizardODBC.getInstance(this);
            }
        }
        return DefaultDBMExtractionWizard.getInstance(this);
    }

    private void refreshMainPanel() {
        if (this.forthPanel != null) {
            this.pnMain.remove(this.forthPanel);
        }
        if (this.thirdPanel != null) {
            this.pnMain.remove(this.thirdPanel);
        }
        if (this.secondPanel != null) {
            this.pnMain.remove(this.secondPanel);
        }
        this.pnMain.remove(this.firstPanel);
        this.pnMain.add((Component)this.firstPanel, FIRST_PAGE);
        if (this.secondPanel != null) {
            this.pnMain.add((Component)this.secondPanel, SECOND_PAGE);
        }
        if (this.thirdPanel != null) {
            this.pnMain.add((Component)this.thirdPanel, THIRD_PAGE);
        }
        if (this.forthPanel != null) {
            this.pnMain.add((Component)this.forthPanel, FOURTH_PAGE);
        }
    }

    public void initSecondPanel() {
        if (this.secondPanel != null) {
            this.pnMain.remove(this.secondPanel);
        }
        this.secondPanel = this.getSecondTabChanged();
        this.refreshMainPanel();
    }

    public JPanel getSecondTabChanged() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.getImpl().getSecondTab(), "Center");
        jPanel.add((Component)this.initOptionsPanel(), "South");
        return jPanel;
    }

    public void initThirdPanel() {
        if (this.thirdPanel != null) {
            this.pnMain.remove(this.thirdPanel);
        }
        this.thirdPanel = this.getImpl().getThirdTab();
        this.refreshMainPanel();
    }

    public void clearSecondTabFilter() {
        this.getImpl().clearSecondTabFilter();
    }

    public void clearThirdTabFilter() {
        this.getImpl().clearThirdTabFilter();
    }

    public boolean initSchemas(boolean bl) {
        return this.getImpl().getSchemas(bl);
    }

    public boolean initDBObjects(boolean bl) {
        return this.getImpl().getDBObjects(bl);
    }

    public void initRDBMSSites(boolean bl) {
        if (bl) {
            RDBMSType rDBMSType = this.getController().getDBMExtractionHandler(this.getSelectedConnectionType()).getRDBMSSite().getType();
            Object object = this.getAppView().getCurrentDesign().getRDBMSSiteSet().iterator();
            while (object.hasNext()) {
                RDBMSSite rDBMSSite = (RDBMSSite)object.next();
                if (!rDBMSType.equals(rDBMSSite.getType())) continue;
                this.cbSite.addItem(rDBMSSite);
            }
            object = this.cbSite.getSelectedItem();
            if (object != null && object instanceof RDBMSSite) {
                this.getImpl().setRdbmsSite((RDBMSSite)object);
            }
        }
    }

    protected JPanel initFourthTab() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.taSummary = new JLabel();
        this.taSummary.setFont(this.taSummary.getFont().deriveFont(0));
        this.taSummary.setVerticalAlignment(1);
        jPanel.add((Component)this.taSummary, "Center");
        jPanel.add((Component)new JPanel(), "East");
        jPanel.add((Component)new JPanel(), "West");
        jPanel.add((Component)new JPanel(), "North");
        return jPanel;
    }

    public JPanel initOptionsPanel() {
        Object object;
        JPanel jPanel = new JPanel(new FlowLayout(0));
        jPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("DBMExtractionWizard.ImportTo")));
        Dimension dimension = new Dimension(190, 20);
        this.cbImportTo = new JComboBox();
        this.cbImportTo.setPreferredSize(dimension);
        jPanel.add(this.cbImportTo);
        jPanel.add(new JLabel());
        Object object2 = null;
        Iterator iterator = this.getAppView().getCurrentDesign().getRelationalDesigns().iterator();
        while (iterator.hasNext()) {
            object = (RelationalDesign)iterator.next();
            this.cbImportTo.addItem(object);
            if (!((RelationalDesign)object).isEmpty() || object2 != null) continue;
            object2 = object;
        }
        this.cbImportTo.addItem("New Relational Model");
        if (object2 != null) {
            this.cbImportTo.setSelectedItem(object2);
        }
        if ((object = this.cbImportTo.getSelectedItem()) != null && object instanceof RelationalDesign) {
            this.getImpl().setRelationalDesign((RelationalDesign)object);
        } else {
            this.getImpl().setRelationalDesign(null);
        }
        this.chbReverseTarget = new JCheckBox(Messages.getString("DBMExtractionWizard.SwapTargetModel"));
        this.chbReverseTarget.setPreferredSize(new Dimension(230, 20));
        this.chbReverseTarget.setEnabled(!this.emptySelected());
        jPanel.add(this.chbReverseTarget);
        this.cbImportTo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object;
                DBMExtractionWizard.this.chbReverseTarget.setEnabled(!DBMExtractionWizard.this.emptySelected());
                if (!DBMExtractionWizard.this.chbReverseTarget.isEnabled()) {
                    DBMExtractionWizard.this.chbReverseTarget.setSelected(false);
                }
                if ((object = DBMExtractionWizard.this.cbImportTo.getSelectedItem()) != null && object instanceof RelationalDesign) {
                    DBMExtractionWizard.this.getImpl().setRelationalDesign((RelationalDesign)object);
                } else {
                    DBMExtractionWizard.this.getImpl().setRelationalDesign(null);
                }
            }
        });
        this.cbSite = new JComboBox();
        this.cbSite.setPreferredSize(dimension);
        jPanel.add(this.cbSite);
        this.cbSite.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object = DBMExtractionWizard.this.cbSite.getSelectedItem();
                if (object != null && object instanceof RDBMSSite) {
                    DBMExtractionWizard.this.getImpl().setRdbmsSite((RDBMSSite)object);
                }
            }
        });
        JButton jButton = new JButton(Messages.getString("DBMExtractionWizard.CompareMapping"));
        jButton.setPreferredSize(new Dimension(200, 20));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CompareMappingDialog compareMappingDialog = new CompareMappingDialog(DBMExtractionWizard.this.getAppView());
                compareMappingDialog.show();
            }
        });
        jPanel.add(jButton);
        return jPanel;
    }

    private boolean emptySelected() {
        if (this.getSelectedConnectionProperties() != null && this.getSelectedConnectionType() != 1) {
            return true;
        }
        if (this.cbImportTo.getSelectedItem() instanceof RelationalDesign) {
            return ((RelationalDesign)this.cbImportTo.getSelectedItem()).isEmpty();
        }
        return true;
    }

    public RelationalDesign getSelectedModel() {
        Object object = this.cbImportTo.getSelectedItem();
        if (object instanceof RelationalDesign) {
            return (RelationalDesign)object;
        }
        return null;
    }

    public boolean swapTargetModel() {
        return this.chbReverseTarget.isSelected();
    }

    protected JPanel createRow(Component component, Component component2) {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add(component, "West");
        jPanel.add(component2, "Center");
        return jPanel;
    }

    private boolean performTask(boolean bl) {
        switch (this.taskNbr) {
            case 1: {
                this.closeConnection();
            }
            case 2: {
                if (bl) {
                    if (!this.initConnection()) {
                        return false;
                    }
                    if (this.connection != null) {
                        this.getController().getDBMExtractionHandler(this.getSelectedConnectionType()).init(this.connection);
                    }
                    this.initSecondPanel();
                    this.initThirdPanel();
                    this.chbReverseTarget.setEnabled(!this.emptySelected());
                    this.clearSecondTabFilter();
                    this.clearThirdTabFilter();
                } else {
                    this.clearThirdTabFilter();
                }
                boolean bl2 = this.initSchemas(bl);
                if (bl) {
                    this.initRDBMSSites(bl);
                }
                return bl2;
            }
            case 3: {
                return this.initDBObjects(bl);
            }
            case 4: {
                return this.getSummary();
            }
        }
        return true;
    }

    private List getSelectedObjects() {
        return this.getImpl().getSelectedObjects();
    }

    private Map getSummaryList() {
        TreeMap<String, Integer> treeMap = new TreeMap<String, Integer>();
        for (DBObject dBObject : this.getSelectedObjects()) {
            if (!dBObject.isSelected()) continue;
            if (treeMap.containsKey(dBObject.getType())) {
                Integer n = (Integer)treeMap.get(dBObject.getType());
                int n2 = n;
                treeMap.put(dBObject.getType(), new Integer(++n2));
                continue;
            }
            treeMap.put(dBObject.getType(), new Integer(1));
        }
        return treeMap;
    }

    private String addTableRow(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<tr>");
        stringBuffer.append("<td width=\"150\">");
        stringBuffer.append("<p>");
        stringBuffer.append(string);
        stringBuffer.append("</p>");
        stringBuffer.append("</td>");
        stringBuffer.append("<td width=\"60\" align=\"right\">");
        stringBuffer.append("<p>");
        stringBuffer.append(string2);
        stringBuffer.append("</p>");
        stringBuffer.append("</td>");
        stringBuffer.append("</tr>");
        return stringBuffer.toString();
    }

    private boolean getSummary() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<html>");
        stringBuffer.append("<body>");
        stringBuffer.append("<p>");
        stringBuffer.append("<b>");
        stringBuffer.append(Messages.getString("DBMExtractionWizard.DatabaseName"));
        stringBuffer.append("</b>");
        stringBuffer.append(this.getController().getDBProductName(this.getSelectedConnectionType()));
        stringBuffer.append("</p>");
        stringBuffer.append("<p>");
        stringBuffer.append("<b>");
        stringBuffer.append(Messages.getString("DBMExtractionWizard.DatabaseVersion"));
        stringBuffer.append("</b>");
        stringBuffer.append(this.getController().getDBProductVersion(this.getSelectedConnectionType()));
        stringBuffer.append("</p>");
        stringBuffer.append("<p></p>");
        stringBuffer.append("<p>");
        stringBuffer.append("<b>");
        stringBuffer.append(Messages.getString("DBMExtractionWizard.DBObjectsIimported"));
        stringBuffer.append("</b>");
        stringBuffer.append("</p>");
        stringBuffer.append("<table border=\"0\" width=\"170\">");
        Map map = this.getSummaryList();
        Object[] objectArray = map.keySet().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            String string = (String)objectArray[i];
            Integer n = (Integer)map.get(objectArray[i]);
            stringBuffer.append(this.addTableRow(string, n.toString()));
        }
        stringBuffer.append("</table>");
        stringBuffer.append("</body>");
        stringBuffer.append("</html>");
        this.taSummary.setText(stringBuffer.toString());
        return true;
    }

    @Override
    protected void doBack() {
        --this.taskNbr;
        try {
            if (this.performTask(false)) {
                this.handleButtons();
                switch (this.taskNbr) {
                    case 1: {
                        this.cardLayout.show(this.pnMain, FIRST_PAGE);
                        break;
                    }
                    case 2: {
                        this.cardLayout.show(this.pnMain, SECOND_PAGE);
                        break;
                    }
                    case 3: {
                        this.cardLayout.show(this.pnMain, THIRD_PAGE);
                    }
                }
            } else {
                ++this.taskNbr;
            }
        }
        catch (Throwable throwable) {
            ++this.taskNbr;
            JOptionPane.showMessageDialog(this, throwable.getMessage(), Messages.getString("DBMExtractionWizard.Error"), 0);
            LOGGER.error(throwable);
        }
    }

    @Override
    protected void doNext() {
        ++this.taskNbr;
        try {
            if (this.performTask(true)) {
                this.handleButtons();
                switch (this.taskNbr) {
                    case 2: {
                        this.cardLayout.show(this.pnMain, SECOND_PAGE);
                        break;
                    }
                    case 3: {
                        this.cardLayout.show(this.pnMain, THIRD_PAGE);
                        break;
                    }
                    case 4: {
                        this.cardLayout.show(this.pnMain, FOURTH_PAGE);
                    }
                }
            } else {
                --this.taskNbr;
            }
        }
        catch (Throwable throwable) {
            --this.taskNbr;
            JOptionPane.showMessageDialog(this, throwable.getMessage(), Messages.getString("DBMExtractionWizard.Error"), 0);
            LOGGER.error(throwable);
        }
    }

    @Override
    protected void doFinish() {
        try {
            this.getController().generateDesign(this.getSelectedConnection(), this.getSelectedConnectionProperties(), this.getSelectedObjects(), this.getSelectedModel(), this.swapTargetModel(), (RDBMSSite)this.cbSite.getSelectedItem());
        }
        catch (Throwable throwable) {
            MessageDialogs.showErrorMessage(this, throwable.getMessage());
            LOGGER.error(throwable);
        }
        this.dispose();
    }

    @Override
    protected void doCancel() {
        this.getController().doCancel();
        this.closeConnection();
        this.dispose();
    }

    @Override
    protected void doClosing() {
        this.closeConnection();
    }

    public void closeConnection() {
        if (this.connection != null) {
            try {
                if (!this.connection.isClosed()) {
                    this.connection.close();
                }
                this.connection = null;
            }
            catch (Exception exception) {
                LOGGER.error("Unable to close the connection", exception);
            }
        }
    }

    private void handleButtons() {
        this.handleLabels();
        this.handleDescription();
        switch (this.taskNbr) {
            case 1: {
                this.bnBack.setEnabled(false);
                this.bnNext.setEnabled(this.tbConnections.getSelectedRow() > -1);
                this.bnFinish.setEnabled(false);
                this.bnCancel.setEnabled(true);
                break;
            }
            case 2: {
                this.bnBack.setEnabled(true);
                this.bnNext.setEnabled(true);
                this.bnFinish.setEnabled(false);
                this.bnCancel.setEnabled(true);
                break;
            }
            case 3: {
                this.bnBack.setEnabled(true);
                this.bnNext.setEnabled(true);
                this.bnFinish.setEnabled(false);
                this.bnCancel.setEnabled(true);
                break;
            }
            case 4: {
                this.bnBack.setEnabled(true);
                this.bnNext.setEnabled(false);
                this.bnFinish.setEnabled(true);
                this.bnCancel.setEnabled(true);
            }
        }
    }

    private void handleLabels() {
        switch (this.taskNbr) {
            case 1: {
                this.setBlueLabel(this.lbTask1);
                this.setGreyLabel(this.lbTask2);
                this.setGreyLabel(this.lbTask3);
                this.setGreyLabel(this.lbTask4);
                break;
            }
            case 2: {
                this.setBlackLabel(this.lbTask1);
                this.setBlueLabel(this.lbTask2);
                this.setGreyLabel(this.lbTask3);
                this.setGreyLabel(this.lbTask4);
                break;
            }
            case 3: {
                this.setBlackLabel(this.lbTask1);
                this.setBlackLabel(this.lbTask2);
                this.setBlueLabel(this.lbTask3);
                this.setGreyLabel(this.lbTask4);
                break;
            }
            case 4: {
                this.setBlackLabel(this.lbTask1);
                this.setBlackLabel(this.lbTask2);
                this.setBlackLabel(this.lbTask3);
                this.setBlueLabel(this.lbTask4);
                break;
            }
            default: {
                this.setBlueLabel(this.lbTask1);
                this.setGreyLabel(this.lbTask2);
                this.setGreyLabel(this.lbTask3);
                this.setGreyLabel(this.lbTask4);
            }
        }
    }

    private void setGreyLabel(JLabel jLabel) {
        jLabel.setForeground(Color.LIGHT_GRAY);
        jLabel.setFont(fontGrey);
    }

    private void setBlueLabel(JLabel jLabel) {
        jLabel.setForeground(Color.BLUE);
        jLabel.setFont(fontBlue);
    }

    private void setBlackLabel(JLabel jLabel) {
        jLabel.setForeground(Color.BLACK);
        jLabel.setFont(fontBlue);
    }

    private void handleDescription() {
        switch (this.taskNbr) {
            case 1: {
                this.taDescription.setText(DESCRIPTION_1);
                break;
            }
            case 2: {
                this.taDescription.setText(DESCRIPTION_2);
                break;
            }
            case 3: {
                this.taDescription.setText(DESCRIPTION_3);
                break;
            }
            case 4: {
                this.taDescription.setText(DESCRIPTION_4);
                break;
            }
            default: {
                this.taDescription.setText(DESCRIPTION_1);
            }
        }
    }

    private class TestAction
    implements ActionListener {
        private TestAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FCPConnectionDialog.testConnection(DBMExtractionWizard.this.getSelectedConnectionProperties());
        }
    }

    private class PropertiesAction
    implements ActionListener {
        private PropertiesAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DBMExtractionWizard.this.showConnectionProperties();
        }
    }

    private class ImportAction
    implements ActionListener {
        private ImportAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FCPConnectionDialog.importConnections();
            DBMExtractionWizard.this.updateConnections();
        }
    }

    private class RemoveAction
    implements ActionListener {
        private RemoveAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Properties properties = DBMExtractionWizard.this.getSelectedConnectionProperties();
            if (properties != null) {
                try {
                    String string = ConnectionInfo.getConnectionName(properties);
                    int n = JOptionPane.showConfirmDialog(DBMExtractionWizard.this, "Are you sure you want to delete: '" + string + "' connection?", "Select an option", 0);
                    if (n == 0) {
                        DatabaseConnections.getInstance().removeConnection(string);
                        DBMExtractionWizard.this.updateConnections();
                        DBMExtractionWizard.this.tbConnections.clearSelection();
                        DBMExtractionWizard.this.bnNext.setEnabled(false);
                        DBMExtractionWizard.this.bnRemove.setEnabled(false);
                        DBMExtractionWizard.this.bnProperties.setEnabled(false);
                        DBMExtractionWizard.this.bnTestConnection.setEnabled(false);
                    }
                }
                catch (ConnectionException connectionException) {
                    LOGGER.error("Unable to delete connection", connectionException);
                    MessageDialogs.showMessage(ApplicationView.frame, "Unable to delete connection");
                }
            }
        }
    }

    private class AddAction
    implements ActionListener {
        private AddAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                FCPConnectionDialog.showConnectionDialog();
                DBMExtractionWizard.this.updateConnections();
            }
            catch (Exception exception) {
                LOGGER.error(exception);
            }
        }
    }
}

