/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.wizards.metadata;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import javax.swing.DefaultRowSorter;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.RowFilter;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.oracle.MOHSynonymOracle;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.WindowsTableHeader;
import oracle.dbtools.crest.swingui.wizards.Messages;
import oracle.dbtools.crest.swingui.wizards.metadata.DBMExtractionWizard;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.logging.Logger;

public abstract class AbstractDBMExtractionWizardImpl {
    public static final String DATABASE = "DATABASE";
    public static final String TABLE = "TABLE";
    public static final String VIEW = "VIEW";
    public static final String LOGIN = "LOGIN";
    public static final String USER = "USER";
    public static final String ROLE = "ROLE";
    public static final String RULE = "RULE";
    public static final String DEFAULT = "DEFAULT";
    public static final String PROCEDURE = "PROCEDURE";
    public static final String TRIGGER = "TRIGGER";
    public static final String DATATYPE = "DATATYPE";
    public static final String ALIAS = "ALIAS";
    public static final String BUFFERPOOL = "BUFFERPOOL";
    public static final String NODEGROUP = "NODEGROUP";
    public static final String OWNER = "OWNER";
    public static final String SEQUENCE = "SEQUENCE";
    public static final String USERGROUP = "USERGROUP";
    public static final String TABLESPACE = "TABLESPACE";
    public static final String AUX_TABLE = "AUX TABLE";
    public static final String STORAGE_GROUP = "STORAGE GROUP";
    public static final String VCAT = "VCAT";
    public static final String VOLUME = "VOLUME";
    protected JTabbedPane tpane;
    protected JTable tbSchemas;
    protected List lsSchemas;
    protected JTextField secondTabFilterText = new JTextField();
    protected JTextField thirdTabFilterText = new JTextField();
    protected JTable tbTables;
    protected JTable tbViews;
    protected List lsTables = new ArrayList();
    protected List lsViews = new ArrayList();
    protected DBMExtractionWizard wizard;
    public JCheckBox chSecondaryTables;
    public JCheckBox chAllSelected;
    public JCheckBox chSpatial;
    private RelationalDesign relationalDesign;
    private RDBMSSite rdbmsSite;
    protected static final Logger LOGGER = new Logger(AbstractDBMExtractionWizardImpl.class);

    public AbstractDBMExtractionWizardImpl(DBMExtractionWizard dBMExtractionWizard) {
        this.wizard = dBMExtractionWizard;
    }

    protected abstract List getCurrentList();

    protected abstract void addTabs();

    protected abstract void updateTables();

    public abstract List getSelectedObjects();

    protected abstract void clearAll();

    protected abstract void initSpecificObjects(List var1);

    public void setSelected(DBObject dBObject, boolean bl) {
        if (dBObject != null) {
            dBObject.setSelected(bl);
        }
    }

    protected List getObjectsByType(List list, String string) {
        ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
        for (DBObject dBObject : list) {
            if (!dBObject.getType().equalsIgnoreCase(string)) continue;
            arrayList.add(dBObject);
        }
        return arrayList;
    }

    protected JTabbedPane getTabbedPane() {
        if (this.tpane == null) {
            this.tpane = new JTabbedPane(3);
        }
        return this.tpane;
    }

    protected JTable getCurrentTable() {
        int n;
        JComponent jComponent;
        Component component = this.getTabbedPane().getSelectedComponent();
        if (component != null && component instanceof JPanel) {
            jComponent = (JPanel)component;
            for (n = 0; n < jComponent.getComponentCount(); ++n) {
                if (!(jComponent.getComponent(n) instanceof JScrollPane)) continue;
                component = jComponent.getComponent(n);
                break;
            }
        }
        if (component != null && component instanceof JScrollPane) {
            jComponent = (JScrollPane)component;
            n = jComponent.getComponentCount();
            for (int i = 0; i < n; ++i) {
                JViewport jViewport;
                Component component2;
                Component component3 = jComponent.getComponent(i);
                if (!(component3 instanceof JViewport) || !((component2 = (jViewport = (JViewport)component3).getComponent(0)) instanceof JTable)) continue;
                return (JTable)component2;
            }
        }
        return null;
    }

    public List getTables() {
        ArrayList<Component> arrayList = new ArrayList<Component>();
        int n = this.getTabbedPane().getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = this.getTabbedPane().getComponent(i);
            if (component == null || !(component instanceof JScrollPane)) continue;
            JScrollPane jScrollPane = (JScrollPane)component;
            int n2 = jScrollPane.getComponentCount();
            for (int j = 0; j < n2; ++j) {
                JViewport jViewport;
                Component component2;
                Component component3 = jScrollPane.getComponent(j);
                if (!(component3 instanceof JViewport) || !((component2 = (jViewport = (JViewport)component3).getComponent(0)) instanceof JTable)) continue;
                arrayList.add(component2);
            }
        }
        return arrayList;
    }

    public JPanel getSecondTab() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.lsSchemas = new ArrayList();
        this.tbSchemas = new JTable(new SchemasModel());
        this.tbSchemas.setAutoCreateRowSorter(true);
        WindowsTableHeader.setSortedHeader(this.tbSchemas);
        TableColumn tableColumn = this.tbSchemas.getColumnModel().getColumn(1);
        tableColumn.setPreferredWidth(300);
        JScrollPane jScrollPane = new JScrollPane(this.tbSchemas);
        jPanel.add((Component)jScrollPane, "Center");
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        JButton jButton = this.createSelectAllButton();
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractDBMExtractionWizardImpl.this.checkAll(AbstractDBMExtractionWizardImpl.this.tbSchemas, AbstractDBMExtractionWizardImpl.this.lsSchemas, true);
            }
        });
        JButton jButton2 = this.createDeselectAllButton();
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractDBMExtractionWizardImpl.this.checkAll(AbstractDBMExtractionWizardImpl.this.tbSchemas, AbstractDBMExtractionWizardImpl.this.lsSchemas, false);
            }
        });
        jPanel2.add(this.createFilterPanel(this.secondTabFilterText, this.tbSchemas, jButton, jButton2));
        this.chAllSelected = new JCheckBox(Messages.getString("AbstractDBMExtractionWizardImpl.AllSelected"));
        this.chAllSelected.setSelected(AbstractDBMExtractionHandler.isAllSelected());
        this.chAllSelected.setToolTipText(Messages.getString("AbstractDBMExtractionWizardImpl.DefaultSelectionStatusOfListedObjects"));
        this.chAllSelected.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractDBMExtractionHandler.setAllSelected(AbstractDBMExtractionWizardImpl.this.chAllSelected.isSelected());
            }
        });
        jPanel2.add(this.chAllSelected);
        if (this.wizard.getSelectedConnectionType() == 1) {
            this.chSecondaryTables = new JCheckBox(Messages.getString("AbstractDBMExtractionWizardImpl.SecondaryTables"));
            this.chSecondaryTables.setToolTipText(Messages.getString("AbstractDBMExtractionWizardImpl.SecondaryTablesIncluded"));
            this.chSecondaryTables.setSelected(false);
            this.chSecondaryTables.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AbstractDBMExtractionWizardImpl.this.wizard.getController().setSecondaryTables(AbstractDBMExtractionWizardImpl.this.wizard.getSelectedConnectionType(), AbstractDBMExtractionWizardImpl.this.chSecondaryTables.isSelected());
                }
            });
            jPanel2.add(this.chSecondaryTables);
            this.chSpatial = new JCheckBox(Messages.getString("AbstractDBMExtractionWizardImpl.SpatialProperties"));
            this.chSpatial.setToolTipText(Messages.getString("AbstractDBMExtractionWizardImpl.SpatialPropertiesWillBeExtracted"));
            this.chSpatial.setSelected(false);
            this.chSpatial.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AbstractDBMExtractionWizardImpl.this.wizard.getController().setSpatialProperties(AbstractDBMExtractionWizardImpl.this.wizard.getSelectedConnectionType(), AbstractDBMExtractionWizardImpl.this.chSpatial.isSelected());
                }
            });
            jPanel2.add(this.chSpatial);
        }
        jPanel.add((Component)jPanel2, "South");
        return jPanel;
    }

    private JButton createSelectAllButton() {
        JButton jButton = new JButton(GUIConfiguration.getInstance().getIcon("SELECT_ALL"));
        jButton.setMnemonic(83);
        jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE_SMALL);
        jButton.setToolTipText(Messages.getString("AbstractDBMExtractionWizardImpl.SelectAll"));
        return jButton;
    }

    private JButton createDeselectAllButton() {
        JButton jButton = new JButton(GUIConfiguration.getInstance().getIcon("DESELECT_ALL"));
        jButton.setMnemonic(68);
        jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE_SMALL);
        jButton.setToolTipText(Messages.getString("AbstractDBMExtractionWizardImpl.DeselectAll"));
        return jButton;
    }

    public JPanel getThirdTab() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.getTabbedPane(), "Center");
        this.addTabs();
        JButton jButton = this.createSelectAllButton();
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractDBMExtractionWizardImpl.this.checkAll(AbstractDBMExtractionWizardImpl.this.getCurrentTable(), AbstractDBMExtractionWizardImpl.this.getCurrentList(), true);
            }
        });
        JButton jButton2 = this.createDeselectAllButton();
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractDBMExtractionWizardImpl.this.checkAll(AbstractDBMExtractionWizardImpl.this.getCurrentTable(), AbstractDBMExtractionWizardImpl.this.getCurrentList(), false);
            }
        });
        jPanel.add((Component)this.createFilterPanel(this.thirdTabFilterText, null, jButton, jButton2), "South");
        return jPanel;
    }

    private void selectAll(JTable jTable, List list) {
        if (jTable != null && jTable.getRowCount() != jTable.getModel().getRowCount()) {
            int n = jTable.getRowCount();
            for (int i = 0; i < n; ++i) {
                DBObject dBObject;
                int n2 = jTable.convertRowIndexToModel(i);
                if (n2 <= -1 || n2 >= list.size() || (dBObject = (DBObject)list.get(n2)).getStatus().equals("Type name exist")) continue;
                this.setSelected(dBObject, true);
            }
        } else {
            for (DBObject dBObject : list) {
                if (dBObject.getStatus().equals("Type name exist")) continue;
                this.setSelected(dBObject, true);
            }
        }
    }

    private void deselectAll(JTable jTable, List list) {
        if (jTable != null && jTable.getRowCount() != jTable.getModel().getRowCount()) {
            int n = jTable.getRowCount();
            for (int i = 0; i < n; ++i) {
                int n2 = jTable.convertRowIndexToModel(i);
                if (n2 <= -1 || n2 >= list.size()) continue;
                DBObject dBObject = (DBObject)list.get(n2);
                this.setSelected(dBObject, false);
            }
        } else {
            for (DBObject dBObject : list) {
                this.setSelected(dBObject, false);
            }
        }
    }

    private JPanel createFilterPanel(final JTextField jTextField, final JTable jTable, JButton jButton, JButton jButton2) {
        JLabel jLabel = new JLabel(Messages.getString("AbstractDBMExtractionWizardImpl.Filter"));
        jTextField.setPreferredSize(new Dimension(150, MessageDialogs.BUTTON_SIZE_EX.height));
        jTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                AbstractDBMExtractionWizardImpl.this.newFilter(jTextField, jTable);
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                AbstractDBMExtractionWizardImpl.this.newFilter(jTextField, jTable);
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                AbstractDBMExtractionWizardImpl.this.newFilter(jTextField, jTable);
            }
        });
        jLabel.setLabelFor(jTextField);
        JPanel jPanel = new JPanel(new FlowLayout(0));
        jPanel.add(jButton);
        jPanel.add(jButton2);
        jPanel.add(new JPanel());
        jPanel.add(jLabel);
        jPanel.add(jTextField);
        return jPanel;
    }

    private void newFilter(JTextField jTextField, JTable jTable) {
        RowFilter rowFilter = null;
        if (jTable == null) {
            jTable = this.getCurrentTable();
        }
        if (jTable != null) {
            if (!"".equals(jTextField.getText())) {
                try {
                    rowFilter = RowFilter.regexFilter("^(?i)" + jTextField.getText(), this.getFilterColumn(jTable));
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    return;
                }
                ((DefaultRowSorter)jTable.getRowSorter()).setRowFilter(rowFilter);
            } else {
                ((DefaultRowSorter)jTable.getRowSorter()).setRowFilter(null);
                jTable.clearSelection();
            }
        }
    }

    protected int getFilterColumn(JTable jTable) {
        TableModel tableModel = jTable.getModel();
        if (tableModel instanceof ObjectModel) {
            return ((ObjectModel)tableModel).getFilterColumn();
        }
        if (tableModel instanceof SchemasModel) {
            return ((SchemasModel)tableModel).getFilterColumn();
        }
        return -1;
    }

    public void clearSecondTabFilter() {
        this.clearFilter(this.secondTabFilterText);
    }

    public void clearThirdTabFilter() {
        this.clearFilter(this.thirdTabFilterText);
    }

    public void clearFilter(JTextField jTextField) {
        if (jTextField != null) {
            for (JTable jTable : this.getTables()) {
                if (jTable.getRowCount() != jTable.getModel().getRowCount()) {
                    if (!"".equals(jTextField.getText())) {
                        jTextField.setText("");
                    }
                    jTable.clearSelection();
                    ((DefaultRowSorter)jTable.getRowSorter()).setRowFilter(null);
                    continue;
                }
                if ("".equals(jTextField.getText())) continue;
                jTextField.setText("");
            }
        }
    }

    protected JTable addTab(JTable jTable, List list, String string) {
        jTable = new JTable(new ObjectModel(list));
        jTable.setAutoCreateRowSorter(true);
        WindowsTableHeader.setSortedHeader(jTable);
        TableColumn tableColumn = jTable.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(50);
        tableColumn = jTable.getColumnModel().getColumn(1);
        tableColumn.setPreferredWidth(60);
        tableColumn = jTable.getColumnModel().getColumn(2);
        tableColumn.setPreferredWidth(60);
        JScrollPane jScrollPane = new JScrollPane(jTable);
        this.getTabbedPane().addTab(string, jScrollPane);
        return jTable;
    }

    /*
     * Exception decompiling
     */
    protected boolean getSchemas(boolean var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    protected boolean getDBObjects(boolean var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public RelationalDesign getRelationalDesign() {
        return this.relationalDesign;
    }

    public void setRelationalDesign(RelationalDesign relationalDesign) {
        this.relationalDesign = relationalDesign;
    }

    public RDBMSSite getRdbmsSite() {
        return this.rdbmsSite;
    }

    public void setRdbmsSite(RDBMSSite rDBMSSite) {
        this.rdbmsSite = rDBMSSite;
    }

    public void applySelectionForExisting(StorageDesign storageDesign, List list) {
        for (DBObject dBObject : list) {
            boolean bl;
            String string = dBObject.getType();
            RelationalObjectProxy relationalObjectProxy = null;
            String string2 = dBObject.getSchema();
            String string3 = dBObject.getName();
            boolean bl2 = bl = string2 != null && !"".equals(string2);
            if (bl) {
                if (string.equalsIgnoreCase(TABLE)) {
                    relationalObjectProxy = storageDesign.getTableProxySet().getByUserSchemaAndName(string2, string3);
                    if (relationalObjectProxy == null) {
                        relationalObjectProxy = storageDesign.getTableProxySet().getBySchemaRelAndName(string2, string3);
                    }
                } else if (string.equalsIgnoreCase(VIEW)) {
                    relationalObjectProxy = storageDesign.getTableViewProxySet().getBySchemaAndName(string2, string3);
                }
            }
            if (relationalObjectProxy == null) continue;
            dBObject.setSelected(true);
        }
    }

    public void applySelectionForExisting(RelationalDesign relationalDesign, RDBMSSite rDBMSSite, List list) {
        Iterator iterator = list.iterator();
        if (relationalDesign != null) {
            StorageDesign storageDesign = null;
            if (rDBMSSite != null) {
                storageDesign = relationalDesign.getStorageDesign(rDBMSSite);
            }
            if (storageDesign != null && storageDesign.isOpen()) {
                this.applySelectionForExisting(storageDesign, list);
            } else {
                while (iterator.hasNext()) {
                    ContainerObject containerObject;
                    DBObject dBObject = (DBObject)iterator.next();
                    String string = dBObject.getType();
                    boolean bl = dBObject.getSchema() != null && !"".equals(dBObject.getSchema());
                    if (!bl) continue;
                    if (string.equalsIgnoreCase(TABLE)) {
                        containerObject = null;
                        containerObject = relationalDesign.getTableSet().getBySchemaAndName(dBObject.getSchema(), dBObject.getName());
                        if (containerObject == null) {
                            containerObject = (Table)relationalDesign.getTableSet().getByName(dBObject.getName());
                        }
                        if (containerObject == null) continue;
                        dBObject.setSelected(true);
                        continue;
                    }
                    if (!string.equalsIgnoreCase(VIEW) || (containerObject = (TableView)relationalDesign.getTableViewSet().getBySchemaAndName(dBObject.getSchema(), dBObject.getName())) == null) continue;
                    dBObject.setSelected(true);
                }
            }
        }
    }

    protected void checkAll(JTable jTable, List<DBObject> list, boolean bl) {
        ListSelectionModel listSelectionModel = jTable.getSelectionModel();
        if (listSelectionModel.isSelectionEmpty()) {
            this.selectAll(jTable, list, bl);
        } else {
            for (int i = 0; i < list.size(); ++i) {
                if (!listSelectionModel.isSelectedIndex(i)) continue;
                list.get(i).setSelected(bl);
            }
        }
        jTable.updateUI();
    }

    protected void selectAll(JTable jTable, List<DBObject> list, boolean bl) {
        if (bl) {
            this.selectAll(jTable, list);
        } else {
            this.deselectAll(jTable, list);
        }
    }

    class ObjectModel
    extends AbstractTableModel {
        List list;

        public ObjectModel(List list) {
            this.list = list;
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return this.list.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("AbstractDBMExtractionWizardImpl.Selected");
            }
            if (n == 1) {
                return Messages.getString("AbstractDBMExtractionWizardImpl.Schema");
            }
            if (n == 2) {
                return Messages.getString("AbstractDBMExtractionWizardImpl.ObjectName");
            }
            return "";
        }

        public int getFilterColumn() {
            return 2;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        public Class getColumnClass(int n) {
            if (n == 0) {
                return Boolean.class;
            }
            return String.class;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n < this.list.size()) {
                DBObject dBObject = (DBObject)this.list.get(n);
                switch (n2) {
                    case 0: {
                        return dBObject.isSelected();
                    }
                    case 1: {
                        if ("SYNONYM".equalsIgnoreCase(dBObject.getType())) {
                            String string = MOHSynonymOracle.getSynonymObjectOwner(dBObject);
                            String string2 = dBObject.getSchema() + " / " + string;
                            return string2;
                        }
                        return dBObject.getSchema();
                    }
                    case 2: {
                        if ("SYNONYM".equalsIgnoreCase(dBObject.getType())) {
                            String string = MOHSynonymOracle.getSynonymObjectName(dBObject);
                            String string3 = dBObject.getName() + " / " + string;
                            return string3;
                        }
                        return dBObject.getName();
                    }
                }
                return new Integer(n * n2);
            }
            return null;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 0) {
                DBObject dBObject = (DBObject)this.list.get(n);
                AbstractDBMExtractionWizardImpl.this.setSelected(dBObject, (Boolean)object);
            }
        }
    }

    class SchemasModel
    extends AbstractTableModel {
        SchemasModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return AbstractDBMExtractionWizardImpl.this.lsSchemas.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("AbstractDBMExtractionWizardImpl.Selected");
            }
            if (n == 1) {
                return Messages.getString("AbstractDBMExtractionWizardImpl.Schema");
            }
            return "";
        }

        public int getFilterColumn() {
            return 1;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        public Class getColumnClass(int n) {
            if (n == 0) {
                return Boolean.class;
            }
            return String.class;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n < AbstractDBMExtractionWizardImpl.this.lsSchemas.size()) {
                DBObject dBObject = (DBObject)AbstractDBMExtractionWizardImpl.this.lsSchemas.get(n);
                switch (n2) {
                    case 0: {
                        return dBObject.isSelected();
                    }
                    case 1: {
                        return dBObject.getName();
                    }
                }
                return null;
            }
            return null;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 0) {
                DBObject dBObject = (DBObject)AbstractDBMExtractionWizardImpl.this.lsSchemas.get(n);
                AbstractDBMExtractionWizardImpl.this.setSelected(dBObject, (Boolean)object);
            }
        }
    }
}

