/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.wizards.cwddesigner;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import oracle.dbtools.crest.imports.cwddesigner.CWDDesignObj;
import oracle.dbtools.crest.imports.cwddesigner.CWDExtractionController;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.wizards.CustomWizard;
import oracle.dbtools.crest.swingui.wizards.Messages;
import oracle.dbtools.crest.swingui.wizards.cwddesigner.CWDOptionDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.ide.Ide;

public class CWDExtractionWizard
extends CustomWizard {
    private static final Font fontGrey = new Font("Dialog", 2, 12);
    private static final Font fontBlue = new Font("Dialog", 1, 12);
    private static final String DESCRIPTION_1 = Messages.getString("CWDExtractionWizard.SelectLogicalRelationalModelsToImport");
    private static final String DESCRIPTION_4 = Messages.getString("CWDExtractionWizard.ViewSummaryGenerateDesign");
    private static final String FIRST_PAGE = "FIRST_PAGE";
    private static final String FOURTH_PAGE = "FOURTH_PAGE";
    private static final Logger LOGGER = new Logger(CWDExtractionWizard.class);
    private int taskNbr = 1;
    private JPanel pnMain;
    protected JPanel firstPanel;
    private CardLayout cardLayout = new CardLayout();
    private JTextArea taDescription;
    private JLabel lbTask1;
    private String designName;
    private List lsModels = new ArrayList();
    private JTable tbModels;
    private CWDExtractionController controller;
    private Object[] relationals;
    private List lsTables = new ArrayList();
    protected JTabbedPane tpane;
    private JTable tbTables;
    private JTable tbViews;
    private List lsViews = new ArrayList();
    private JTable tbTypes;
    private List lsTypes = new ArrayList();
    private JLabel taSummary;
    private Object importFile;
    private JTable tbEntities;
    private List lsEntities = new ArrayList();
    private String prefix = "";
    private JPanel fourthPanel;
    private JLabel lbTask4;
    private List lsSubViews = new ArrayList();
    private JTable tbSubViews;

    public CWDExtractionWizard(ApplicationView applicationView, String string) {
        super(applicationView);
        this.designName = string;
    }

    public CWDExtractionWizard(ApplicationView applicationView, File file) {
        super(applicationView);
        this.importFile = file;
        this.relationals = applicationView.getCurrentDesign().getRelationalDesigns().toArray();
        this.prefix = this.getController().getCustomPrefix();
        this.loadTempDesign();
        this.pnMain.setLayout(this.cardLayout);
        this.firstPanel = this.initFirstTab();
        this.pnMain.add((Component)this.firstPanel, FIRST_PAGE);
        this.fourthPanel = this.initFourthTab();
        this.pnMain.add((Component)this.fourthPanel, FOURTH_PAGE);
        this.handleButtons();
    }

    private void loadTempDesign() {
        try {
            this.getController().loadTempDesign((File)this.getImportFile());
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("CWDExtractionWizard.UnableToGenerateDesign"), Messages.getString("CWDExtractionWizard.ErrorGenerateDesign"), 0);
            this.doClose();
        }
    }

    private ApplicationView getApplicationView() {
        return this.view;
    }

    @Override
    protected JPanel initMainPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBackground(Color.WHITE);
        ImageIcon imageIcon = (ImageIcon)GUIConfiguration.getInstance().getIcon("DBM_WIZARD_BANNER");
        jPanel2.add((Component)new JLabel(imageIcon), "West");
        this.taDescription = new JTextArea();
        this.taDescription.setEditable(false);
        this.taDescription.setFont(fontBlue);
        this.taDescription.setBackground(Color.WHITE);
        JPanel jPanel3 = new JPanel(new FlowLayout(1, 0, 25));
        jPanel3.setBackground(Color.WHITE);
        jPanel3.add(this.taDescription);
        jPanel2.add((Component)jPanel3, "Center");
        jPanel.add((Component)jPanel2, "North");
        JPanel jPanel4 = new JPanel(new GridLayout(0, 1));
        jPanel4.setBackground(Color.WHITE);
        jPanel4.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        this.lbTask1 = new JLabel(Messages.getString("CWDExtractionWizard.SelectModelsToImport"));
        this.lbTask4 = new JLabel(Messages.getString("CWDExtractionWizard.GenerateDesign"));
        jPanel4.add(this.lbTask1);
        jPanel4.add(this.lbTask4);
        jPanel4.add(new JLabel());
        jPanel4.add(new JLabel());
        jPanel4.add(new JLabel());
        jPanel4.add(new JLabel());
        jPanel4.add(new JLabel());
        jPanel4.add(new JLabel());
        jPanel4.add(new JLabel());
        jPanel4.setPreferredSize(new Dimension(200, 350));
        jPanel.add((Component)jPanel4, "West");
        this.pnMain = new JPanel();
        this.pnMain.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        this.pnMain.setPreferredSize(new Dimension(530, 350));
        jPanel.add((Component)this.pnMain, "Center");
        return jPanel;
    }

    public JPanel initFirstTab() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.lsModels = this.initDPObject();
        this.tbModels = new JTable(new DesignPartModel(this.lsModels));
        this.tbModels.setSelectionMode(0);
        TableColumn tableColumn = this.tbModels.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(10);
        tableColumn = this.tbModels.getColumnModel().getColumn(1);
        tableColumn.setPreferredWidth(100);
        tableColumn = this.tbModels.getColumnModel().getColumn(2);
        tableColumn.setPreferredWidth(100);
        tableColumn.setCellEditor(new DesignPartComboBoxEditor(this.relationals));
        JScrollPane jScrollPane = new JScrollPane(this.tbModels);
        jPanel.add((Component)jScrollPane, "Center");
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        JButton jButton = new JButton(Messages.getString("CWDExtractionWizard.SelectAll"));
        jButton.setMnemonic(83);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                for (CWDDesignObj cWDDesignObj : CWDExtractionWizard.this.lsModels) {
                    cWDDesignObj.setSelected(true);
                }
                CWDExtractionWizard.this.tbModels.updateUI();
                CWDExtractionWizard.this.bnNext.setEnabled(CWDExtractionWizard.this.hasModelSelected());
            }
        });
        JButton jButton2 = new JButton(Messages.getString("CWDExtractionWizard.DeselectAll"));
        jButton2.setMnemonic(68);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                for (CWDDesignObj cWDDesignObj : CWDExtractionWizard.this.lsModels) {
                    cWDDesignObj.setSelected(false);
                }
                CWDExtractionWizard.this.tbModels.updateUI();
                CWDExtractionWizard.this.bnNext.setEnabled(CWDExtractionWizard.this.hasModelSelected());
            }
        });
        jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE_EX);
        jButton2.setPreferredSize(MessageDialogs.BUTTON_SIZE_EX);
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        jPanel.add((Component)jPanel2, "South");
        this.tbModels.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                CWDExtractionWizard.this.bnNext.setEnabled(CWDExtractionWizard.this.hasModelSelected());
            }
        });
        this.tbModels.updateUI();
        return jPanel;
    }

    private boolean hasModelSelected() {
        for (CWDDesignObj cWDDesignObj : this.lsModels) {
            if (!cWDDesignObj.isSelected()) continue;
            return true;
        }
        return false;
    }

    private List initDPObject() {
        return this.getController().getDPObject();
    }

    public JPanel initSecondTab() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.tbSubViews = new JTable(new ObjectModel(this.lsSubViews));
        this.tbSubViews.setRowHeight(18);
        this.tbSubViews.setSelectionMode(0);
        TableColumn tableColumn = this.tbSubViews.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(10);
        tableColumn = this.tbSubViews.getColumnModel().getColumn(1);
        tableColumn.setPreferredWidth(100);
        tableColumn = this.tbSubViews.getColumnModel().getColumn(2);
        tableColumn.setPreferredWidth(100);
        JScrollPane jScrollPane = new JScrollPane(this.tbSubViews);
        jPanel.add((Component)jScrollPane, "Center");
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        JButton jButton = new JButton(Messages.getString("CWDExtractionWizard.SelectAll"));
        jButton.setMnemonic(83);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                for (CWDDesignObj cWDDesignObj : CWDExtractionWizard.this.lsSubViews) {
                    cWDDesignObj.setSelected(true);
                }
                CWDExtractionWizard.this.tbSubViews.updateUI();
            }
        });
        JButton jButton2 = new JButton(Messages.getString("CWDExtractionWizard.DeselectAll"));
        jButton2.setMnemonic(68);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                for (CWDDesignObj cWDDesignObj : CWDExtractionWizard.this.lsSubViews) {
                    cWDDesignObj.setSelected(false);
                }
                CWDExtractionWizard.this.tbSubViews.updateUI();
            }
        });
        Dimension dimension = new Dimension(120, 25);
        jButton.setPreferredSize(dimension);
        jButton2.setPreferredSize(dimension);
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        jPanel.add((Component)jPanel2, "South");
        this.tbSubViews.updateUI();
        return jPanel;
    }

    public JPanel initThirdTab() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.getTabbedPane(), "Center");
        this.addTabs();
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        JButton jButton = new JButton(Messages.getString("CWDExtractionWizard.SelectAll"));
        jButton.setMnemonic(83);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                for (CWDDesignObj cWDDesignObj : CWDExtractionWizard.this.getCurrentList()) {
                    cWDDesignObj.setSelected(true);
                }
                CWDExtractionWizard.this.updateTables();
            }
        });
        JButton jButton2 = new JButton(Messages.getString("CWDExtractionWizard.DeselectAll"));
        jButton2.setMnemonic(68);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                for (CWDDesignObj cWDDesignObj : CWDExtractionWizard.this.getCurrentList()) {
                    cWDDesignObj.setSelected(false);
                }
                CWDExtractionWizard.this.updateTables();
            }
        });
        JButton jButton3 = new JButton(Messages.getString("CWDExtractionWizard.Options"));
        jButton3.setMnemonic(79);
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CWDOptionDialog cWDOptionDialog = new CWDOptionDialog(CWDExtractionWizard.this.getApplicationView());
                cWDOptionDialog.initProperties(CWDExtractionWizard.this.prefix);
                int n = cWDOptionDialog.showDialog();
                if (n == 1) {
                    CWDExtractionWizard.this.getController().setCustomPrefix(cWDOptionDialog.getCustomPrefix());
                }
            }
        });
        Dimension dimension = new Dimension(120, 25);
        jButton.setPreferredSize(dimension);
        jButton2.setPreferredSize(dimension);
        jButton3.setPreferredSize(dimension);
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        jPanel2.add(jButton3);
        jPanel.add((Component)jPanel2, "South");
        return jPanel;
    }

    protected JPanel initFourthTab() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.taSummary = new JLabel();
        this.taSummary.setFont(this.taSummary.getFont().deriveFont(0));
        this.taSummary.setVerticalAlignment(1);
        jPanel.add((Component)this.taSummary, "Center");
        jPanel.add((Component)new JPanel(), "East");
        jPanel.add((Component)new JPanel(), "West");
        jPanel.add((Component)new JPanel(), "North");
        jPanel.add((Component)new JPanel(), "South");
        return jPanel;
    }

    private void updateTables() {
    }

    protected List getCurrentList() {
        int n = this.getTabbedPane().getSelectedIndex();
        switch (n) {
            case 0: {
                return this.lsTables;
            }
            case 1: {
                return this.lsEntities;
            }
            case 2: {
                return this.lsViews;
            }
            case 3: {
                return this.lsTypes;
            }
        }
        return this.lsTables;
    }

    protected void addTabs() {
        this.tbTables = this.addTab(this.tbTables, Messages.getString("CWDExtractionWizard.Tables"), new ObjectModel(this.lsTables));
        this.tbEntities = this.addTab(this.tbEntities, Messages.getString("CWDExtractionWizard.Entities"), new ObjectModel(this.lsEntities));
        this.tbViews = this.addTab(this.tbViews, Messages.getString("CWDExtractionWizard.Views"), new ObjectModel(this.lsViews));
        this.tbTypes = this.addTab(this.tbTypes, Messages.getString("CWDExtractionWizard.DataTypes"), new DataTypeModel(this.lsTypes));
    }

    protected JTable addTab(JTable jTable, String string, AbstractTableModel abstractTableModel) {
        jTable = new JTable(abstractTableModel);
        jTable.setSelectionMode(0);
        TableColumn tableColumn = jTable.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(10);
        tableColumn = jTable.getColumnModel().getColumn(1);
        tableColumn.setPreferredWidth(130);
        tableColumn = jTable.getColumnModel().getColumn(2);
        tableColumn.setPreferredWidth(130);
        JScrollPane jScrollPane = new JScrollPane(jTable);
        this.getTabbedPane().addTab(string, jScrollPane);
        return jTable;
    }

    protected JTabbedPane getTabbedPane() {
        if (this.tpane == null) {
            this.tpane = new JTabbedPane(3);
        }
        return this.tpane;
    }

    private void handleButtons() {
        this.handleLabels();
        this.handleDescription();
        switch (this.taskNbr) {
            case 1: {
                this.bnBack.setEnabled(false);
                this.bnNext.setEnabled(this.hasModelSelected());
                this.bnFinish.setEnabled(false);
                this.bnCancel.setEnabled(true);
                break;
            }
            case 2: {
                this.bnBack.setEnabled(true);
                this.bnNext.setEnabled(false);
                this.bnFinish.setEnabled(true);
                this.bnCancel.setEnabled(true);
            }
        }
    }

    private void handleLabels() {
        switch (this.taskNbr) {
            case 1: {
                this.setBlueLabel(this.lbTask1);
                this.setGreyLabel(this.lbTask4);
                break;
            }
            case 2: {
                this.setBlackLabel(this.lbTask1);
                this.setBlueLabel(this.lbTask4);
                break;
            }
            default: {
                this.setBlueLabel(this.lbTask1);
                this.setGreyLabel(this.lbTask4);
            }
        }
    }

    private void setGreyLabel(JLabel jLabel) {
        jLabel.setForeground(Color.LIGHT_GRAY);
        jLabel.setFont(fontGrey);
    }

    private void setBlueLabel(JLabel jLabel) {
        jLabel.setForeground(Color.BLUE);
        jLabel.setFont(fontBlue);
    }

    private void setBlackLabel(JLabel jLabel) {
        jLabel.setForeground(Color.BLACK);
        jLabel.setFont(fontBlue);
    }

    private void handleDescription() {
        switch (this.taskNbr) {
            case 1: {
                this.taDescription.setText(DESCRIPTION_1);
                break;
            }
            case 2: {
                this.taDescription.setText(DESCRIPTION_4);
                break;
            }
            default: {
                this.taDescription.setText(DESCRIPTION_1);
            }
        }
    }

    @Override
    protected String getCaption() {
        return Messages.getString("CWDExtractionWizard.DataModelingDesignImportWizard");
    }

    @Override
    protected void doBack() {
        --this.taskNbr;
        try {
            if (this.performTask(false)) {
                this.handleButtons();
                switch (this.taskNbr) {
                    case 1: {
                        this.cardLayout.show(this.pnMain, FIRST_PAGE);
                        break;
                    }
                    case 2: {
                        this.cardLayout.show(this.pnMain, FOURTH_PAGE);
                    }
                }
            } else {
                ++this.taskNbr;
            }
        }
        catch (Throwable throwable) {
            ++this.taskNbr;
            JOptionPane.showMessageDialog(this, throwable.getMessage(), Messages.getString("CWDExtractionWizard.Error"), 0);
            LOGGER.error(throwable);
        }
    }

    private boolean performTask(boolean bl) {
        switch (this.taskNbr) {
            case 2: {
                this.initSubViews(bl);
                return this.getSummary();
            }
        }
        return true;
    }

    private Map getSummaryList() {
        TreeMap<String, Integer> treeMap = new TreeMap<String, Integer>();
        for (CWDDesignObj cWDDesignObj : this.getSelectedObjects()) {
            if (!cWDDesignObj.isSelected()) continue;
            if (treeMap.containsKey(cWDDesignObj.getType())) {
                Integer n = (Integer)treeMap.get(cWDDesignObj.getType());
                int n2 = n;
                treeMap.put(cWDDesignObj.getType(), new Integer(++n2));
                continue;
            }
            treeMap.put(cWDDesignObj.getType(), new Integer(1));
        }
        return treeMap;
    }

    private String addTableRow(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<tr>");
        stringBuffer.append("<td width=\"150\">");
        stringBuffer.append("<p>");
        stringBuffer.append(string);
        stringBuffer.append("</p>");
        stringBuffer.append("</td>");
        stringBuffer.append("<td width=\"60\" align=\"right\">");
        stringBuffer.append("<p>");
        stringBuffer.append(string2);
        stringBuffer.append("</p>");
        stringBuffer.append("</td>");
        stringBuffer.append("</tr>");
        return stringBuffer.toString();
    }

    private boolean getSummary() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<html>");
        stringBuffer.append("<body>");
        stringBuffer.append("<p>");
        stringBuffer.append("<b>");
        stringBuffer.append(Messages.getString("CWDExtractionWizard.ModelsImported"));
        stringBuffer.append("</b>");
        stringBuffer.append("</p>");
        stringBuffer.append("<table border=\"0\" width=\"170\">");
        Map map = this.getSummaryList();
        Object[] objectArray = map.keySet().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            String string = (String)objectArray[i];
            Integer n = (Integer)map.get(objectArray[i]);
            stringBuffer.append(this.addTableRow(string, n.toString()));
        }
        stringBuffer.append("</table>");
        stringBuffer.append("</body>");
        stringBuffer.append("</html>");
        this.taSummary.setText(stringBuffer.toString());
        return true;
    }

    public CWDExtractionController getController() {
        if (this.controller == null) {
            this.controller = new CWDExtractionController(this.view);
        }
        return this.controller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initSubViews(boolean bl) {
        if (bl) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                this.clearAll();
                try {
                    ApplicationView.loading = true;
                    List list = this.getController().loadDesign(this.getSelectedModels());
                    if (list.size() > 0) {
                        this.initSpecificObjects(list);
                    }
                    this.updateTables();
                    boolean bl2 = true;
                    return bl2;
                }
                catch (Exception exception) {
                    MessageDialogs.showErrorMessage(this, exception.getMessage());
                    LOGGER.error(exception);
                    this.updateTables();
                    boolean bl3 = false;
                    ApplicationView.loading = false;
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    return bl3;
                }
            }
            finally {
                ApplicationView.loading = false;
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
        return true;
    }

    public boolean initModels(boolean bl) {
        return this.getModels(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean getModels(boolean bl) {
        if (bl) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                this.clearAll();
                try {
                    List list = this.getController().loadDesign(this.getSelectedModels());
                    if (list.size() > 0) {
                        this.initSpecificObjects(list);
                    }
                    this.updateTables();
                    boolean bl2 = true;
                    return bl2;
                }
                catch (Exception exception) {
                    MessageDialogs.showErrorMessage(this, exception.getMessage());
                    LOGGER.error(exception);
                    this.updateTables();
                    boolean bl3 = false;
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    return bl3;
                }
            }
            finally {
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
        return true;
    }

    private void initSpecificObjects(List list) {
        this.clearAll();
    }

    private void clearAll() {
        this.lsSubViews.clear();
    }

    @Override
    protected void doNext() {
        ++this.taskNbr;
        try {
            if (this.performTask(true)) {
                this.handleButtons();
                switch (this.taskNbr) {
                    case 2: {
                        this.cardLayout.show(this.pnMain, FOURTH_PAGE);
                    }
                }
            } else {
                --this.taskNbr;
            }
        }
        catch (Throwable throwable) {
            --this.taskNbr;
            JOptionPane.showMessageDialog(this, throwable.getMessage(), Messages.getString("CWDExtractionWizard.ErrorGenerateDesign"), 0);
            LOGGER.error(throwable);
        }
    }

    private List getSelectedModels() {
        ArrayList<CWDDesignObj> arrayList = new ArrayList<CWDDesignObj>();
        for (CWDDesignObj cWDDesignObj : this.lsModels) {
            if (!cWDDesignObj.isSelected()) continue;
            arrayList.add(cWDDesignObj);
        }
        return arrayList;
    }

    public List getSelectedObjects() {
        ArrayList<CWDDesignObj> arrayList = new ArrayList<CWDDesignObj>();
        for (CWDDesignObj cWDDesignObj : this.lsModels) {
            if (!cWDDesignObj.isSelected()) continue;
            arrayList.add(cWDDesignObj);
        }
        for (CWDDesignObj cWDDesignObj : this.lsSubViews) {
            if (!cWDDesignObj.isSelected()) continue;
            arrayList.add(cWDDesignObj);
        }
        return arrayList;
    }

    public List getUnSelectedObjects() {
        ArrayList<CWDDesignObj> arrayList = new ArrayList<CWDDesignObj>();
        for (CWDDesignObj cWDDesignObj : this.lsModels) {
            if (cWDDesignObj.isSelected()) continue;
            arrayList.add(cWDDesignObj);
        }
        for (CWDDesignObj cWDDesignObj : this.lsTables) {
            if (cWDDesignObj.isSelected()) continue;
            arrayList.add(cWDDesignObj);
        }
        for (CWDDesignObj cWDDesignObj : this.lsEntities) {
            if (cWDDesignObj.isSelected()) continue;
            arrayList.add(cWDDesignObj);
        }
        for (CWDDesignObj cWDDesignObj : this.lsViews) {
            if (cWDDesignObj.isSelected()) continue;
            arrayList.add(cWDDesignObj);
        }
        for (CWDDesignObj cWDDesignObj : this.lsTypes) {
            if (cWDDesignObj.isSelected()) continue;
            arrayList.add(cWDDesignObj);
        }
        return arrayList;
    }

    public List getAllObjects() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.lsTables);
        arrayList.addAll(this.lsViews);
        arrayList.addAll(this.lsTypes);
        return arrayList;
    }

    @Override
    protected void doFinish() {
        this.getController().initDesignHandler(this.lsModels, this.lsSubViews);
        this.dispose();
        this.getController().insertDesign();
    }

    @Override
    protected void doCancel() {
        this.dispose();
        this.getController().getExtractionHandler().clearCWDHObjects();
        this.getController().removeTempDesign();
    }

    protected void doClose() {
        this.dispose();
        this.getController().getExtractionHandler().clearCWDHObjects();
        this.getController().removeTempDesign();
    }

    public String getDesignName() {
        return this.designName;
    }

    public void setDesignName(String string) {
        this.designName = string;
    }

    public Object getImportFile() {
        return this.importFile;
    }

    public void setImportFile(Object object) {
        this.importFile = object;
    }

    @Override
    protected String getHelpIndex() {
        return "IMPORT_CWD4ALL_DESIGN_WIZARD";
    }

    class DataTypeModel
    extends AbstractTableModel {
        List list;

        public DataTypeModel(List list) {
            this.list = list;
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public int getRowCount() {
            return this.list.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("CWDExtractionWizard.Selected");
            }
            if (n == 1) {
                return Messages.getString("CWDExtractionWizard.Name");
            }
            if (n == 2) {
                return Messages.getString("CWDExtractionWizard.Type");
            }
            if (n == 3) {
                return Messages.getString("CWDExtractionWizard.Status");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            CWDDesignObj cWDDesignObj = (CWDDesignObj)this.list.get(n);
            switch (n2) {
                case 0: {
                    return cWDDesignObj.isSelected();
                }
                case 1: {
                    return cWDDesignObj.getObject();
                }
                case 2: {
                    return cWDDesignObj.getType();
                }
                case 3: {
                    return cWDDesignObj.getStatus();
                }
            }
            return new Integer(n * n2);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 0) {
                CWDDesignObj cWDDesignObj = (CWDDesignObj)this.list.get(n);
                cWDDesignObj.setSelected((Boolean)object);
            }
        }
    }

    class DesignPartModel
    extends AbstractTableModel {
        List list;

        public DesignPartModel(List list) {
            this.list = list;
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return this.list.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("CWDExtractionWizard.Selected");
            }
            if (n == 1) {
                return Messages.getString("CWDExtractionWizard.Model");
            }
            if (n == 2) {
                return Messages.getString("CWDExtractionWizard.ImportTo");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            if (n2 == 0) {
                return true;
            }
            return n != 0 && (n2 == 1 || n2 == 2);
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            CWDDesignObj cWDDesignObj = (CWDDesignObj)this.list.get(n);
            switch (n2) {
                case 0: {
                    return cWDDesignObj.isSelected();
                }
                case 1: {
                    return cWDDesignObj.getModel();
                }
                case 2: {
                    return cWDDesignObj.getImportTo();
                }
            }
            return new Integer(n * n2);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            CWDDesignObj cWDDesignObj;
            if (n2 == 0) {
                cWDDesignObj = (CWDDesignObj)this.list.get(n);
                cWDDesignObj.setSelected((Boolean)object);
                CWDExtractionWizard.this.bnNext.setEnabled(CWDExtractionWizard.this.hasModelSelected());
            }
            if (n2 == 2) {
                cWDDesignObj = (CWDDesignObj)this.list.get(n);
                cWDDesignObj.setImportTo(object);
            }
        }
    }

    class ObjectModel
    extends AbstractTableModel {
        List list;

        public ObjectModel(List list) {
            this.list = list;
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public int getRowCount() {
            return this.list.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("CWDExtractionWizard.Selected");
            }
            if (n == 1) {
                return Messages.getString("CWDExtractionWizard.Model");
            }
            if (n == 2) {
                return Messages.getString("CWDExtractionWizard.Name");
            }
            if (n == 3) {
                return Messages.getString("CWDExtractionWizard.Status");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            if (n2 == 0) {
                return true;
            }
            return n != 0 && (n2 == 1 || n2 == 2);
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            CWDDesignObj cWDDesignObj = (CWDDesignObj)this.list.get(n);
            switch (n2) {
                case 0: {
                    return cWDDesignObj.isSelected();
                }
                case 1: {
                    return cWDDesignObj.getModel();
                }
                case 2: {
                    return cWDDesignObj.getObject();
                }
                case 3: {
                    return cWDDesignObj.getStatus();
                }
            }
            return new Integer(n * n2);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            CWDDesignObj cWDDesignObj;
            if (n2 == 0) {
                cWDDesignObj = (CWDDesignObj)this.list.get(n);
                cWDDesignObj.setSelected((Boolean)object);
            }
            if (n2 == 2) {
                cWDDesignObj = (CWDDesignObj)this.list.get(n);
                cWDDesignObj.setImportTo(object);
            }
        }
    }

    public class DesignPartComboBoxEditor
    extends DefaultCellEditor {
        private JComboBox cbox;

        public DesignPartComboBoxEditor(Object[] objectArray) {
            super(new JComboBox<Object>(objectArray));
            this.cbox = (JComboBox)this.getComponent();
            this.cbox.addItem(Messages.getString("CWDExtractionWizard.NewRelational"));
        }
    }
}

