/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.wizards;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import oracle.dbtools.crest.imports.MappingDatatypeNameLogicalDataType;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.relational.ApplyNamingStandards;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.ColumnView;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.relational.TableViewSet;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.wizards.CustomTableModel;
import oracle.dbtools.crest.swingui.wizards.Messages;
import oracle.dbtools.crest.swingui.wizards.Table2ViewDialog;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.logging.Logger;

public class View2TableDialog
extends CustomDialog {
    public static final String VIEW_OBJECT_ID = "view.object_id";
    public static final String VIEW_SQL = "view.sql";
    public static final String OPEN_BRACKET = "(";
    private JButton btnGenerate;
    private JButton btnClose;
    private JComboBox cmbRelationals;
    private JButton bnSelectAll;
    private JButton bnDeselectAll;
    private JScrollPane spnViews;
    private JTable tblViews;
    private String title;
    private JDialog dialog;
    private static final Logger LOGGER = new Logger(Table2ViewDialog.class);
    private JTextField tfNamingRule;
    private JButton btnAddVariable;

    public View2TableDialog(ApplicationView applicationView, String string) {
        super(applicationView);
        this.title = string;
        this.setLayout(new BorderLayout());
        this.cmbRelationals = new JComboBox();
        this.bnSelectAll = new JButton(Messages.getString("Table2ViewDialog.SelectAll"));
        this.bnSelectAll.setMnemonic(65);
        this.bnSelectAll.setPreferredSize(MessageDialogs.BUTTON_SIZE_160);
        this.bnSelectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                View2TableDialog.this.selectAllRows(true);
            }
        });
        this.bnDeselectAll = new JButton(Messages.getString("Table2ViewDialog.DeselectAll"));
        this.bnDeselectAll.setMnemonic(68);
        this.bnDeselectAll.setPreferredSize(MessageDialogs.BUTTON_SIZE_180);
        this.bnDeselectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                View2TableDialog.this.selectAllRows(false);
            }
        });
        this.spnViews = new JScrollPane();
        this.tblViews = new JTable();
        this.add((Component)this.makeTopPanel(), "North");
        this.add(this.makeCenterPanel(), "Center");
        this.add(this.makeDialogButtonsPanel(), "South");
    }

    @Override
    protected String getHelpIndex() {
        return "VIEW_TO_TABLE_WIZARD";
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog(this.getApplicationView().getFrame(), this.title, true);
            this.dialog.getContentPane().add(this);
            this.setDefaultActions(this.dialog);
            this.addListeners();
            this.dialog.setResizable(true);
            this.dialog.pack();
        }
        return this.dialog;
    }

    public void showDialog() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.refreshComponents();
        this.getDialog().setVisible(true);
    }

    private void refreshComponents() {
        DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this.cmbRelationals.getModel();
        ActionListener[] actionListenerArray = this.cmbRelationals.getActionListeners();
        for (int i = 0; i < actionListenerArray.length; ++i) {
            this.cmbRelationals.removeActionListener(actionListenerArray[i]);
        }
        defaultComboBoxModel.removeAllElements();
        Object[] objectArray = this.getApplicationView().getCurrentDesign().getRelationalDesigns().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            defaultComboBoxModel.addElement(objectArray[i]);
        }
        this.cmbRelationals.setEditable(false);
        RelationalDesign relationalDesign = (RelationalDesign)this.cmbRelationals.getSelectedItem();
        this.tblViews.setModel(new CustomTableModel(relationalDesign.getTableViewSet()));
        this.setTableWidths();
        for (int i = 0; i < actionListenerArray.length; ++i) {
            this.cmbRelationals.addActionListener(actionListenerArray[i]);
        }
        this.handleGenerateButton();
    }

    private void addListeners() {
        this.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                View2TableDialog.this.close();
            }
        });
        this.btnGenerate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                View2TableDialog.this.generateTables();
            }
        });
        this.cmbRelationals.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                View2TableDialog.this.loadNewViewSet();
            }
        });
    }

    protected void loadNewViewSet() {
        try {
            RelationalDesign relationalDesign = (RelationalDesign)this.cmbRelationals.getSelectedItem();
            CustomTableModel customTableModel = new CustomTableModel(relationalDesign.getTableViewSet());
            this.tblViews.setModel(customTableModel);
            this.setTableWidths();
            this.handleGenerateButton();
        }
        catch (ClassCastException classCastException) {
            LOGGER.error("ERROR::View2TableDialog::loadNewViewSet() -> ClassCastException", classCastException);
        }
    }

    protected void selectAllRows(boolean bl) {
        CustomTableModel customTableModel = (CustomTableModel)this.tblViews.getModel();
        int n = customTableModel != null ? customTableModel.getRowCount() : 0;
        for (int i = 0; i < n; ++i) {
            customTableModel.setValueAt(new Boolean(bl), i, 0);
        }
        this.tblViews.invalidate();
        this.tblViews.repaint();
        this.handleGenerateButton();
    }

    private void handleGenerateButton() {
        CustomTableModel customTableModel = (CustomTableModel)this.tblViews.getModel();
        int n = customTableModel != null ? customTableModel.getRowCount() : 0;
        for (int i = 0; i < n; ++i) {
            Boolean bl = (Boolean)customTableModel.getValueAt(i, 0);
            if (!bl.booleanValue()) continue;
            this.btnGenerate.setEnabled(true);
            return;
        }
        this.btnGenerate.setEnabled(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateTables() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        ApplicationView.canLogging = false;
        try {
            CustomTableModel customTableModel = (CustomTableModel)this.tblViews.getModel();
            int n = customTableModel != null ? customTableModel.getRowCount() : 0;
            Boolean bl = null;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            try {
                Object object2;
                for (int i = 0; i < n; ++i) {
                    bl = (Boolean)customTableModel.getValueAt(i, 0);
                    if (!bl.booleanValue()) continue;
                    arrayList.add(customTableModel.getElementAt(i, 1));
                }
                RelationalDesign relationalDesign = (RelationalDesign)this.cmbRelationals.getSelectedItem();
                ArrayList<Table> arrayList2 = new ArrayList<Table>();
                for (Object object2 : arrayList) {
                    arrayList2.add(this.addTable((TableView)object2, relationalDesign, new Rectangle(0, 0)));
                }
                object2 = relationalDesign.getMainView().getWorkSpace().getDiagramBounds();
                if (object2 != null) {
                    Rectangle rectangle = ((RectangularShape)object2).getBounds();
                    this.rearrangeTables(rectangle, arrayList2);
                }
                relationalDesign.setDirty(true);
                JOptionPane.showMessageDialog(this, Messages.getString("View2TableDialog.TablesGeneratedSuccessfully"));
            }
            catch (ClassCastException classCastException) {
                LOGGER.error("ERROR::View2TableDialog::generateTables() -> ClassCastException", classCastException);
                JOptionPane.showMessageDialog(this, Messages.getString("View2TableDialog.ErrorOccuredWhileGeneratingTables"));
                ApplicationView.canLogging = true;
                this.setCursor(Cursor.getPredefinedCursor(0));
                return;
            }
        }
        finally {
            ApplicationView.canLogging = true;
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private void rearrangeTables(Rectangle rectangle, List list) {
        int n = 20;
        int n2 = 50;
        int n3 = 50;
        int n4 = 200;
        int n5 = 80;
        int n6 = n;
        int n7 = (int)Math.round(rectangle.getMaxY()) + n3;
        int n8 = 0;
        if (list != null && list.size() > 0) {
            Iterator iterator = list.iterator();
            n8 = 0;
            int n9 = ((int)rectangle.getMaxX() - n) / (n4 + n2);
            if (n9 > n4) {
                ++n9;
            }
            int n10 = (int)Math.floor(n9);
            while (iterator.hasNext()) {
                Table table = (Table)iterator.next();
                TopView topView = table.getTopView();
                if (topView == null) continue;
                ++n8;
                Rectangle rectangle2 = topView.getBounds();
                if (topView.getCellView() != null) {
                    topView.getCellView().setNewBounds(new Rectangle(n6, n7, rectangle2.width, rectangle2.height));
                }
                n6 = n6 + rectangle2.width + n2;
                n5 = Math.max(n5, rectangle2.height);
                if (n8 != n10) continue;
                n8 = 0;
                n6 = n;
                n7 = n7 + n5 + n3;
                n5 = 80;
            }
        }
    }

    private Table addTable(TableView tableView, RelationalDesign relationalDesign, Rectangle rectangle) {
        Object object2;
        Table table = relationalDesign.getTableSet().createTable(null);
        String string = ApplyNamingStandards.createTableName(tableView.getName(), this.tfNamingRule.getText(), tableView.getDesignPart().getName());
        this.getApplicationView().getSettings().setTableNamingRule(this.tfNamingRule.getText());
        ApplicationView.log(Messages.getString("View2TableDialog.CreateTable") + " - " + string);
        table.setName(string);
        table.setProperty(VIEW_OBJECT_ID, tableView.getObjectID());
        table.setProperty(VIEW_SQL, tableView.getUserDefinedSQL());
        if (tableView.isBST()) {
            table.setBasedOnStructuredType(tableView.getBasedOnStructuredType());
        } else {
            for (Object object2 : tableView.getElementsCollection()) {
                Object object3;
                String string2;
                Column column = table.createColumn();
                ((DesignObject)object2).copyDefaults(column);
                if (!(object2 instanceof ColumnView)) continue;
                String string3 = ((ColumnView)object2).getDataType();
                String string4 = string3.trim();
                String string5 = null;
                if (Token.getFirstToken(string3).equals("INTERVAL")) {
                    string4 = Token.cutTokenFromFront(string3, "INTERVAL").startsWith("YEAR") ? "INTERVAL YEAR TO MONTH" : "INTERVAL DAY TO SECOND";
                } else if (string3.startsWith("SYS.XMLTYPE")) {
                    string4 = "XMLTYPE";
                }
                if (string4.equals("INTERVAL YEAR TO MONTH")) {
                    string2 = "2";
                    if ((string3 = Token.getStringAfter(string3, "YEAR")).startsWith(OPEN_BRACKET)) {
                        string2 = Token.getValBetweenBrackets(string3, 1).trim();
                    }
                    column.setDataTypeParameter("precision", string2);
                } else if (string4.equals("INTERVAL DAY TO SECOND")) {
                    string2 = "2";
                    object3 = "6";
                    if ((string3 = Token.getStringAfter(string3, "DAY")).startsWith(OPEN_BRACKET)) {
                        string2 = Token.getValBetweenBrackets(string3, 1).trim();
                    }
                    if ((string3 = Token.getStringAfter(string3, "SECOND")).startsWith(OPEN_BRACKET)) {
                        object3 = Token.getValBetweenBrackets(string3, 1).trim();
                    }
                    column.setDataTypeParameter("precision", string2);
                    column.setDataTypeParameter("scale", (String)object3);
                } else if (Token.hasCloseAndOpenBrackets(string3)) {
                    string4 = Token.getValBeforeBrackets(string3);
                    string5 = Token.getValBetweenBrackets(string3);
                }
                string2 = StandardDatatypeNames.getUsedDatatypeName(string4);
                string2 = StandardDatatypeNames.getTransformedDatatypeName(string2, relationalDesign.getSelectedRDBMSType());
                object3 = MappingDatatypeNameLogicalDataType.getLogicalDatatype(relationalDesign.getSelectedRDBMSType(), string2);
                column.setLogicalDatatype((LogicalDatatype)object3);
                column.setUse((short)1);
                if (string5 == null) continue;
                int n = string5.indexOf(",");
                if (n != -1) {
                    column.setDataTypeParameter("size", "0");
                    column.setDataTypeParameter("precision", string5.substring(0, n).trim());
                    column.setDataTypeParameter("scale", string5.substring(n + 1).trim());
                    continue;
                }
                if (StandardDatatypeNames.isPackedSized(string4)) {
                    column.setDataTypeParameter("size", "0");
                    column.setDataTypeParameter("precision", string5.trim());
                    column.setDataTypeParameter("scale", "0");
                    continue;
                }
                column.setDataTypeParameter("size", string5.trim());
                column.setDataTypeParameter("precision", "0");
                column.setDataTypeParameter("scale", "0");
            }
        }
        TopView topView = relationalDesign.getMainView().getViewFor(table);
        object2 = relationalDesign.getTableSize(table);
        if (topView != null && topView.getCellView() != null) {
            rectangle.width = ((Dimension)object2).width;
            rectangle.height = ((Dimension)object2).height;
            topView.getCellView().setNewBounds(rectangle);
        }
        return table;
    }

    private Component makeCenterPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.makeTable(), "Center");
        jPanel.add((Component)this.makeNamingRule(), "South");
        return jPanel;
    }

    private Component makeDialogButtonsPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(2));
        this.btnGenerate = new JButton(Messages.getString("Table2ViewDialog.Generate"));
        this.btnGenerate.setMnemonic(71);
        this.btnClose = new JButton(Messages.getString("Table2ViewDialog.Close"));
        this.btnClose.setMnemonic(67);
        this.btnGenerate.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.btnClose.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        JButton jButton = new JButton(this.getHelpAction());
        jButton.setMnemonic(72);
        jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jPanel.add(this.btnGenerate);
        jPanel.add(this.btnClose);
        jPanel.add(jButton);
        return jPanel;
    }

    private JComponent makeTopPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(0));
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
        this.cmbRelationals.setModel(defaultComboBoxModel);
        this.cmbRelationals.setEditable(false);
        this.cmbRelationals.setPreferredSize(new Dimension(250, 23));
        JPanel jPanel2 = new JPanel(new FlowLayout(2));
        jPanel2.add(this.bnSelectAll);
        jPanel2.add(this.bnDeselectAll);
        jPanel.add(this.cmbRelationals);
        jPanel.add(jPanel2);
        return jPanel;
    }

    private JComponent makeTable() {
        this.tblViews.getSelectionModel().setSelectionMode(0);
        this.tblViews.setCellSelectionEnabled(false);
        this.tblViews.setRowSelectionAllowed(true);
        this.tblViews.setColumnSelectionAllowed(false);
        this.tblViews.setBorder(LineBorder.createBlackLineBorder());
        this.tblViews.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                View2TableDialog.this.handleGenerateButton();
            }
        });
        CustomTableModel customTableModel = new CustomTableModel(new TableViewSet(null));
        this.tblViews.setModel(customTableModel);
        this.setTableWidths();
        this.spnViews.setViewportView(this.tblViews);
        return this.spnViews;
    }

    private void setTableWidths() {
        CustomTableModel customTableModel = (CustomTableModel)this.tblViews.getModel();
        Enumeration<TableColumn> enumeration = this.tblViews.getColumnModel().getColumns();
        int n = 0;
        FontMetrics fontMetrics = this.tblViews.getFontMetrics(this.tblViews.getFont());
        String string = "default";
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            if (n == 0 && enumeration.hasMoreElements()) {
                string = customTableModel.getColumnName(n);
                int n2 = fontMetrics.stringWidth(string) + 20;
                tableColumn.setMaxWidth(n2);
            }
            ++n;
        }
    }

    private JComponent makeNamingRule() {
        JPanel jPanel = new JPanel(new FlowLayout(0));
        JLabel jLabel = new JLabel(Messages.getString("Table2ViewDialog.NamingRule"));
        jLabel.setHorizontalAlignment(4);
        jPanel.add(jLabel);
        this.tfNamingRule = new JTextField();
        this.tfNamingRule.setText(this.getApplicationView().getSettings().getTableNamingRule());
        this.tfNamingRule.setPreferredSize(new Dimension(250, 23));
        jPanel.add(this.tfNamingRule);
        this.btnAddVariable = new JButton(Messages.getString("Table2ViewDialog.AddVariable"));
        this.btnAddVariable.setMnemonic(86);
        this.btnAddVariable.setPreferredSize(MessageDialogs.BUTTON_SIZE_EX);
        this.btnAddVariable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String[][] stringArray = new String[][]{{"{model}", "model name"}, {"{view}", "view name"}};
                View2TableDialog.this.createDialog(stringArray, View2TableDialog.this.tfNamingRule);
            }
        });
        jPanel.add(this.btnAddVariable);
        return jPanel;
    }

    private void createDialog(String[][] stringArray, JTextField jTextField) {
        KeyDialog keyDialog = new KeyDialog(this.getApplicationView());
        keyDialog.setValues(stringArray);
        keyDialog.setVisible(true);
        StringBuffer stringBuffer = new StringBuffer();
        int n = jTextField.getCaretPosition();
        int n2 = jTextField.getText().length();
        if (n == 0) {
            stringBuffer.append(keyDialog.getProviderName());
        }
        if (n2 != 0) {
            for (int i = 0; i < n2; ++i) {
                String string;
                stringBuffer.append(jTextField.getText().charAt(i));
                if (n != i + 1 || (string = keyDialog.getProviderName()) == null) continue;
                stringBuffer.append(string);
            }
            jTextField.setText(stringBuffer.toString());
        } else {
            jTextField.setText(keyDialog.getProviderName());
        }
    }

    private class KeyDialog
    extends JDialog {
        private JTable nameTable;
        private JScrollPane pane;
        private JPanel buttonsPanel;
        private String[][] values;
        private NameProvider provider;

        public KeyDialog(ApplicationView applicationView) {
            super(applicationView.getFrame());
            this.values = new String[0][];
            this.provider = new NameProvider();
            this.setTitle(Messages.getString("Table2ViewDialog.NameElementProvider"));
            this.nameTable = new JTable(new KeyTableModel());
            this.nameTable.setSelectionMode(0);
            this.nameTable.setTableHeader(null);
            this.pane = new JScrollPane(this.nameTable);
            this.pane.setPreferredSize(new Dimension(350, 100));
            this.getContentPane().add(this.pane);
            this.getContentPane().add((Component)this.getButtonPanel(), "South");
            this.setResizable(false);
            this.setModal(true);
            this.pack();
            CommonUtil.centerOnScreen(this);
        }

        protected JPanel getButtonPanel() {
            if (this.buttonsPanel == null) {
                this.buttonsPanel = new JPanel();
                JButton jButton = new JButton(Messages.getString("Table2ViewDialog.OK"));
                jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
                jButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (KeyDialog.this.nameTable.getSelectedRow() != -1) {
                            KeyDialog.this.provider.setName(KeyDialog.this.nameTable.getValueAt(KeyDialog.this.nameTable.getSelectedRow(), 0).toString());
                        }
                        KeyDialog.this.dispose();
                    }
                });
                JButton jButton2 = new JButton(Messages.getString("Table2ViewDialog.Cancel"));
                jButton2.setPreferredSize(MessageDialogs.BUTTON_SIZE);
                jButton2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        KeyDialog.this.dispose();
                    }
                });
                this.buttonsPanel.add(jButton);
                this.buttonsPanel.add(jButton2);
            }
            return this.buttonsPanel;
        }

        public String getProviderName() {
            return this.provider.getName();
        }

        public void setValues(String[][] stringArray) {
            this.values = stringArray;
        }

        class KeyTableModel
        extends AbstractTableModel {
            KeyTableModel() {
            }

            @Override
            public int getColumnCount() {
                return 2;
            }

            @Override
            public int getRowCount() {
                return KeyDialog.this.values.length;
            }

            @Override
            public Object getValueAt(int n, int n2) {
                return KeyDialog.this.values[n][n2];
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        }
    }

    class NameProvider {
        private String name;

        NameProvider() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }
    }
}

