/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.wizards;

import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.relational.TableViewSet;
import oracle.dbtools.crest.swingui.wizards.Messages;

class CustomTableModel
extends AbstractTableModel {
    private TableViewSet mdlData = null;
    private ArrayList checkedState = null;
    private Class[] columnTypes = new Class[]{Boolean.class, Object.class};
    private String[] columnNames = new String[]{Messages.getString("Table2ViewDialog.Selected"), Messages.getString("View2TableDialog.Views")};
    private boolean[] columnEditable = new boolean[]{true, false};

    public CustomTableModel(TableViewSet tableViewSet) {
        this.mdlData = tableViewSet;
        this.initCheckedState();
    }

    private void initCheckedState() {
        if (this.mdlData != null) {
            int n = this.mdlData.size();
            this.checkedState = new ArrayList(n);
            for (int i = 0; i < n; ++i) {
                this.checkedState.add(i, new Boolean(true));
            }
        }
    }

    public Class getColumnClass(int n) {
        return this.columnTypes[n];
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return this.columnEditable[n2];
    }

    @Override
    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.mdlData != null ? this.mdlData.size() : -1;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (this.getColumnClass(n2).equals(Boolean.class)) {
            return this.checkedState.get(n);
        }
        if (this.getColumnClass(n2).equals(Object.class)) {
            TableView tableView = (TableView)this.mdlData.getElement(n);
            return tableView.getName();
        }
        return new String("Unexpected class at: " + n + " " + n2);
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (this.isCellEditable(n, n2) && this.getColumnClass(n2).equals(Boolean.class)) {
            this.checkedState.set(n, object);
        }
    }

    public Object getElementAt(int n, int n2) {
        return this.mdlData.getElement(n);
    }

    public boolean[] getColumnEditable() {
        return this.columnEditable;
    }

    public void setColumnEditable(boolean[] blArray) {
        this.columnEditable = blArray;
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public void setColumnNames(String[] stringArray) {
        this.columnNames = stringArray;
    }

    public Class[] getColumnTypes() {
        return this.columnTypes;
    }

    public void setColumnTypes(Class[] classArray) {
        this.columnTypes = classArray;
    }

    public TableViewSet getMdlData() {
        return this.mdlData;
    }
}

