/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.transformations;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import oracle.dbtools.crest.model.ClassificationType;
import oracle.dbtools.crest.model.design.ContainerObjectPlaceHolder;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.transformations.Messages;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.ide.Ide;

public class ChangeNamePrefixDialog
extends CustomDialog {
    private JPanel general;
    private JTextField tfFind;
    private JTextField tfReplace;
    private JCheckBox chbCaseSensitive;
    private JCheckBox chbAddNewPrefix;
    private JCheckBox chbTables;
    private JCheckBox chbColumns;
    private JCheckBox chbIndices;
    private JCheckBox chbViews;
    private JCheckBox chbPKUKConstraints;
    private JCheckBox chbFKConstraints;
    private JDialog dialog;
    private RelationalDesign relDesign;
    private DesignPartView dpv = null;
    private String oldPrefix;
    private String newPrefix;
    private int counter = 0;
    private JRadioButton rbClassificationsReplacement;
    private JRadioButton rbCustomReplacement;
    JPanel pnGeneral;
    private static final Logger LOGGER = new Logger(ChangeNamePrefixDialog.class);

    public ChangeNamePrefixDialog(ApplicationView applicationView, DesignPartView designPartView) {
        super(applicationView);
        this.relDesign = (RelationalDesign)designPartView.getDesignPart();
        this.dpv = designPartView;
        this.process();
    }

    public ChangeNamePrefixDialog(ApplicationView applicationView, RelationalDesign relationalDesign) {
        super(applicationView);
        this.relDesign = relationalDesign;
        this.process();
    }

    private void process() {
        this.setLayout(new BorderLayout());
        this.general = new JPanel(new SpringLayout());
        this.general.setPreferredSize(new Dimension(360, 240));
        this.initGeneralView();
        this.add((Component)this.general, "Center");
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        JButton jButton = new JButton(Messages.getString("ChangeNamePrefixDialog.Apply"));
        jButton.addActionListener(new OKAction());
        jButton.setMnemonic(79);
        JButton jButton2 = new JButton(Messages.getString("ChangeNamePrefixDialog.Cancel"));
        jButton2.setMnemonic(67);
        jButton2.addActionListener(new CancelAction());
        JButton jButton3 = new JButton(this.getHelpAction());
        jButton3.setMnemonic(72);
        jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jButton2.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jButton3.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jPanel.add(jButton);
        jPanel.add(jButton2);
        jPanel.add(jButton3);
        this.add((Component)jPanel, "South");
    }

    private void setObjectConstraints(JPanel jPanel, Component component, int n, int n2) {
        SpringLayout.Constraints constraints = ((SpringLayout)jPanel.getLayout()).getConstraints(component);
        constraints.setX(Spring.constant(n));
        constraints.setY(Spring.constant(n2));
    }

    private void initGeneralView() {
        this.initGeneral();
        this.initTextFields();
        this.initObjects();
    }

    private void initGeneral() {
        this.pnGeneral = new JPanel(new SpringLayout());
        this.pnGeneral.setBorder(BorderFactory.createCompoundBorder(new EtchedBorder(), BorderFactory.createEmptyBorder(4, 4, 225, 388)));
        this.setObjectConstraints(this.general, this.pnGeneral, 4, 4);
        this.general.add(this.pnGeneral);
        this.rbCustomReplacement = new JRadioButton(Messages.getString("ChangeNamePrefixDialog.PrefixReplacement"));
        this.rbCustomReplacement.addActionListener(new RadioCustomReplacementListener());
        this.rbCustomReplacement.setSelected(true);
        this.rbCustomReplacement.setToolTipText(Messages.getString("ChangeNamePrefixDialog.ChangeCurrentPrefixWithNewPrefix"));
        this.rbClassificationsReplacement = new JRadioButton(Messages.getString("ChangeNamePrefixDialog.AddClassificationPrefix"));
        this.rbClassificationsReplacement.addActionListener(new RadioClassificationsReplacementListener());
        this.rbClassificationsReplacement.setSelected(false);
        this.rbClassificationsReplacement.setToolTipText(Messages.getString("ChangeNamePrefixDialog.AddPrefixAccordingToClassificationType"));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.rbCustomReplacement);
        buttonGroup.add(this.rbClassificationsReplacement);
        this.pnGeneral.add(this.rbCustomReplacement);
        this.pnGeneral.add(this.rbClassificationsReplacement);
        this.setObjectConstraints(this.pnGeneral, this.rbCustomReplacement, 4, 5);
        this.setObjectConstraints(this.pnGeneral, this.rbClassificationsReplacement, 190, 5);
    }

    private void initTextFields() {
        JPanel jPanel = new JPanel(new SpringLayout());
        TitledBorder titledBorder = new TitledBorder(Messages.getString("ChangeNamePrefixDialog.Prefix"));
        jPanel.setBorder(BorderFactory.createCompoundBorder(titledBorder, BorderFactory.createEmptyBorder(1, 5, 67, 360)));
        this.setObjectConstraints(this.pnGeneral, jPanel, 4, 25);
        Dimension dimension = new Dimension(170, 20);
        JLabel jLabel = new JLabel(Messages.getString("ChangeNamePrefixDialog.CurrentPrefix"));
        jPanel.add(jLabel);
        this.setObjectConstraints(jPanel, jLabel, 8, 1);
        this.tfFind = new JTextField();
        this.tfFind.setPreferredSize(dimension);
        jPanel.add(this.tfFind);
        this.setObjectConstraints(jPanel, this.tfFind, 130, 1);
        JLabel jLabel2 = new JLabel(Messages.getString("ChangeNamePrefixDialog.NewPrefix"));
        jPanel.add(jLabel2);
        this.setObjectConstraints(jPanel, jLabel2, 8, 23);
        this.tfReplace = new JTextField();
        this.tfReplace.setPreferredSize(dimension);
        jPanel.add(this.tfReplace);
        this.setObjectConstraints(jPanel, this.tfReplace, 130, 23);
        this.chbCaseSensitive = new JCheckBox(Messages.getString("ChangeNamePrefixDialog.CaseSensitive"));
        jPanel.add(this.chbCaseSensitive);
        this.setObjectConstraints(jPanel, this.chbCaseSensitive, 8, 47);
        this.chbAddNewPrefix = new JCheckBox(Messages.getString("ChangeNamePrefixDialog.AddNewPrefix"));
        this.chbAddNewPrefix.setToolTipText(Messages.getString("ChangeNamePrefixDialog.AddPrefixCaseOfMissingPrefix"));
        jPanel.add(this.chbAddNewPrefix);
        this.setObjectConstraints(jPanel, this.chbAddNewPrefix, 200, 47);
        this.pnGeneral.add(jPanel);
    }

    private void initObjects() {
        JPanel jPanel = new JPanel(new SpringLayout());
        TitledBorder titledBorder = new TitledBorder(Messages.getString("ChangeNamePrefixDialog.ApplyTo"));
        jPanel.setBorder(BorderFactory.createCompoundBorder(titledBorder, BorderFactory.createEmptyBorder(1, 5, 80, 360)));
        this.setObjectConstraints(this.pnGeneral, jPanel, 4, 116);
        this.chbTables = new JCheckBox(Messages.getString("ChangeNamePrefixDialog.Tables"));
        this.chbTables.setSelected(true);
        this.chbColumns = new JCheckBox(Messages.getString("ChangeNamePrefixDialog.Columns"));
        this.chbIndices = new JCheckBox(Messages.getString("ChangeNamePrefixDialog.Indexes"));
        this.chbViews = new JCheckBox(Messages.getString("ChangeNamePrefixDialog.Views"));
        this.chbPKUKConstraints = new JCheckBox(Messages.getString("ChangeNamePrefixDialog.PKUKConstraints"));
        this.chbFKConstraints = new JCheckBox(Messages.getString("ChangeNamePrefixDialog.FKConstraints"));
        jPanel.add(this.chbTables);
        jPanel.add(this.chbViews);
        jPanel.add(this.chbColumns);
        jPanel.add(this.chbIndices);
        jPanel.add(this.chbPKUKConstraints);
        jPanel.add(this.chbFKConstraints);
        this.setObjectConstraints(jPanel, this.chbTables, 8, 0);
        this.setObjectConstraints(jPanel, this.chbColumns, 160, 0);
        this.setObjectConstraints(jPanel, this.chbViews, 8, 30);
        this.setObjectConstraints(jPanel, this.chbIndices, 160, 30);
        this.setObjectConstraints(jPanel, this.chbFKConstraints, 8, 60);
        this.setObjectConstraints(jPanel, this.chbPKUKConstraints, 160, 60);
        this.pnGeneral.add(jPanel);
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), Messages.getString("ChangeNamePrefixDialog.ChangeObjectNamesPrefix"));
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.setPreferredSize(new Dimension(410, 310));
            this.dialog.getContentPane().add(this);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            this.dialog.setResizable(true);
        }
        return this.dialog;
    }

    public void showDialog() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().setVisible(true);
    }

    @Override
    protected String getHelpIndex() {
        return "CHANGE_OBJECT_NAMES_PREFIX_DIALOG";
    }

    private void runTransformation() {
        this.transform();
        this.close();
    }

    private void manageControls(boolean bl) {
        if (bl) {
            this.tfFind.setText("");
            this.tfFind.setEnabled(false);
            this.tfReplace.setText("");
            this.tfReplace.setEnabled(false);
            this.chbCaseSensitive.setSelected(false);
            this.chbCaseSensitive.setEnabled(false);
            this.chbAddNewPrefix.setSelected(false);
            this.chbAddNewPrefix.setEnabled(false);
            this.chbTables.setSelected(true);
            this.chbTables.setEnabled(false);
            this.chbColumns.setSelected(false);
            this.chbColumns.setEnabled(false);
            this.chbIndices.setSelected(false);
            this.chbIndices.setEnabled(false);
            this.chbViews.setSelected(false);
            this.chbViews.setEnabled(false);
            this.chbPKUKConstraints.setSelected(false);
            this.chbPKUKConstraints.setEnabled(false);
            this.chbFKConstraints.setSelected(false);
            this.chbFKConstraints.setEnabled(false);
        } else {
            this.tfFind.setEnabled(true);
            this.tfReplace.setEnabled(true);
            this.chbCaseSensitive.setEnabled(true);
            this.chbAddNewPrefix.setEnabled(true);
            this.chbTables.setSelected(true);
            this.chbTables.setEnabled(true);
            this.chbColumns.setSelected(false);
            this.chbColumns.setEnabled(true);
            this.chbIndices.setSelected(false);
            this.chbIndices.setEnabled(true);
            this.chbViews.setSelected(false);
            this.chbViews.setEnabled(true);
            this.chbPKUKConstraints.setSelected(false);
            this.chbPKUKConstraints.setEnabled(true);
            this.chbFKConstraints.setSelected(false);
            this.chbFKConstraints.setEnabled(true);
        }
    }

    private void transform() {
        try {
            this.counter = 0;
            this.oldPrefix = this.tfFind.getText();
            this.newPrefix = this.tfReplace.getText();
            if (this.chbTables.isSelected()) {
                this.renameTables();
            }
            if (this.rbCustomReplacement.isSelected()) {
                if (this.chbColumns.isSelected()) {
                    this.renameColumns();
                }
                if (this.chbIndices.isSelected()) {
                    this.renameIndices();
                }
                if (this.chbPKUKConstraints.isSelected()) {
                    this.renamePKUKConstraints();
                }
                if (this.chbFKConstraints.isSelected()) {
                    this.renameFKConstraints();
                }
                if (this.chbViews.isSelected()) {
                    this.renameViews();
                }
            }
            String string = this.counter == 1 ? Messages.getString("ChangeNamePrefixDialog.NameHasBeenChanged") : MessageFormat.format(Messages.getString("ChangeNamePrefixDialog.ManyNameHasBeenChanged"), String.valueOf(this.counter));
            MessageDialogs.showMessage(this, string);
        }
        catch (Exception exception) {
            LOGGER.error("ChangeNamePrefixDialog.transform()", exception);
        }
    }

    private void convertName(DesignObject designObject) {
        if (this.chbCaseSensitive.isSelected()) {
            String string = designObject.getName();
            if (string.startsWith(this.oldPrefix)) {
                string = string.replaceFirst(this.oldPrefix, this.newPrefix);
                designObject.setName(string);
                designObject.setDirty(true);
                ++this.counter;
            }
        } else {
            String string = designObject.getName().toUpperCase();
            if (string.startsWith(this.oldPrefix.toUpperCase())) {
                string = this.newPrefix + string.substring(this.oldPrefix.length());
                designObject.setName(string);
                designObject.setDirty(true);
                ++this.counter;
            }
        }
    }

    private void convertClassificationName(Table table) {
        String string;
        String string2 = table.getName();
        ClassificationType classificationType = this.relDesign.getDesign().getDLSettings().getClassificationTypeByID(table.getTypeID());
        if (classificationType != null && (string = classificationType.getTypePrefix()) != null && !"".equals(string)) {
            string2 = string + string2;
            table.setName(string2);
            table.setDirty(true);
            ++this.counter;
        }
    }

    private void renameTables() {
        Table[] tableArray = (Table[])this.relDesign.getTableSet().toArray();
        for (int i = 0; i < tableArray.length; ++i) {
            Table table = tableArray[i];
            if (this.dpv != null) {
                if (table.getFirstViewForDPV(this.dpv) == null) continue;
                if (this.rbClassificationsReplacement.isSelected()) {
                    this.convertClassificationName(table);
                } else {
                    this.convertName(table);
                }
                table.setDirty(true);
                continue;
            }
            if (this.rbClassificationsReplacement.isSelected()) {
                this.convertClassificationName(table);
            } else {
                this.convertName(table);
            }
            table.setDirty(true);
        }
    }

    private void renameColumns() {
        Table[] tableArray = (Table[])this.relDesign.getTableSet().toArray();
        for (int i = 0; i < tableArray.length; ++i) {
            Column column;
            int n;
            Table table = tableArray[i];
            Column[] columnArray = (Column[])table.getElements();
            if (this.dpv != null) {
                if (table.getFirstViewForDPV(this.dpv) == null) continue;
                for (n = 0; n < columnArray.length; ++n) {
                    column = columnArray[n];
                    this.convertName(column);
                }
                table.setDirty(true);
                continue;
            }
            for (n = 0; n < columnArray.length; ++n) {
                column = columnArray[n];
                this.convertName(column);
            }
            table.setDirty(true);
        }
    }

    private void renameIndices() {
        Table[] tableArray = (Table[])this.relDesign.getTableSet().toArray();
        for (int i = 0; i < tableArray.length; ++i) {
            Index index;
            Table table = tableArray[i];
            Iterator iterator = table.getIndexes().iterator();
            if (this.dpv != null) {
                if (table.getFirstViewForDPV(this.dpv) == null) continue;
                while (iterator.hasNext()) {
                    index = (Index)((ContainerObjectPlaceHolder)iterator.next()).getObject();
                    this.convertName(index);
                }
                table.setDirty(true);
                continue;
            }
            while (iterator.hasNext()) {
                index = (Index)((ContainerObjectPlaceHolder)iterator.next()).getObject();
                this.convertName(index);
            }
            table.setDirty(true);
        }
    }

    private void renamePKUKConstraints() {
        Table[] tableArray = (Table[])this.relDesign.getTableSet().toArray();
        for (int i = 0; i < tableArray.length; ++i) {
            Index index;
            Table table = tableArray[i];
            Iterator iterator = table.getPKeys().iterator();
            Iterator iterator2 = table.getUKeys().iterator();
            if (this.dpv != null) {
                if (table.getFirstViewForDPV(this.dpv) == null) continue;
                while (iterator.hasNext()) {
                    index = (Index)((ContainerObjectPlaceHolder)iterator.next()).getObject();
                    this.convertName(index);
                }
                while (iterator2.hasNext()) {
                    index = (Index)((ContainerObjectPlaceHolder)iterator2.next()).getObject();
                    this.convertName(index);
                }
                table.setDirty(true);
                continue;
            }
            while (iterator.hasNext()) {
                index = (Index)((ContainerObjectPlaceHolder)iterator.next()).getObject();
                this.convertName(index);
            }
            while (iterator2.hasNext()) {
                index = (Index)((ContainerObjectPlaceHolder)iterator2.next()).getObject();
                this.convertName(index);
            }
            table.setDirty(true);
        }
    }

    private void renameFKConstraints() {
        Table[] tableArray = (Table[])this.relDesign.getTableSet().toArray();
        for (int i = 0; i < tableArray.length; ++i) {
            FKIndexAssociation fKIndexAssociation;
            Table table = tableArray[i];
            Iterator<FKIndexAssociation> iterator = table.getFKAssociationsList().iterator();
            if (this.dpv != null) {
                if (table.getFirstViewForDPV(this.dpv) == null) continue;
                while (iterator.hasNext()) {
                    fKIndexAssociation = iterator.next();
                    this.convertName(fKIndexAssociation);
                }
                table.setDirty(true);
                continue;
            }
            while (iterator.hasNext()) {
                fKIndexAssociation = iterator.next();
                this.convertName(fKIndexAssociation);
            }
            table.setDirty(true);
        }
    }

    private void renameViews() {
        TableView[] tableViewArray = (TableView[])this.relDesign.getTableViewSet().toArray();
        for (int i = 0; i < tableViewArray.length; ++i) {
            TableView tableView = tableViewArray[i];
            if (this.dpv != null) {
                if (tableView.getFirstViewForDPV(this.dpv) == null) continue;
                this.convertName(tableView);
                continue;
            }
            this.convertName(tableView);
        }
    }

    private class RadioClassificationsReplacementListener
    implements ActionListener {
        private RadioClassificationsReplacementListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ChangeNamePrefixDialog.this.manageControls(true);
        }
    }

    private class RadioCustomReplacementListener
    implements ActionListener {
        private RadioCustomReplacementListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ChangeNamePrefixDialog.this.manageControls(false);
        }
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ChangeNamePrefixDialog.this.close();
        }
    }

    private class OKAction
    implements ActionListener {
        private OKAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (ChangeNamePrefixDialog.this.rbCustomReplacement.isSelected()) {
                if (!"".equalsIgnoreCase(ChangeNamePrefixDialog.this.tfFind.getText())) {
                    if (!"".equalsIgnoreCase(ChangeNamePrefixDialog.this.tfReplace.getText())) {
                        ChangeNamePrefixDialog.this.runTransformation();
                    } else {
                        MessageDialogs.showWarningMessage(ChangeNamePrefixDialog.this, Messages.getString("ChangeNamePrefixDialog.NewPrefixNotBeEmpty"));
                        ChangeNamePrefixDialog.this.tfReplace.requestFocus();
                    }
                } else if (ChangeNamePrefixDialog.this.chbAddNewPrefix.isSelected()) {
                    if (!"".equalsIgnoreCase(ChangeNamePrefixDialog.this.tfReplace.getText())) {
                        ChangeNamePrefixDialog.this.runTransformation();
                    } else {
                        int n = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), Messages.getString("ChangeNamePrefixDialog.NewPrefixNotSpecified"), Messages.getString("ChangeNamePrefixDialog.Confirm"), 0);
                        if (n == 0) {
                            ChangeNamePrefixDialog.this.runTransformation();
                        }
                    }
                } else {
                    MessageDialogs.showWarningMessage(ChangeNamePrefixDialog.this, Messages.getString("ChangeNamePrefixDialog.CurrentPrefixCanBeEmpty"));
                    ChangeNamePrefixDialog.this.tfFind.requestFocus();
                }
            } else if (ChangeNamePrefixDialog.this.rbClassificationsReplacement.isSelected()) {
                ChangeNamePrefixDialog.this.runTransformation();
            }
        }
    }
}

