/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.transformations;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.designrules.DRCustomScript;

public class ApplyCustomTransformation {
    private RelationalDesign rd;
    private String type;
    private DesignPart dp;
    private ArrayList<DRCustomScript> customTransformationScripts;

    public ApplyCustomTransformation(String string, DesignPart designPart, ArrayList<DRCustomScript> arrayList) {
        this.type = string;
        this.dp = designPart;
        this.customTransformationScripts = arrayList;
    }

    public boolean runTransformation() {
        boolean bl = false;
        for (DRCustomScript dRCustomScript : this.customTransformationScripts) {
            dRCustomScript.init();
            dRCustomScript.doCheck(this.dp);
            if (!dRCustomScript.hasEvalError()) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private List getConstraintSet() {
        if (this.rd != null) {
            ArrayList arrayList = new ArrayList();
            Iterator iterator = this.rd.getTableSet().iterator();
            while (iterator.hasNext()) {
                Table table = (Table)iterator.next();
                arrayList.addAll(table.getCheckConstraints());
            }
            return arrayList;
        }
        return null;
    }
}

