/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.storage.usertype;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserDefinedTypeSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserSqlServer;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.storage.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class UserDefinedTypesDialogSqlServer
extends JPanel {
    private static final String EMPTY_VALUE = "";
    protected static final int FIELD_WIDTH = 15;
    private static final int DEFAULT_COMBO_MAX_ROW_COUNT = 8;
    private ApplicationView view;
    private StorageDesignSqlServer storageDesign;
    private JDialog dialog;
    private JButton btnAdd;
    private JButton btnRemove;
    private JButton btnApply;
    private JButton btnOK;
    private JButton btnCancel;
    private JPanel general;
    private JPanel addPanel;
    private JPanel listPanel;
    private JPanel propPanel;
    private JPanel buttonPanel;
    private DefaultListModel allTypesModel;
    private JList allTypesList;
    private JPanel typesButtonsPanel;
    private JTextField tfName;
    private JComboBox cbDomain;
    private JComboBox cbNullType;
    private JComboBox cbOwner;

    public UserDefinedTypesDialogSqlServer(ApplicationView applicationView, StorageDesignSqlServer storageDesignSqlServer) {
        this.view = applicationView;
        this.storageDesign = storageDesignSqlServer;
        this.storageDesign.setDtDialogVisible(true);
    }

    public void showDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.view.getFrame(), Messages.getString("UserDefinedTypesDialogSqlServer.UserDefinedTypes"));
            this.dialog.setDefaultCloseOperation(2);
            this.general = new JPanel();
            this.general.setLayout(new BorderLayout());
            this.dialog.getContentPane().add(this.general);
            this.addPanel = new JPanel(new BorderLayout());
            this.addPanel.setPreferredSize(new Dimension(180, 200));
            this.addPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("UserDefinedTypesDialogSqlServer.ChooseUserDefinedType")));
            this.propPanel = new JPanel(new SpringLayout());
            this.propPanel.setPreferredSize(new Dimension(280, 200));
            this.propPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("UserDefinedTypesDialogSqlServer.UserDefinedTypeProperties")));
            this.initAddPanel();
            this.initPropPanel();
            this.buttonPanel = this.getButtonPanel();
            this.general.add((Component)this.addPanel, "West");
            this.general.add((Component)this.propPanel, "Center");
            this.general.add((Component)this.buttonPanel, "South");
            this.dialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    UserDefinedTypesDialogSqlServer.this.close(UserDefinedTypesDialogSqlServer.this.dialog);
                }

                @Override
                public void windowClosed(WindowEvent windowEvent) {
                    UserDefinedTypesDialogSqlServer.this.storageDesign.setDtDialogVisible(false);
                }
            });
            this.dialog.pack();
            this.dialog.setResizable(false);
        }
        CommonUtil.centerOnScreen(this.dialog);
        this.dialog.setVisible(true);
    }

    private void initAddPanel() {
        this.initAddSubPanels();
        this.initTypesPanel();
        this.initTypesButtons();
    }

    private void initAddSubPanels() {
        this.typesButtonsPanel = new JPanel();
        this.typesButtonsPanel.setAlignmentX(0.5f);
        this.listPanel = new JPanel(new BorderLayout());
        this.listPanel.setAlignmentX(0.5f);
        this.addPanel.add((Component)this.typesButtonsPanel, "South");
        this.addPanel.add(this.listPanel);
    }

    private void initTypesPanel() {
        Object object;
        this.allTypesModel = new DefaultListModel();
        this.allTypesList = new JList(this.allTypesModel);
        Iterator iterator = this.storageDesign.getUserDefinedTypeSet().iterator();
        while (iterator.hasNext()) {
            object = (UserDefinedTypeSqlServer)iterator.next();
            this.allTypesModel.addElement(object);
        }
        this.allTypesList.setSelectionMode(0);
        this.allTypesList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (UserDefinedTypesDialogSqlServer.this.allTypesList.getSelectedValue() != null) {
                    UserDefinedTypesDialogSqlServer.this.clear();
                    UserDefinedTypeSqlServer userDefinedTypeSqlServer = (UserDefinedTypeSqlServer)UserDefinedTypesDialogSqlServer.this.allTypesList.getSelectedValue();
                    UserDefinedTypesDialogSqlServer.this.tfName.setText(userDefinedTypeSqlServer.getName());
                    UserDefinedTypesDialogSqlServer.this.cbDomain.setSelectedItem(userDefinedTypeSqlServer.getDomainObj());
                    UserDefinedTypesDialogSqlServer.this.cbNullType.setSelectedItem(userDefinedTypeSqlServer.getNullType());
                    UserDefinedTypesDialogSqlServer.this.cbOwner.setSelectedItem(userDefinedTypeSqlServer.getOwner());
                    UserDefinedTypesDialogSqlServer.this.enableCombos(true);
                    UserDefinedTypesDialogSqlServer.this.btnRemove.setEnabled(true);
                } else {
                    UserDefinedTypesDialogSqlServer.this.enableCombos(false);
                    UserDefinedTypesDialogSqlServer.this.btnRemove.setEnabled(false);
                }
            }
        });
        object = new JScrollPane(this.allTypesList);
        this.listPanel.add((Component)object);
    }

    protected void initTypesButtons() {
        this.btnAdd = new JButton(Messages.getString("UserDefinedTypesDialogSqlServer.Add"));
        this.btnAdd.setPreferredSize(new Dimension(80, 25));
        this.btnAdd.setMnemonic(65);
        this.btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = UserDefinedTypesDialogSqlServer.this.storageDesign.getAppView().getIDGenerator().createNewID();
                while (UserDefinedTypesDialogSqlServer.this.storageDesign.getUserDefinedTypeSet().containsId(string)) {
                    string = UserDefinedTypesDialogSqlServer.this.storageDesign.getAppView().getIDGenerator().createNewID();
                }
                UserDefinedTypeSqlServer userDefinedTypeSqlServer = UserDefinedTypesDialogSqlServer.this.storageDesign.getUserDefinedTypeSet().createType();
                userDefinedTypeSqlServer.setName(string);
                userDefinedTypeSqlServer.setDomain("BigNumber");
                UserDefinedTypesDialogSqlServer.this.allTypesModel.addElement(userDefinedTypeSqlServer);
                UserDefinedTypesDialogSqlServer.this.allTypesList.setSelectedValue(userDefinedTypeSqlServer, true);
                UserDefinedTypesDialogSqlServer.this.enableCombos(true);
            }
        });
        this.typesButtonsPanel.add(this.btnAdd);
        this.btnRemove = new JButton(Messages.getString("UserDefinedTypesDialogSqlServer.Remove"));
        this.btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UserDefinedTypeSqlServer userDefinedTypeSqlServer = (UserDefinedTypeSqlServer)UserDefinedTypesDialogSqlServer.this.allTypesList.getSelectedValue();
                if (userDefinedTypeSqlServer != null) {
                    UserDefinedTypesDialogSqlServer.this.allTypesModel.removeElement(userDefinedTypeSqlServer);
                }
                UserDefinedTypesDialogSqlServer.this.clear();
                UserDefinedTypesDialogSqlServer.this.enableCombos(false);
            }
        });
        this.btnRemove.setMnemonic(82);
        this.btnRemove.setEnabled(false);
        this.btnRemove.setPreferredSize(this.btnAdd.getPreferredSize());
        this.typesButtonsPanel.add(this.btnRemove);
    }

    private void initPropPanel() {
        this.initName();
        this.initDomain();
        this.initNullType();
        this.initOwner();
        this.fillCombos();
        this.enableCombos(false);
    }

    private void initName() {
        JLabel jLabel = new JLabel(Messages.getString("UserDefinedTypesDialogSqlServer.Name"));
        this.propPanel.add(jLabel);
        this.tfName = new JTextField(EMPTY_VALUE, 15);
        this.propPanel.add(this.tfName);
        this.setLabelConstraints((SpringLayout)this.propPanel.getLayout(), jLabel, 10);
        this.setObjectConstraints((SpringLayout)this.propPanel.getLayout(), this.tfName, 10);
    }

    private void initDomain() {
        JLabel jLabel = new JLabel(Messages.getString("UserDefinedTypesDialogSqlServer.Domain"));
        jLabel.setPreferredSize(this.tfName.getPreferredSize());
        this.propPanel.add(jLabel);
        this.cbDomain = new JComboBox();
        this.cbDomain.setPreferredSize(this.tfName.getPreferredSize());
        this.propPanel.add(this.cbDomain);
        this.setBG(this.cbDomain);
        this.cbDomain.setPreferredSize(this.tfName.getPreferredSize());
        this.cbDomain.setMaximumRowCount(8);
        this.setLabelConstraints((SpringLayout)this.propPanel.getLayout(), jLabel, 50);
        this.setObjectConstraints((SpringLayout)this.propPanel.getLayout(), this.cbDomain, 50);
    }

    private void initNullType() {
        JLabel jLabel = new JLabel(Messages.getString("UserDefinedTypesDialogSqlServer.NullType"));
        jLabel.setPreferredSize(this.tfName.getPreferredSize());
        this.propPanel.add(jLabel);
        this.cbNullType = new JComboBox();
        this.cbNullType.setPreferredSize(this.tfName.getPreferredSize());
        this.propPanel.add(this.cbNullType);
        this.setBG(this.cbNullType);
        this.cbNullType.setPreferredSize(this.tfName.getPreferredSize());
        this.cbNullType.setMaximumRowCount(8);
        this.setLabelConstraints((SpringLayout)this.propPanel.getLayout(), jLabel, 90);
        this.setObjectConstraints((SpringLayout)this.propPanel.getLayout(), this.cbNullType, 90);
    }

    private void initOwner() {
        JLabel jLabel = new JLabel(Messages.getString("UserDefinedTypesDialogSqlServer.Owner"));
        jLabel.setPreferredSize(this.tfName.getPreferredSize());
        this.propPanel.add(jLabel);
        this.cbOwner = new JComboBox();
        this.cbOwner.setPreferredSize(this.tfName.getPreferredSize());
        this.propPanel.add(this.cbOwner);
        this.setBG(this.cbOwner);
        this.cbOwner.setPreferredSize(this.tfName.getPreferredSize());
        this.cbOwner.setMaximumRowCount(8);
        this.setLabelConstraints((SpringLayout)this.propPanel.getLayout(), jLabel, 130);
        this.setObjectConstraints((SpringLayout)this.propPanel.getLayout(), this.cbOwner, 130);
    }

    protected void setProperties() {
        UserDefinedTypeSqlServer userDefinedTypeSqlServer = (UserDefinedTypeSqlServer)this.allTypesList.getSelectedValue();
        this.allTypesModel.removeElement(userDefinedTypeSqlServer);
        if (userDefinedTypeSqlServer != null) {
            userDefinedTypeSqlServer.setName(this.tfName.getText());
            userDefinedTypeSqlServer.setDomain((String)this.cbDomain.getSelectedItem());
            userDefinedTypeSqlServer.setNullType((String)this.cbNullType.getSelectedItem());
            userDefinedTypeSqlServer.setOwner((UserSqlServer)this.cbOwner.getSelectedItem());
            userDefinedTypeSqlServer.setDirty(true);
        }
        this.allTypesModel.addElement(userDefinedTypeSqlServer);
        this.storageDesign.getUserDefinedTypeSet().removeAll();
        Object[] objectArray = this.allTypesModel.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            UserDefinedTypeSqlServer userDefinedTypeSqlServer2 = (UserDefinedTypeSqlServer)objectArray[i];
            if (userDefinedTypeSqlServer2 == null) continue;
            this.storageDesign.getUserDefinedTypeSet().add(userDefinedTypeSqlServer2);
        }
        this.refreshTypesList();
        this.clear();
        this.enableCombos(false);
    }

    protected void enableCombos(boolean bl) {
        this.tfName.setEnabled(bl);
        this.cbDomain.setEnabled(bl);
        this.cbNullType.setEnabled(bl);
        this.cbOwner.setEnabled(bl);
    }

    protected void fillCombos() {
        Iterator iterator = this.storageDesign.getDesign().getDomainSet().iterator();
        while (iterator.hasNext()) {
            Domain domain = (Domain)iterator.next();
            this.cbDomain.addItem(domain.getName());
        }
        for (int i = 0; i < UserDefinedTypeSqlServer.NULL_STATES.length; ++i) {
            this.cbNullType.addItem(UserDefinedTypeSqlServer.NULL_STATES[i]);
        }
        iterator = this.storageDesign.getUserSet().iterator();
        while (iterator.hasNext()) {
            this.cbOwner.addItem(iterator.next());
        }
    }

    protected void refreshTypesList() {
        this.allTypesModel.clear();
        Iterator iterator = this.storageDesign.getUserDefinedTypeSet().iterator();
        while (iterator.hasNext()) {
            this.allTypesModel.addElement(iterator.next());
        }
    }

    protected JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel();
            this.btnOK = new JButton(Messages.getString("UserDefinedTypesDialogSqlServer.OK"));
            this.btnOK.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    UserDefinedTypesDialogSqlServer.this.setProperties();
                    UserDefinedTypesDialogSqlServer.this.close(UserDefinedTypesDialogSqlServer.this.dialog);
                }
            });
            this.btnApply = new JButton(Messages.getString("UserDefinedTypesDialogSqlServer.Apply"));
            this.btnApply.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    UserDefinedTypesDialogSqlServer.this.setProperties();
                }
            });
            this.btnApply.setPreferredSize(new Dimension(80, 25));
            this.btnApply.setMnemonic(80);
            this.btnOK.setPreferredSize(new Dimension(80, 25));
            this.btnOK.setCursor(Cursor.getPredefinedCursor(12));
            this.btnOK.setMnemonic(83);
            this.btnCancel = new JButton(Messages.getString("UserDefinedTypesDialogSqlServer.Cancel"));
            this.btnCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    UserDefinedTypesDialogSqlServer.this.close(UserDefinedTypesDialogSqlServer.this.dialog);
                }
            });
            this.btnCancel.setPreferredSize(this.btnOK.getPreferredSize());
            this.btnCancel.setMnemonic(67);
            this.btnCancel.setCursor(Cursor.getPredefinedCursor(12));
            this.buttonPanel.add(this.btnOK);
            this.buttonPanel.add(this.btnApply);
            this.buttonPanel.add(this.btnCancel);
        }
        return this.buttonPanel;
    }

    protected SpringLayout getPanelLayout(JPanel jPanel) {
        return (SpringLayout)jPanel.getLayout();
    }

    public void setBG(Component component) {
        component.setBackground(Color.WHITE);
        if (!component.getFont().isPlain()) {
            component.setFont(new Font(component.getFont().getName(), 0, component.getFont().getSize()));
        }
    }

    public void close(JDialog jDialog) {
        jDialog.dispose();
    }

    private void clear() {
        this.tfName.setText(EMPTY_VALUE);
    }

    protected void setLabelConstraints(SpringLayout springLayout, JLabel jLabel, int n) {
        SpringLayout.Constraints constraints = springLayout.getConstraints(jLabel);
        constraints.setX(Spring.constant(10));
        constraints.setY(Spring.constant(n));
    }

    protected void setObjectConstraints(SpringLayout springLayout, Component component, int n) {
        SpringLayout.Constraints constraints = springLayout.getConstraints(component);
        constraints.setX(Spring.constant(80));
        constraints.setY(Spring.constant(n));
    }
}

