/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.storage.spacecalculation;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.db2.AUXTableIndexDB2;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.DataBaseDB2;
import oracle.dbtools.crest.model.design.storage.db2.IndexProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.StorageGroupDB2;
import oracle.dbtools.crest.model.design.storage.db2.StorageTemplateDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableSpaceDB2;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.printing.DesignPrintModule;
import oracle.dbtools.crest.swingui.storage.Messages;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;
import oracle.ide.Ide;

public class SpaceCalculationDB2
extends JDialog
implements ChangeListener {
    private ApplicationView appView;
    private JTabbedPane tpane;
    protected JPanel propQTY;
    protected JPanel estSpace;
    private JPanel settings;
    protected JLabel lbName;
    protected JTextField tfName;
    protected JTextArea taComments;
    protected final String[] NONE = new String[]{""};
    protected final String[] YES_NO = new String[]{Messages.getString("SpaceCalculationDB2.YES"), Messages.getString("SpaceCalculationDB2.NO")};
    protected static final int FIELD_WIDTH = 25;
    protected AbstractStorageDesignDB2 storageDesign;
    private JTable qtyTable;
    private JTable spaceTable;
    private JButton bnPrint;
    JCheckBox chbUseObjectSet;
    JRadioButton bInsert;
    JRadioButton bLoad;
    ButtonGroup bgInsert = new ButtonGroup();
    private JIntegerField ifFreePage;
    private JIntegerField ifPCTFREE;
    private JCheckBox chbUsePCTFilling;
    private JIntegerField ifPCTFilling;
    List propQList = new ArrayList();
    List backupList = new ArrayList();
    StorageTemplateDB2 tempStorageTemplate;
    List spaceList = new ArrayList();

    public SpaceCalculationDB2(ApplicationView applicationView, AbstractStorageDesignDB2 abstractStorageDesignDB2) {
        super(applicationView.getFrame());
        this.appView = applicationView;
        this.storageDesign = abstractStorageDesignDB2;
        this.storageDesign.setScDialogVisible(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                SpaceCalculationDB2.this.storageDesign.setScDialogVisible(false);
            }
        });
        this.setTitle(this.getCaption());
        this.setDefaultCloseOperation(2);
        this.tpane = new JTabbedPane();
        this.tpane.addChangeListener(this);
        this.tpane.setPreferredSize(new Dimension(890, 500));
        this.propQTY = new JPanel(new SpringLayout());
        this.tpane.addTab(Messages.getString("SpaceCalculationDB2.ProposedQTY"), this.propQTY);
        this.initQTYView();
        this.addTabs();
        this.estSpace = new JPanel(new SpringLayout());
        this.tpane.addTab(Messages.getString("SpaceCalculationDB2.EstimatedSpace"), this.estSpace);
        this.initSpaceView();
        this.settings = new JPanel(new SpringLayout());
        this.tpane.addTab(Messages.getString("SpaceCalculationDB2.Settings"), this.settings);
        this.initSettingsView();
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.tpane, "Center");
        JPanel jPanel2 = new JPanel();
        JButton jButton = new JButton(Messages.getString("SpaceCalculationDB2.Calculate"));
        jButton.addActionListener(new CalculateAction());
        jButton.setCursor(Cursor.getPredefinedCursor(12));
        jButton.setMnemonic(65);
        jPanel2.add(jButton);
        this.bnPrint = new JButton(Messages.getString("SpaceCalculationDB2.Print"));
        this.bnPrint.addActionListener(new PrintAction());
        this.bnPrint.setCursor(Cursor.getPredefinedCursor(12));
        this.bnPrint.setMnemonic(80);
        jPanel2.add(this.bnPrint);
        JButton jButton2 = new JButton(Messages.getString("SpaceCalculationDB2.Close"));
        jButton2.setMnemonic(67);
        jButton2.addActionListener(new CancelAction());
        jButton2.setCursor(Cursor.getPredefinedCursor(12));
        jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.bnPrint.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jButton2.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jPanel2.add(jButton2);
        jPanel.add((Component)jPanel2, "South");
        this.getContentPane().add(jPanel);
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.setResizable(false);
        this.calculate();
    }

    public String getCaption() {
        return Messages.getString("SpaceCalculationDB2.SpaceCalculation");
    }

    protected void addTabs() {
    }

    protected void initQTYView() {
        Serializable serializable;
        this.qtyTable = new JTable(new PropQTYTableModel());
        this.qtyTable.addMouseListener(new SpaceMouseListener(this.propQList));
        this.qtyTable.setToolTipText(Messages.getString("SpaceCalculationDB2.UseDoubleClickPropertyDialog"));
        this.qtyTable.getSelectionModel().setSelectionMode(0);
        this.qtyTable.setAutoResizeMode(0);
        TableColumnModel tableColumnModel = this.qtyTable.getColumnModel();
        Enumeration<TableColumn> enumeration = tableColumnModel.getColumns();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            serializable = enumeration.nextElement();
            if (n == 0) {
                ((TableColumn)serializable).setPreferredWidth(210);
            } else {
                ((TableColumn)serializable).setPreferredWidth(110);
            }
            ++n;
        }
        serializable = new JScrollPane(this.qtyTable);
        int n2 = this.getPane().getPreferredSize().height - 40;
        int n3 = this.getPane().getPreferredSize().width;
        ((JComponent)serializable).setPreferredSize(new Dimension(n3, n2));
        ((JComponent)serializable).setBorder(BorderFactory.createEtchedBorder(0));
        this.propQTY.add((Component)serializable);
    }

    protected void initSpaceView() {
        Serializable serializable;
        this.spaceTable = new JTable(new SpaceTableModel());
        this.spaceTable.addMouseListener(new SpaceMouseListener(this.spaceList));
        this.spaceTable.setToolTipText(Messages.getString("SpaceCalculationDB2.UseDoubleClickPropertyDialog"));
        this.spaceTable.getSelectionModel().setSelectionMode(0);
        this.spaceTable.setAutoResizeMode(0);
        this.spaceTable.setDefaultRenderer(Object.class, new SpaceColorRenderer(this.spaceList));
        TableColumnModel tableColumnModel = this.spaceTable.getColumnModel();
        Enumeration<TableColumn> enumeration = tableColumnModel.getColumns();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            serializable = enumeration.nextElement();
            if (n == 0) {
                ((TableColumn)serializable).setPreferredWidth(210);
            } else {
                ((TableColumn)serializable).setPreferredWidth(135);
            }
            ++n;
        }
        serializable = new JScrollPane(this.spaceTable);
        int n2 = this.getPane().getPreferredSize().height - 40;
        int n3 = this.getPane().getPreferredSize().width;
        ((JComponent)serializable).setPreferredSize(new Dimension(n3, n2));
        ((JComponent)serializable).setBorder(BorderFactory.createEtchedBorder(0));
        this.estSpace.add((Component)serializable);
    }

    private JTable getSpaceTable() {
        JTable jTable = new JTable(new SpaceTableModel());
        jTable.setDefaultRenderer(Object.class, new SpaceColorRenderer(this.spaceList));
        jTable.setAutoResizeMode(0);
        Dimension dimension = new Dimension(this.spaceTable.getSize().width, this.spaceTable.getSize().height + this.spaceTable.getTableHeader().getSize().height + 20);
        jTable.setSize(dimension);
        TableColumnModel tableColumnModel = this.spaceTable.getColumnModel();
        TableColumnModel tableColumnModel2 = jTable.getColumnModel();
        Enumeration<TableColumn> enumeration = tableColumnModel.getColumns();
        Enumeration<TableColumn> enumeration2 = tableColumnModel2.getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            TableColumn tableColumn2 = enumeration2.nextElement();
            tableColumn2.setPreferredWidth(tableColumn.getPreferredWidth());
        }
        return jTable;
    }

    private JTable getQTYTable() {
        JTable jTable = new JTable(new PropQTYTableModel());
        jTable.setAutoResizeMode(0);
        Dimension dimension = new Dimension(this.qtyTable.getSize().width, this.qtyTable.getSize().height + this.qtyTable.getTableHeader().getSize().height + 20);
        jTable.setSize(dimension);
        TableColumnModel tableColumnModel = this.qtyTable.getColumnModel();
        Enumeration<TableColumn> enumeration = tableColumnModel.getColumns();
        TableColumnModel tableColumnModel2 = jTable.getColumnModel();
        Enumeration<TableColumn> enumeration2 = tableColumnModel2.getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            TableColumn tableColumn2 = enumeration2.nextElement();
            tableColumn2.setPreferredWidth(tableColumn.getPreferredWidth());
        }
        return jTable;
    }

    SpringLayout getSettingsLayout() {
        return (SpringLayout)this.settings.getLayout();
    }

    void initSettingsView() {
        this.initUseObjectSettings();
        this.initInsertMethod();
        this.initFreePage();
        this.initPCTFree();
        this.initPCTFilling();
        this.chbUseObjectSet.setSelected(true);
        this.setUseObjectSettings(false);
    }

    void initUseObjectSettings() {
        this.chbUseObjectSet = new JCheckBox(Messages.getString("SpaceCalculationDB2.UseObjectLevelSettings"));
        this.settings.add(this.chbUseObjectSet);
        this.chbUseObjectSet.addActionListener(new UseObSetCheckBoxListener());
        CommonUtil.setObjectConstraints(this.getSettingsLayout(), this.chbUseObjectSet, 10, 10);
    }

    void initInsertMethod() {
        this.bInsert = new JRadioButton(Messages.getString("SpaceCalculationDB2.InsertMethodSQLInsert"), true);
        this.bLoad = new JRadioButton(Messages.getString("SpaceCalculationDB2.InsertMethodLoad"), false);
        this.bgInsert.add(this.bInsert);
        this.bgInsert.add(this.bLoad);
        this.settings.add(this.bInsert);
        this.settings.add(this.bLoad);
        CommonUtil.setObjectConstraints(this.getSettingsLayout(), this.bInsert, 30, 40);
        CommonUtil.setObjectConstraints(this.getSettingsLayout(), this.bLoad, 30, 60);
    }

    void initFreePage() {
        JLabel jLabel = new JLabel(Messages.getString("SpaceCalculationDB2.FreePage"));
        this.settings.add(jLabel);
        this.ifFreePage = new JIntegerField(0, 3);
        this.settings.add(this.ifFreePage);
        CommonUtil.setLabelConstraints(this.getSettingsLayout(), jLabel, 30, 90);
        CommonUtil.setObjectConstraints(this.getSettingsLayout(), this.ifFreePage, 130, 90);
        this.ifFreePage.setValue(0L);
    }

    void initPCTFree() {
        JLabel jLabel = new JLabel(Messages.getString("SpaceCalculationDB2.PCTFREE"));
        this.settings.add(jLabel);
        this.ifPCTFREE = new JIntegerField(0, 3);
        this.settings.add(this.ifPCTFREE);
        CommonUtil.setLabelConstraints(this.getSettingsLayout(), jLabel, 30, 120);
        CommonUtil.setObjectConstraints(this.getSettingsLayout(), this.ifPCTFREE, 130, 120);
        this.ifPCTFREE.setValue(5L);
    }

    void initPCTFilling() {
        JLabel jLabel = new JLabel(Messages.getString("SpaceCalculationDB2.UsePCTFillingForVarTypes"));
        this.settings.add(jLabel);
        this.chbUsePCTFilling = new JCheckBox("");
        this.chbUsePCTFilling.addActionListener(new CheckBoxListener());
        this.settings.add(this.chbUsePCTFilling);
        CommonUtil.setLabelConstraints(this.getSettingsLayout(), jLabel, 30, 150);
        CommonUtil.setObjectConstraints(this.getSettingsLayout(), this.chbUsePCTFilling, 190, 150);
        jLabel = new JLabel(Messages.getString("SpaceCalculationDB2.PCTFilling"));
        CommonUtil.setLabelConstraints(this.getSettingsLayout(), jLabel, 120, 180);
        this.settings.add(jLabel);
        this.ifPCTFilling = new JIntegerField(0, 3);
        this.settings.add(this.ifPCTFilling);
        CommonUtil.setObjectConstraints(this.getSettingsLayout(), this.ifPCTFilling, 195, 180);
        this.setPCTFillingUse(false);
        this.ifPCTFilling.setValue(66L);
    }

    private void setPCTFillingUse(boolean bl) {
        this.ifPCTFilling.setEditable(bl);
        this.ifPCTFilling.setEnabled(bl);
    }

    private void setUseObjectSettings(boolean bl) {
        this.bInsert.setEnabled(bl);
        this.bLoad.setEnabled(bl);
        this.ifPCTFREE.setEditable(bl);
        this.ifPCTFREE.setEnabled(bl);
        this.ifFreePage.setEditable(bl);
        this.ifFreePage.setEnabled(bl);
        this.ifPCTFilling.setEditable(bl && this.chbUsePCTFilling.isSelected());
        this.ifPCTFilling.setEnabled(bl && this.chbUsePCTFilling.isSelected());
        this.chbUsePCTFilling.setEnabled(bl);
    }

    protected SpringLayout getGeneralLayout() {
        return (SpringLayout)this.propQTY.getLayout();
    }

    protected SpringLayout getCommentsLayout() {
        return (SpringLayout)this.estSpace.getLayout();
    }

    protected void setLabelConstraints(JLabel jLabel, int n) {
        SpringLayout.Constraints constraints = this.getGeneralLayout().getConstraints(jLabel);
        constraints.setX(Spring.constant(10));
        constraints.setY(Spring.constant(n));
    }

    protected void setObjectConstraints(Component component, int n) {
        SpringLayout.Constraints constraints = this.getGeneralLayout().getConstraints(component);
        constraints.setX(Spring.constant(125));
        constraints.setY(Spring.constant(n));
    }

    protected void setObjectConstraints(Component component, int n, int n2) {
        SpringLayout.Constraints constraints = this.getGeneralLayout().getConstraints(component);
        constraints.setX(Spring.constant(n));
        constraints.setY(Spring.constant(n2));
    }

    public JTabbedPane getPane() {
        return this.tpane;
    }

    public ApplicationView getAppView() {
        return this.appView;
    }

    public void setBG(Component component) {
        component.setBackground(Color.WHITE);
        if (!component.getFont().isPlain()) {
            component.setFont(new Font(component.getFont().getName(), 0, component.getFont().getSize()));
        }
    }

    protected void initCaption(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getCaption()).append(" - ").append(string);
        this.setTitle(stringBuffer.toString());
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (this.tpane != null && this.bnPrint != null) {
            this.bnPrint.setEnabled(this.tpane.getSelectedIndex() < 2);
        }
    }

    void backupAndSet() {
        StorageObject storageObject;
        BackupData backupData;
        this.backupList.clear();
        this.tempStorageTemplate = this.storageDesign.getStorageTemplateSet().createStorageTemplate(null);
        this.tempStorageTemplate.setPctFree(this.ifPCTFREE.getIntValue());
        this.tempStorageTemplate.setFreePage(this.ifFreePage.getIntValue());
        String string = this.bInsert.isSelected() ? "SQL Insert" : "Load/Reorg";
        boolean bl = this.chbUsePCTFilling.isSelected();
        int n = this.ifPCTFilling.getIntValue();
        Iterator iterator = this.storageDesign.getTableSpaceSet().iterator();
        while (iterator.hasNext()) {
            backupData = new BackupData();
            backupData.storageObject = storageObject = (TableSpaceDB2)iterator.next();
            backupData.stTemplate = ((TableSpaceDB2)storageObject).getStorageTemplate();
            this.backupList.add(backupData);
            ((TableSpaceDB2)storageObject).setStorageTemplate(this.tempStorageTemplate);
        }
        iterator = this.storageDesign.getIndexProxySet().iterator();
        while (iterator.hasNext()) {
            backupData = new BackupData();
            backupData.storageObject = storageObject = (IndexProxyDB2)iterator.next();
            backupData.stTemplate = ((IndexProxyDB2)storageObject).getStorageTemplate();
            this.backupList.add(backupData);
            ((IndexProxyDB2)storageObject).setStorageTemplate(this.tempStorageTemplate);
        }
        iterator = this.storageDesign.getAUXTableIndexSet().iterator();
        while (iterator.hasNext()) {
            backupData = new BackupData();
            backupData.storageObject = storageObject = (AUXTableIndexDB2)iterator.next();
            backupData.stTemplate = ((AUXTableIndexDB2)storageObject).getStorageTemplate();
            this.backupList.add(backupData);
            ((AUXTableIndexDB2)storageObject).setStorageTemplate(this.tempStorageTemplate);
        }
        iterator = this.storageDesign.getTableProxySet().iterator();
        while (iterator.hasNext()) {
            backupData = new BackupData();
            backupData.storageObject = storageObject = (TableProxyDB2)iterator.next();
            backupData.insMode = ((TableProxyDB2)storageObject).getInsertMethod();
            backupData.usePctFilling = ((TableProxyDB2)storageObject).isUsePCTFilling();
            backupData.pctFilling = ((TableProxyDB2)storageObject).getPctFilling();
            this.backupList.add(backupData);
            ((TableProxyDB2)storageObject).setInsertMethod(string);
            ((TableProxyDB2)storageObject).setUsePCTFilling(bl);
            ((TableProxyDB2)storageObject).setPctFilling(n);
        }
    }

    void restore() {
        for (BackupData backupData : this.backupList) {
            StorageObject storageObject;
            if (backupData.storageObject instanceof TableSpaceDB2) {
                storageObject = (TableSpaceDB2)backupData.storageObject;
                ((TableSpaceDB2)storageObject).setStorageTemplate(backupData.stTemplate);
                continue;
            }
            if (backupData.storageObject instanceof IndexProxyDB2) {
                storageObject = (IndexProxyDB2)backupData.storageObject;
                ((IndexProxyDB2)storageObject).setStorageTemplate(backupData.stTemplate);
                continue;
            }
            if (backupData.storageObject instanceof AUXTableIndexDB2) {
                storageObject = (AUXTableIndexDB2)backupData.storageObject;
                ((AUXTableIndexDB2)storageObject).setStorageTemplate(backupData.stTemplate);
                continue;
            }
            if (!(backupData.storageObject instanceof TableProxyDB2)) continue;
            storageObject = (TableProxyDB2)backupData.storageObject;
            ((TableProxyDB2)storageObject).setInsertMethod(backupData.insMode);
            ((TableProxyDB2)storageObject).setUsePCTFilling(backupData.usePctFilling);
            ((TableProxyDB2)storageObject).setPctFilling(backupData.pctFilling);
        }
        this.storageDesign.getStorageTemplateSet().remove(this.tempStorageTemplate);
    }

    boolean useObjectLevelSettings() {
        return this.chbUseObjectSet.isSelected();
    }

    void loadPropQLIst() {
        PropQTYData propQTYData;
        StorageObject storageObject;
        this.propQList.clear();
        Iterator iterator = this.storageDesign.getTableSpaceSet().iterator();
        while (iterator.hasNext()) {
            storageObject = (TableSpaceDB2)iterator.next();
            if (storageObject.isNullInstance()) continue;
            propQTYData = new PropQTYData();
            propQTYData.storageObject = storageObject;
            propQTYData.name = storageObject.getName();
            propQTYData.type = "TableSpace";
            propQTYData.priQTY = Integer.toString(((TableSpaceDB2)storageObject).getProposedPRIQTY());
            propQTYData.secQTY = Integer.toString(((TableSpaceDB2)storageObject).getProposedSECQTY());
            propQTYData.initSpace = Integer.toString(((TableSpaceDB2)storageObject).getInitialNumberUsedPages());
            propQTYData.maxSpace = Integer.toString(((TableSpaceDB2)storageObject).getMaxNumberUsedPages());
            if (((TableSpaceDB2)storageObject).getStorageTemplate() != null) {
                propQTYData.currPQTY = Integer.toString(((TableSpaceDB2)storageObject).getStorageTemplate().getSgPriqty());
                propQTYData.currSQTY = Integer.toString(((TableSpaceDB2)storageObject).getStorageTemplate().getSgSeqty());
            } else {
                propQTYData.currPQTY = "";
                propQTYData.currSQTY = "";
            }
            this.propQList.add(propQTYData);
        }
        iterator = this.storageDesign.getIndexProxySet().iterator();
        while (iterator.hasNext()) {
            storageObject = (IndexProxyDB2)iterator.next();
            propQTYData = new PropQTYData();
            propQTYData.storageObject = storageObject;
            propQTYData.name = ((IndexProxy)storageObject).getTableProxy().getName() + "." + ((IndexProxyDB2)storageObject).getName();
            propQTYData.type = "Index";
            propQTYData.priQTY = Integer.toString(((IndexProxyDB2)storageObject).getProposedPRIQTY());
            propQTYData.secQTY = Integer.toString(((IndexProxyDB2)storageObject).getProposedSECQTY());
            propQTYData.initSpace = Integer.toString(((IndexProxyDB2)storageObject).getInitialNumberUsedPages());
            propQTYData.maxSpace = Integer.toString(((IndexProxyDB2)storageObject).getMaxNumberUsedPages());
            if (((IndexProxyDB2)storageObject).getStorageTemplate() != null) {
                propQTYData.currPQTY = Integer.toString(((IndexProxyDB2)storageObject).getStorageTemplate().getSgPriqty());
                propQTYData.currSQTY = Integer.toString(((IndexProxyDB2)storageObject).getStorageTemplate().getSgSeqty());
            } else {
                propQTYData.currPQTY = "";
                propQTYData.currSQTY = "";
            }
            this.propQList.add(propQTYData);
        }
        iterator = this.storageDesign.getAUXTableIndexSet().iterator();
        while (iterator.hasNext()) {
            storageObject = (AUXTableIndexDB2)iterator.next();
            propQTYData = new PropQTYData();
            propQTYData.storageObject = storageObject;
            propQTYData.name = ((AUXTableIndexDB2)storageObject).getAuxTable().getName() + "." + storageObject.getName();
            propQTYData.type = Messages.getString("SpaceCalculationDB2.0");
            propQTYData.priQTY = Integer.toString(((AUXTableIndexDB2)storageObject).getProposedPRIQTY());
            propQTYData.secQTY = Integer.toString(((AUXTableIndexDB2)storageObject).getProposedSECQTY());
            propQTYData.initSpace = Integer.toString(((AUXTableIndexDB2)storageObject).getInitialNumberUsedPages());
            propQTYData.maxSpace = Integer.toString(((AUXTableIndexDB2)storageObject).getMaxNumberUsedPages());
            if (((AUXTableIndexDB2)storageObject).getStorageTemplate() != null) {
                propQTYData.currPQTY = Integer.toString(((AUXTableIndexDB2)storageObject).getStorageTemplate().getSgPriqty());
                propQTYData.currSQTY = Integer.toString(((AUXTableIndexDB2)storageObject).getStorageTemplate().getSgSeqty());
            } else {
                propQTYData.currPQTY = "";
                propQTYData.currSQTY = "";
            }
            this.propQList.add(propQTYData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void calculate() {
        if (this.useObjectLevelSettings()) {
            this.loadPropQLIst();
            ((PropQTYTableModel)this.qtyTable.getModel()).dataChanged();
            this.loadSpaceLIst();
            ((SpaceTableModel)this.spaceTable.getModel()).dataChanged();
        } else {
            try {
                this.backupAndSet();
                this.loadPropQLIst();
                ((PropQTYTableModel)this.qtyTable.getModel()).dataChanged();
                this.loadSpaceLIst();
                ((SpaceTableModel)this.spaceTable.getModel()).dataChanged();
            }
            catch (Exception exception) {
                System.out.println("Error: SpaceCalculationDB2.calculate");
            }
            finally {
                this.restore();
            }
        }
    }

    void loadSpaceLIst() {
        SpaceData spaceData;
        Object object;
        Iterator iterator;
        StorageObject storageObject;
        this.spaceList.clear();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        Iterator iterator2 = this.storageDesign.getDataBaseSet().iterator();
        while (iterator2.hasNext()) {
            n = 0;
            n2 = 0;
            n3 = 0;
            n4 = 0;
            storageObject = (DataBaseDB2)iterator2.next();
            iterator = this.storageDesign.getTableProxySet().iterator();
            while (iterator.hasNext()) {
                object = (TableProxyDB2)iterator.next();
                if (!((DataBaseDB2)storageObject).containsTable((TableProxyDB2)object)) continue;
                spaceData = new SpaceData();
                spaceData.storageObject = object;
                spaceData.name = ((RelationalObjectProxy)object).getName();
                spaceData.type = "Table";
                spaceData.initSpace = Integer.toString(((TableProxyDB2)object).getInitialNumberUsedPages());
                spaceData.maxSpace = Integer.toString(((TableProxyDB2)object).getMaxNumberUsedPages());
                spaceData.initSpaceKB = Integer.toString(((TableProxyDB2)object).getInitialStorageKB());
                spaceData.maxSpaceKB = Integer.toString(((TableProxyDB2)object).getMaxStorageKB());
                this.spaceList.add(spaceData);
                n += ((TableProxyDB2)object).getInitialNumberUsedPages();
                n2 += ((TableProxyDB2)object).getMaxNumberUsedPages();
                n3 += ((TableProxyDB2)object).getInitialStorageKB();
                n4 += ((TableProxyDB2)object).getMaxStorageKB();
            }
            if (n <= 0) continue;
            object = new SpaceData();
            ((SpaceData)object).initSpace = Integer.toString(n);
            ((SpaceData)object).maxSpace = Integer.toString(n2);
            ((SpaceData)object).initSpaceKB = Integer.toString(n3);
            ((SpaceData)object).maxSpaceKB = Integer.toString(n4);
            ((SpaceData)object).storageObject = storageObject;
            ((SpaceData)object).name = storageObject.getName();
            ((SpaceData)object).type = Messages.getString("SpaceCalculationDB2.DataBase");
            this.spaceList.add(object);
        }
        iterator2 = this.storageDesign.getStorageGroupSet().iterator();
        while (iterator2.hasNext()) {
            n = 0;
            n2 = 0;
            n3 = 0;
            n4 = 0;
            storageObject = (StorageGroupDB2)iterator2.next();
            iterator = this.storageDesign.getIndexProxySet().iterator();
            while (iterator.hasNext()) {
                object = (IndexProxyDB2)iterator.next();
                if (!((StorageGroupDB2)storageObject).containsIndex((IndexProxyDB2)object)) continue;
                spaceData = new SpaceData();
                spaceData.storageObject = object;
                spaceData.name = ((IndexProxy)object).getTableProxy().getName() + "." + ((IndexProxyDB2)object).getName();
                spaceData.type = "Index";
                spaceData.initSpace = Integer.toString(((IndexProxyDB2)object).getInitialNumberUsedPages());
                spaceData.maxSpace = Integer.toString(((IndexProxyDB2)object).getMaxNumberUsedPages());
                spaceData.initSpaceKB = Integer.toString((int)((IndexProxyDB2)object).getInitialNumberUsedKB());
                spaceData.maxSpaceKB = Integer.toString((int)((IndexProxyDB2)object).getMaxNumberUsedKB());
                this.spaceList.add(spaceData);
                n += ((IndexProxyDB2)object).getInitialNumberUsedPages();
                n2 += ((IndexProxyDB2)object).getMaxNumberUsedPages();
                n3 = (int)((long)n3 + ((IndexProxyDB2)object).getInitialNumberUsedKB());
                n4 = (int)((long)n4 + ((IndexProxyDB2)object).getMaxNumberUsedKB());
            }
            iterator = this.storageDesign.getAUXTableIndexSet().iterator();
            while (iterator.hasNext()) {
                object = (AUXTableIndexDB2)iterator.next();
                if (!((StorageGroupDB2)storageObject).containsAUXTableIndex((AUXTableIndexDB2)object)) continue;
                spaceData = new SpaceData();
                spaceData.storageObject = object;
                spaceData.name = ((AUXTableIndexDB2)object).getAuxTable().getName() + "." + ((StorageObject)object).getName();
                spaceData.type = "AUXTableIndex";
                spaceData.initSpace = Integer.toString(((AUXTableIndexDB2)object).getInitialNumberUsedPages());
                spaceData.maxSpace = Integer.toString(((AUXTableIndexDB2)object).getMaxNumberUsedPages());
                spaceData.initSpaceKB = Integer.toString((int)((AUXTableIndexDB2)object).getInitialNumberUsedKB());
                spaceData.maxSpaceKB = Integer.toString((int)((AUXTableIndexDB2)object).getMaxNumberUsedKB());
                this.spaceList.add(spaceData);
                n += ((AUXTableIndexDB2)object).getInitialNumberUsedPages();
                n2 += ((AUXTableIndexDB2)object).getMaxNumberUsedPages();
                n3 = (int)((long)n3 + ((AUXTableIndexDB2)object).getInitialNumberUsedKB());
                n4 = (int)((long)n4 + ((AUXTableIndexDB2)object).getMaxNumberUsedKB());
            }
            iterator = this.storageDesign.getTableSpaceSet().iterator();
            while (iterator.hasNext()) {
                object = (TableSpaceDB2)iterator.next();
                if (((StorageObject)object).isNullInstance() || !((StorageGroupDB2)storageObject).containsTableSpace((TableSpaceDB2)object)) continue;
                spaceData = new SpaceData();
                spaceData.storageObject = object;
                spaceData.name = ((TableSpaceDB2)object).getDataBase() != null ? ((TableSpaceDB2)object).getDataBase().getName() + "." + ((StorageObject)object).getName() : ((StorageObject)object).getName();
                spaceData.type = "TableSpace";
                spaceData.initSpace = Integer.toString(((TableSpaceDB2)object).getInitialNumberUsedPages());
                spaceData.maxSpace = Integer.toString(((TableSpaceDB2)object).getMaxNumberUsedPages());
                spaceData.initSpaceKB = Integer.toString(((TableSpaceDB2)object).getInitialNumberUsedPages());
                spaceData.maxSpaceKB = Integer.toString(((TableSpaceDB2)object).getMaxNumberUsedKB());
                this.spaceList.add(spaceData);
                n += ((TableSpaceDB2)object).getInitialNumberUsedPages();
                n2 += ((TableSpaceDB2)object).getMaxNumberUsedPages();
                n3 += ((TableSpaceDB2)object).getInitialNumberUsedKB();
                n4 += ((TableSpaceDB2)object).getMaxNumberUsedKB();
            }
            if (n <= 0) continue;
            object = new SpaceData();
            ((SpaceData)object).initSpace = Integer.toString(n);
            ((SpaceData)object).maxSpace = Integer.toString(n2);
            ((SpaceData)object).initSpaceKB = Integer.toString(n3);
            ((SpaceData)object).maxSpaceKB = Integer.toString(n4);
            ((SpaceData)object).storageObject = storageObject;
            ((SpaceData)object).name = storageObject.getName();
            ((SpaceData)object).type = "StorageGroup";
            this.spaceList.add(object);
        }
    }

    public class SpaceColorRenderer
    extends DefaultTableCellRenderer {
        List estDataList;

        public SpaceColorRenderer(List list) {
            this.estDataList = list;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Color color;
            Color color2;
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            EstData estData = (EstData)this.estDataList.get(n);
            if (estData.type != null && (estData.type.equalsIgnoreCase("DataBase") || estData.type.equalsIgnoreCase("StorageGroup"))) {
                color2 = Color.GRAY;
                color = Color.WHITE;
            } else {
                color2 = Color.WHITE;
                color = Color.BLACK;
            }
            this.setBackground(color2);
            this.setForeground(color);
            return this;
        }
    }

    class SpaceMouseListener
    implements MouseListener {
        List estDataList;

        SpaceMouseListener(List list) {
            this.estDataList = list;
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            Object object;
            if (mouseEvent.getClickCount() == 2 && (object = mouseEvent.getSource()) instanceof JTable) {
                int n = ((JTable)object).getSelectedRow();
                if (((EstData)this.estDataList.get((int)n)).storageObject != null) {
                    ((EstData)this.estDataList.get((int)n)).storageObject.showPropertyDialog();
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }
    }

    class SpaceTableModel
    extends AbstractTableModel {
        final String[] COL_NAMES = new String[]{Messages.getString("SpaceCalculationDB2.Name"), Messages.getString("SpaceCalculationDB2.Type"), Messages.getString("SpaceCalculationDB2.InitialPages"), Messages.getString("SpaceCalculationDB2.MaxPages"), Messages.getString("SpaceCalculationDB2.InitialSpaceKB"), Messages.getString("SpaceCalculationDB2.MaxSpaceKB")};
        String nullString = "";

        SpaceTableModel() {
        }

        @Override
        public int getColumnCount() {
            return this.COL_NAMES.length;
        }

        public void dataChanged() {
            this.fireTableDataChanged();
        }

        @Override
        public int getRowCount() {
            return SpaceCalculationDB2.this.spaceList.size();
        }

        @Override
        public String getColumnName(int n) {
            return this.COL_NAMES[n];
        }

        @Override
        public Object getValueAt(int n, int n2) {
            SpaceData spaceData = (SpaceData)SpaceCalculationDB2.this.spaceList.get(n);
            switch (n2) {
                case 0: {
                    return spaceData.name;
                }
                case 1: {
                    return spaceData.type;
                }
                case 2: {
                    return spaceData.initSpace;
                }
                case 3: {
                    return spaceData.maxSpace;
                }
                case 4: {
                    return spaceData.initSpaceKB;
                }
                case 5: {
                    return spaceData.maxSpaceKB;
                }
            }
            return this.nullString;
        }
    }

    class PropQTYTableModel
    extends AbstractTableModel {
        final String[] COL_NAMES = new String[]{Messages.getString("SpaceCalculationDB2.Name"), Messages.getString("SpaceCalculationDB2.Type"), Messages.getString("SpaceCalculationDB2.ProposedPRIQTY"), Messages.getString("SpaceCalculationDB2.ProposedSECQTY"), Messages.getString("SpaceCalculationDB2.InitialPages"), Messages.getString("SpaceCalculationDB2.MaxPages"), Messages.getString("SpaceCalculationDB2.CurrentPRIQTY"), Messages.getString("SpaceCalculationDB2.CurrentSECQTY")};
        String nullString = "Null";

        PropQTYTableModel() {
        }

        @Override
        public int getColumnCount() {
            return this.COL_NAMES.length;
        }

        public void dataChanged() {
            this.fireTableDataChanged();
        }

        @Override
        public int getRowCount() {
            return SpaceCalculationDB2.this.propQList.size();
        }

        @Override
        public String getColumnName(int n) {
            return this.COL_NAMES[n];
        }

        @Override
        public Object getValueAt(int n, int n2) {
            PropQTYData propQTYData = (PropQTYData)SpaceCalculationDB2.this.propQList.get(n);
            switch (n2) {
                case 0: {
                    return propQTYData.name;
                }
                case 1: {
                    return propQTYData.type;
                }
                case 2: {
                    return propQTYData.priQTY;
                }
                case 3: {
                    return propQTYData.secQTY;
                }
                case 4: {
                    return propQTYData.initSpace;
                }
                case 5: {
                    return propQTYData.maxSpace;
                }
                case 6: {
                    return propQTYData.currPQTY;
                }
                case 7: {
                    return propQTYData.currSQTY;
                }
            }
            return this.nullString;
        }
    }

    class SpaceData
    extends EstData {
        String initSpace;
        String maxSpace;
        String initSpaceKB;
        String maxSpaceKB;

        SpaceData() {
        }
    }

    class BackupData
    extends EstData {
        StorageTemplateDB2 stTemplate;
        String insMode;
        int pctFilling;
        boolean usePctFilling;

        BackupData() {
        }
    }

    class PropQTYData
    extends EstData {
        String priQTY;
        String secQTY;
        String initSpace;
        String maxSpace;
        String currPQTY;
        String currSQTY;

        PropQTYData() {
        }
    }

    class EstData {
        StorageObject storageObject;
        String name;
        String type;

        EstData() {
        }
    }

    private class UseObSetCheckBoxListener
    implements ActionListener {
        private UseObSetCheckBoxListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SpaceCalculationDB2.this.setUseObjectSettings(!SpaceCalculationDB2.this.chbUseObjectSet.isSelected());
        }
    }

    private class CheckBoxListener
    implements ActionListener {
        private CheckBoxListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SpaceCalculationDB2.this.setPCTFillingUse(SpaceCalculationDB2.this.chbUsePCTFilling.isSelected());
        }
    }

    private class PrintAction
    implements ActionListener {
        private PrintAction() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            block10: {
                if (SpaceCalculationDB2.this.tpane.getSelectedIndex() > 1) {
                    return;
                }
                DesignPrintModule designPrintModule = null;
                Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(3));
                try {
                    String[] stringArray;
                    if (designPrintModule == null) {
                        designPrintModule = new DesignPrintModule();
                    }
                    if ((stringArray = designPrintModule.connect()) != null) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        JPanel jPanel = new JPanel();
                        JTable jTable = SpaceCalculationDB2.this.tpane.getSelectedIndex() == 0 ? SpaceCalculationDB2.this.getQTYTable() : SpaceCalculationDB2.this.getSpaceTable();
                        jTable.setPreferredSize(jTable.getSize());
                        jPanel.setLayout(new SpringLayout());
                        jPanel.setSize(jTable.getSize());
                        jPanel.add(jTable.getTableHeader());
                        jPanel.add(jTable);
                        SpaceCalculationDB2.this.tpane.add(jPanel);
                        JPanel jPanel2 = jPanel;
                        Dimension dimension = jPanel2.getSize();
                        if (dimension.height <= 0 || dimension.width <= 0) {
                            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), new Object[]{Messages.getString("SpaceCalculationDB2.NoPrintableArea"), MessageFormat.format(Messages.getString("SpaceCalculationDB2.Width"), dimension.width), MessageFormat.format(Messages.getString("SpaceCalculationDB2.Height"), dimension.height)}, Messages.getString("SpaceCalculationDB2.Information"), 2);
                            return;
                        }
                        designPrintModule.setComponentToPrint(jPanel2, dimension);
                        JPanel jPanel3 = new JPanel(new BorderLayout());
                        jPanel3.add(designPrintModule.getButtonPanel(), "North");
                        jPanel3.add((Component)new JScrollPane(designPrintModule.getViewComponent()), "Center");
                        JDialog jDialog = new JDialog(SpaceCalculationDB2.this.appView.getFrame(), Messages.getString("SpaceCalculationDB2.Print"), true);
                        jDialog.setContentPane(jPanel3);
                        jDialog.pack();
                        jDialog.setSize(800, 600);
                        CommonUtil.centerOnScreen(jDialog);
                        jDialog.setVisible(true);
                        SpaceCalculationDB2.this.tpane.remove(jPanel);
                        break block10;
                    }
                    JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), stringArray, Messages.getString("SpaceCalculationDB2.PrintError"), 0);
                }
                finally {
                    Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        }
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SpaceCalculationDB2.this.dispose();
        }
    }

    private class CalculateAction
    implements ActionListener {
        private CalculateAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SpaceCalculationDB2.this.calculate();
        }
    }
}

