/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.storage;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import oracle.dbtools.crest.model.LongNameObject;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.swingui.AbstractController;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.MDBAction;
import oracle.dbtools.crest.swingui.MenuUtils;
import oracle.dbtools.crest.swingui.SelectableObject;
import oracle.dbtools.crest.swingui.storage.Messages;
import oracle.ide.Ide;

public class ControllerStorage
extends AbstractController {
    private StoreDesign storeDesign;
    private final String[] STORAGE_PATH = new String[]{AbstractController.STORAGE_CAPTION};
    private final String[] FILE_PATH = this.STORAGE_PATH;

    public ControllerStorage(ApplicationView applicationView) {
        super(applicationView);
    }

    public StoreDesign getStoreDesign() {
        return this.storeDesign;
    }

    @Override
    public void initializeActions() {
        if (this.isEditable()) {
            this.storeDesign = new StoreDesign();
            this.add(this.storeDesign);
        }
    }

    @Override
    public void setDesignPartView(DesignPartView designPartView) {
    }

    @Override
    protected void configureActions() {
        Iterator iterator = this.getActionsIterator();
        while (iterator.hasNext()) {
            MDBAction mDBAction = (MDBAction)iterator.next();
            if (!mDBAction.needSelectedObject()) continue;
            mDBAction.setEnabled(false);
        }
    }

    public RDBMSSite getSelectedSite() {
        RDBMSSite rDBMSSite = this.getPhysicalDesign() != null ? this.getPhysicalDesign().getSelectedRDBMSSite() : this.getDesign().getSelectedRDBMSSite();
        return rDBMSSite;
    }

    public StorageDesign getSelectedStorageDesign() {
        RDBMSSite rDBMSSite = this.getSelectedSite();
        StorageDesign storageDesign = this.getDesign().getStorageDesign(rDBMSSite);
        return storageDesign;
    }

    @Override
    public SelectableObject getCurrentSelection() {
        return null;
    }

    @Override
    public DesignPartView getDesignPartView() {
        return null;
    }

    @Override
    public String getToolBarName() {
        return Messages.getString("ControllerStorage.PhysicalModel");
    }

    public class StoreDesign
    extends MDBAction {
        private StoreDesign() {
            super(MenuUtils.getMnemonicStr(AbstractController.SAVE_STORAGE_DESIGN_CAPTION), ControllerStorage.this.getConfiguration().getIcon("SAVE_ICON", ControllerStorage.this.getPreferredIconSize()));
            this.setMenuPath(ControllerStorage.this.FILE_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.SAVE_STORAGE_DESIGN_CAPTION));
            this.setAccelerator(KeyStroke.getKeyStroke(83, 576, false));
        }

        @Override
        public boolean addSeparatorBefore() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            if (!ControllerStorage.this.getDesign().isNewDesign()) {
                RelationalDesign relationalDesign = ControllerStorage.this.getApplicationView().selectRelationalDesign();
                if (relationalDesign != null) {
                    LongNameObject longNameObject;
                    StorageDesign[] storageDesignArray = relationalDesign.getStorageDesignFactory().getOpenStorageDesigns();
                    ArrayList<RDBMSSite> arrayList = new ArrayList<RDBMSSite>();
                    Object[] objectArray = null;
                    for (int i = 0; i < storageDesignArray.length; ++i) {
                        longNameObject = storageDesignArray[i];
                        if (!longNameObject.isDirty() && !longNameObject.hasDirtyStorableObjects()) continue;
                        arrayList.add(longNameObject.getRDBMSSite());
                    }
                    if (arrayList.toArray().length > 1) {
                        JList<Object> jList = new JList<Object>(arrayList.toArray());
                        if (relationalDesign.getSelectedRDBMSSite() != null) {
                            jList.setSelectedValue(relationalDesign.getSelectedRDBMSSite(), true);
                        }
                        JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), new JScrollPane(jList), Messages.getString("ControllerStorage.SavePhysicalModels"), 3);
                        objectArray = jList.getSelectedValues();
                    } else if (arrayList.toArray().length == 1) {
                        objectArray = arrayList.toArray();
                    } else {
                        ApplicationView.log(Messages.getString("ControllerStorage.NoPhysicalModelOpened"));
                        JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("ControllerStorage.NoPhysicalModelOpened"));
                        return;
                    }
                    for (int i = 0; i < objectArray.length; ++i) {
                        longNameObject = (RDBMSSite)objectArray[i];
                        StorageDesign storageDesign = relationalDesign.getStorageDesign((RDBMSSite)longNameObject);
                        ApplicationView.log(Messages.getString("ControllerStorage.SavePhysicalModel") + storageDesign.getFileName());
                        if (storageDesign.isTempModel()) continue;
                        storageDesign.save();
                        storageDesign.setDirty(false);
                    }
                }
            } else {
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("ControllerStorage.SaveMainDesign"), Messages.getString("ControllerStorage.Warning"), 2);
            }
        }
    }
}

