/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.search;

import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.datatypes.TVStructuredType;
import oracle.dbtools.crest.swingui.diagram.datatypes.StructuredTypeDiagramCell;
import oracle.dbtools.crest.swingui.diagram.logical.EntityDiagramCell;
import oracle.dbtools.crest.swingui.diagram.logical.EntityViewDiagramCell;
import oracle.dbtools.crest.swingui.diagram.logical.RelationEdge;
import oracle.dbtools.crest.swingui.diagram.multidimensional.CubeDiagramCell;
import oracle.dbtools.crest.swingui.diagram.multidimensional.DimensionDiagramCell;
import oracle.dbtools.crest.swingui.diagram.multidimensional.LevelDiagramCell;
import oracle.dbtools.crest.swingui.diagram.process.AgentDiagramCell;
import oracle.dbtools.crest.swingui.diagram.process.ProcessDiagramCell;
import oracle.dbtools.crest.swingui.diagram.process.StoreDiagramCell;
import oracle.dbtools.crest.swingui.diagram.relational.FKEdge;
import oracle.dbtools.crest.swingui.diagram.relational.TableDiagramCell;
import oracle.dbtools.crest.swingui.diagram.relational.TableViewDiagramCell;
import oracle.dbtools.crest.swingui.logical.TVEntity;
import oracle.dbtools.crest.swingui.logical.TVEntityView;
import oracle.dbtools.crest.swingui.logical.TVRelation;
import oracle.dbtools.crest.swingui.multidimensional.TVCube;
import oracle.dbtools.crest.swingui.multidimensional.TVDimension;
import oracle.dbtools.crest.swingui.multidimensional.TVLevel;
import oracle.dbtools.crest.swingui.process.TVAgent;
import oracle.dbtools.crest.swingui.process.TVInfoStore;
import oracle.dbtools.crest.swingui.process.TVProcess;
import oracle.dbtools.crest.swingui.relational.TVFKRelation;
import oracle.dbtools.crest.swingui.relational.TVTable;
import oracle.dbtools.crest.swingui.relational.TVView;
import oracle.dbtools.crest.swingui.search.ItemsHolder;
import oracle.dbtools.crest.swingui.search.Messages;
import oracle.dbtools.crest.swingui.search.SearchResultsList;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class SearchPanel
extends CustomDialog
implements ActionListener,
PropertyChangeListener {
    private static final String ENTITY_STR = "Entity";
    private static final String TABLE_STR = "Table";
    private static final String ATTRIBUTE_STR = "Attribute";
    private static final String COLUMN_STR = "Column";
    private static final String KEY_STR = "Key";
    private static final String INDEX_STR = "Index";
    private static final String VIEW_STR = "View";
    private static final String FOREIGN_KEY_STR = "Foreign Key";
    private static final String RELATION_STR = "Relation";
    private static final String PROCESS_STR = "Process";
    private static final String AGENT_STR = "External Agent";
    private static final String STORE_STR = "Info Store";
    private static final String CUBE_STR = "Cube";
    private static final String DIMENSION_STR = "Dimension";
    private static final String LEVEL_STR = "Level";
    private static final String STRUCTURED_TYPE_STR = "Structured Type";
    private Object[] logicalItems = new Object[]{"Entity", "Attribute", "Key", "View", "Relation"};
    private Object[] physicalItems = new Object[]{"Table", "Column", "Index", "View", "Foreign Key"};
    private Object[] processItems = new Object[]{"Process", "External Agent", "Info Store"};
    private Object[] multidimensionalItems = new Object[]{"Cube", "Level", "Dimension"};
    private Object[] dataTypesItems = new Object[]{"Structured Type"};
    public static final int LOGICAL_SEARCH = 1;
    public static final int PHYSICAL_SEARCH = 2;
    public static final int PROCESS_SEARCH = 3;
    public static final int MULTIDIMENSIONAL_SEARCH = 4;
    public static final int DATATYPES_SEARCH = 5;
    JDialog dlg;
    private JTextField textField;
    private JOptionPane optionPane;
    private String typedText = null;
    private JComboBox comboBox;
    private JCheckBox checkBox;
    private String btnFind = Messages.getString("SearchPanel.Find");
    private String btnCancel = Messages.getString("SearchPanel.Cancel");
    private String btnHelp = Messages.getString("SearchPanel.Help");
    private SearchResultsList resultList;
    private JFrame frame;
    private int currentType;
    private JDialog dialog;

    public SearchPanel(ApplicationView applicationView) {
        super(applicationView);
        this.frame = applicationView.getFrame();
        this.textField = new JTextField();
        this.comboBox = new JComboBox();
        this.checkBox = new JCheckBox(Messages.getString("SearchPanel.CaseSensitive"));
        this.checkBox.setMnemonic(67);
        String string = Messages.getString("SearchPanel.ObjectToFind");
        String string2 = Messages.getString("SearchPanel.ObjectType");
        Object[] objectArray = new Object[]{string, this.textField, this.checkBox, string2, this.comboBox};
        Object[] objectArray2 = new Object[]{this.btnFind, this.btnCancel, this.btnHelp};
        this.optionPane = new JOptionPane(objectArray, -1, 0, null, objectArray2, objectArray2[0]);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent componentEvent) {
                SearchPanel.this.textField.requestFocusInWindow();
                SearchPanel.this.textField.selectAll();
            }
        });
        this.textField.addActionListener(this);
        this.optionPane.addPropertyChangeListener(this);
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    @Override
    public Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.frame, Messages.getString("SearchPanel.Find"));
            this.dialog.setResizable(false);
            this.dialog.setContentPane(this.optionPane);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            CommonUtil.centerOnScreen(this.dialog);
        }
        return this.dialog;
    }

    @Override
    protected String getHelpIndex() {
        return "FIND_DIALOG";
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.optionPane.setValue(this.btnFind);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        boolean bl = false;
        if (this.isVisible() && propertyChangeEvent.getSource() == this.optionPane && ("value".equals(string) || "inputValue".equals(string))) {
            Object object = this.optionPane.getValue();
            if (object == JOptionPane.UNINITIALIZED_VALUE) {
                return;
            }
            this.optionPane.setValue(JOptionPane.UNINITIALIZED_VALUE);
            if (this.btnFind.equals(object)) {
                this.typedText = this.textField.getText();
                this.getSearchResultList().clear();
                String string2 = (String)this.comboBox.getSelectedItem();
                bl = ENTITY_STR.equalsIgnoreCase(string2) ? this.findEntity(this.typedText) : (TABLE_STR.equalsIgnoreCase(string2) ? this.findTable(this.typedText) : (ATTRIBUTE_STR.equalsIgnoreCase(string2) ? this.findAttribute(this.typedText) : (COLUMN_STR.equalsIgnoreCase(string2) ? this.findColumn(this.typedText) : (KEY_STR.equalsIgnoreCase(string2) ? this.findCandidateKey(this.typedText) : (INDEX_STR.equalsIgnoreCase(string2) ? this.findIndex(this.typedText) : (VIEW_STR.equalsIgnoreCase(string2) ? (this.currentType == 1 ? this.findEntityView(this.typedText) : this.findView(this.typedText)) : (FOREIGN_KEY_STR.equalsIgnoreCase(string2) ? this.findFK(this.typedText) : (RELATION_STR.equalsIgnoreCase(string2) ? this.findRelation(this.typedText) : (PROCESS_STR.equalsIgnoreCase(string2) ? this.findProcess(this.typedText) : (AGENT_STR.equalsIgnoreCase(string2) ? this.findAgent(this.typedText) : (STORE_STR.equalsIgnoreCase(string2) ? this.findStore(this.typedText) : (CUBE_STR.equalsIgnoreCase(string2) ? this.findCube(this.typedText) : (LEVEL_STR.equalsIgnoreCase(string2) ? this.findLevel(this.typedText) : (DIMENSION_STR.equalsIgnoreCase(string2) ? this.findDimension(this.typedText) : (STRUCTURED_TYPE_STR.equalsIgnoreCase(string2) ? this.findStructuredType(this.typedText) : false)))))))))))))));
                if (bl) {
                    this.clearAndHide();
                    this.getSearchResultList().sort();
                    this.showResults();
                } else {
                    this.textField.selectAll();
                    JOptionPane.showMessageDialog(this, MessageFormat.format(Messages.getString("SearchPanel.NoMatchFound"), this.typedText), Messages.getString("SearchPanel.FindObject"), 1);
                }
            } else if (this.btnHelp.equals(object)) {
                this.getHelpAction().actionPerformed(null);
            } else {
                this.typedText = null;
                this.clearAndHide();
            }
        }
    }

    public void clearAndHide() {
        this.close();
    }

    public String getSearchText() {
        return this.typedText;
    }

    private boolean findEntity(String string) {
        boolean bl = false;
        DesignPartView designPartView = this.getApplicationView().getCurrentDPV();
        Object[] objectArray = designPartView.getWorkSpace().getRoots();
        for (int i = 0; i < objectArray.length; ++i) {
            TVEntity tVEntity;
            if (!(objectArray[i] instanceof EntityDiagramCell) || !(((EntityDiagramCell)objectArray[i]).getTopView() instanceof TVEntity) || !this.match((tVEntity = (TVEntity)((EntityDiagramCell)objectArray[i]).getTopView()).toString(), string)) continue;
            this.getSearchResultList().addDesignObject(tVEntity);
            bl = true;
        }
        return bl;
    }

    private boolean findTable(String string) {
        boolean bl = false;
        DesignPartView designPartView = this.getApplicationView().getCurrentDPV();
        Object[] objectArray = designPartView.getWorkSpace().getRoots();
        for (int i = 0; i < objectArray.length; ++i) {
            TVTable tVTable;
            if (!(objectArray[i] instanceof TableDiagramCell) || !(((TableDiagramCell)objectArray[i]).getTopView() instanceof TVTable) || !this.match((tVTable = (TVTable)((TableDiagramCell)objectArray[i]).getTopView()).toString(), string)) continue;
            this.getSearchResultList().addDesignObject(tVTable);
            bl = true;
        }
        return bl;
    }

    private boolean findAttribute(String string) {
        boolean bl = false;
        ArrayList<ItemsHolder> arrayList = new ArrayList<ItemsHolder>();
        DesignPartView designPartView = this.getApplicationView().getCurrentDPV();
        Object[] objectArray = designPartView.getWorkSpace().getRoots();
        for (int i = 0; i < objectArray.length; ++i) {
            if (!(objectArray[i] instanceof EntityDiagramCell) || !(((EntityDiagramCell)objectArray[i]).getTopView() instanceof TVEntity)) continue;
            TVEntity object = (TVEntity)((EntityDiagramCell)objectArray[i]).getTopView();
            Entity entity = (Entity)object.getModel();
            ContainedObject[] containedObjectArray = entity.getElements();
            for (int j = 0; j < containedObjectArray.length; ++j) {
                ItemsHolder itemsHolder = new ItemsHolder();
                itemsHolder.dobject = containedObjectArray[j];
                itemsHolder.tv = object;
                arrayList.add(itemsHolder);
            }
        }
        for (ItemsHolder itemsHolder : arrayList) {
            if (!this.match(itemsHolder.toString(), string)) continue;
            this.getSearchResultList().addDesignObject(itemsHolder);
            bl = true;
        }
        return bl;
    }

    private boolean findColumn(String string) {
        boolean bl = false;
        ArrayList<ItemsHolder> arrayList = new ArrayList<ItemsHolder>();
        DesignPartView designPartView = this.getApplicationView().getCurrentDPV();
        Object[] objectArray = designPartView.getWorkSpace().getRoots();
        for (int i = 0; i < objectArray.length; ++i) {
            if (!(objectArray[i] instanceof TableDiagramCell) || !(((TableDiagramCell)objectArray[i]).getTopView() instanceof TVTable)) continue;
            TVTable object = (TVTable)((TableDiagramCell)objectArray[i]).getTopView();
            Table table = (Table)object.getModel();
            ContainedObject[] containedObjectArray = table.getElements();
            for (int j = 0; j < containedObjectArray.length; ++j) {
                ItemsHolder itemsHolder = new ItemsHolder();
                itemsHolder.dobject = containedObjectArray[j];
                itemsHolder.tv = object;
                arrayList.add(itemsHolder);
            }
        }
        for (ItemsHolder itemsHolder : arrayList) {
            if (!this.match(itemsHolder.toString(), string)) continue;
            this.getSearchResultList().addDesignObject(itemsHolder);
            bl = true;
        }
        return bl;
    }

    private boolean findCandidateKey(String string) {
        boolean bl = false;
        ArrayList<ItemsHolder> arrayList = new ArrayList<ItemsHolder>();
        DesignPartView designPartView = this.getApplicationView().getCurrentDPV();
        Object[] objectArray = designPartView.getWorkSpace().getRoots();
        for (int i = 0; i < objectArray.length; ++i) {
            if (!(objectArray[i] instanceof EntityDiagramCell) || !(((EntityDiagramCell)objectArray[i]).getTopView() instanceof TVEntity)) continue;
            TVEntity object = (TVEntity)((EntityDiagramCell)objectArray[i]).getTopView();
            Entity entity = (Entity)object.getModel();
            KeyObject[] keyObjectArray = entity.getKeys();
            for (int j = 0; j < keyObjectArray.length; ++j) {
                ItemsHolder itemsHolder = new ItemsHolder();
                itemsHolder.dobject = keyObjectArray[j];
                itemsHolder.tv = object;
                arrayList.add(itemsHolder);
            }
        }
        for (ItemsHolder itemsHolder : arrayList) {
            if (!this.match(itemsHolder.toString(), string)) continue;
            this.getSearchResultList().addDesignObject(itemsHolder);
            bl = true;
        }
        return bl;
    }

    private boolean findIndex(String string) {
        boolean bl = false;
        ArrayList<ItemsHolder> arrayList = new ArrayList<ItemsHolder>();
        DesignPartView designPartView = this.getApplicationView().getCurrentDPV();
        Object[] objectArray = designPartView.getWorkSpace().getRoots();
        for (int i = 0; i < objectArray.length; ++i) {
            if (!(objectArray[i] instanceof TableDiagramCell) || !(((TableDiagramCell)objectArray[i]).getTopView() instanceof TVTable)) continue;
            TVTable object = (TVTable)((TableDiagramCell)objectArray[i]).getTopView();
            Table table = (Table)object.getModel();
            KeyObject[] keyObjectArray = table.getKeys();
            for (int j = 0; j < keyObjectArray.length; ++j) {
                ItemsHolder itemsHolder = new ItemsHolder();
                itemsHolder.dobject = keyObjectArray[j];
                itemsHolder.tv = object;
                arrayList.add(itemsHolder);
            }
        }
        for (ItemsHolder itemsHolder : arrayList) {
            if (!this.match(itemsHolder.toString(), string)) continue;
            this.getSearchResultList().addDesignObject(itemsHolder);
            bl = true;
        }
        return bl;
    }

    private boolean findView(String string) {
        boolean bl = false;
        DesignPartView designPartView = this.getApplicationView().getCurrentDPV();
        Object[] objectArray = designPartView.getWorkSpace().getRoots();
        for (int i = 0; i < objectArray.length; ++i) {
            TVView tVView;
            if (!(objectArray[i] instanceof TableViewDiagramCell) || !(((TableViewDiagramCell)objectArray[i]).getTopView() instanceof TVView) || !this.match((tVView = (TVView)((TableViewDiagramCell)objectArray[i]).getTopView()).toString(), string)) continue;
            this.getSearchResultList().addDesignObject(tVView);
            bl = true;
        }
        return bl;
    }

    private boolean findEntityView(String string) {
        boolean bl = false;
        DesignPartView designPartView = this.getApplicationView().getCurrentDPV();
        Object[] objectArray = designPartView.getWorkSpace().getRoots();
        for (int i = 0; i < objectArray.length; ++i) {
            TVEntityView tVEntityView;
            if (!(objectArray[i] instanceof EntityViewDiagramCell) || !(((EntityViewDiagramCell)objectArray[i]).getTopView() instanceof TVEntityView) || !this.match((tVEntityView = (TVEntityView)((EntityViewDiagramCell)objectArray[i]).getTopView()).toString(), string)) continue;
            this.getSearchResultList().addDesignObject(tVEntityView);
            bl = true;
        }
        return bl;
    }

    private boolean findFK(String string) {
        boolean bl = false;
        DesignPartView designPartView = this.getApplicationView().getCurrentDPV();
        Object[] objectArray = designPartView.getWorkSpace().getRoots();
        for (int i = 0; i < objectArray.length; ++i) {
            TVFKRelation tVFKRelation;
            if (!(objectArray[i] instanceof FKEdge) || !(((FKEdge)objectArray[i]).getTopView() instanceof TVFKRelation) || !this.match((tVFKRelation = (TVFKRelation)((FKEdge)objectArray[i]).getTopView()).toString(), string)) continue;
            this.getSearchResultList().addDesignObject(tVFKRelation);
            bl = true;
        }
        return bl;
    }

    private boolean findRelation(String string) {
        boolean bl = false;
        DesignPartView designPartView = this.getApplicationView().getCurrentDPV();
        Object[] objectArray = designPartView.getWorkSpace().getRoots();
        for (int i = 0; i < objectArray.length; ++i) {
            TVRelation tVRelation;
            if (!(objectArray[i] instanceof RelationEdge) || !(((RelationEdge)objectArray[i]).getTopView() instanceof TVRelation) || !this.match((tVRelation = (TVRelation)((RelationEdge)objectArray[i]).getTopView()).toString(), string)) continue;
            this.getSearchResultList().addDesignObject(tVRelation);
            bl = true;
        }
        return bl;
    }

    private boolean findProcess(String string) {
        boolean bl = false;
        DesignPartView designPartView = this.getApplicationView().getCurrentDPV();
        Object[] objectArray = designPartView.getWorkSpace().getRoots();
        for (int i = 0; i < objectArray.length; ++i) {
            TVProcess tVProcess;
            if (!(objectArray[i] instanceof ProcessDiagramCell) || !(((ProcessDiagramCell)objectArray[i]).getTopView() instanceof TVProcess) || !this.match((tVProcess = (TVProcess)((ProcessDiagramCell)objectArray[i]).getTopView()).toString(), string)) continue;
            this.getSearchResultList().addDesignObject(tVProcess);
            bl = true;
        }
        return bl;
    }

    private boolean findAgent(String string) {
        boolean bl = false;
        DesignPartView designPartView = this.getApplicationView().getCurrentDPV();
        Object[] objectArray = designPartView.getWorkSpace().getRoots();
        for (int i = 0; i < objectArray.length; ++i) {
            TVAgent tVAgent;
            if (!(objectArray[i] instanceof AgentDiagramCell) || !(((AgentDiagramCell)objectArray[i]).getTopView() instanceof TVAgent) || !this.match((tVAgent = (TVAgent)((AgentDiagramCell)objectArray[i]).getTopView()).toString(), string)) continue;
            this.getSearchResultList().addDesignObject(tVAgent);
            bl = true;
        }
        return bl;
    }

    private boolean findStore(String string) {
        boolean bl = false;
        DesignPartView designPartView = this.getApplicationView().getCurrentDPV();
        Object[] objectArray = designPartView.getWorkSpace().getRoots();
        for (int i = 0; i < objectArray.length; ++i) {
            TVInfoStore tVInfoStore;
            if (!(objectArray[i] instanceof StoreDiagramCell) || !(((StoreDiagramCell)objectArray[i]).getTopView() instanceof TVInfoStore) || !this.match((tVInfoStore = (TVInfoStore)((StoreDiagramCell)objectArray[i]).getTopView()).toString(), string)) continue;
            this.getSearchResultList().addDesignObject(tVInfoStore);
            bl = true;
        }
        return bl;
    }

    private boolean findCube(String string) {
        boolean bl = false;
        DesignPartView designPartView = this.getApplicationView().getCurrentDPV();
        Object[] objectArray = designPartView.getWorkSpace().getRoots();
        for (int i = 0; i < objectArray.length; ++i) {
            TVCube tVCube;
            if (!(objectArray[i] instanceof CubeDiagramCell) || !(((CubeDiagramCell)objectArray[i]).getTopView() instanceof TVCube) || !this.match((tVCube = (TVCube)((CubeDiagramCell)objectArray[i]).getTopView()).toString(), string)) continue;
            this.getSearchResultList().addDesignObject(tVCube);
            bl = true;
        }
        return bl;
    }

    private boolean findLevel(String string) {
        boolean bl = false;
        DesignPartView designPartView = this.getApplicationView().getCurrentDPV();
        Object[] objectArray = designPartView.getWorkSpace().getRoots();
        for (int i = 0; i < objectArray.length; ++i) {
            TVLevel tVLevel;
            if (!(objectArray[i] instanceof LevelDiagramCell) || !(((LevelDiagramCell)objectArray[i]).getTopView() instanceof TVLevel) || !this.match((tVLevel = (TVLevel)((LevelDiagramCell)objectArray[i]).getTopView()).toString(), string)) continue;
            this.getSearchResultList().addDesignObject(tVLevel);
            bl = true;
        }
        return bl;
    }

    private boolean findDimension(String string) {
        boolean bl = false;
        DesignPartView designPartView = this.getApplicationView().getCurrentDPV();
        Object[] objectArray = designPartView.getWorkSpace().getRoots();
        for (int i = 0; i < objectArray.length; ++i) {
            TVDimension tVDimension;
            if (!(objectArray[i] instanceof DimensionDiagramCell) || !(((DimensionDiagramCell)objectArray[i]).getTopView() instanceof TVDimension) || !this.match((tVDimension = (TVDimension)((DimensionDiagramCell)objectArray[i]).getTopView()).toString(), string)) continue;
            this.getSearchResultList().addDesignObject(tVDimension);
            bl = true;
        }
        return bl;
    }

    private boolean findStructuredType(String string) {
        boolean bl = false;
        DesignPartView designPartView = this.getApplicationView().getCurrentDPV();
        Object[] objectArray = designPartView.getWorkSpace().getRoots();
        for (int i = 0; i < objectArray.length; ++i) {
            TVStructuredType tVStructuredType;
            if (!(objectArray[i] instanceof StructuredTypeDiagramCell) || !(((StructuredTypeDiagramCell)objectArray[i]).getTopView() instanceof TVStructuredType) || !this.match((tVStructuredType = (TVStructuredType)((StructuredTypeDiagramCell)objectArray[i]).getTopView()).toString(), string)) continue;
            this.getSearchResultList().addDesignObject(tVStructuredType);
            bl = true;
        }
        return bl;
    }

    private SearchResultsList getSearchResultList() {
        if (this.resultList == null) {
            this.resultList = new SearchResultsList(this.getApplicationView());
            this.resultList.pack();
            this.getSearchResultList().setLocationRelativeTo(this.frame);
        }
        return this.resultList;
    }

    private void showResults() {
        if (!this.getSearchResultList().isEmpty()) {
            this.getSearchResultList().addDesignObject(" ");
            this.getSearchResultList().setVisible(true);
        }
    }

    private boolean match(String string, String string2) {
        if (!this.checkBox.isSelected()) {
            string = string.toUpperCase();
            string2 = string2.toUpperCase();
        }
        if (!"".equalsIgnoreCase(string2)) {
            if ("*".equalsIgnoreCase(string2)) {
                return true;
            }
            if (string2.indexOf(42) > -1) {
                string2 = string2.replaceAll("\\*", "\\.*");
                Pattern pattern = Pattern.compile(string2);
                Matcher matcher = pattern.matcher(string);
                return matcher.matches();
            }
            return string.equals(string2);
        }
        return false;
    }

    public void resetItems(int n) {
        if (n != -1 && this.currentType != n) {
            this.currentType = n;
            this.comboBox.removeAllItems();
            if (this.currentType == 1) {
                this.comboBox.setModel(new DefaultComboBoxModel<Object>(this.logicalItems));
            } else if (this.currentType == 2) {
                this.comboBox.setModel(new DefaultComboBoxModel<Object>(this.physicalItems));
            } else if (this.currentType == 3) {
                this.comboBox.setModel(new DefaultComboBoxModel<Object>(this.processItems));
            } else if (this.currentType == 4) {
                this.comboBox.setModel(new DefaultComboBoxModel<Object>(this.multidimensionalItems));
            } else if (this.currentType == 5) {
                this.comboBox.setModel(new DefaultComboBoxModel<Object>(this.dataTypesItems));
            }
        }
    }
}

