/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.relational;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import oracle.dbtools.crest.model.MultiShapedDesignObject;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.ContainerWithKeyObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.relational.FKArc;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.TopViewListener;
import oracle.dbtools.crest.swingui.relational.TVFKRelation;
import oracle.dbtools.crest.util.logging.Logger;

public class TVTable
extends ContainerView {
    private Collection conns = new ArrayList();
    private Set listeners = new HashSet();
    private static final Logger LOGGER = new Logger(TVTable.class);

    public TVTable(ApplicationView applicationView, DesignPartView designPartView) {
        super(applicationView, designPartView);
    }

    @Override
    protected void fireChange(ObjectChangeEvent objectChangeEvent) {
        TopViewListener[] topViewListenerArray = this.listeners.toArray(new TopViewListener[0]);
        for (int i = 0; i < topViewListenerArray.length; ++i) {
            try {
                topViewListenerArray[i].changed(this, objectChangeEvent);
                continue;
            }
            catch (Exception exception) {
                LOGGER.error("Listener caused exception: ", exception);
            }
        }
    }

    public void addConnection(FKIndexAssociation.FKConnection fKConnection) {
        this.conns.add(fKConnection);
        ++fKConnection.countAdded;
        if (fKConnection.countAdded < 2 && fKConnection.getChildTable() == this.getModel()) {
            TVTable tVTable = fKConnection.getSourceTV(this.getDesignPartView());
            if (tVTable == null) {
                tVTable = (TVTable)this.getApplicationView().getDPVRelational().openViewFor(fKConnection.getParentTable());
            }
            tVTable.addConnection(fKConnection);
        }
    }

    @Override
    public void addTopViewListener(TopViewListener topViewListener) {
        this.listeners.add(topViewListener);
    }

    @Override
    public void removeTopViewListener(TopViewListener topViewListener) {
        this.listeners.remove(topViewListener);
    }

    public void remConnection(FKIndexAssociation.FKConnection fKConnection) {
        this.conns.remove(fKConnection);
        --fKConnection.countAdded;
    }

    public void addJustConnection(FKIndexAssociation.FKConnection fKConnection) {
        this.conns.add(fKConnection);
        ++fKConnection.countAdded;
    }

    public void removeConnection(FKIndexAssociation.FKConnection fKConnection) {
        TVTable tVTable;
        this.conns.remove(fKConnection);
        --fKConnection.countAdded;
        if (fKConnection.countAdded > 0 && fKConnection.getChildTable() == this.getModel() && (tVTable = fKConnection.getSourceTV(this.getDesignPartView())) != null) {
            tVTable.removeConnection(fKConnection);
        }
    }

    @Override
    public void changed(DesignObject designObject, ObjectChangeEvent objectChangeEvent) {
        if (!objectChangeEvent.isType(ObjectChangeEvent.FKINDEX_ADDED) || !objectChangeEvent.isType(ObjectChangeEvent.FKINDEX_REMOVED)) {
            super.changed(designObject, objectChangeEvent);
        }
    }

    @Override
    public DesignPartView getDesignPartView() {
        if (this.dpv == null) {
            if (ApplicationView.loading) {
                return this.getDesign().getRelationalDesign().getMainView();
            }
            return this.getApplicationView().getCurrentDPV();
        }
        return this.dpv;
    }

    @Override
    public void setModel(DesignObject designObject) {
        super.setModel(designObject);
    }

    protected FKIndexAssociation.FKConnection[] getConnections() {
        FKIndexAssociation[] fKIndexAssociationArray = ((Table)this.getModel()).getFKAssociations();
        FKIndexAssociation.FKConnection[] fKConnectionArray = new FKIndexAssociation.FKConnection[fKIndexAssociationArray.length];
        for (int i = 0; i < fKIndexAssociationArray.length; ++i) {
            fKConnectionArray[i] = fKIndexAssociationArray[i].getFKConnection();
        }
        return fKConnectionArray;
    }

    public void redistributePoints() {
    }

    public Collection getAllConnections() {
        return this.conns;
    }

    public void addTVFKRelations() {
        Table table = (Table)this.getModel();
        DesignPartView designPartView = this.getDesignPartView();
        FKIndexAssociation[] fKIndexAssociationArray = table.getFKAssociations();
        for (int i = 0; i < fKIndexAssociationArray.length; ++i) {
            if (fKIndexAssociationArray[i].getTargetTV(designPartView) == null) {
                fKIndexAssociationArray[i].setTargetTVTable(this);
            }
            fKIndexAssociationArray[i].getSourceTV(designPartView);
        }
        Collection collection = ((RelationalDesign)this.getModel().getDesignPart()).getFKIndexAssociationSet().getAssociationsWith(table);
        for (FKIndexAssociation fKIndexAssociation : collection) {
            if (fKIndexAssociation.getSourceTV(designPartView) == null) {
                fKIndexAssociation.setSourceTVTable(this);
            }
            fKIndexAssociation.getTargetTV(designPartView);
            if (fKIndexAssociation.getContainerWithKeyObject() != fKIndexAssociation.getRemoteTable()) continue;
            ((TVFKRelation)fKIndexAssociation.getViewFor(designPartView)).repairSelfReference(this);
        }
    }

    public void addTVFKRelations(DesignPartView designPartView) {
        Table table = (Table)this.getModel();
        FKIndexAssociation[] fKIndexAssociationArray = table.getFKAssociations();
        for (int i = 0; i < fKIndexAssociationArray.length; ++i) {
            if (fKIndexAssociationArray[i].getTargetTV(designPartView) != null) continue;
            fKIndexAssociationArray[i].setTargetTVTable(this);
        }
        Collection collection = ((RelationalDesign)this.getModel().getDesignPart()).getFKIndexAssociationSet().getAssociationsWith(table);
        for (FKIndexAssociation fKIndexAssociation : collection) {
            if (fKIndexAssociation.getSourceTV(designPartView) == null) {
                fKIndexAssociation.setSourceTVTable(this);
            }
            if (fKIndexAssociation.getContainerWithKeyObject() != fKIndexAssociation.getRemoteTable()) continue;
            ((TVFKRelation)fKIndexAssociation.getViewFor(designPartView)).repairSelfReference(this);
        }
    }

    @Override
    protected void doPrivateActions() {
        this.reassignFKs();
    }

    @Override
    protected ContainerView createViewSynonim(ApplicationView applicationView, DesignPartView designPartView) {
        return new TVTable(applicationView, designPartView);
    }

    public void reassignFKs() {
        TVTable tVTable = (TVTable)((ContainerWithKeyObject)this.getModel()).getAnotherView(this);
        if (tVTable != null) {
            Object object2;
            Table table = (Table)this.getModel();
            Collection collection = ((RelationalDesign)this.getModel().getDesignPart()).getFKIndexAssociationSet().getAssociationsWith(table);
            for (Object object2 : collection) {
                if (((FKIndexAssociation)object2).getSourceTV(this.getDesignPartView()) != this) continue;
                ((FKIndexAssociation)object2).setSourceTVTable(tVTable);
            }
            object2 = table.getFKAssociations();
            for (int i = 0; i < ((Object)object2).length; ++i) {
                if (((FKIndexAssociation)object2[i]).getTargetTV(this.getDesignPartView()) != this) continue;
                ((FKIndexAssociation)object2[i]).setTargetTVTable(tVTable);
            }
        } else {
            this.fireChange(ObjectChangeEvent.TOPVIEW_REMOVED);
        }
    }

    @Override
    public String toString() {
        int n = this.getViewNumber();
        String string = n == 0 ? "" : ":" + n;
        return this.getModel().getName() + string;
    }

    @Override
    protected void hideRelations() {
    }

    public void addArcs() {
        Object object;
        Table table = (Table)this.getModel();
        for (DesignObject designObject : table.getArcs()) {
            if (((MultiShapedDesignObject)designObject).getFirstViewForDPV(this.getDesignPartView()) != null) continue;
            object = ((FKArc)designObject).getFkeys().iterator();
            int n = 0;
            while (object.hasNext()) {
                FKIndexAssociation fKIndexAssociation = (FKIndexAssociation)object.next();
                TopView topView = fKIndexAssociation.getFirstViewForDPV(this.getDesignPartView());
                if (topView == null) continue;
                ++n;
            }
            if (n <= true) continue;
            this.getDesignPartView().addViewFor(designObject, true);
        }
        for (DesignObject designObject : ((RelationalDesign)this.getDesignPartView().getDesignPart()).getFKIndexAssociationSet().getAssociatedTablesWith(table)) {
            object = ((FKIndexAssociation)designObject).getTable();
            if (((MultiShapedDesignObject)object).getFirstViewForDPV(this.getDesignPartView()) == null) continue;
            this.addArc((Table)object);
        }
    }

    private void addArc(Table table) {
        for (FKArc fKArc : table.getArcs()) {
            if (fKArc.getFirstViewForDPV(this.getDesignPartView()) != null) continue;
            Iterator iterator = fKArc.getFkeys().iterator();
            int n = 0;
            while (iterator.hasNext()) {
                FKIndexAssociation fKIndexAssociation = (FKIndexAssociation)iterator.next();
                TopView topView = fKIndexAssociation.getFirstViewForDPV(this.getDesignPartView());
                if (topView == null) continue;
                ++n;
            }
            if (n <= true) continue;
            this.getDesignPartView().addViewFor(fKArc);
        }
    }

    public TVFKRelation[] getAllFKConnections() {
        List list = ((Table)this.getModel()).getAllFKeysEndingToTable();
        ArrayList<TVFKRelation> arrayList = new ArrayList<TVFKRelation>();
        DesignPartView designPartView = this.getDesignPartView();
        for (FKIndexAssociation fKIndexAssociation : list) {
            TVFKRelation tVFKRelation = (TVFKRelation)fKIndexAssociation.getFirstViewForDPV(designPartView);
            if (tVFKRelation == null) continue;
            arrayList.add(tVFKRelation);
        }
        return arrayList.toArray(new TVFKRelation[0]);
    }
}

