/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.relational;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.DenormalizerSplitTable;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableSet;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.relational.Messages;
import oracle.dbtools.crest.swingui.relational.TVTable;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.logging.Logger;

public class SplitTableWizard
extends CustomDialog {
    private static final String FIRST_PAGE = "FIRST_PAGE";
    private static final String SECOND_PAGE = "SECOND_PAGE";
    private static final String THIRD_PAGE = "THIRD_PAGE";
    private static final String MOVE_LEFT = Messages.getString("SplitTableWizard.MoveL");
    private static final String MOVE_RIGHT = Messages.getString("SplitTableWizard.MoveR");
    private static final String COPY_RIGHT = Messages.getString("SplitTableWizard.CopyR");
    private DenormalizerSplitTable denormalizer;
    private JDialog dialog;
    protected JButton bnBack;
    protected JButton bnNext;
    protected JButton bnFinish;
    protected JButton bnCancel;
    protected JButton bnHelp;
    private CardLayout cardLayout = new CardLayout();
    private int taskNbr = 1;
    private JPanel pnMain;
    private JPanel firstPanel;
    private JPanel secondPanel;
    private JPanel thirdPanel;
    private JTextField tfName;
    private JTextArea taComments;
    private Border border = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2), BorderFactory.createLineBorder(Color.GRAY, 1));
    private JList sourceFKList;
    private JList destinationFKList;
    private JList sourceColumnsList;
    private JList destinationColumnsList;
    private int width = 0;
    private static final Logger LOGGER = new Logger(DenormalizerSplitTable.class);

    public SplitTableWizard(ApplicationView applicationView, DenormalizerSplitTable denormalizerSplitTable) {
        super(applicationView);
        this.denormalizer = denormalizerSplitTable;
        this.add((Component)this.initMainPanel(), "Center");
        this.add((Component)this.initBottomPanel(), "South");
        this.handleButtons();
    }

    public void showDialog() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().setVisible(true);
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), Messages.getString("SplitTableWizard.SplitTableWizard"));
            this.dialog.setContentPane(this);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            this.dialog.setResizable(false);
        }
        return this.dialog;
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    @Override
    protected String getHelpIndex() {
        return "f1_splittable_html";
    }

    protected JPanel initMainPanel() {
        this.pnMain = new JPanel(this.cardLayout);
        this.secondPanel = this.initSecondPanel();
        this.firstPanel = this.initFirstPanel();
        this.thirdPanel = this.initThirdPanel();
        this.pnMain.add((Component)this.firstPanel, FIRST_PAGE);
        this.pnMain.add((Component)this.secondPanel, SECOND_PAGE);
        this.pnMain.add((Component)this.thirdPanel, THIRD_PAGE);
        return this.pnMain;
    }

    private String getProperName(String string) {
        TableSet tableSet = this.getApplicationView().getCurrentDesign().getRelationalDesign().getTableSet();
        int n = 1;
        while (tableSet.getByName(string + "_" + n) != null) {
            ++n;
        }
        return string + "_" + n;
    }

    private JPanel initFirstPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createRaisedBevelBorder());
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.setBorder(BorderFactory.createTitledBorder(Messages.getString("SplitTableWizard.SpecifyNameNewTable")));
        jPanel2.add(new JLabel(Messages.getString("SplitTableWizard.TableName")));
        this.tfName = new JTextField();
        this.tfName.setPreferredSize(new Dimension(this.width - 100, this.tfName.getPreferredSize().height));
        this.tfName.setText(this.getProperName(this.denormalizer.getBaseTable().getName()));
        this.tfName.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent caretEvent) {
                SplitTableWizard.this.bnNext.setEnabled(!"".equalsIgnoreCase(SplitTableWizard.this.tfName.getText()));
            }
        });
        jPanel2.add(this.tfName);
        JPanel jPanel3 = new JPanel();
        jPanel3.add(jPanel2);
        jPanel.add((Component)jPanel3, "North");
        JPanel jPanel4 = new JPanel();
        jPanel4.setPreferredSize(new Dimension(jPanel2.getPreferredSize().width, 275));
        jPanel4.setBorder(BorderFactory.createTitledBorder(Messages.getString("SplitTableWizard.AddCommentsNewTable")));
        this.taComments = new JTextArea();
        this.taComments.setPreferredSize(new Dimension(jPanel4.getPreferredSize().width - 25, jPanel4.getPreferredSize().height - 40));
        jPanel4.add(new JScrollPane(this.taComments));
        JPanel jPanel5 = new JPanel();
        jPanel5.add(jPanel4);
        jPanel.add((Component)jPanel5, "Center");
        return jPanel;
    }

    private JPanel initSecondPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createRaisedBevelBorder());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(BorderFactory.createTitledBorder(Messages.getString("SplitTableWizard.ForeignKeysAddedNewTable")));
        JButton jButton = new JButton(MOVE_RIGHT);
        JButton jButton2 = new JButton(COPY_RIGHT);
        JButton jButton3 = new JButton(MOVE_LEFT);
        DefaultListModel defaultListModel = new DefaultListModel();
        DefaultListModel defaultListModel2 = new DefaultListModel();
        this.sourceFKList = new JList(defaultListModel);
        this.destinationFKList = new JList(defaultListModel2);
        this.addFKs(this.sourceFKList, this.denormalizer.getBaseTable());
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SplitTableWizard.this.transfer(SplitTableWizard.this.sourceFKList, SplitTableWizard.this.destinationFKList, true, true);
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SplitTableWizard.this.transfer(SplitTableWizard.this.sourceFKList, SplitTableWizard.this.destinationFKList, false, true);
            }
        });
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SplitTableWizard.this.transfer(SplitTableWizard.this.destinationFKList, SplitTableWizard.this.sourceFKList, true, false);
            }
        });
        JLabel jLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        jLabel.setText(Messages.getString("SplitTableWizard.SourceForeignKeys"));
        jLabel2.setText(Messages.getString("SplitTableWizard.TargetForeignKeys"));
        jLabel.setHorizontalAlignment(0);
        jLabel2.setHorizontalAlignment(0);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.setBorder(this.border);
        jPanel3.add((Component)jLabel, "North");
        JScrollPane jScrollPane = new JScrollPane(this.sourceFKList);
        jScrollPane.setPreferredSize(new Dimension(220, 299));
        jPanel3.add(jScrollPane);
        jPanel2.add((Component)jPanel3, "West");
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.setBorder(this.border);
        jPanel4.add((Component)jLabel2, "North");
        jScrollPane = new JScrollPane(this.destinationFKList);
        jScrollPane.setPreferredSize(new Dimension(220, 299));
        jPanel4.add(jScrollPane);
        jPanel2.add((Component)jPanel4, "East");
        JPanel jPanel5 = new JPanel(new GridLayout(0, 1));
        JPanel jPanel6 = new JPanel(new GridLayout(0, 1));
        jPanel6.add(jButton);
        jPanel6.add(jButton2);
        jPanel6.add(jButton3);
        jPanel5.add(new JPanel());
        jPanel5.add(jPanel6);
        jPanel5.add(new JPanel());
        jPanel2.add((Component)jPanel5, "Center");
        JPanel jPanel7 = new JPanel();
        jPanel7.add(jPanel2);
        jPanel.add(jPanel7);
        this.width = jPanel2.getPreferredSize().width;
        return jPanel;
    }

    private JPanel initThirdPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createRaisedBevelBorder());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(BorderFactory.createTitledBorder(Messages.getString("SplitTableWizard.NonKeyColumnsNewTable")));
        JButton jButton = new JButton(MOVE_RIGHT);
        JButton jButton2 = new JButton(COPY_RIGHT);
        JButton jButton3 = new JButton(MOVE_LEFT);
        DefaultListModel defaultListModel = new DefaultListModel();
        DefaultListModel defaultListModel2 = new DefaultListModel();
        this.sourceColumnsList = new JList(defaultListModel);
        this.destinationColumnsList = new JList(defaultListModel2);
        this.addColumns(this.sourceColumnsList, this.denormalizer.getBaseTable());
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SplitTableWizard.this.transfer(SplitTableWizard.this.sourceColumnsList, SplitTableWizard.this.destinationColumnsList, true, true);
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SplitTableWizard.this.transfer(SplitTableWizard.this.sourceColumnsList, SplitTableWizard.this.destinationColumnsList, false, true);
            }
        });
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SplitTableWizard.this.transfer(SplitTableWizard.this.destinationColumnsList, SplitTableWizard.this.sourceColumnsList, true, false);
            }
        });
        JLabel jLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        jLabel.setText(Messages.getString("SplitTableWizard.SourceColumns"));
        jLabel2.setText(Messages.getString("SplitTableWizard.TargetColumns"));
        jLabel.setHorizontalAlignment(0);
        jLabel2.setHorizontalAlignment(0);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.setBorder(this.border);
        jPanel3.add((Component)jLabel, "North");
        JScrollPane jScrollPane = new JScrollPane(this.sourceColumnsList);
        jScrollPane.setPreferredSize(new Dimension(220, 299));
        jPanel3.add(jScrollPane);
        jPanel2.add((Component)jPanel3, "West");
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.setBorder(this.border);
        jPanel4.add((Component)jLabel2, "North");
        jScrollPane = new JScrollPane(this.destinationColumnsList);
        jScrollPane.setPreferredSize(new Dimension(220, 299));
        jPanel4.add(jScrollPane);
        jPanel2.add((Component)jPanel4, "East");
        JPanel jPanel5 = new JPanel(new GridLayout(0, 1));
        JPanel jPanel6 = new JPanel(new GridLayout(0, 1));
        jPanel6.add(jButton);
        jPanel6.add(jButton2);
        jPanel6.add(jButton3);
        jPanel5.add(new JPanel());
        jPanel5.add(jPanel6);
        jPanel5.add(new JPanel());
        jPanel2.add((Component)jPanel5, "Center");
        JPanel jPanel7 = new JPanel();
        jPanel7.add(jPanel2);
        jPanel.add(jPanel7);
        return jPanel;
    }

    private void transfer(JList jList, JList jList2, boolean bl, boolean bl2) {
        Object[] objectArray = jList.getSelectedValues();
        for (int i = 0; i < objectArray.length; ++i) {
            Object object;
            if (bl2) {
                object = (DesignObject)objectArray[i];
                if (!this.containsObject((DefaultListModel)jList2.getModel(), (DesignObject)object)) {
                    MCObject mCObject = new MCObject((DesignObject)object, bl);
                    ((DefaultListModel)jList2.getModel()).addElement(mCObject);
                }
                if (!bl) continue;
                ((DefaultListModel)jList.getModel()).removeElement(objectArray[i]);
                continue;
            }
            object = (MCObject)objectArray[i];
            if (!((DefaultListModel)jList2.getModel()).contains(((MCObject)object).getDesignObject())) {
                ((DefaultListModel)jList2.getModel()).addElement(((MCObject)object).getDesignObject());
            }
            if (!bl) continue;
            ((DefaultListModel)jList.getModel()).removeElement(object);
        }
    }

    private boolean containsObject(DefaultListModel defaultListModel, DesignObject designObject) {
        int n = defaultListModel.size();
        for (int i = 0; i < n; ++i) {
            MCObject mCObject = (MCObject)defaultListModel.get(i);
            if (mCObject.getDesignObject() != designObject) continue;
            return true;
        }
        return false;
    }

    private void addColumns(JList jList, Table table) {
        DefaultListModel defaultListModel = (DefaultListModel)jList.getModel();
        Column[] columnArray = (Column[])table.getElements();
        for (int i = 0; i < columnArray.length; ++i) {
            if (columnArray[i].isFKElement() || columnArray[i].isPKElement()) continue;
            defaultListModel.addElement(columnArray[i]);
        }
    }

    private void addFKs(JList jList, Table table) {
        DefaultListModel defaultListModel = (DefaultListModel)jList.getModel();
        FKIndexAssociation[] fKIndexAssociationArray = table.getFKAssociations();
        for (int i = 0; i < fKIndexAssociationArray.length; ++i) {
            defaultListModel.addElement(fKIndexAssociationArray[i]);
        }
    }

    protected JPanel initBottomPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(2));
        this.bnBack = new JButton(Messages.getString("SplitTableWizard.Back"));
        this.bnBack.setMnemonic(66);
        this.bnBack.addActionListener(new BackAction());
        this.bnNext = new JButton(Messages.getString("SplitTableWizard.Next"));
        this.bnNext.setMnemonic(78);
        this.bnNext.addActionListener(new NextAction());
        this.bnFinish = new JButton(Messages.getString("SplitTableWizard.Finish"));
        this.bnFinish.setMnemonic(70);
        this.bnFinish.addActionListener(new FinishAction());
        this.bnCancel = new JButton(Messages.getString("SplitTableWizard.Cancel"));
        this.bnCancel.setMnemonic(67);
        this.bnCancel.addActionListener(new CancelAction());
        this.bnHelp = new JButton(Messages.getString("SplitTableWizard.Help"));
        this.bnHelp.setMnemonic(72);
        this.bnHelp.addActionListener(new HelpAction());
        this.bnBack.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.bnNext.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.bnFinish.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.bnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.bnHelp.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jPanel.add(this.bnBack);
        jPanel.add(this.bnNext);
        jPanel.add(this.bnFinish);
        jPanel.add(this.bnCancel);
        jPanel.add(this.bnHelp);
        return jPanel;
    }

    private void handleButtons() {
        switch (this.taskNbr) {
            case 1: {
                this.bnBack.setEnabled(false);
                this.bnFinish.setEnabled(false);
                this.bnCancel.setEnabled(true);
                break;
            }
            case 2: {
                this.bnBack.setEnabled(true);
                this.bnNext.setEnabled(true);
                this.bnFinish.setEnabled(false);
                this.bnCancel.setEnabled(true);
                break;
            }
            case 3: {
                this.bnBack.setEnabled(true);
                this.bnNext.setEnabled(false);
                this.bnFinish.setEnabled(true);
                this.bnCancel.setEnabled(true);
            }
        }
    }

    public static void main(String[] stringArray) {
        SplitTableWizard splitTableWizard = new SplitTableWizard(null, null);
        splitTableWizard.showDialog();
    }

    public void initColumns(Object[] objectArray, Table table) {
        for (int i = 0; i < objectArray.length; ++i) {
            MCObject mCObject = (MCObject)objectArray[i];
            Column column = (Column)mCObject.getDesignObject();
            Column column2 = null;
            if (column.isFKElement()) {
                Column column3 = column;
                FKIndexAssociation fKIndexAssociation = column3.getFKIndexAssociation();
                FKIndexAssociation fKIndexAssociation2 = null;
                FKIndexAssociation[] fKIndexAssociationArray = table.getFKAssociations();
                for (int j = 0; j < fKIndexAssociationArray.length; ++j) {
                    FKIndexAssociation fKIndexAssociation3 = fKIndexAssociationArray[j];
                    if (!fKIndexAssociation.getObjectID().equalsIgnoreCase(fKIndexAssociation3.getGeneratorID())) continue;
                    fKIndexAssociation2 = fKIndexAssociation3;
                    break;
                }
                if (fKIndexAssociation2 == null) {
                    fKIndexAssociation2 = table.addFK(fKIndexAssociation.getKeyObject(), fKIndexAssociation);
                    fKIndexAssociation2.getLocalFKIndex().setGeneratorID(fKIndexAssociation.getGeneratorID());
                }
                System.out.println("SplitTableWizard.initColumns(): Should FKAssociation be recreated?");
            } else {
                column2 = table.createColumn();
            }
            if (column2 != null) {
                column.copy(column2);
                column2.setGeneratorID(column.getGeneratorID());
            }
            if (!mCObject.isMove()) continue;
            column.remove();
        }
    }

    public void initForeignKeys(Object[] objectArray, Table table) {
        for (int i = 0; i < objectArray.length; ++i) {
            MCObject mCObject = (MCObject)objectArray[i];
            FKIndexAssociation fKIndexAssociation = (FKIndexAssociation)mCObject.getDesignObject();
            FKIndexAssociation fKIndexAssociation2 = null;
            fKIndexAssociation2 = table.addFK(fKIndexAssociation.getKeyObject(), fKIndexAssociation);
            fKIndexAssociation2.getLocalFKIndex().setGeneratorID(fKIndexAssociation.getGeneratorID());
            fKIndexAssociation.copy(fKIndexAssociation2);
            if (!mCObject.isMove()) continue;
            fKIndexAssociation.remove();
        }
    }

    public class MCObject {
        private boolean move;
        private DesignObject designObject;

        public MCObject(DesignObject designObject, boolean bl) {
            this.designObject = designObject;
            this.move = bl;
        }

        public DesignObject getDesignObject() {
            return this.designObject;
        }

        public boolean isMove() {
            return this.move;
        }

        public String toString() {
            return this.designObject.toString();
        }
    }

    private class HelpAction
    implements ActionListener {
        private HelpAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SplitTableWizard.this.showHelp();
        }
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SplitTableWizard.this.close();
        }
    }

    private class FinishAction
    implements ActionListener {
        private FinishAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                SplitTableWizard.this.denormalizer.makeSplitTable(SplitTableWizard.this.tfName.getText());
                Table table = SplitTableWizard.this.denormalizer.getOriginalTable();
                Table table2 = SplitTableWizard.this.denormalizer.getSplitTable();
                table2.setComment(SplitTableWizard.this.taComments.getText());
                SplitTableWizard.this.initColumns(((DefaultListModel)SplitTableWizard.this.destinationColumnsList.getModel()).toArray(), table2);
                SplitTableWizard.this.initForeignKeys(((DefaultListModel)SplitTableWizard.this.destinationFKList.getModel()).toArray(), table2);
                TVTable tVTable = (TVTable)table.getTopView();
                TVTable tVTable2 = (TVTable)table2.getTopView();
                int n = tVTable.getCellView().getBounds().getBounds().x + 30;
                int n2 = tVTable.getCellView().getBounds().getBounds().y + 30;
                int n3 = tVTable.getCellView().getBounds().getBounds().width;
                int n4 = tVTable.getCellView().getBounds().getBounds().height;
                tVTable2.getCellView().setNewBounds(new Rectangle(n, n2, n3, n4));
            }
            catch (Exception exception) {
                LOGGER.error(Messages.getString("SplitTableWizard.UnableToSplitTable"), exception);
            }
            SplitTableWizard.this.close();
        }
    }

    private class NextAction
    implements ActionListener {
        private NextAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SplitTableWizard.this.taskNbr++;
            SplitTableWizard.this.handleButtons();
            switch (SplitTableWizard.this.taskNbr) {
                case 2: {
                    SplitTableWizard.this.cardLayout.show(SplitTableWizard.this.pnMain, SplitTableWizard.SECOND_PAGE);
                    break;
                }
                case 3: {
                    SplitTableWizard.this.cardLayout.show(SplitTableWizard.this.pnMain, SplitTableWizard.THIRD_PAGE);
                }
            }
        }
    }

    private class BackAction
    implements ActionListener {
        private BackAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SplitTableWizard.this.taskNbr--;
            SplitTableWizard.this.handleButtons();
            switch (SplitTableWizard.this.taskNbr) {
                case 1: {
                    SplitTableWizard.this.cardLayout.show(SplitTableWizard.this.pnMain, SplitTableWizard.FIRST_PAGE);
                    break;
                }
                case 2: {
                    SplitTableWizard.this.cardLayout.show(SplitTableWizard.this.pnMain, SplitTableWizard.SECOND_PAGE);
                }
            }
        }
    }
}

