/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.relational;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.dbtools.crest.imports.SyncUtils;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.TypeSubstitution;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectCollection;
import oracle.dbtools.crest.model.design.DesignObjectPlaceHolder;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.undo.DesignObjectEdit;
import oracle.dbtools.crest.model.placeholder.PlaceHolder;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;
import oracle.dbtools.crest.swingui.AbstractController;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TVTypeSubstitution;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.editor.ModelPropertiesDialogEx;
import oracle.dbtools.crest.swingui.relational.ControllerRelational;
import oracle.dbtools.crest.swingui.relational.DPVRelational;
import oracle.dbtools.crest.swingui.relational.Messages;
import oracle.dbtools.crest.swingui.relational.TVFKRelation;
import oracle.dbtools.crest.swingui.relational.TVTable;
import oracle.dbtools.crest.swingui.relational.TVView;

public class DPVRelationalSubView
extends DPVRelational {
    private AbstractController controller;
    DesignObjectCollection tvTables = new DesignObjectCollection(true);
    DesignObjectCollection tvViews = new DesignObjectCollection(true);
    DesignObjectCollection tvFKAss = new DesignObjectCollection(true);
    DesignObjectCollection tvTypeSubst = new DesignObjectCollection(true);

    public DPVRelationalSubView(ApplicationView applicationView, DesignPart designPart) {
        super(applicationView, designPart);
        ((RelationalDesign)designPart).getTableSet().addSetListener(this.tvTables);
        ((RelationalDesign)designPart).getTableViewSet().addSetListener(this.tvViews);
        ((RelationalDesign)designPart).getFKIndexAssociationSet().addSetListener(this.tvFKAss);
        ((RelationalDesign)designPart).getTypeSubstitutionSet().addSetListener(this.tvTypeSubst);
        this.controller = new ControllerRelational(applicationView);
        this.controller.setName("Relational_SubView");
        this.controller.setDesignPartView(this);
        this.tvTables.setElementDescriptor(Table.class);
        this.tvTables.setName(Messages.getString("DPVRelationalSubView.Tables"));
        this.tvViews.setElementDescriptor(TableView.class);
        this.tvViews.setName(Messages.getString("DPVRelationalSubView.Views"));
        this.tvFKAss.setElementDescriptor(FKIndexAssociation.class);
        this.tvFKAss.setName(Messages.getString("DPVRelationalSubView.FKRelations"));
        this.tvTypeSubst.setElementDescriptor(TypeSubstitution.class);
        this.tvTypeSubst.setName(Messages.getString("DPVRelationalSubView.TypeSubstitutions"));
    }

    @Override
    public void clearDPV() {
        ((RelationalDesign)this.getDesignPart()).getTableSet().removeSetListener(this.tvTables);
        ((RelationalDesign)this.getDesignPart()).getTableViewSet().removeSetListener(this.tvViews);
        ((RelationalDesign)this.getDesignPart()).getFKIndexAssociationSet().removeSetListener(this.tvFKAss);
        ((RelationalDesign)this.getDesignPart()).getTypeSubstitutionSet().removeSetListener(this.tvTypeSubst);
        super.clearDPV();
    }

    @Override
    public void sortCollections() {
        this.tvTables.sort();
        this.tvViews.sort();
        this.tvFKAss.sort();
        this.tvTypeSubst.sort();
    }

    @Override
    public void objectAdded(DesignPart designPart, DesignObject designObject) {
        if (DesignObjectEdit.UNDOABLE_ADD) {
            return;
        }
        if (ApplicationView.loading || !this.isCurrentDPV()) {
            return;
        }
        TopView topView = this.getViewFor(designObject);
        if (topView == null) {
            this.addViewFor(designObject);
        }
    }

    @Override
    public TopView createViewFor(DesignObject designObject) {
        if (ApplicationView.loading || !this.isCurrentDPV()) {
            return null;
        }
        return this.createTopViewFor(designObject);
    }

    @Override
    public void setPlaceHolder(PlaceHolder placeHolder) {
        super.setPlaceHolder(placeHolder);
        this.tvTables.setParent(this.getPlaceHolder());
        this.tvViews.setParent(this.getPlaceHolder());
        this.tvFKAss.setParent(this.getPlaceHolder());
        this.tvTypeSubst.setParent(this.getPlaceHolder());
        this.getDisplays().setParent(this.getPlaceHolder());
    }

    @Override
    public int getNumberOfChildren() {
        return 4;
    }

    @Override
    public ModelObject getChild(int n) {
        switch (n) {
            case 0: {
                return this.tvTables;
            }
            case 1: {
                return this.tvViews;
            }
            case 2: {
                return this.tvFKAss;
            }
            case 3: {
                return this.getDisplays();
            }
        }
        return null;
    }

    @Override
    public int getIndexForChild(ModelObject modelObject) {
        if (modelObject == this.tvTables) {
            return 0;
        }
        if (modelObject == this.tvViews) {
            return 1;
        }
        if (modelObject == this.tvFKAss) {
            return 2;
        }
        if (modelObject == this.getDisplays()) {
            return 3;
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public AbstractController getController() {
        return this.controller;
    }

    @Override
    public boolean isMainDiagram() {
        return false;
    }

    @Override
    public void registerForTreemodel(TopView topView) {
        DesignObjectPlaceHolder designObjectPlaceHolder = new DesignObjectPlaceHolder(topView.getModel().getDesignPart(), topView.getModel());
        designObjectPlaceHolder.setTopView(topView);
        if (topView instanceof TVTable && !this.tvTables.containsPlaceHolderFor(topView.getModel())) {
            this.tvTables.add(designObjectPlaceHolder);
        } else if (topView instanceof TVView && !this.tvViews.containsPlaceHolderFor(topView.getModel())) {
            this.tvViews.add(designObjectPlaceHolder);
        } else if (topView instanceof TVFKRelation && !this.tvFKAss.containsPlaceHolderFor(topView.getModel())) {
            this.tvFKAss.add(designObjectPlaceHolder);
        } else if (topView instanceof TVTypeSubstitution && !this.tvTypeSubst.containsPlaceHolderFor(topView.getModel())) {
            this.tvTypeSubst.add(designObjectPlaceHolder);
        }
        if (this.getViewFor(topView.getModel()) == null) {
            this.modelToView.put(topView.getModel(), topView);
        }
    }

    @Override
    public void unregisterFromTreemodel(TopView topView) {
        if (topView != null) {
            this.unregisterTopView(topView);
            DesignObject designObject = topView.getModel();
            TopView topView2 = this.getFirstViewFor(designObject);
            if (topView2 == null) {
                if (topView instanceof TVTable) {
                    this.tvTables.removePlaceHolderFor(designObject);
                }
                if (topView instanceof TVView) {
                    this.tvViews.removePlaceHolderFor(designObject);
                }
                if (topView instanceof TVFKRelation) {
                    this.tvFKAss.removePlaceHolderFor(designObject);
                }
                if (topView instanceof TVTypeSubstitution) {
                    this.tvTypeSubst.removePlaceHolderFor(designObject);
                }
            }
        }
    }

    @Override
    public Collection getTVTables() {
        ArrayList<TopView> arrayList = new ArrayList<TopView>();
        for (TopView topView : this.topViews) {
            if (!(topView instanceof TVTable)) continue;
            arrayList.add(topView);
        }
        return arrayList;
    }

    @Override
    public DesignPartView createSubordinateView(ApplicationView applicationView, DesignPart designPart) {
        return new DPVRelationalSubView(this.getApplicationView(), this.getDesignPart());
    }

    public XtdMapping getDeletedMapping(String string) {
        List list = this.getDesign().getExtendedMap().getDeletedMappingsForDesignPart(this.getPlaceHolder(), string);
        if (list.size() > 0) {
            XtdMapping xtdMapping = (XtdMapping)list.get(0);
            return xtdMapping;
        }
        return null;
    }

    @Override
    protected void showPropertiesDialog() {
        if (!this.getPlaceHolder().isDialogVisible()) {
            ModelPropertiesDialogEx modelPropertiesDialogEx = new ModelPropertiesDialogEx(this.getDesign().getAppView(), this.getPlaceHolder());
            modelPropertiesDialogEx.initProperties(this.getPlaceHolder());
            modelPropertiesDialogEx.show();
        }
    }

    private void sync(boolean bl) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (TopView topView : this.getTopviewsList()) {
            DesignObject designObject = topView.getModel();
            if (!(designObject instanceof Table) && !(designObject instanceof TableView)) continue;
            hashMap.put(designObject.getObjectID(), designObject.getObjectID());
        }
        if (hashMap.size() > 0) {
            SyncUtils.syncDataDictionary((RelationalDesign)this.getDesignPart(), bl, hashMap);
        }
    }

    @Override
    public JPopupMenu getPopupMenu() {
        JPopupMenu jPopupMenu = super.getPopupMenu();
        jPopupMenu.addSeparator();
        JMenuItem jMenuItem = jPopupMenu.add(new AbstractAction(MI_SYNC_SUBVIEW_WITH_DATA_DICTIONARY){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DPVRelationalSubView.this.sync(false);
            }
        });
        jMenuItem.setIcon(this.getConfiguration().getIcon("SYNC_MODEL_WITH_DICT", 16));
        jPopupMenu.addSeparator();
        jMenuItem = jPopupMenu.add(new AbstractAction(MI_SYNC_DATA_DICTIONARY_WITH_SUBVIEW){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DPVRelationalSubView.this.sync(true);
            }
        });
        jMenuItem.setIcon(this.getConfiguration().getIcon("SYNC_DICT_WITH_MODEL", 16));
        return jPopupMenu;
    }
}

