/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.relational;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import oracle.dbtools.crest.imports.DBConnectionStamp;
import oracle.dbtools.crest.imports.SyncUtils;
import oracle.dbtools.crest.model.Constants;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.TypeSubstitution;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.relational.ApplyNamingStandards;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.DenormalizerMergeTable;
import oracle.dbtools.crest.model.design.relational.DenormalizerSplitTable;
import oracle.dbtools.crest.model.design.relational.FKArc;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.metadata.MDTransformationManager;
import oracle.dbtools.crest.model.metadata.MDTransformer;
import oracle.dbtools.crest.model.metadata.MetaDataManager;
import oracle.dbtools.crest.model.metadata.XMLFromObjTransformer;
import oracle.dbtools.crest.model.metadata.XMLObjToStreamTransformer;
import oracle.dbtools.crest.model.metadata.XMLToObjectTransformer;
import oracle.dbtools.crest.model.xtdmapping.ExtendedMap;
import oracle.dbtools.crest.swingui.AbstractController;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.GlassComponent;
import oracle.dbtools.crest.swingui.MDBAction;
import oracle.dbtools.crest.swingui.MenuUtils;
import oracle.dbtools.crest.swingui.PointsEnteredCallback;
import oracle.dbtools.crest.swingui.SelectableObject;
import oracle.dbtools.crest.swingui.SelectedObjectAction;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.diagram.Diagram;
import oracle.dbtools.crest.swingui.diagram.graph.ContainerDiagramCell;
import oracle.dbtools.crest.swingui.diagram.relational.TableDiagramCell;
import oracle.dbtools.crest.swingui.editor.relational.FKUtilities;
import oracle.dbtools.crest.swingui.editor.relational.ForeignKeyPropertiesDialogEx;
import oracle.dbtools.crest.swingui.engineeringcompare.EngineeringCompareDialog;
import oracle.dbtools.crest.swingui.relational.DPVRelational;
import oracle.dbtools.crest.swingui.relational.Messages;
import oracle.dbtools.crest.swingui.relational.SplitTableWizard;
import oracle.dbtools.crest.swingui.relational.TVTable;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.ide.Ide;
import oracle.ide.marshal.xml.HashStructureIO;
import oracle.javatools.data.ChangeBuffer;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.StructureChangeListener;
import org.xml.sax.InputSource;

public class ControllerRelational
extends AbstractController
implements Constants {
    private Select select;
    private ZoomIn zoomIn;
    private ZoomOut zoomOut;
    private FitScreen fitScreen;
    private ActualSize actualSize;
    private Search search;
    public RevEngineer revEngineer;
    private TableCollectorFKRelation fkCollector = null;
    private NewArc newArc;
    private AddToArc add2Arc;
    private RemoveFromArc removeFromArc;
    private NewTable newTable;
    private NewTableView newTableView;
    private SplitTable splitTable;
    private MergeTables mergeTables;
    private NewFKRelation newFK;
    private NewTypeSubstitution newTypeSubstitution;
    private NewNote newNote;
    private Delete delete;
    private static final Logger LOGGER = new Logger(ControllerRelational.class);
    DesignPartView designPV = null;
    private final String[] OBJECT_PHYSICAL_PATH = new String[]{AbstractController.OBJECT_CAPTION, AbstractController.PHYSICAL_CAPTION};
    private final String[] DESIGN_PATH = new String[]{AbstractController.DESIGN_CAPTION};
    private final String[] PHYSICAL_PATH = new String[]{AbstractController.PHYSICAL_CAPTION};

    public ControllerRelational(ApplicationView applicationView) {
        super(applicationView);
    }

    @Override
    public void initializeActions() {
        if (this.isEditable()) {
            this.select = new Select();
            this.newTable = new NewTable();
            this.newTableView = new NewTableView();
            this.splitTable = new SplitTable();
            this.mergeTables = new MergeTables();
            this.newFK = new NewFKRelation();
            this.newTypeSubstitution = new NewTypeSubstitution();
            this.newArc = new NewArc();
            this.add2Arc = new AddToArc();
            this.removeFromArc = new RemoveFromArc();
            this.newNote = new NewNote();
            this.delete = new Delete();
            this.revEngineer = new RevEngineer();
            this.add(this.select);
            this.add(this.newTable);
            this.add(this.newTableView);
            this.add(this.splitTable);
            this.add(this.mergeTables);
            this.add(this.newFK);
            this.add(this.newTypeSubstitution);
            this.add(this.newArc);
            this.add(this.add2Arc);
            this.add(this.removeFromArc);
            this.add(this.newNote);
            this.add(this.delete);
            this.add(this.revEngineer);
        }
        this.zoomIn = new ZoomIn();
        this.add(this.zoomIn);
        this.zoomOut = new ZoomOut();
        this.add(this.zoomOut);
        this.fitScreen = new FitScreen();
        this.add(this.fitScreen);
        this.actualSize = new ActualSize();
        this.add(this.actualSize);
        this.search = new Search();
        this.add(this.search);
        this.add(new GenerateDDL());
        if (ApplicationView.debugMode) {
            // empty if block
        }
        this.add(new SyncModelWithDataDictionary());
        this.add(new SyncDataDictionaryWithModel());
    }

    @Override
    public String getToolBarName() {
        return Messages.getString("ControllerRelational.Relational");
    }

    public DPVRelational getDPVPhysical() {
        return (DPVRelational)this.designPV;
    }

    @Override
    public void setDesignPartView(DesignPartView designPartView) {
        this.designPV = designPartView;
    }

    @Override
    public DesignPartView getDesignPartView() {
        return this.getDPVPhysical();
    }

    public DesignPartView getCurrentDPV() {
        return this.designPV;
    }

    @Override
    public RelationalDesign getPhysicalDesign() {
        if (this.getCurrentDPV() != null && this.getCurrentDPV().getDesignPart() instanceof RelationalDesign) {
            return (RelationalDesign)this.getCurrentDPV().getDesignPart();
        }
        return super.getPhysicalDesign();
    }

    @Override
    public boolean canPaste() {
        for (Object e : this.getApplicationView().getCopiedObjects()) {
            if (e == null || !(e instanceof Table) && !(e instanceof TableView)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paste(Point point) {
        if (this.canPaste()) {
            try {
                TopView topView;
                ContainerObject containerObject;
                ApplicationView.canLogging = false;
                int n = 0;
                int n2 = 0;
                HashMap<String, ContainerObject> hashMap = null;
                for (Object object : this.getApplicationView().getCopiedObjects()) {
                    Cloneable cloneable;
                    Cloneable cloneable2;
                    TopView topView2;
                    ContainerObject containerObject2;
                    if (!(object instanceof DesignObject)) continue;
                    if (object instanceof Table) {
                        ApplicationView.log(Messages.getString("ControllerRelational.CreateTable"));
                        containerObject2 = (Table)object;
                        containerObject = ((RelationalDesign)this.getDesignPartView().getDesignPart()).createTable();
                        if (hashMap == null) {
                            hashMap = new HashMap<String, ContainerObject>();
                        }
                        hashMap.put(containerObject2.getObjectID(), containerObject);
                        containerObject2.copy(containerObject, hashMap);
                        topView = this.getDesignPartView().getViewFor(containerObject);
                        if (topView == null || topView.getCellView() == null || (topView2 = containerObject2.getTopView()) == null || topView2.getCellView() == null) continue;
                        cloneable2 = null;
                        if (point != null) {
                            cloneable2 = this.getDesignPartView().getWorkSpace().fromScreen(new Point2D.Double(point.x, point.y));
                        }
                        cloneable = new Rectangle(topView2.getCellView().getBounds().getBounds());
                        if (cloneable2 != null) {
                            cloneable.x = (int)((Point2D)cloneable2).getX() + n;
                            cloneable.y = (int)((Point2D)cloneable2).getY() + n2;
                        } else {
                            cloneable.x += 30 + n;
                            cloneable.y += 30 + n2;
                        }
                        topView.getCellView().setNewBounds((Rectangle)cloneable);
                        n += 20;
                        n2 += 20;
                        continue;
                    }
                    if (!(object instanceof TableView)) continue;
                    ApplicationView.log(Messages.getString("ControllerRelational.CreateView"));
                    containerObject2 = (TableView)object;
                    containerObject = ((RelationalDesign)this.getDesignPartView().getDesignPart()).getTableViewSet().createTableView(null);
                    ((TableView)containerObject2).copy(containerObject);
                    topView = this.getDesignPartView().getViewFor(containerObject);
                    if (topView == null || topView.getCellView() == null || (topView2 = containerObject2.getTopView()) == null || topView2.getCellView() == null) continue;
                    cloneable2 = new Rectangle(topView2.getCellView().getBounds().getBounds());
                    cloneable = null;
                    if (point != null) {
                        cloneable = this.getDesignPartView().getWorkSpace().fromScreen(new Point2D.Double(point.x, point.y));
                    }
                    if (cloneable != null) {
                        ((Rectangle)cloneable2).x = (int)((Point2D)cloneable).getX() + n;
                        ((Rectangle)cloneable2).y = (int)((Point2D)cloneable).getY() + n2;
                    } else {
                        ((Rectangle)cloneable2).x += 30 + n;
                        ((Rectangle)cloneable2).y += 30 + n2;
                    }
                    topView.getCellView().setNewBounds((Rectangle)cloneable2);
                    n += 20;
                    n2 += 20;
                }
                if (hashMap != null) {
                    Object object;
                    object = new ApplyNamingStandards(this.getDesign().getDLSettings().getNamingStandardRule(), true, true, true, true, true, true, false);
                    for (ContainerObject containerObject2 : this.getApplicationView().getCopiedObjects()) {
                        if (!(containerObject2 instanceof Table) || !((topView = hashMap.get((containerObject = (Table)containerObject2).getObjectID())) instanceof Table)) continue;
                        ((Table)containerObject).copyForeignKeys((Table)((Object)topView), hashMap);
                        if (containerObject.getDesignPart() != ((Table)((Object)topView)).getDesignPart()) continue;
                        ((ApplyNamingStandards)object).apply((Table)((Object)topView));
                    }
                }
                this.getDesign().setDirty(true);
            }
            finally {
                ApplicationView.canLogging = true;
                this.getDesignPartView().getDesignPart().sortCollections();
            }
        }
    }

    public JMenu getObjectRelationalMenu() {
        return this.getApplicationView().getControllerSet().getMenuStructure().get(this.OBJECT_PHYSICAL_PATH);
    }

    public ActualSize getActualSize() {
        return this.actualSize;
    }

    public FitScreen getFitScreen() {
        return this.fitScreen;
    }

    @Override
    public MDBAction getSearch() {
        return this.search;
    }

    public ZoomIn getZoomIn() {
        return this.zoomIn;
    }

    public ZoomOut getZoomOut() {
        return this.zoomOut;
    }

    public NewArc getNewArcAction() {
        return this.newArc;
    }

    public AddToArc getAddToArcAction() {
        return this.add2Arc;
    }

    public RemoveFromArc getRemoveFromArcAction() {
        return this.removeFromArc;
    }

    @Override
    public void updateActions() {
        boolean bl = true;
        if (this.getDesign().isLoadFromDB() && this.getDesignPartView().getDesignPart().getRepositoryOID() != null) {
            bl = this.getDesignPartView().getDesignPart().isCheckedOutByMe();
        }
        this.getDesignPartView().getWorkSpace().updateReadOnlyStatus();
        this.setEnabled(this.newTable, bl);
        this.setEnabled(this.newTableView, bl);
        this.setEnabled(this.splitTable, bl);
        this.setEnabled(this.mergeTables, bl);
        this.setEnabled(this.newFK, bl);
        this.setEnabled(this.newTypeSubstitution, bl);
        this.setEnabled(this.newArc, bl);
        this.setEnabled(this.add2Arc, bl);
        this.setEnabled(this.removeFromArc, bl);
        this.setEnabled(this.newNote, bl);
        this.setEnabled(this.delete, bl);
    }

    class Search
    extends MDBAction {
        private Search() {
            super(MenuUtils.getMnemonicStr(AbstractController.SEARCH_CAPTION), ControllerRelational.this.getConfiguration().getIcon("SEARCH_ICON", ControllerRelational.this.getPreferredIconSize()));
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.SEARCH_CAPTION));
        }

        @Override
        public boolean addToolbarSeparator() {
            return true;
        }

        @Override
        public boolean addSeparatorAfter() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            ControllerRelational.this.getApplicationView().search(2);
        }
    }

    class ActualSize
    extends MDBAction {
        private ActualSize() {
            super(MenuUtils.getMnemonicStr(AbstractController.ACTUAL_SIZE_CAPTION), ControllerRelational.this.getConfiguration().getIcon("ACTUAL_SIZE_ICON", ControllerRelational.this.getPreferredIconSize()));
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.ACTUAL_SIZE_CAPTION));
            this.setAllowedInToolbar(true);
        }

        @Override
        public boolean addSeparatorAfter() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            DesignPartView designPartView = ControllerRelational.this.getApplicationView().getCurrentDPV();
            designPartView.actualSize();
        }
    }

    class FitScreen
    extends MDBAction {
        private FitScreen() {
            super(MenuUtils.getMnemonicStr(AbstractController.FIT_SCREEN_CAPTION), ControllerRelational.this.getConfiguration().getIcon("FIT_SCREEN_ICON", ControllerRelational.this.getPreferredIconSize()));
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.FIT_SCREEN_CAPTION));
            this.setAllowedInToolbar(true);
        }

        @Override
        public boolean addSeparatorAfter() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            DesignPartView designPartView = ControllerRelational.this.getApplicationView().getCurrentDPV();
            designPartView.fitScreen();
        }
    }

    class ZoomOut
    extends MDBAction {
        private ZoomOut() {
            super(MenuUtils.getMnemonicStr(AbstractController.ZOOM_OUT_CAPTION), ControllerRelational.this.getConfiguration().getIcon("ZOOM_OUT_ICON", ControllerRelational.this.getPreferredIconSize()));
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.ZOOM_OUT_CAPTION));
            this.setAllowedInToolbar(true);
        }

        @Override
        public boolean addSeparatorAfter() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            DesignPartView designPartView = ControllerRelational.this.getApplicationView().getCurrentDPV();
            designPartView.zoomOut();
        }
    }

    class ZoomIn
    extends MDBAction {
        private ZoomIn() {
            super(MenuUtils.getMnemonicStr(AbstractController.ZOOM_IN_CAPTION), ControllerRelational.this.getConfiguration().getIcon("ZOOM_IN_ICON", ControllerRelational.this.getPreferredIconSize()));
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.ZOOM_IN_CAPTION));
            this.setAllowedInToolbar(true);
        }

        @Override
        public boolean addToolbarSeparator() {
            return ControllerRelational.this.isEditable();
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            DesignPartView designPartView = ControllerRelational.this.getApplicationView().getCurrentDPV();
            designPartView.zoomIn();
        }
    }

    class TableCollectorMerge
    extends TableCollector {
        DenormalizerMergeTable denormalizer;

        TableCollectorMerge(DenormalizerMergeTable denormalizerMergeTable) {
            this.denormalizer = null;
            this.denormalizer = denormalizerMergeTable;
        }

        private String title() {
            return Messages.getString("ControllerRelational.MergeTables");
        }

        @Override
        public void pointsSelected(Point[] pointArray) {
            ControllerRelational.this.select.actionPerformed(null);
            TVTable tVTable = this.getTVTableFor(pointArray[0]);
            TVTable tVTable2 = this.getTVTableFor(pointArray[1]);
            String string = null;
            if (tVTable == null) {
                string = Messages.getString("ControllerRelational.NoSourceTableSelected");
            } else if (tVTable2 == null) {
                string = Messages.getString("ControllerRelational.NoTargetTableSelected");
            } else if (tVTable == tVTable2) {
                string = Messages.getString("ControllerRelational.SelectTwoDifferentTables");
            }
            if (string == null) {
                this.doIt(tVTable, tVTable2);
            } else {
                MessageDialogs.showErrorMessage(ControllerRelational.this.getApplicationView().getFrame(), string);
            }
        }

        @Override
        public void doIt(TVTable tVTable, TVTable tVTable2) {
            this.doMerge((Table)tVTable.getModel(), (Table)tVTable2.getModel());
        }

        private void doMerge(Table table, Table table2) {
            this.denormalizer.setSource(table);
            this.denormalizer.setTarget(table2);
            if (this.denormalizer.canMerge()) {
                ArrayList<String> arrayList = new ArrayList<String>(5);
                arrayList.add(Messages.getString("ControllerRelational.AreYouSureMergeTables"));
                Object[] objectArray = arrayList.toArray();
                int n = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), objectArray, Messages.getString("ControllerRelational.MergeTables"), 0, 3);
                if (n == 0) {
                    this.denormalizer.merge();
                }
            } else if (!this.denormalizer.isTargetable(table2)) {
                ArrayList<String> arrayList = new ArrayList<String>(2);
                arrayList.add(Messages.getString("ControllerRelational.CanNotMergeTables"));
                if (!table.hasPK()) {
                    arrayList.add(Messages.getString("ControllerRelational.SourceTableDoesNotHavePK"));
                } else if (!table2.hasFKAssociationFor(table.getPK())) {
                    arrayList.add(Messages.getString("ControllerRelational.TargetHasNoFKRelationToSource"));
                }
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), arrayList.toArray(), this.title(), 0);
            }
        }
    }

    class TableCollectorFKRelation
    extends TableCollector {
        TableCollectorFKRelation() {
        }

        @Override
        public void doIt(TVTable tVTable, TVTable tVTable2) {
            FKIndexAssociation fKIndexAssociation = this.createRelation(tVTable, tVTable2);
            if (fKIndexAssociation != null && fKIndexAssociation.getDesign().getAppView().getSettings().showPropertiesDialogOnNew()) {
                ForeignKeyPropertiesDialogEx foreignKeyPropertiesDialogEx = new ForeignKeyPropertiesDialogEx(ControllerRelational.this.getApplicationView(), fKIndexAssociation);
                foreignKeyPropertiesDialogEx.initProperties(fKIndexAssociation);
                foreignKeyPropertiesDialogEx.setModal(true);
                foreignKeyPropertiesDialogEx.show();
            }
            if (fKIndexAssociation.getDesignObjectSet() != DesignObjectSet.NULL_SET) {
                ((RelationalDesign)fKIndexAssociation.getDesignPart()).postFKCreateEdit(fKIndexAssociation);
                fKIndexAssociation.resetEdgeParams();
            }
        }

        private FKIndexAssociation createRelation(TVTable tVTable, TVTable tVTable2) {
            ApplicationView.log(Messages.getString("ControllerRelational.CreateFKRelation"));
            Table table = (Table)tVTable2.getModel();
            KeyObject keyObject = ((Table)tVTable.getModel()).getPKorUnique();
            FKIndexAssociation fKIndexAssociation = table.addFK(keyObject);
            if (fKIndexAssociation != null) {
                fKIndexAssociation.setSourceTVTable(tVTable);
                fKIndexAssociation.setTargetTVTable(tVTable2);
                if (table == tVTable.getModel()) {
                    fKIndexAssociation.setMandatory(false);
                }
                fKIndexAssociation.setName(FKUtilities.generateFKName(table, (Table)tVTable.getModel(), keyObject));
                fKIndexAssociation.addToAllDPVs();
                fKIndexAssociation.resetEdgeParams();
            }
            return fKIndexAssociation;
        }
    }

    abstract class TableCollector
    implements PointsEnteredCallback {
        private GlassComponent glassComp = null;

        protected TableCollector() {
            this.startCollecting();
        }

        public void startCollecting() {
            ControllerRelational.this.getDesignPartView().getWorkSpace().clearSelection();
            this.collect();
        }

        protected void collect() {
            this.glassComp = ControllerRelational.this.getDesignPartView().getGlassPane();
            this.glassComp.getPoints(this, 2);
        }

        public void stopWaiting() {
            if (this.glassComp != null) {
                this.glassComp.stopAll();
            }
        }

        private String title() {
            return Messages.getString("ControllerRelational.NewFKRelation");
        }

        @Override
        public void rectangleSelected(Rectangle rectangle) {
        }

        @Override
        public void pointSelected(Point point) {
        }

        @Override
        public void pointsSelected(Point[] pointArray) {
            KeyObject keyObject;
            TVTable tVTable = this.getTVTableFor(pointArray[0]);
            TVTable tVTable2 = this.getTVTableFor(pointArray[1]);
            Table table = null;
            Table table2 = null;
            if (tVTable != null) {
                table = (Table)tVTable.getModel();
            }
            if (tVTable2 != null) {
                table2 = (Table)tVTable2.getModel();
            }
            ArrayList<String> arrayList = new ArrayList<String>(2);
            if (table == null) {
                arrayList.add(Messages.getString("ControllerRelational.NoSourceTableSelected"));
            } else if (!table.hasPK() && !table.hasUnique()) {
                arrayList.add(Messages.getString("ControllerRelational.SourceTabledoesNotHavePKorUC"));
            }
            if (table != null && table.isBST() && (keyObject = table.getPK()) == null) {
                arrayList.add(Messages.getString("ControllerRelational.ParentTableShouldHavePK"));
            }
            if (table2 == null) {
                arrayList.add(Messages.getString("ControllerRelational.NoTargetTableSelected"));
            }
            if (table != null && table2 != null && (table.getTypeSubstitution() != null || table2.getTypeSubstitution() != null)) {
                arrayList.add(Messages.getString("ControllerRelational.TableCannotParticipateInFKrelationship"));
            }
            this.checkFKPossibility(table, table2, arrayList);
            if (arrayList.size() == 0) {
                this.doIt(tVTable, tVTable2);
            } else {
                JOptionPane.showMessageDialog(ControllerRelational.this.getDesignPartView(), arrayList.toArray(), this.title(), 0);
            }
            ControllerRelational.this.select_SelectAction();
        }

        private void checkFKPossibility(Table table, Table table2, List list) {
            if (table != null && table2 != null) {
                Column column;
                if (table2.isBST()) {
                    Column column2;
                    if (table.isBST() && (column2 = (Column)table2.getRefToStructurtedType(table.getBasedOnStructuredType(), table)) == null) {
                        list.add(Messages.getString("ControllerRelational.ChildTableDoesntHaveReferenceColumn"));
                    }
                } else if (table.isBST() && table2.isBST() && (column = (Column)table2.getRefToStructurtedType(table.getBasedOnStructuredType(), table)) == null) {
                    list.add(Messages.getString("ControllerRelational.ChildTableDoesntHaveReferenceColumn"));
                }
            }
        }

        protected TVTable getTVTableFor(Point point) {
            Object object = ControllerRelational.this.getDesignPartView().getWorkSpace().getFirstCellForLocation(point.getX(), point.getY());
            if (object != null && object instanceof TableDiagramCell) {
                return (TVTable)((TableDiagramCell)object).getTopView();
            }
            return null;
        }

        public abstract void doIt(TVTable var1, TVTable var2);

        @Override
        public Component getTargetCoordinateSpace() {
            return ControllerRelational.this.getDesignPartView().getWorkSpace();
        }
    }

    class RemoveFromArc
    extends MDBAction {
        private RemoveFromArc() {
            super(MenuUtils.getMnemonicStr(AbstractController.REMOVE_FK_FROM_ARC), ControllerRelational.this.getConfiguration().getIcon("REMOVE_FROM_ARC_ICON", ControllerRelational.this.getPreferredIconSize()));
            this.setMenuPath(ControllerRelational.this.OBJECT_PHYSICAL_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.REMOVE_FK_FROM_ARC));
            this.setObjectAction(true);
        }

        @Override
        public void setEnabled(boolean bl) {
            super.setEnabled(bl && this.canHandle());
        }

        private boolean canHandle() {
            if (ControllerRelational.this.getDesign().isLoadFromDB() && !ControllerRelational.this.getDesignPartView().getDesignPart().isCheckedOutByMe()) {
                return false;
            }
            Object[] objectArray = ControllerRelational.this.getDesignPartView().getSelectedObjects();
            return ControllerRelational.this.getPhysicalDesign() != null && ControllerRelational.this.getPhysicalDesign().canRemoveFromArc(objectArray);
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            Object[] objectArray = ControllerRelational.this.getDesignPartView().getSelectedObjects();
            ControllerRelational.this.getPhysicalDesign().removeFromArc(objectArray);
            ControllerRelational.this.getDesignPartView().fireSelectionChanged();
        }
    }

    class AddToArc
    extends MDBAction {
        private AddToArc() {
            super(MenuUtils.getMnemonicStr(AbstractController.ADD_FK_TO_ARC), ControllerRelational.this.getConfiguration().getIcon("ADD_TO_ARC_ICON", ControllerRelational.this.getPreferredIconSize()));
            this.setMenuPath(ControllerRelational.this.OBJECT_PHYSICAL_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.ADD_FK_TO_ARC));
            this.setObjectAction(true);
        }

        @Override
        public void setEnabled(boolean bl) {
            super.setEnabled(bl && this.canHandle());
        }

        private boolean canHandle() {
            if (ControllerRelational.this.getDesign().isLoadFromDB() && !ControllerRelational.this.getDesignPartView().getDesignPart().isCheckedOutByMe()) {
                return false;
            }
            Object[] objectArray = ControllerRelational.this.getDesignPartView().getSelectedObjects();
            return ControllerRelational.this.getPhysicalDesign() != null && ControllerRelational.this.getPhysicalDesign().canAddToArc(objectArray);
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            Object[] objectArray = ControllerRelational.this.getDesignPartView().getSelectedObjects();
            for (int i = 0; i < objectArray.length; ++i) {
                if (!(objectArray[i] instanceof FKIndexAssociation) || !((FKIndexAssociation)objectArray[i]).isMandatory()) continue;
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("ControllerRelational.MandatoryForeignKeyCannotBeInArc"), Messages.getString("ControllerRelational.ArcDefinition"), 0);
                return;
            }
            ControllerRelational.this.getPhysicalDesign().addToArc(objectArray);
            ControllerRelational.this.getDesignPartView().fireSelectionChanged();
        }
    }

    class NewArc
    extends MDBAction {
        private NewArc() {
            super(MenuUtils.getMnemonicStr(AbstractController.NEW_ARC), ControllerRelational.this.getConfiguration().getIcon("NEW_ARC_ICON", ControllerRelational.this.getPreferredIconSize()));
            this.setMenuPath(ControllerRelational.this.OBJECT_PHYSICAL_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.NEW_ARC));
            this.setObjectAction(true);
        }

        @Override
        public void setEnabled(boolean bl) {
            super.setEnabled(bl && this.canHandle());
        }

        private boolean canHandle() {
            if (ControllerRelational.this.getDesign().isLoadFromDB() && !ControllerRelational.this.getDesignPartView().getDesignPart().isCheckedOutByMe()) {
                return false;
            }
            Object[] objectArray = ControllerRelational.this.getDesignPartView().getSelectedObjects();
            return ControllerRelational.this.getPhysicalDesign() != null && ControllerRelational.this.getPhysicalDesign().canCreateArc(objectArray);
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            Object[] objectArray = ControllerRelational.this.getDesignPartView().getSelectedObjects();
            for (int i = 0; i < objectArray.length; ++i) {
                if (!(objectArray[i] instanceof FKIndexAssociation) || !((FKIndexAssociation)objectArray[i]).isMandatory()) continue;
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("ControllerRelational.MandatoryForeignKeyCannotBeInArc"), Messages.getString("ControllerRelational.ArcDefinition"), 0);
                return;
            }
            FKArc fKArc = ControllerRelational.this.getPhysicalDesign().createArc(objectArray);
            ControllerRelational.this.getPhysicalDesign().postFKArcCreateEdit(fKArc);
            ControllerRelational.this.getDesignPartView().fireSelectionChanged();
        }
    }

    class TypedElementCollector
    implements PointsEnteredCallback {
        private GlassComponent glassComp = null;

        protected TypedElementCollector() {
            this.collect();
        }

        protected void collect() {
            this.glassComp = ControllerRelational.this.getDesignPartView().getGlassPane();
            this.glassComp.getPoints(this, 2);
        }

        public void stopWaiting() {
            if (this.glassComp != null) {
                this.glassComp.stopAll();
            }
        }

        private String title() {
            return Messages.getString("ControllerRelational.NewTypeSubstitution");
        }

        @Override
        public void rectangleSelected(Rectangle rectangle) {
        }

        @Override
        public void pointSelected(Point point) {
        }

        @Override
        public void pointsSelected(Point[] pointArray) {
            ContainerView containerView = this.getContainerViewFor(pointArray[0]);
            ContainerView containerView2 = this.getContainerViewFor(pointArray[1]);
            ContainerObject containerObject = null;
            ContainerObject containerObject2 = null;
            if (containerView != null) {
                containerObject = (ContainerObject)containerView.getModel();
            }
            if (containerView2 != null) {
                containerObject2 = (ContainerObject)containerView2.getModel();
            }
            ArrayList<String> arrayList = new ArrayList<String>(2);
            if (containerObject != null && containerObject2 != null) {
                if (containerObject2 == containerObject) {
                    arrayList.add(Messages.getString("ControllerRelational.TwoDifferentObjectsMustBeSelected"));
                }
                if (containerObject.getClass() != containerObject2.getClass()) {
                    arrayList.add(Messages.getString("ControllerRelational.TwoObjectsSameKindShouldBeSelected"));
                }
                if (!containerObject.isBST() || !containerObject2.isBST()) {
                    arrayList.add(Messages.getString("ControllerRelational.ObjectsStructuredTypeCanBeSelected"));
                }
                if (containerObject.isBST() && containerObject2.isBST()) {
                    if (containerObject.getBasedOnStructuredType().getParentType() != containerObject2.getBasedOnStructuredType() && containerObject2.getBasedOnStructuredType().getParentType() != containerObject.getBasedOnStructuredType()) {
                        arrayList.add(Messages.getString("ControllerRelational.ObjectsStructuredTypeDirectSubTypeCanBeSelected"));
                    } else if (containerObject.getBasedOnStructuredType().getParentType() == containerObject2.getBasedOnStructuredType()) {
                        if (containerObject.getTypeSubstitution() != null) {
                            arrayList.add(MessageFormat.format(Messages.getString("ControllerRelational.TypeSubstitutionDefined"), containerObject.getName()));
                        }
                        if (containerObject instanceof Table && ((Table)containerObject).isReferencedByFKs()) {
                            arrayList.add(MessageFormat.format(Messages.getString("ControllerRelational.ChildTableReferenced"), containerObject.getName()));
                        }
                    } else if (containerObject2.getBasedOnStructuredType().getParentType() == containerObject.getBasedOnStructuredType()) {
                        if (containerObject2.getTypeSubstitution() != null) {
                            arrayList.add(MessageFormat.format(Messages.getString("ControllerRelational.TypeSubstitutionDefined"), containerObject2.getName()));
                        }
                        if (containerObject2 instanceof Table && ((Table)containerObject2).isReferencedByFKs()) {
                            arrayList.add(MessageFormat.format(Messages.getString("ControllerRelational.ChildTableReferenced"), containerObject.getName()));
                        }
                    }
                }
                if (arrayList.size() == 0) {
                    this.doIt(containerView, containerView2);
                } else {
                    JOptionPane.showMessageDialog(ControllerRelational.this.getDesignPartView(), arrayList.toArray(), this.title(), 0);
                }
            } else {
                arrayList.add(Messages.getString("ControllerRelational.ErrorInObjectSelection"));
                JOptionPane.showMessageDialog(ControllerRelational.this.getDesignPartView(), arrayList.toArray(), this.title(), 0);
            }
            ControllerRelational.this.select_SelectAction();
        }

        protected ContainerView getContainerViewFor(Point point) {
            Object object = ControllerRelational.this.getDesignPartView().getWorkSpace().getFirstCellForLocation(point.getX(), point.getY());
            if (object != null && object instanceof ContainerDiagramCell) {
                return (ContainerView)((ContainerDiagramCell)object).getTopView();
            }
            return null;
        }

        public void doIt(ContainerView containerView, ContainerView containerView2) {
            ContainerObject containerObject = null;
            ContainerObject containerObject2 = null;
            ContainerObject containerObject3 = null;
            ContainerObject containerObject4 = null;
            ContainerView containerView3 = null;
            ContainerView containerView4 = null;
            if (containerView != null) {
                containerObject3 = (ContainerObject)containerView.getModel();
            }
            if (containerView2 != null) {
                containerObject4 = (ContainerObject)containerView2.getModel();
            }
            if (containerObject3 != null && containerObject4 != null) {
                if (containerObject3.getBasedOnStructuredType() == containerObject4.getBasedOnStructuredType().getParentType()) {
                    containerObject2 = containerObject3;
                    containerObject = containerObject4;
                    containerView4 = containerView;
                    containerView3 = containerView2;
                } else if (containerObject3.getBasedOnStructuredType().getParentType() == containerObject4.getBasedOnStructuredType()) {
                    containerObject = containerObject3;
                    containerObject2 = containerObject4;
                    containerView3 = containerView;
                    containerView4 = containerView2;
                }
                if (containerObject != null && containerObject2 != null) {
                    TypeSubstitution typeSubstitution = ControllerRelational.this.getDesign().getRelationalDesign().createTypeSubstitution();
                    typeSubstitution.setChildCV(containerView3);
                    typeSubstitution.setParentCV(containerView4);
                    typeSubstitution.addToAllDPVs();
                }
            }
        }

        @Override
        public Component getTargetCoordinateSpace() {
            return ControllerRelational.this.getDesignPartView().getWorkSpace();
        }
    }

    class GenerateXML
    extends MDBAction {
        private GenerateXML() {
            super(MenuUtils.getMnemonicStr(""), ControllerRelational.this.getConfiguration().getIcon("DDL_PREVIEW_ICON", ControllerRelational.this.getPreferredIconSize()));
            this.setMenuPath(ControllerRelational.this.OBJECT_PHYSICAL_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey("Generate XML"));
            this.setAccelerator(KeyStroke.getKeyStroke(71, 64, false));
        }

        @Override
        public boolean addToolbarSeparator() {
            return true;
        }

        void test() {
            RelationalDesign relationalDesign = (RelationalDesign)ControllerRelational.this.getDPVPhysical().getDesignPart();
            ControllerRelational.this.getDesign().setRelationalDesign(relationalDesign);
            Iterator iterator = relationalDesign.getTableSet().iterator();
            String string = "file:///:D:/HS_IO_test/tab1.xml";
            String string2 = "file:///:D:/HS_IO_test/";
            URL uRL = null;
            try {
                uRL = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            URL uRL2 = null;
            try {
                uRL2 = new URL(string2);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            FileWriter fileWriter = null;
            try {
                fileWriter = new FileWriter("d:/HS_IO_test/HSio_Test.xml");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            HashStructureIO hashStructureIO = new HashStructureIO(string, "Table");
            PrintWriter printWriter = new PrintWriter(fileWriter);
            boolean bl = false;
            while (iterator.hasNext()) {
                Table table = (Table)iterator.next();
                HashStructure hashStructure = HashStructure.newInstance();
                hashStructure.putString("name", table.getName());
                hashStructure.putString("abbreviation", table.getAbbreviation());
                hashStructure.putString("ID", table.getObjectID());
                hashStructure.putString("class", table.getClass().getName());
                ListStructure listStructure = hashStructure.getOrCreateListStructure("columns");
                ContainedObject[] containedObjectArray = table.getElements();
                for (int i = 0; i < containedObjectArray.length; ++i) {
                    Column column = (Column)containedObjectArray[i];
                    HashStructure hashStructure2 = HashStructure.newInstance();
                    ChangeBuffer changeBuffer = new ChangeBuffer();
                    hashStructure2.putString("type", "Column");
                    hashStructure2.putString("ID", column.getObjectID());
                    hashStructure2.putString("class", column.getClass().getName());
                    HashStructure hashStructure3 = HashStructure.newInstance();
                    hashStructure3.putString("name", column.getName());
                    hashStructure3.putString("abbreviation", column.getAbbreviation());
                    hashStructure3.putString("dataType", column.getDataType().toString());
                    hashStructure3.putInt("position", i);
                    hashStructure2.putHashStructure("properties", hashStructure3);
                    hashStructure2.markDirty(false);
                    listStructure.add((Object)hashStructure2);
                    hashStructure2.addStructureChangeListener((StructureChangeListener)changeBuffer);
                    hashStructure2.isDirty();
                    hashStructure2.removeStructureChangeListener((StructureChangeListener)changeBuffer);
                }
                if (!bl) {
                    try {
                        hashStructureIO.save(uRL, (Object)hashStructure);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    bl = true;
                }
                try {
                    hashStructureIO.write(hashStructure, (Writer)printWriter, uRL2);
                }
                catch (IOException iOException) {}
            }
            printWriter.close();
            try {
                uRL2 = new URL("file:///:d:/HS_IO_test/HSio_Test.xml");
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            MetaDataManager metaDataManager = new MetaDataManager();
            MDTransformationManager mDTransformationManager = new MDTransformationManager(metaDataManager);
            mDTransformationManager.registerTransformer(ModelIDObject.class, XMLFromObjTransformer.class, XMLToObjectTransformer.class, XMLObjToStreamTransformer.class);
            mDTransformationManager.registerTransformer(Object.class, XMLFromObjTransformer.class, XMLToObjectTransformer.class, XMLObjToStreamTransformer.class);
            RelationalDesign relationalDesign = (RelationalDesign)ControllerRelational.this.getDPVPhysical().getDesignPart();
            MDTransformer.SKP_DEFAULTS = true;
            boolean bl = false;
            if (relationalDesign != null) {
                String string = MDTransformer.SKP_DEFAULTS ? "d:/txml_ext/" : "d:/txmld_ext/";
                ControllerRelational.this.getDesign().setRelationalDesign(relationalDesign);
                System.out.println("begin test: " + System.currentTimeMillis());
                if (bl) {
                    ArrayList<Design> arrayList = new ArrayList<Design>();
                    arrayList.add(relationalDesign.getDesign());
                    for (Object e : arrayList) {
                        MDTransformationManager.TrObjects trObjects = mDTransformationManager.getTransformersFor(e.getClass());
                        String string2 = "";
                        try {
                            if (trObjects.getFromObjectTransformer() != null) {
                                string2 = ((XMLFromObjTransformer)trObjects.getFromObjectTransformer()).transformFromObjectToString(e, true);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        FileWriter fileWriter = null;
                        try {
                            String string3;
                            String string4 = string + this.getObjectType(e) + "/";
                            if (e instanceof EntityView) {
                                string4 = string + "EntityView/";
                            } else if (e instanceof ExtendedMap) {
                                string4 = string + "mapping/";
                            }
                            if ("".equals(string3 = this.getObjectID(e))) continue;
                            File file = new File(string4);
                            if (!file.exists()) {
                                file.mkdirs();
                            }
                            String string5 = string4 + string3 + ".xml";
                            fileWriter = new FileWriter(string5);
                            fileWriter.write(string2);
                            fileWriter.flush();
                            fileWriter.close();
                        }
                        catch (IOException iOException) {}
                    }
                } else {
                    try {
                        ApplicationView.canLogging = false;
                        ControllerRelational.this.getDesign().setPropagatePKChahges(false);
                        ApplicationView.loading = true;
                        this.readFiles(string, mDTransformationManager);
                        System.out.println("begin arrange: " + System.currentTimeMillis());
                    }
                    finally {
                        ControllerRelational.this.getDesign().setPropagatePKChahges(true);
                        ApplicationView.canLogging = true;
                        ApplicationView.loading = false;
                        ControllerRelational.this.getDesign().getAppView().getBrowserPanel().getNavigationTreeDesign().updateSubtree(ControllerRelational.this.getDesign());
                    }
                }
                System.out.println("end test: " + System.currentTimeMillis());
            }
        }

        private String getObjectID(Object object) {
            if (object instanceof ModelIDObject) {
                return ((ModelIDObject)object).getObjectID();
            }
            if (object instanceof DesignPartView) {
                DesignPartView designPartView = (DesignPartView)object;
                return designPartView.getDPVId();
            }
            if (object instanceof ExtendedMap) {
                return "ExtendedMap";
            }
            return "";
        }

        private String getObjectType(Object object) {
            if (object instanceof ModelIDObject) {
                return ((ModelIDObject)object).getObjectTypeName();
            }
            if (object instanceof DesignPartView) {
                DesignPartView designPartView = (DesignPartView)object;
                if (designPartView.getDesignPart() instanceof RelationalDesign) {
                    return "reldiagrams";
                }
                if (designPartView.getDesignPart() instanceof LogicalDesign) {
                    return "logdiagrams";
                }
            }
            return "others";
        }

        private String getID(File file) {
            String string = file.getName();
            int n = string.indexOf(".xml");
            if (n > -1) {
                return string.substring(0, n);
            }
            return null;
        }

        private void readFiles(String string, MDTransformationManager mDTransformationManager) {
            this.readFiles(string, "Design", mDTransformationManager);
        }

        private void readFiles(String string, String string2, MDTransformationManager mDTransformationManager) {
            File file = new File(string + "/" + string2);
            if (file.isDirectory()) {
                File[] fileArray = file.listFiles();
                for (int i = 0; i < fileArray.length; ++i) {
                    MDTransformationManager.TrObjects trObjects;
                    FileInputStream fileInputStream = null;
                    try {
                        fileInputStream = new FileInputStream(fileArray[i]);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        // empty catch block
                    }
                    if (fileInputStream == null) continue;
                    InputStreamReader inputStreamReader = null;
                    try {
                        inputStreamReader = new InputStreamReader((InputStream)fileInputStream, "UTF-8");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                    if (inputStreamReader == null) continue;
                    InputSource inputSource = new InputSource(inputStreamReader);
                    String string3 = this.getID(fileArray[i]);
                    Object object = null;
                    if (string3 != null) {
                        object = ControllerRelational.this.getDesign().getDesignObject(string3);
                    }
                    if (string2.equalsIgnoreCase("reldiagrams")) {
                        object = ControllerRelational.this.getDesign().getRelationalDesign().getMainView();
                    }
                    if (string2.equalsIgnoreCase("RelationalModel")) {
                        object = ControllerRelational.this.getDesign().getRelationalDesign();
                    }
                    if (string2.equalsIgnoreCase("Design")) {
                        object = ControllerRelational.this.getDesign();
                    }
                    if (object == null) {
                        object = this.createObject(string2);
                    }
                    if (object == null || (trObjects = mDTransformationManager.getTransformersFor(object.getClass())).getToObjectTransformer() == null) continue;
                    ((XMLToObjectTransformer)trObjects.getToObjectTransformer()).transformToObject(object, inputSource, true);
                    if (!(object instanceof FKIndexAssociation)) continue;
                }
            }
        }

        private Object createObject(String string) {
            if (string.equalsIgnoreCase("Table")) {
                return ControllerRelational.this.getDesign().getRelationalDesign().createTable();
            }
            if (string.equalsIgnoreCase("View")) {
                return ControllerRelational.this.getDesign().getRelationalDesign().createTableView();
            }
            if (string.equalsIgnoreCase("FKIndexAssociation")) {
                return new FKIndexAssociation(ControllerRelational.this.getDesign().getRelationalDesign());
            }
            if (string.equalsIgnoreCase("Entity")) {
                return ControllerRelational.this.getDesign().getLogicalDesign().createEntity();
            }
            if (string.equalsIgnoreCase("EntityView")) {
                return ControllerRelational.this.getDesign().getLogicalDesign().createEntityView();
            }
            if (string.equalsIgnoreCase("Relation")) {
                return ControllerRelational.this.getDesign().getLogicalDesign().createRelation();
            }
            if (string.equalsIgnoreCase("Hierarchy relation")) {
                return ControllerRelational.this.getDesign().getLogicalDesign().createNewInheritanceRelation();
            }
            if (string.equalsIgnoreCase("Arc")) {
                return ControllerRelational.this.getDesign().getLogicalDesign().createArc();
            }
            if (string.equalsIgnoreCase("FKArc")) {
                return ControllerRelational.this.getDesign().getRelationalDesign().createArc();
            }
            return null;
        }
    }

    class SyncDataDictionary
    extends MDBAction {
        private RelationalDesign relModel;
        private boolean syncMode;

        private SyncDataDictionary(String string, Icon icon, boolean bl) {
            super(string, icon);
            this.relModel = null;
            this.syncMode = bl;
        }

        @Override
        public void setEnabled(boolean bl) {
            super.setEnabled(bl && this.canHandle());
        }

        private boolean canHandle() {
            this.relModel = (RelationalDesign)ControllerRelational.this.getDPVPhysical().getDesignPart();
            if (this.relModel != null && !this.relModel.getImportConnectionStamps().isEmpty()) {
                for (int i = 0; i < this.relModel.getImportConnectionStamps().size(); ++i) {
                    DBConnectionStamp dBConnectionStamp = this.relModel.getImportConnectionStamp(i);
                    if (dBConnectionStamp.getConnType() != 1 && dBConnectionStamp.getConnType() != 2 && dBConnectionStamp.getConnType() != 3 && dBConnectionStamp.getConnType() != 4) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            try {
                this.relModel = (RelationalDesign)ControllerRelational.this.getDPVPhysical().getDesignPart();
                if (this.relModel != null) {
                    SyncUtils.syncDataDictionary(this.relModel, this.syncMode, null);
                }
            }
            catch (Throwable throwable) {
                MessageDialogs.showErrorMessage(throwable.getMessage());
                LOGGER.error(throwable);
            }
        }
    }

    class SyncDataDictionaryWithModel
    extends SyncDataDictionary {
        private SyncDataDictionaryWithModel() {
            super(MenuUtils.getMnemonicStr(Messages.getString("ControllerRelational.SyncDataDictionaryWithModel")), ControllerRelational.this.getConfiguration().getIcon("SYNC_DICT_WITH_MODEL", ControllerRelational.this.getPreferredIconSize()), true);
            this.setMenuPath(ControllerRelational.this.PHYSICAL_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(Messages.getString("ControllerRelational.SyncDataDictionaryWithModel")));
        }

        @Override
        public boolean addToolbarSeparator() {
            return false;
        }
    }

    class SyncModelWithDataDictionary
    extends SyncDataDictionary {
        private SyncModelWithDataDictionary() {
            super(MenuUtils.getMnemonicStr(Messages.getString("ControllerRelational.SyncModelWithDataDictionary")), ControllerRelational.this.getConfiguration().getIcon("SYNC_MODEL_WITH_DICT", ControllerRelational.this.getPreferredIconSize()), false);
            this.setMenuPath(ControllerRelational.this.PHYSICAL_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(Messages.getString("ControllerRelational.SyncModelWithDataDictionary")));
        }

        @Override
        public boolean addToolbarSeparator() {
            return true;
        }
    }

    class GenerateDDL
    extends MDBAction {
        private GenerateDDL() {
            super(MenuUtils.getMnemonicStr(Messages.getString("ControllerRelational.GenerateDDL")), ControllerRelational.this.getConfiguration().getIcon("DDL_FILE_ICON", ControllerRelational.this.getPreferredIconSize()));
            this.setMenuPath(ControllerRelational.this.OBJECT_PHYSICAL_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(Messages.getString("ControllerRelational.GenerateDDL")));
            this.setAccelerator(KeyStroke.getKeyStroke(71, 64, false));
        }

        @Override
        public boolean addToolbarSeparator() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            RelationalDesign relationalDesign = (RelationalDesign)ControllerRelational.this.getDPVPhysical().getDesignPart();
            if (relationalDesign != null) {
                ControllerRelational.this.getDesign().setRelationalDesign(relationalDesign);
                ControllerRelational.this.getApplicationView().setCurrentDesign(ControllerRelational.this.getDesign());
                ControllerRelational.this.getApplicationView().setDDLFileMakerEditorVisible(true);
            }
        }
    }

    class MergeTables
    extends SelectedObjectAction {
        private MergeTables() {
            super(MenuUtils.getMnemonicStr(AbstractController.MERGE_TABLES_CAPTION), ControllerRelational.this.getConfiguration().getIcon("MERGE_TABLE_ICON", ControllerRelational.this.getPreferredIconSize()));
            this.setMenuPath(ControllerRelational.this.OBJECT_PHYSICAL_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.MERGE_TABLES_CAPTION));
            this.setObjectAction(true);
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            if (ControllerRelational.this.fkCollector != null) {
                ControllerRelational.this.fkCollector.stopWaiting();
            }
            ControllerRelational.this.updateToolbar(this);
            ApplicationView.log(Messages.getString("ControllerRelational.MergeTables"));
            ControllerRelational.this.getDesignPartView().getWorkSpace().setCursor(Diagram.MERGE_CURSOR);
            DenormalizerMergeTable denormalizerMergeTable = new DenormalizerMergeTable();
            new TableCollectorMerge(denormalizerMergeTable);
        }

        @Override
        public void setEnabled(boolean bl) {
            super.setEnabled(bl && this.canHandle());
        }

        private boolean canHandle() {
            return !ControllerRelational.this.getDesign().isLoadFromDB() || ControllerRelational.this.getDesignPartView().getDesignPart().isCheckedOutByMe();
        }

        @Override
        public boolean canHandle(SelectableObject selectableObject) {
            return !ControllerRelational.this.getDesign().isLoadFromDB() || ControllerRelational.this.getDesignPartView().getDesignPart().isCheckedOutByMe();
        }
    }

    class SplitTable
    extends SelectedObjectAction {
        private SplitTable() {
            super(MenuUtils.getMnemonicStr(Messages.getString("ControllerRelational.SplitTable")), ControllerRelational.this.getConfiguration().getIcon("SPLIT_TABLE_ICON", ControllerRelational.this.getPreferredIconSize()));
            this.setMenuPath(ControllerRelational.this.OBJECT_PHYSICAL_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(Messages.getString("ControllerRelational.SplitTable")));
            this.setObjectAction(true);
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            if (ControllerRelational.this.fkCollector != null) {
                ControllerRelational.this.fkCollector.stopWaiting();
            }
            ControllerRelational.this.updateToolbar(this);
            DenormalizerSplitTable denormalizerSplitTable = new DenormalizerSplitTable();
            Table table = (Table)ControllerRelational.this.getDesignPartView().getCurrentSelection().getSelectedObject();
            if (table != null) {
                ApplicationView.log(MessageFormat.format(Messages.getString("ControllerRelational.SplitTable1"), table.getName()));
            } else {
                ApplicationView.log(Messages.getString("ControllerRelational.SplitTable"));
            }
            denormalizerSplitTable.setOriginalTable(table);
            if (denormalizerSplitTable.canSplit()) {
                SplitTableWizard splitTableWizard = new SplitTableWizard(ControllerRelational.this.getApplicationView(), denormalizerSplitTable);
                splitTableWizard.showDialog();
            }
        }

        @Override
        public void setEnabled(boolean bl) {
            super.setEnabled(bl && this.canHandle());
        }

        private boolean canHandle() {
            return !ControllerRelational.this.getDesign().isLoadFromDB() || ControllerRelational.this.getDesignPartView().getDesignPart().isCheckedOutByMe();
        }

        @Override
        public boolean canHandle(SelectableObject selectableObject) {
            if (ControllerRelational.this.getDesign().isLoadFromDB() && !ControllerRelational.this.getDesignPartView().getDesignPart().isCheckedOutByMe()) {
                return false;
            }
            if (selectableObject == null) {
                return false;
            }
            boolean bl = selectableObject.getSelectedDesignObject() instanceof Table;
            return bl;
        }
    }

    public class RevEngineer
    extends MDBAction {
        private RevEngineer() {
            super(MenuUtils.getMnemonicStr(AbstractController.REVERSE_ENGINEER_CAPTION), ControllerRelational.this.getConfiguration().getIcon("REVERSE_ENGINEER_ICON", ControllerRelational.this.getPreferredIconSize()));
            this.setMenuPath(ControllerRelational.this.DESIGN_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.REVERSE_ENGINEER_CAPTION));
            this.setAccelerator(KeyStroke.getKeyStroke(82, 192, false));
        }

        @Override
        public boolean addToolbarSeparator() {
            return true;
        }

        @Override
        public void setEnabled(boolean bl) {
            super.setEnabled(bl && this.canHandle());
        }

        private boolean canHandle() {
            return !ControllerRelational.this.getDesign().isLoadFromDB() || ControllerRelational.this.getDesignPartView().getDesignPart().isCheckedOutByMe();
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            EngineeringCompareDialog engineeringCompareDialog = new EngineeringCompareDialog(ControllerRelational.this.getApplicationView(), ControllerRelational.this.getApplicationView().getCurrentDPV().getDesignPart());
            engineeringCompareDialog.setModal(true);
            engineeringCompareDialog.show();
        }
    }

    class NewTypeSubstitution
    extends MDBAction {
        TypedElementCollector collector;

        private NewTypeSubstitution() {
            super(MenuUtils.getMnemonicStr(AbstractController.NEW_TYPE_SUBSTITUTION_CAPTION), ControllerRelational.this.getConfiguration().getIcon("RAGGED_LINK_ICON", ControllerRelational.this.getPreferredIconSize()));
            this.setMenuPath(ControllerRelational.this.OBJECT_PHYSICAL_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.NEW_TYPE_SUBSTITUTION_CAPTION));
            this.setObjectAction(true);
        }

        @Override
        public boolean isToggleButton() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            ControllerRelational.this.getDesignPartView().getWorkSpace().setDrawnObjectID(18);
            ControllerRelational.this.getDesignPartView().getWorkSpace().setCursor(Diagram.LINE_CURSOR);
            ControllerRelational.this.updateToolbar(this);
            this.collector = new TypedElementCollector();
        }
    }

    class NewFKRelation
    extends MDBAction {
        private NewFKRelation() {
            super(MenuUtils.getMnemonicStr(AbstractController.NEW_FK_RELATION_CAPTION), ControllerRelational.this.getConfiguration().getIcon("FK_ICON", ControllerRelational.this.getPreferredIconSize()));
            this.setMenuPath(ControllerRelational.this.OBJECT_PHYSICAL_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.NEW_FK_RELATION_CAPTION));
            this.setObjectAction(true);
        }

        @Override
        public boolean isToggleButton() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            ControllerRelational.this.getDesignPartView().getWorkSpace().setDrawnObjectID(3);
            ControllerRelational.this.getDesignPartView().getWorkSpace().setCursor(Diagram.LINE_CURSOR);
            ControllerRelational.this.updateToolbar(this);
            if (ControllerRelational.this.fkCollector != null) {
                ControllerRelational.this.fkCollector.stopWaiting();
            }
            ControllerRelational.this.fkCollector = new TableCollectorFKRelation();
        }
    }

    class NewNote
    extends MDBAction {
        private NewNote() {
            super(MenuUtils.getMnemonicStr(AbstractController.NEW_NOTE_CAPTION), ControllerRelational.this.getConfiguration().getIcon("NOTE_ICON", ControllerRelational.this.getPreferredIconSize()));
            this.setMenuPath(ControllerRelational.this.OBJECT_PHYSICAL_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.NEW_NOTE_CAPTION));
            this.setObjectAction(true);
        }

        @Override
        public boolean isToggleButton() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            if (ControllerRelational.this.fkCollector != null) {
                ControllerRelational.this.fkCollector.stopWaiting();
            }
            ControllerRelational.this.getDesignPartView().getWorkSpace().setDrawnObjectID(5);
            ControllerRelational.this.getDesignPartView().getWorkSpace().setCursor(new Cursor(1));
            ControllerRelational.this.updateToolbar(this);
        }
    }

    class NewTableView
    extends MDBAction {
        private NewTableView() {
            super(MenuUtils.getMnemonicStr(AbstractController.NEW_VIEW_CAPTION), ControllerRelational.this.getConfiguration().getIcon("VIEW_ICON", ControllerRelational.this.getPreferredIconSize()));
            this.setMenuPath(ControllerRelational.this.OBJECT_PHYSICAL_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.NEW_VIEW_CAPTION));
            this.setObjectAction(true);
        }

        @Override
        public boolean isToggleButton() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            if (ControllerRelational.this.fkCollector != null) {
                ControllerRelational.this.fkCollector.stopWaiting();
            }
            ControllerRelational.this.getDesignPartView().getWorkSpace().setDrawnObjectID(4);
            ControllerRelational.this.getDesignPartView().getWorkSpace().setCursor(new Cursor(1));
            ControllerRelational.this.updateToolbar(this);
        }
    }

    class NewTable
    extends MDBAction {
        private NewTable() {
            super(MenuUtils.getMnemonicStr(AbstractController.NEW_TABLE_CAPTION), ControllerRelational.this.getConfiguration().getIcon("TABLE_ICON", ControllerRelational.this.getPreferredIconSize()));
            this.setMenuPath(ControllerRelational.this.OBJECT_PHYSICAL_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.NEW_TABLE_CAPTION));
            this.setObjectAction(true);
        }

        @Override
        public boolean isToggleButton() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            if (ControllerRelational.this.fkCollector != null) {
                ControllerRelational.this.fkCollector.stopWaiting();
            }
            ControllerRelational.this.getDesignPartView().getWorkSpace().setDrawnObjectID(2);
            ControllerRelational.this.getDesignPartView().getWorkSpace().setCursor(new Cursor(1));
            ControllerRelational.this.updateToolbar(this);
        }
    }

    class Delete
    extends MDBAction {
        private Delete() {
            super(MenuUtils.getMnemonicStr(AbstractController.DELETE_CAPTION), ControllerRelational.this.getConfiguration().getIcon("DELETE_ICON", ControllerRelational.this.getPreferredIconSize()));
            this.setMenuPath(ControllerRelational.this.OBJECT_PHYSICAL_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.DELETE_CAPTION));
            this.setObjectAction(true);
        }

        @Override
        public boolean isToggleButton() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            if (ControllerRelational.this.fkCollector != null) {
                ControllerRelational.this.fkCollector.stopWaiting();
            }
            ControllerRelational.this.getDesignPartView().getWorkSpace().setDrawnObjectID(6);
            ControllerRelational.this.getDesignPartView().getWorkSpace().setCursor(Diagram.DELETE_CURSOR);
            ControllerRelational.this.updateToolbar(this);
        }
    }

    class Select
    extends MDBAction {
        private Select() {
            super(MenuUtils.getMnemonicStr(AbstractController.SELECT_CAPTION), ControllerRelational.this.getConfiguration().getIcon("SELECT_ICON", ControllerRelational.this.getPreferredIconSize()));
            this.setMenuPath(ControllerRelational.this.OBJECT_PHYSICAL_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.SELECT_CAPTION));
            this.setObjectAction(true);
        }

        @Override
        public boolean isToggleButton() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            if (ControllerRelational.this.fkCollector != null) {
                ControllerRelational.this.fkCollector.stopWaiting();
            }
            ControllerRelational.this.getDesignPartView().getWorkSpace().setDrawnObjectID(-1);
            ControllerRelational.this.getDesignPartView().getWorkSpace().setCursor(new Cursor(0));
            ControllerRelational.this.updateToolbar(this);
        }
    }
}

