/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.process;

import java.awt.Color;
import java.awt.event.MouseEvent;
import java.util.Map;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.process.Event;
import oracle.dbtools.crest.model.design.process.Flow;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.SelectableObject;
import oracle.dbtools.crest.swingui.SelectableObjectMultiple;
import oracle.dbtools.crest.swingui.TVConnector;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultEdge;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.swingui.diagram.graph.EdgeView;
import oracle.dbtools.crest.swingui.diagram.process.DFDiagramCell;
import oracle.dbtools.crest.swingui.diagram.process.FlowEdge;
import oracle.dbtools.crest.swingui.diagram.process.FlowView;
import oracle.dbtools.crest.swingui.process.AbstractDataFlowTV;

public class TVFlow
extends TVConnector {
    private FlowSelection selectionWrapper = new FlowSelection();

    public TVFlow(ApplicationView applicationView, DesignPartView designPartView) {
        super(applicationView, designPartView);
    }

    @Override
    public boolean isConnection() {
        return true;
    }

    @Override
    public DesignPartView getDesignPartView() {
        if (this.dpv == null) {
            return this.getApplicationView().getCurrentDPV();
        }
        return this.dpv;
    }

    public void remove() {
        this.remove(true);
    }

    public void remove(boolean bl) {
        if (bl) {
            this.getModel().remove();
            this.getDesignPartView().getWorkSpace().repaint();
        }
    }

    public Flow getFlow() {
        return (Flow)this.getModel();
    }

    public DefaultEdge addConnection() {
        if (this.edge == null) {
            AbstractDataFlowTV abstractDataFlowTV = this.getFlow().getSourceTV(this.getDesignPartView());
            AbstractDataFlowTV abstractDataFlowTV2 = this.getFlow().getTargetTV(this.getDesignPartView());
            if (abstractDataFlowTV.getCellView() != null && abstractDataFlowTV2.getCellView() != null) {
                DFDiagramCell dFDiagramCell = (DFDiagramCell)abstractDataFlowTV.getCellView().getCell();
                DFDiagramCell dFDiagramCell2 = (DFDiagramCell)abstractDataFlowTV2.getCellView().getCell();
                this.edge = this.getDesignPartView().getWorkSpace().addConnection(dFDiagramCell, dFDiagramCell2, Color.MAGENTA);
                this.edge.setTopView(this);
                this.setCellView(this.edge.getCellView());
                this.setEdge(this.edge);
                this.displayLabels();
                if (!ApplicationView.loading) {
                    this.edge.straightLine();
                }
            }
        }
        return this.edge;
    }

    @Override
    public void displayLabels() {
        if (this.edge != null && this.edge.getDiagram().getDesignPartView().showLabels()) {
            if (this.edge != null && this.edge.getTopView() != null) {
                if (!"".equalsIgnoreCase(((FlowEdge)this.edge).getName())) {
                    this.displayLabel(((FlowEdge)this.edge).getName(), this.getLabelBounds(), 1);
                } else {
                    this.removeLabel(1);
                }
            }
        } else {
            this.removeLabel(1);
        }
    }

    public boolean isSelected() {
        return this.selectionWrapper == this.getDesignPartView().getCurrentSelection();
    }

    @Override
    public SelectableObject getSelectableObject() {
        return this.selectionWrapper;
    }

    @Override
    public Object getLayerConstraint() {
        return RELATION_LAYER;
    }

    @Override
    public String toString() {
        return this.getModel().getName();
    }

    public void oneClick(MouseEvent mouseEvent) {
        this.getDesignPartView().setCurrentSelection(this.selectionWrapper, this);
    }

    public FlowView getFlowView() {
        return (FlowView)this.getCellView();
    }

    @Override
    public void changed(DesignObject designObject, ObjectChangeEvent objectChangeEvent) {
    }

    public void setEdge(DefaultEdge defaultEdge) {
        this.edge = defaultEdge;
    }

    @Override
    public Color getDefaultLineColor() {
        return this.getDesign().getDLSettings().getDefaultLWCObject("Process Flow").getColor();
    }

    @Override
    public int getDefaultLineWidth() {
        return this.getDesign().getDLSettings().getDefaultLWCObject("Process Flow").getWidth();
    }

    @Override
    public void resetEdgeParams() {
        if (this.edge != null) {
            this.resetEdgeParams(this.edge, true);
        }
    }

    public void resetEdgeParams(boolean bl) {
        if (this.edge != null) {
            this.resetEdgeParams(this.edge, bl);
        }
    }

    private void resetEdgeParams(DefaultEdge defaultEdge, boolean bl) {
        Event event = ((Flow)this.getModel()).getEvent();
        if (event != null) {
            if (defaultEdge != null) {
                Map map = defaultEdge.getAttributes();
                DiagramConstants.setLineEnd(map, 9);
                defaultEdge.setAttributes(map);
                EdgeView edgeView = (EdgeView)defaultEdge.getDiagram().getDiagramLayoutCache().getMapping(defaultEdge, false);
                edgeView.update();
            }
        } else if (defaultEdge != null) {
            Map map = defaultEdge.getAttributes();
            DiagramConstants.setLineEnd(map, 1);
            defaultEdge.setAttributes(map);
            EdgeView edgeView = (EdgeView)defaultEdge.getDiagram().getDiagramLayoutCache().getMapping(defaultEdge, false);
            edgeView.update();
        }
    }

    class FlowSelection
    implements SelectableObject {
        FlowSelection() {
        }

        @Override
        public Object[] getSelectedContainedObject() {
            return null;
        }

        @Override
        public Object getSelectedObject() {
            return this.getSelectedDesignObject();
        }

        @Override
        public DesignObject getSelectedDesignObject() {
            return TVFlow.this.getModel();
        }

        @Override
        public boolean hasContainedArray() {
            return false;
        }

        @Override
        public boolean isMultiple() {
            return false;
        }

        @Override
        public SelectableObjectMultiple asMultiple() {
            throw new ClassCastException("Not a SelectableObjectMultiple");
        }
    }
}

