/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.process;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.dbtools.crest.fcp.DataModelerAddin;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.DiagramView;
import oracle.dbtools.crest.model.design.Label;
import oracle.dbtools.crest.model.design.Legend;
import oracle.dbtools.crest.model.design.Note;
import oracle.dbtools.crest.model.design.process.AbstractProcessObject;
import oracle.dbtools.crest.model.design.process.Flow;
import oracle.dbtools.crest.model.design.process.InOutParams;
import oracle.dbtools.crest.model.design.process.InfoStore;
import oracle.dbtools.crest.model.design.process.Process;
import oracle.dbtools.crest.model.design.process.Transformation;
import oracle.dbtools.crest.model.design.process.TransformationTask;
import oracle.dbtools.crest.swingui.AbstractController;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.MenuUtils;
import oracle.dbtools.crest.swingui.TVDiagramView;
import oracle.dbtools.crest.swingui.TVLabel;
import oracle.dbtools.crest.swingui.TVLegend;
import oracle.dbtools.crest.swingui.TVNote;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.process.ControllerTransformation;
import oracle.dbtools.crest.swingui.process.TVFlow;
import oracle.dbtools.crest.swingui.process.TVInOutParams;
import oracle.dbtools.crest.swingui.process.TVInfoStore;
import oracle.dbtools.crest.swingui.process.TVProcess;
import oracle.dbtools.crest.swingui.process.TVTransformation;

public class DPVTransformation
extends DesignPartView {
    private static final Dimension TOPVIEW_SIZE = new Dimension(280, 320);
    private ControllerTransformation controller;
    private JPopupMenu menu;
    private JCheckBoxMenuItem miAutoRoute;
    private JCheckBoxMenuItem miShowGrid;
    private JCheckBoxMenuItem miShowLabels;
    private JMenu detailsMenu;
    private JCheckBoxMenuItem miAllDetails;
    private JCheckBoxMenuItem miNameOnly;
    private JCheckBoxMenuItem miShowLegend;
    private JMenuItem miDiagramColor;

    public DPVTransformation(ApplicationView applicationView, DesignPart designPart) {
        super(applicationView, designPart);
        this.controller = new ControllerTransformation(applicationView);
        this.controller.setName("Transformation");
        this.controller.setDesignPartView(this);
        ((TransformationTask)designPart).getProcessModel().addDesignPartListener(this);
    }

    @Override
    public TopView createViewFor(DesignObject designObject) {
        return this.createTopViewFor(designObject);
    }

    @Override
    public AbstractController getController() {
        return this.controller;
    }

    private boolean canCreateViewForGlobalObject(DesignObject designObject) {
        return this.getApplicationView().getCurrentDPV() == this && !ApplicationView.loading;
    }

    public TopView createViewSynonim(DesignObject designObject) {
        AbstractProcessObject abstractProcessObject = (AbstractProcessObject)designObject;
        TopView topView = abstractProcessObject.getFirstViewForDPV(this);
        if (topView == null) {
            if (designObject instanceof InfoStore) {
                topView = new TVInfoStore(this.getApplicationView(), this);
            } else if (designObject instanceof Flow) {
                topView = new TVFlow(this.getApplicationView(), this);
            } else if (designObject instanceof Process) {
                topView = new TVProcess(this.getApplicationView(), this);
            }
        }
        if (topView != null) {
            topView.setModel(designObject);
            this.modelToView.put(designObject, topView);
            this.add(topView);
            ((TransformationTask)this.getDesignPart()).registerLocalObject(topView);
        }
        return topView;
    }

    @Override
    public void registerForTreemodel(TopView topView) {
        ((TransformationTask)this.getDesignPart()).registerLocalObject(topView);
    }

    @Override
    public void unregisterFromTreemodel(TopView topView) {
        if (topView != null) {
            ((TransformationTask)this.getDesignPart()).unRegisterLocalObject(topView);
            this.unregisterTopView(topView);
        }
    }

    @Override
    public DesignPartView createSubordinateView(ApplicationView applicationView, DesignPart designPart) {
        return new DPVTransformation(this.getApplicationView(), this.getDesignPart());
    }

    @Override
    public TopView createTopViewFor(DesignObject designObject) {
        TopView topView = null;
        if (designObject instanceof Transformation) {
            TVTransformation tVTransformation = new TVTransformation(this.getApplicationView(), this);
            tVTransformation.setModel(designObject);
            topView = tVTransformation;
        } else {
            if (designObject instanceof Note) {
                TVNote tVNote = new TVNote(this.getApplicationView(), this);
                tVNote.setModel(designObject);
                return tVNote;
            }
            if (designObject instanceof Legend) {
                TVLegend tVLegend = new TVLegend(this.getApplicationView(), this);
                tVLegend.setModel(designObject);
                return tVLegend;
            }
            if (designObject instanceof InfoStore && this.canCreateViewForGlobalObject(designObject)) {
                TVInfoStore tVInfoStore = new TVInfoStore(this.getApplicationView(), this);
                tVInfoStore.setModel(designObject);
                ((TransformationTask)this.getDesignPart()).registerLocalObject(tVInfoStore);
                return tVInfoStore;
            }
            if (designObject instanceof Flow) {
                TVFlow tVFlow = new TVFlow(this.getApplicationView(), this);
                tVFlow.setModel(designObject);
                topView = tVFlow;
            } else if (designObject instanceof InOutParams) {
                TVInOutParams tVInOutParams = new TVInOutParams(this.getApplicationView(), this);
                tVInOutParams.setModel(designObject);
                topView = tVInOutParams;
            } else if (designObject instanceof DiagramView) {
                TVDiagramView tVDiagramView = new TVDiagramView(this.getApplicationView(), this);
                tVDiagramView.setModel(designObject);
                topView = tVDiagramView;
            } else if (designObject instanceof Label) {
                TVLabel tVLabel = new TVLabel(this.getApplicationView(), this);
                tVLabel.setModel(designObject);
                topView = tVLabel;
            } else {
                return null;
            }
        }
        topView.setSize(new Dimension(TOPVIEW_SIZE));
        this.registerForTreemodel(topView);
        this.setDirty(true);
        return topView;
    }

    @Override
    public TopView createTopViewForGlobal(DesignObject designObject) {
        TopView topView = null;
        if (designObject instanceof Transformation) {
            TVTransformation tVTransformation = new TVTransformation(this.getApplicationView(), this);
            tVTransformation.setModel(designObject);
            topView = tVTransformation;
        } else {
            if (designObject instanceof Note) {
                TVNote tVNote = new TVNote(this.getApplicationView(), this);
                tVNote.setModel(designObject);
                return tVNote;
            }
            if (designObject instanceof InfoStore) {
                TVInfoStore tVInfoStore = new TVInfoStore(this.getApplicationView(), this);
                tVInfoStore.setModel(designObject);
                ((TransformationTask)this.getDesignPart()).registerLocalObject(tVInfoStore);
                return tVInfoStore;
            }
            if (designObject instanceof Flow) {
                TVFlow tVFlow = new TVFlow(this.getApplicationView(), this);
                tVFlow.setModel(designObject);
                topView = tVFlow;
            } else if (designObject instanceof InOutParams) {
                TVInOutParams tVInOutParams = new TVInOutParams(this.getApplicationView(), this);
                tVInOutParams.setModel(designObject);
                topView = tVInOutParams;
            } else if (designObject instanceof DiagramView) {
                TVDiagramView tVDiagramView = new TVDiagramView(this.getApplicationView(), this);
                tVDiagramView.setModel(designObject);
                topView = tVDiagramView;
            } else if (designObject instanceof Label) {
                TVLabel tVLabel = new TVLabel(this.getApplicationView(), this);
                tVLabel.setModel(designObject);
                topView = tVLabel;
            } else {
                return null;
            }
        }
        topView.setSize(new Dimension(TOPVIEW_SIZE));
        this.registerForTreemodel(topView);
        return topView;
    }

    @Override
    public JPopupMenu getPopupMenu() {
        this.menu = new JPopupMenu();
        if (this.isEditable()) {
            this.miAutoRoute = new JCheckBoxMenuItem(MI_AUTO_ROUTE);
            this.miAutoRoute.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DPVTransformation.this.setAutoRoute(!DPVTransformation.this.isAutoRoute());
                    DPVTransformation.this.getWorkSpace().updateSettings();
                }
            });
            this.menu.add(this.miAutoRoute);
            this.menu.addSeparator();
            this.menu.add(this.getStraightenLinesItem());
            this.menu.addSeparator();
            this.menu.add(this.getDetailsMenu());
            this.menu.addSeparator();
            this.miDiagramColor = this.menu.add(new AbstractAction(MI_DIAGRAM_COLOR){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DPVTransformation.this.changeDiagramColor();
                }
            });
            this.miDiagramColor.setEnabled(false);
            this.menu.addSeparator();
        }
        this.menu.add(this.getGoToDiagramMenu());
        this.menu.addSeparator();
        this.menu.add(this.getShowMenu());
        this.menu.addSeparator();
        this.menu.add(DataModelerAddin.findOrCreateVersioningMenu(this.menu));
        this.menu.addSeparator();
        this.menu.add(new AbstractAction(MI_PROPERTIES){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DPVTransformation.this.getDesignPart().showPropertyDialog();
            }
        });
        if (this.isEditable()) {
            this.miAutoRoute.setSelected(this.isAutoRoute());
            this.miAllDetails.setSelected(this.showAllDetails());
            this.miNameOnly.setSelected(this.isShowNamesOnly());
            this.miDiagramColor.setEnabled(true);
        }
        return this.menu;
    }

    public JMenu getShowMenu() {
        JMenu jMenu = new JMenu(MenuUtils.getMnemonicStr(MI_SHOW));
        jMenu.setMnemonic(MenuUtils.getMnemonicKey(MI_SHOW));
        this.miShowGrid = new JCheckBoxMenuItem(MI_SHOW_GRID);
        this.miShowGrid.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DPVTransformation.this.setShowGrid(!DPVTransformation.this.showGrid());
            }
        });
        jMenu.add(this.miShowGrid);
        jMenu.addSeparator();
        this.miShowLabels = new JCheckBoxMenuItem(MI_SHOW_LABELS);
        this.miShowLabels.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DPVTransformation.this.setShowLabels(!DPVTransformation.this.showLabels());
            }
        });
        jMenu.add(this.miShowLabels);
        jMenu.addSeparator();
        this.miShowLegend = new JCheckBoxMenuItem(MI_SHOW_LEGEND);
        this.miShowLegend.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DPVTransformation.this.setShowLegend(!DPVTransformation.this.showLegend());
            }
        });
        jMenu.add(this.miShowLegend);
        this.miShowGrid.setSelected(this.showGrid());
        this.miShowLabels.setSelected(this.showLabels());
        this.miShowLegend.setSelected(this.showLegend());
        return jMenu;
    }

    @Override
    public JMenu getDetailsMenu() {
        this.detailsMenu = new JMenu(MenuUtils.getMnemonicStr(MI_DETAILS));
        this.detailsMenu.setMnemonic(MenuUtils.getMnemonicKey(MI_DETAILS));
        this.miAllDetails = new JCheckBoxMenuItem(MenuUtils.getMnemonicStr(MI_ALL_DETAILS));
        this.miAllDetails.setMnemonic(MenuUtils.getMnemonicKey(MI_ALL_DETAILS));
        this.miNameOnly = new JCheckBoxMenuItem(MenuUtils.getMnemonicStr(MI_NAMES_ONLY));
        this.miNameOnly.setMnemonic(MenuUtils.getMnemonicKey(MI_NAMES_ONLY));
        this.miAllDetails.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DPVTransformation.this.setShowAllDetails(true);
                DPVTransformation.this.setShowNamesOnly(false);
                DPVTransformation.this.setShowElements(false);
                DPVTransformation.this.setShowDatatype(false);
                DPVTransformation.this.setShowKeys(false);
                DPVTransformation.this.getWorkSpace().invalidate();
                DPVTransformation.this.getWorkSpace().repaint();
            }
        });
        this.detailsMenu.add(this.miAllDetails);
        this.detailsMenu.addSeparator();
        this.miNameOnly.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DPVTransformation.this.setShowNamesOnly(true);
                DPVTransformation.this.setShowAllDetails(false);
                DPVTransformation.this.setShowNamesOnly(true);
                DPVTransformation.this.setShowElements(false);
                DPVTransformation.this.setShowDatatype(false);
                DPVTransformation.this.setShowKeys(false);
                DPVTransformation.this.getWorkSpace().invalidate();
                DPVTransformation.this.getWorkSpace().repaint();
            }
        });
        this.detailsMenu.add(this.miNameOnly);
        this.miAllDetails.setSelected(this.showAllDetails());
        this.miNameOnly.setSelected(this.isShowNamesOnly());
        return this.detailsMenu;
    }

    @Override
    public boolean isStorable() {
        return false;
    }
}

