/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.process;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.dbtools.crest.fcp.DataModelerAddin;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.DiagramView;
import oracle.dbtools.crest.model.design.Label;
import oracle.dbtools.crest.model.design.Legend;
import oracle.dbtools.crest.model.design.Note;
import oracle.dbtools.crest.model.design.process.AbstractProcessObject;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.ExternalAgent;
import oracle.dbtools.crest.model.design.process.Flow;
import oracle.dbtools.crest.model.design.process.InfoStore;
import oracle.dbtools.crest.model.design.process.Process;
import oracle.dbtools.crest.swingui.AbstractController;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.MenuUtils;
import oracle.dbtools.crest.swingui.TVDiagramView;
import oracle.dbtools.crest.swingui.TVLabel;
import oracle.dbtools.crest.swingui.TVLegend;
import oracle.dbtools.crest.swingui.TVNote;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.process.ControllerProcess;
import oracle.dbtools.crest.swingui.process.TVAgent;
import oracle.dbtools.crest.swingui.process.TVFlow;
import oracle.dbtools.crest.swingui.process.TVInfoStore;
import oracle.dbtools.crest.swingui.process.TVProcess;

public class DPVProcess
extends DesignPartView {
    private static final Dimension TOPVIEW_SIZE = new Dimension(280, 320);
    private ControllerProcess controller;
    private JPopupMenu menu;
    private JMenuItem miPaste;
    private JCheckBoxMenuItem miAutoRoute;
    private JCheckBoxMenuItem miGoToParent;
    private JCheckBoxMenuItem miShowGrid;
    private JMenu detailsMenu;
    private JCheckBoxMenuItem miAllDetails;
    private JCheckBoxMenuItem miNameOnly;
    private JCheckBoxMenuItem miShowLegend;
    private JCheckBoxMenuItem miShowLabels;
    private DataFlowDesign parentDFD;
    private JMenuItem miDiagramColor;

    public DPVProcess(ApplicationView applicationView, DesignPart designPart) {
        super(applicationView, designPart);
        this.controller = new ControllerProcess(applicationView);
        this.controller.setName("Process");
        this.controller.setDesignPartView(this);
        ((DataFlowDesign)designPart).getProcessModel().addDesignPartListener(this);
    }

    @Override
    public TopView createViewFor(DesignObject designObject) {
        return this.createTopViewFor(designObject);
    }

    @Override
    public AbstractController getController() {
        return this.controller;
    }

    private boolean canCreateViewForGlobalObject(DesignObject designObject) {
        return this.getApplicationView().getCurrentDPV() == this && !ApplicationView.loading;
    }

    public TopView createViewSynonim(DesignObject designObject) {
        AbstractProcessObject abstractProcessObject = (AbstractProcessObject)designObject;
        TopView topView = abstractProcessObject.getFirstViewForDPV(this);
        if (topView == null) {
            if (designObject instanceof ExternalAgent) {
                topView = new TVAgent(this.getApplicationView(), this);
            } else if (designObject instanceof InfoStore) {
                topView = new TVInfoStore(this.getApplicationView(), this);
            } else if (designObject instanceof Flow) {
                topView = new TVFlow(this.getApplicationView(), this);
            } else if (designObject instanceof Process) {
                topView = new TVProcess(this.getApplicationView(), this);
            }
        }
        if (topView != null) {
            topView.setModel(designObject);
            this.modelToView.put(designObject, topView);
            this.add(topView);
            ((DataFlowDesign)this.getDesignPart()).registerLocalObject(topView);
        }
        return topView;
    }

    @Override
    public void registerForTreemodel(TopView topView) {
        ((DataFlowDesign)this.getDesignPart()).registerLocalObject(topView);
    }

    @Override
    public void unregisterFromTreemodel(TopView topView) {
        if (topView != null) {
            ((DataFlowDesign)this.getDesignPart()).unRegisterLocalObject(topView);
            this.unregisterTopView(topView);
        }
    }

    @Override
    public DesignPartView createSubordinateView(ApplicationView applicationView, DesignPart designPart) {
        return new DPVProcess(this.getApplicationView(), this.getDesignPart());
    }

    @Override
    public TopView createTopViewFor(DesignObject designObject) {
        TopView topView = null;
        if (designObject instanceof Process) {
            TVProcess tVProcess = new TVProcess(this.getApplicationView(), this);
            tVProcess.setModel(designObject);
            topView = tVProcess;
        } else {
            if (designObject instanceof Note) {
                TVNote tVNote = new TVNote(this.getApplicationView(), this);
                tVNote.setModel(designObject);
                return tVNote;
            }
            if (designObject instanceof Legend) {
                TVLegend tVLegend = new TVLegend(this.getApplicationView(), this);
                tVLegend.setModel(designObject);
                return tVLegend;
            }
            if (designObject instanceof ExternalAgent && this.canCreateViewForGlobalObject(designObject)) {
                TVAgent tVAgent = new TVAgent(this.getApplicationView(), this);
                tVAgent.setModel(designObject);
                ((DataFlowDesign)this.getDesignPart()).registerLocalObject(tVAgent);
                return tVAgent;
            }
            if (designObject instanceof InfoStore && this.canCreateViewForGlobalObject(designObject)) {
                TVInfoStore tVInfoStore = new TVInfoStore(this.getApplicationView(), this);
                tVInfoStore.setModel(designObject);
                ((DataFlowDesign)this.getDesignPart()).registerLocalObject(tVInfoStore);
                return tVInfoStore;
            }
            if (designObject instanceof Flow) {
                TVFlow tVFlow = new TVFlow(this.getApplicationView(), this);
                tVFlow.setModel(designObject);
                topView = tVFlow;
            } else if (designObject instanceof DiagramView) {
                TVDiagramView tVDiagramView = new TVDiagramView(this.getApplicationView(), this);
                tVDiagramView.setModel(designObject);
                topView = tVDiagramView;
            } else if (designObject instanceof Label) {
                TVLabel tVLabel = new TVLabel(this.getApplicationView(), this);
                tVLabel.setModel(designObject);
                topView = tVLabel;
            } else {
                return null;
            }
        }
        topView.setSize(new Dimension(TOPVIEW_SIZE));
        this.registerForTreemodel(topView);
        this.setDirty(true);
        return topView;
    }

    @Override
    public TopView createTopViewForGlobal(DesignObject designObject) {
        TopView topView = null;
        if (designObject instanceof Process) {
            TVProcess tVProcess = new TVProcess(this.getApplicationView(), this);
            tVProcess.setModel(designObject);
            topView = tVProcess;
        } else {
            if (designObject instanceof Note) {
                TVNote tVNote = new TVNote(this.getApplicationView(), this);
                tVNote.setModel(designObject);
                return tVNote;
            }
            if (designObject instanceof ExternalAgent) {
                TVAgent tVAgent = new TVAgent(this.getApplicationView(), this);
                tVAgent.setModel(designObject);
                ((DataFlowDesign)this.getDesignPart()).registerLocalObject(tVAgent);
                return tVAgent;
            }
            if (designObject instanceof InfoStore) {
                TVInfoStore tVInfoStore = new TVInfoStore(this.getApplicationView(), this);
                tVInfoStore.setModel(designObject);
                ((DataFlowDesign)this.getDesignPart()).registerLocalObject(tVInfoStore);
                return tVInfoStore;
            }
            if (designObject instanceof Flow) {
                TVFlow tVFlow = new TVFlow(this.getApplicationView(), this);
                tVFlow.setModel(designObject);
                topView = tVFlow;
            } else if (designObject instanceof DiagramView) {
                TVDiagramView tVDiagramView = new TVDiagramView(this.getApplicationView(), this);
                tVDiagramView.setModel(designObject);
                topView = tVDiagramView;
            } else if (designObject instanceof Label) {
                TVLabel tVLabel = new TVLabel(this.getApplicationView(), this);
                tVLabel.setModel(designObject);
                topView = tVLabel;
            } else {
                return null;
            }
        }
        topView.setSize(new Dimension(TOPVIEW_SIZE));
        this.registerForTreemodel(topView);
        return topView;
    }

    @Override
    public JPopupMenu getPopupMenu() {
        this.menu = new JPopupMenu();
        if (this.isEditable()) {
            this.addUndoRedo(this.menu);
            this.menu.addSeparator();
            DesignPart designPart = this.getDesignPart();
            this.parentDFD = null;
            if (designPart instanceof DataFlowDesign) {
                DataFlowDesign dataFlowDesign = (DataFlowDesign)designPart;
                this.parentDFD = dataFlowDesign.getParentDataFlowdesign();
                if (this.parentDFD != null) {
                    this.miGoToParent = new JCheckBoxMenuItem(MI_GO_TO_PARENT);
                    this.miGoToParent.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            TopView topView;
                            DPVProcess.this.parentDFD.setMainViewVisible(true);
                            Process process = ((DataFlowDesign)DPVProcess.this.getDesignPart()).getProcess();
                            if (process != null && (topView = process.getFirstViewForDPV(DPVProcess.this.parentDFD.getMainView())) != null) {
                                ((ContainerView)topView).setCurrentSelectionToContainer();
                            }
                        }
                    });
                    this.menu.add(this.miGoToParent);
                    this.menu.addSeparator();
                }
            }
            this.miAutoRoute = new JCheckBoxMenuItem(MI_AUTO_ROUTE);
            this.miAutoRoute.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DPVProcess.this.setAutoRoute(!DPVProcess.this.isAutoRoute());
                    DPVProcess.this.getWorkSpace().updateSettings();
                }
            });
            this.menu.add(this.miAutoRoute);
            this.menu.addSeparator();
            this.miPaste = this.menu.add(new AbstractAction(MI_PASTE){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DPVProcess.this.getController().paste(DPVProcess.this.pt);
                }
            });
            this.menu.addSeparator();
            this.menu.add(this.getStraightenLinesItem());
            this.menu.addSeparator();
            this.menu.add(this.getDetailsMenu());
            this.menu.addSeparator();
            this.miDiagramColor = this.menu.add(new AbstractAction(MI_DIAGRAM_COLOR){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DPVProcess.this.changeDiagramColor();
                }
            });
            this.miDiagramColor.setEnabled(false);
            this.menu.addSeparator();
        }
        this.menu.add(this.getGoToDiagramMenu());
        this.menu.addSeparator();
        this.menu.add(this.getShowMenu());
        this.menu.addSeparator();
        this.menu.add(DataModelerAddin.findOrCreateVersioningMenu(this.menu));
        this.menu.addSeparator();
        this.menu.add(new AbstractAction(MI_PROPERTIES){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DPVProcess.this.getDesignPart().showPropertyDialog();
            }
        });
        if (this.isEditable()) {
            this.miAutoRoute.setSelected(this.isAutoRoute());
            this.miPaste.setEnabled(this.canPaste());
            this.miAllDetails.setSelected(this.showAllDetails());
            this.miNameOnly.setSelected(this.isShowNamesOnly());
            this.miDiagramColor.setEnabled(true);
        }
        return this.menu;
    }

    public JMenu getShowMenu() {
        JMenu jMenu = new JMenu(MenuUtils.getMnemonicStr(MI_SHOW));
        jMenu.setMnemonic(MenuUtils.getMnemonicKey(MI_SHOW));
        this.miShowGrid = new JCheckBoxMenuItem(MI_SHOW_GRID);
        this.miShowGrid.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DPVProcess.this.setShowGrid(!DPVProcess.this.showGrid());
            }
        });
        jMenu.add(this.miShowGrid);
        jMenu.addSeparator();
        this.miShowLabels = new JCheckBoxMenuItem(MI_SHOW_LABELS);
        this.miShowLabels.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DPVProcess.this.setShowLabels(!DPVProcess.this.showLabels());
            }
        });
        jMenu.add(this.miShowLabels);
        jMenu.addSeparator();
        this.miShowLegend = new JCheckBoxMenuItem(MI_SHOW_LEGEND);
        this.miShowLegend.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DPVProcess.this.setShowLegend(!DPVProcess.this.showLegend());
            }
        });
        jMenu.add(this.miShowLegend);
        this.miShowGrid.setSelected(this.showGrid());
        this.miShowLabels.setSelected(this.showLabels());
        this.miShowLegend.setSelected(this.showLegend());
        return jMenu;
    }

    @Override
    public JMenu getDetailsMenu() {
        this.detailsMenu = new JMenu(MenuUtils.getMnemonicStr(MI_DETAILS));
        this.detailsMenu.setMnemonic(MenuUtils.getMnemonicKey(MI_DETAILS));
        this.miAllDetails = new JCheckBoxMenuItem(MenuUtils.getMnemonicStr(MI_ALL_DETAILS));
        this.miAllDetails.setMnemonic(MenuUtils.getMnemonicKey(MI_ALL_DETAILS));
        this.miNameOnly = new JCheckBoxMenuItem(MenuUtils.getMnemonicStr(MI_NAMES_ONLY));
        this.miNameOnly.setMnemonic(MenuUtils.getMnemonicKey(MI_NAMES_ONLY));
        this.miAllDetails.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DPVProcess.this.setShowAllDetails(true);
                DPVProcess.this.setShowNamesOnly(false);
                DPVProcess.this.setShowElements(false);
                DPVProcess.this.setShowDatatype(false);
                DPVProcess.this.setShowKeys(false);
                DPVProcess.this.getWorkSpace().invalidate();
                DPVProcess.this.getWorkSpace().repaint();
            }
        });
        this.detailsMenu.add(this.miAllDetails);
        this.detailsMenu.addSeparator();
        this.miNameOnly.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DPVProcess.this.setShowNamesOnly(true);
                DPVProcess.this.setShowAllDetails(false);
                DPVProcess.this.setShowNamesOnly(true);
                DPVProcess.this.setShowElements(false);
                DPVProcess.this.setShowDatatype(false);
                DPVProcess.this.setShowKeys(false);
                DPVProcess.this.getWorkSpace().invalidate();
                DPVProcess.this.getWorkSpace().repaint();
            }
        });
        this.detailsMenu.add(this.miNameOnly);
        this.miAllDetails.setSelected(this.showAllDetails());
        this.miNameOnly.setSelected(this.isShowNamesOnly());
        return this.detailsMenu;
    }

    @Override
    public boolean isStorable() {
        return false;
    }
}

