/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.process;

import java.awt.Component;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JOptionPane;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.process.AbstractProcessObject;
import oracle.dbtools.crest.model.design.process.Flow;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TopViewListener;
import oracle.dbtools.crest.swingui.process.Messages;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.ide.Ide;

public abstract class AbstractDataFlowTV
extends ContainerView {
    protected Set listeners = new HashSet();
    protected static Logger LOGGER = new Logger(AbstractDataFlowTV.class);

    public AbstractDataFlowTV(ApplicationView applicationView, DesignPartView designPartView) {
        super(applicationView, designPartView);
    }

    @Override
    public void addTopViewListener(TopViewListener topViewListener) {
        this.listeners.add(topViewListener);
    }

    @Override
    public void removeTopViewListener(TopViewListener topViewListener) {
        this.listeners.remove(topViewListener);
    }

    @Override
    public void setModel(DesignObject designObject) {
        if (this.model != null) {
            this.model.removeObjectListener(this);
        }
        this.model = designObject;
        designObject.setTopView(this);
        this.model.addObjectListener(this);
    }

    @Override
    public DesignPartView getDesignPartView() {
        if (this.dpv == null) {
            return this.getApplicationView().getCurrentDPV();
        }
        return this.dpv;
    }

    @Override
    public String toString() {
        int n = this.getModel().getViewNumber(this);
        String string = n == 0 ? "" : ":" + n;
        return this.getModel().getName() + string;
    }

    @Override
    protected void fireChange(ObjectChangeEvent objectChangeEvent) {
        TopViewListener[] topViewListenerArray = this.listeners.toArray(new TopViewListener[0]);
        for (int i = 0; i < topViewListenerArray.length; ++i) {
            try {
                topViewListenerArray[i].changed(this, objectChangeEvent);
                continue;
            }
            catch (Exception exception) {
                LOGGER.error("Listener caused exception: ", exception);
            }
        }
    }

    @Override
    public void remove(boolean bl) {
        if (bl) {
            int n = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("AbstractDataFlowTV.SureYouWantToDelete"), this.getModel().getName()), Messages.getString("AbstractDataFlowTV.ConfirmObjectDelete"), 0);
            if (n == 0) {
                this.getModel().remove();
                this.getDesignPartView().getWorkSpace().repaint();
            }
        } else {
            this.doPrivateActions();
            this.getDesignPartView().removeView(this);
            if (this.getCellView() != null) {
                Object[] objectArray = new Object[]{this.getCellView().getCell()};
                this.getDesignPartView().getWorkSpace().removeCells(objectArray);
                this.getDesignPartView().getWorkSpace().repaint();
            }
        }
    }

    public void addTVFlows() {
    }

    public boolean isConnected() {
        AbstractProcessObject abstractProcessObject = (AbstractProcessObject)this.getModel();
        Flow.Connection[] connectionArray = abstractProcessObject.getAllFlows();
        for (int i = 0; i < connectionArray.length; ++i) {
            Flow flow = connectionArray[i].getFlow();
            if (flow.getViewFor(this.getDesignPartView()) == null) continue;
            return true;
        }
        return false;
    }
}

