/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.printing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.util.Enumeration;
import java.util.Properties;
import javax.swing.JDialog;
import oracle.dbtools.crest.swingui.printing.Messages;
import oracle.dbtools.crest.swingui.printing.PrintPreviewController;
import oracle.dbtools.crest.swingui.printing.PrintPreviewModel;
import oracle.dbtools.crest.swingui.printing.PrintPreviewView;
import oracle.dbtools.crest.swingui.printing.SwingComponentPrinter;

public class SwingComponentAdapter
implements SwingComponentPrinter {
    private PrintPreviewView view;
    private PrintPreviewModel model;
    private PrintPreviewController control;

    @Override
    public void setComponentToPrint(Component component, Dimension dimension) {
        this.model = new PrintPreviewModel(component, dimension);
    }

    @Override
    public Component getViewComponent() {
        if (this.model == null) {
            throw new IllegalStateException(Messages.getString("SwingComponentAdapter.PrinterModelNotYetInitialized"));
        }
        if (this.view == null) {
            this.view = new PrintPreviewView(this.model);
        }
        return this.view;
    }

    @Override
    public Component getButtonPanel() {
        if (this.model == null) {
            throw new IllegalStateException(Messages.getString("SwingComponentAdapter.PrinterModelNotYetInitialized"));
        }
        if (this.control == null) {
            this.control = new PrintPreviewController(this.model);
        }
        return this.control;
    }

    @Override
    public void setPreferences(Properties properties) {
        if (this.model == null) {
            throw new IllegalStateException(Messages.getString("SwingComponentAdapter.PrinterModelNotYetInitialized"));
        }
        if (properties == null) {
            return;
        }
        PageFormat pageFormat = (PageFormat)this.model.getPageFormat().clone();
        Paper paper = pageFormat.getPaper();
        int n = pageFormat.getOrientation();
        double d = paper.getWidth();
        double d2 = paper.getHeight();
        double d3 = paper.getImageableX();
        double d4 = paper.getImageableY();
        double d5 = paper.getImageableWidth();
        double d6 = paper.getImageableHeight();
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement().toString().trim();
            String string2 = properties.get(string).toString().trim();
            if ("pageformat.orientation".equalsIgnoreCase(string)) {
                n = Integer.parseInt(string2);
                continue;
            }
            if ("pageformat.width".equalsIgnoreCase(string)) {
                d = Double.parseDouble(string2);
                continue;
            }
            if ("pageformat.height".equalsIgnoreCase(string)) {
                d2 = Double.parseDouble(string2);
                continue;
            }
            if ("pageformat.imageablex".equalsIgnoreCase(string)) {
                d3 = Double.parseDouble(string2);
                continue;
            }
            if ("pageformat.imageabley".equalsIgnoreCase(string)) {
                d4 = Double.parseDouble(string2);
                continue;
            }
            if ("pageformat.imageablewidth".equalsIgnoreCase(string)) {
                d5 = Double.parseDouble(string2);
                continue;
            }
            if (!"pageformat.imageableheight".equalsIgnoreCase(string)) continue;
            d6 = Double.parseDouble(string2);
        }
        pageFormat.setOrientation(n);
        paper.setSize(d, d2);
        paper.setImageableArea(d3, d4, d5, d6);
        this.model.setPageFormat(pageFormat);
    }

    @Override
    public Properties getPreferences() {
        if (this.model == null) {
            throw new IllegalStateException(Messages.getString("SwingComponentAdapter.PrinterModelNotYetInitialized"));
        }
        PageFormat pageFormat = this.model.getPageFormat();
        Paper paper = pageFormat.getPaper();
        Properties properties = new Properties();
        properties.put("pageformat.orientation", pageFormat.getOrientation() + "");
        properties.put("pageformat.width", paper.getWidth() + "");
        properties.put("pageformat.height", paper.getHeight() + "");
        properties.put("pageformat.imageablex", paper.getImageableX() + "");
        properties.put("pageformat.imageabley", paper.getImageableY() + "");
        properties.put("pageformat.imageablewidth", paper.getImageableWidth() + "");
        properties.put("pageformat.imageableheight", paper.getImageableHeight() + "");
        return properties;
    }

    @Override
    public void prepareGC() {
        this.model = null;
        this.view = null;
        this.control = null;
    }

    @Override
    public void setDialog(JDialog jDialog) {
        if (this.control != null) {
            this.control.setDialog(jDialog);
        }
    }
}

