/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.printing;

import java.awt.Graphics;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import javax.swing.RepaintManager;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.swingui.diagram.Diagram;
import oracle.dbtools.crest.swingui.printing.AbstractExporter;
import oracle.dbtools.crest.swingui.printing.Messages;
import oracle.dbtools.crest.swingui.printing.SVGErrorHandler;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.TimeLog;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.ide.net.URLFilter;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.ErrorHandler;
import org.apache.batik.svggen.SVGGraphics2D;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;

public class SVGExporter
extends AbstractExporter {
    private static final Logger LOGGER = new Logger(SVGExporter.class);

    public SVGExporter(ApplicationView applicationView) {
        super(applicationView);
        this.getFilterList().add(new SVGFileFilter());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void export(Diagram diagram) {
        block5: {
            try {
                File file = this.getFile();
                if (file == null) break block5;
                String string = this.getFileName(file);
                TimeLog.log("Export Started");
                DOMImplementation dOMImplementation = GenericDOMImplementation.getDOMImplementation();
                Document document = dOMImplementation.createDocument("http://www.w3.org/2000/svg", "svg", null);
                SVGGraphics2D sVGGraphics2D = new SVGGraphics2D(document);
                sVGGraphics2D.getGeneratorContext().setErrorHandler((ErrorHandler)new SVGErrorHandler());
                RepaintManager repaintManager = RepaintManager.currentManager(diagram);
                repaintManager.setDoubleBufferingEnabled(false);
                ProgressDialog progressDialog = new ProgressDialog(this.getAppView(), "", 0, 100, true);
                try {
                    progressDialog.setNote(Messages.getString("SVGExporter.SavingFileWait"));
                    progressDialog.setProgress(1);
                    diagram.paint((Graphics)sVGGraphics2D);
                    FileOutputStream fileOutputStream = new FileOutputStream(string);
                    OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
                    sVGGraphics2D.stream((Writer)outputStreamWriter, false);
                    ((Writer)outputStreamWriter).close();
                    TimeLog.log("Export End");
                }
                finally {
                    repaintManager.setDoubleBufferingEnabled(true);
                    progressDialog.close();
                }
            }
            catch (Exception exception) {
                LOGGER.error("SVGExporter.export", exception);
                MessageDialogs.showErrorMessage("Error occures while saving SVG file.");
            }
        }
    }

    protected String getDefaultExtension() {
        return ".svg";
    }

    @Override
    protected String getTitle() {
        return Messages.getString("SVGExporter.SaveAsSVG");
    }

    @Override
    protected boolean isSupportedExtension(String string) {
        return string.equals("svg");
    }

    private class SVGFileFilter
    implements URLFilter {
        private SVGFileFilter() {
        }

        public boolean accept(URL uRL) {
            File file = new File(uRL.getPath());
            if (file.isDirectory()) {
                return true;
            }
            String string = AbstractExporter.getExtension(file);
            if (string != null) {
                return SVGExporter.this.isSupportedExtension(string);
            }
            return false;
        }

        public String toString() {
            return Messages.getString("SVGExporter.SVGFiles");
        }
    }
}

