/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.printing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JPanel;
import javax.swing.JViewport;
import oracle.dbtools.crest.swingui.printing.PagePreview;
import oracle.dbtools.crest.swingui.printing.PrintPreviewModel;

public class PrintPreviewView
extends JPanel
implements Observer {
    private PrintPreviewModel model;

    public PrintPreviewView(PrintPreviewModel printPreviewModel) {
        this.model = printPreviewModel;
        this.model.addObserver(this);
        this.model.updateObservers(this);
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        int n = this.getComponentCount();
        if (n == 0) {
            return new Dimension(16, 10);
        }
        Component component = this.getComponent(0);
        Dimension dimension = component.getPreferredSize();
        int n2 = dimension.width;
        int n3 = dimension.height;
        Dimension dimension2 = this.getParent().getSize();
        int n4 = Math.max((dimension2.width - 16) / (n2 + 16), 1);
        int n5 = n / n4;
        if (n5 * n4 < n) {
            ++n5;
        }
        int n6 = n4 * (n2 + 16) + 16;
        int n7 = n5 * (n3 + 10) + 10;
        Insets insets = this.getInsets();
        return new Dimension(n6 + insets.left + insets.right, n7 + insets.top + insets.bottom);
    }

    @Override
    public void doLayout() {
        Insets insets = this.getInsets();
        int n = insets.left + 16;
        int n2 = insets.top + 10;
        int n3 = this.getComponentCount();
        if (n3 == 0) {
            return;
        }
        Component component = this.getComponent(0);
        Dimension dimension = component.getPreferredSize();
        int n4 = dimension.width;
        int n5 = dimension.height;
        Dimension dimension2 = this.getParent().getSize();
        int n6 = Math.max((dimension2.width - 16) / (n4 + 16), 1);
        int n7 = n3 / n6;
        if (n7 * n6 < n3) {
            ++n7;
        }
        int n8 = 0;
        for (int i = 0; i < n7; ++i) {
            for (int j = 0; j < n6; ++j) {
                if (n8 >= n3) {
                    return;
                }
                component = this.getComponent(n8++);
                component.setBounds(n, n2, n4, n5);
                n += n4 + 16;
            }
            n2 += n5 + 10;
            n = insets.left + 16;
        }
    }

    public void prepareGC() {
        Component[] componentArray = this.getComponents();
        if (componentArray != null) {
            for (int i = 0; i < componentArray.length; ++i) {
                if (!(componentArray[i] instanceof PagePreview)) continue;
                if (componentArray[i].getGraphics() != null) {
                    componentArray[i].getGraphics().dispose();
                }
                componentArray[i] = null;
            }
        }
        componentArray = null;
        this.removeAll();
        this.repaint();
    }

    @Override
    public void update(Observable observable, Object object) {
        this.prepareGC();
        int n = this.model.getNumberOfPages();
        for (int i = 0; i < n; ++i) {
            PagePreview pagePreview = new PagePreview(this.model, i);
            this.add(pagePreview);
        }
        Container container = this.getParent();
        if (container instanceof JViewport) {
            container = container.getParent();
        }
        if (container != null) {
            ((Component)container).validate();
        }
    }
}

